---
title: 'Python 潮流周刊#25：性能最快的代码格式化工具 Ruff！'
pubDate: 2023-11-04
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。标题取自其中一则分享，不代表全部内容都是该主题，特此声明。

本周刊由 **Python猫** 出品，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

[微信](https://img.pythoncat.top/python_cat.jpg) | [博客](https://pythoncat.top) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou) 

本周刊归档在 Github 上，已收获 800+ star 好评，如果对你有帮助，请给颗 star 支持一下吧：[https://github.com/chinesehuazhou/python-weekly](https://github.com/chinesehuazhou/python-weekly)

## 🦄文章&教程

1、[Ruff：一款极其快、兼容 Black 的 Python 格式化工具](https://astral.sh/blog/the-ruff-formatter)

我在今年 4 月份介绍过 [性能最快的代码分析工具](https://pythoncat.top/posts/2023-04-09-ruff) Ruff，当时发现它不局限于 Linter 的定位，还提供了部分 Formatter 的功能。现在，它发布了重大更新，正式成为性能最快的 Python 代码格式化工具，比 **Black** 快 30 倍以上，比 **YAPF** 快 100 倍！

![不用缓存，格式化约25万行代码的表现](https://img.pythoncat.top/2023-11-04_ruff.png)

2、[你应该什么时候升级到 Python 3.12？](https://pythonspeed.com/articles/upgrade-python-3.12/)

Python 3.12 已经发布了，你是否迫切想要升级了呢？现在是最佳的升级到 3.12 的时候么？文章建议你等到 12 月，等发布 3.12.1 错误修复版本后，因为新版本存在这些问题：不兼容的软件包、缺少二进制包、每次大版本总有大量的问题要修复。

3、[Python 3.12：一个被人忽略的史诗级版本](https://www.manjusaka.blog/posts/2023/10/29/the-most-important-thing-in-python-3-12/)

作者认为 3.12 对于 Python 的意义，大于 3.5 的“async/await” 和 3.6 的 “Type Hint” 对于 Python 的意义！主要分析了三个方面提升：PEP-669 带来的可观测性、PEP-684 为 non-GIL 带来的性能提升、PEP-697 全新 C API 保证跨版本兼容性。

4、[不要再用 requirements.txt 了](https://quanttype.net/posts/2023-10-31-do-not-use-requirements.txt.html)

作者给了两个建议：不要使用 pip 和 `requirements.txt` 来管理 Python 依赖项，推荐使用 Poetry。pip 的主要问题是没有 lockfile 和手工管理虚拟环境麻烦。除了 Poetry，作者也提及了 Hatch 和 PDM。

5、[为什么 Django 后台管理系统那么“丑陋”？](https://www.coderedcorp.com/blog/why-is-the-django-admin-ugly/)

Django 提供了一个默认的后台管理系统，即 Django Admin，它的 UI 很多年没有变化，显得设计过时了。为什么 Django 维护者们不改善它呢？作者通过询问多位维护者，得出了它的历史及如此设计的原因，主要观点是 Django Admin 面向内部管理员，不应该暴露给终端用户。

![Django Admin管理页面](https://img.pythoncat.top/2023-11-04_django_admin.png)

6、[我迁移弃用 setup.py 的糟糕体验](https://gregoryszorc.com/blog/2023/10/30/my-user-experience-porting-off-setup.py/)

PyOxidizer 作者的一篇长文，他在将 Python 3.12 用于另一个库时，CI 运行`python setup.py` 提示 setuptools 无法导入。作者在寻求解决方案时，发现 Python 的打包生态非常让人困惑，他经历了一系列复杂而耗时的过程。

7、[使用 Ptpython 提高你的编码效率](https://realpython.com/ptpython-shell/)

Ptpython 是一个功能丰富且对用户友好的 Python REPL，这是一篇非常详细的使用教程。重点介绍的功能包括历史记录、输入验证、自动补全、自动处理缩进、自定义交互式 shell、在脚本中嵌入 ptpython 等。

8、[100%的测试覆盖率是不够的：Python 中基于属性的测试](https://blog.robertroskam.com/p/100-test-coverage-is-not-enough)

测试覆盖率固然重要，但这项指标并不足以解决所有问题。文章通过示例揭示测试覆盖率的不足，简单介绍了如何用 Hypothesis  作基于属性的测试。

9、[从零开始编写一个 Python 异步 ASGI Web 框架](https://www.cnblogs.com/hanabi-cnblogs/p/17792740.html)

从零开始编写一个异步 ASGI Web 框架难么？需要了解哪些知识、实现哪些功能、思考哪些问题？这篇循序渐进的教程是很好的学习材料，让你了解 Web 框架设计、异步编程、功能封装与项目管理。

![一个请求的生命周期](https://img.pythoncat.top/20231026181957.png)

10、[Python 如何在日志中隐藏明文密码？](https://www.cnblogs.com/frankming/p/17762591.html)

不在日志中打印明文密码是安全需求，但是有太多可能出现打印密码的情况，如何能高效地隐藏明文密码呢？文章介绍了基于 **logging** 模块的两种实现方案：自定义 filter 和自定义 formatter，使用特定规则过滤明文密码。

11、[从混沌到凝聚：构建你自己的 Monorepo](https://monadical.com/posts/from-chaos-to-cohesion.html)

monorepo 是将所有项目都放到一个代码仓管理，可能包含不同语言和框架。这意味着对它的依赖管理和 CI/CD 等都与普通代码仓不同。文章介绍如何使用 GitHub Actions 作为 CI/CD 工具构建简单的 Python monorepo。

12、[Python 是一种编译型语言](https://eddieantonio.ca/blog/2023/10/25/python-is-a-compiled-language/)

我们通常习惯将 Python 称为一种解释型语言，因为它在运行时逐行解释和执行代码。很多人还知道 Python 其实也有编译的过程，解释器会先编译再执行。然而作者不止步于此，他通过苏格拉底式对话和几轮实验，引导读者重新思考“解释”与“编译”：它们是错误的二分法、限制了编程语言的可能性。Python 既是解释型语言，也是编译型语言！

🎁**Python潮流周刊**🎁已免费发布了 25 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

周末不休息，又更新了一期周刊，我想明天喝杯奶茶了~~

![](https://img.pythoncat.top/wechat_code.png)



## 🐿️项目&资源

1、[ccxt：加密货币交易 API，支持 100 多个交易所](https://github.com/ccxt/ccxt)

用于加密货币交易的 JavaScript/Python/PHP/C# 库，支持许多比特币/以太币/山寨币交易市场和商家 API。（star 29.5K）

2、[uDjango：单文件的 Django 微型项目](https://github.com/pauloxnet/uDjango)

这个项目是 DjangoCon US 2023 的演示项目，使用单文件不到 10 行代码，演示一个最小的 Django 应用。

3、[esmerald：高度可扩展、高性能的 Web 框架](https://github.com/dymmond/esmerald)

基于 Starlette 和 Pydantic 之上构建的开箱即用的 Web 框架，用于构建现代可扩展的 API 应用，支持同步和异步，提供 DAO、ORM、ODM、依赖注入、权限管理等功能。

![](https://img.pythoncat.top/2023-11-04_esmerald.png)

4、[Python-Type-Challenges：通过在线挑战来学习 Python 类型提示](https://github.com/laike9m/Python-Type-Challenges)

一个很有意思的项目，它包含从初级到高级的一系列挑战题目，让你在线练习 type hint 的使用。

5、[mify：微服务基础架构，代码生成工具](https://github.com/mify-io/mify)

可生成 OpenAPI http 服务端，内置 Prometheus 指标，提供结构化日志记录，支持多种语言代码生成。

6、[de4py：Python 逆向工程工具包](https://github.com/Fadi002/de4py)

一款高级的 Python 反混淆器，面向恶意软件分析师和逆向工程师，它拥有精美的 UI 和一些高级功能。

7、[public-apis：面向开发者的公共 API 列表](https://github.com/public-apis-dev/public-apis)

非常非常丰富的公共 API 清单，内容应有尽有。（star 2K）

8、[FunASR：端到端语音识别工具包](https://github.com/alibaba-damo-academy/FunASR)

阿里达摩院开源的语音识别工具包，功能包括语音识别（ASR）、语音端点检测（VAD）、标点恢复、语言模型、说话人验证、说话人分离和多人对话语音识别等。（star 1.2K）

9、[XHS_Downloader: 小红书图文/视频作品采集工具](https://github.com/JoeanAmier/XHS_Downloader)

支持采集和下载小红书图文/视频作品，支持批量下载，有作品文件完整性处理机制。

![](https://img.pythoncat.top/2023-11-04-xhs.png)

10、[RSS-GPT：使用 ChatGPT 为你的 RSS 订阅源生成摘要](https://github.com/yinan-c/RSS-GPT)

使用 GitHub workflow 自动运行一个简单的 Python 脚本，调用 OpenAI API 为 RSS 订阅源生成摘要，然后将新生成的 RSS 订阅源推送到 GitHub Pages。配置简单快速，无需服务器。

11、[codespell：检查代码是否存在常见拼写错误](https://github.com/codespell-project/codespell)

用于检查源代码中拼写错误的单词，支持多种运行方式，可指定忽略单词和文件，可用于 pre-commit。（star 1.5K）

12、[codeshell：多语言代码大模型基座](https://github.com/WisdomShell/codeshell)

具有 70 亿参数，在五千亿 Tokens 进行了训练，上下文窗口长度为 8192。在权威的代码评估Benchmark 上，CodeShell 取得同等规模最好的性能。（star 1.2K）

## 🐱赞助&支持

如果你喜欢周刊，请分享给其他需要的同学，让更多人可以从中受益～

如果你觉得周刊有价值，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你想帮助周刊办得更好，欢迎向我们投稿或提出建议：[投稿/建议通道](https://github.com/chinesehuazhou/python-weekly/issues/new)

如果你是品牌方或广告主，欢迎私信我，洽谈赞助与合作事项。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。