---
title: 'Python 潮流周刊#21：如何提升及测量 Python 代码的性能？'
pubDate: 2023-09-23
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。标题取自其中三则分享，不代表全部内容都是该主题，特此声明。

本周刊由 **Python猫** 出品，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

[微信](https://img.pythoncat.top/python_cat.jpg) | [博客](https://pythoncat.top) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou) 

本周刊开通 Telegram 频道后，已有 700+ 小伙伴加入，欢迎你到来：[https://t.me/pythontrendingweekly](https://t.me/pythontrendingweekly)

## 🦄文章&教程

1、[在单核情况下加快 Python 代码速度](https://pythonspeed.com/articles/optimizing-dithering/)

文章使用弗洛伊德-斯坦伯格抖动算法为例，使用各种技巧来提升代码性能，实现将耗时从 2339 微秒逐步降低到 554 微秒。涉及的一些概念：指令级并行 （ILP）、分支预测、单指令多数据（SIMD）、内存层次结构等。

2、[使用 Radon 作 Python 的代码度量](https://www.blog.pythonlibrary.org/2023/09/20/learning-about-code-metrics-in-python-with-radon/)

一篇基础的入门教程，了解如何用 Radon 来衡量 Python 的代码复杂度，即计算圈复杂度等指标，介绍了相关命令的使用。

3、[Python（大部分）由语法糖组成](https://lwn.net/Articles/942767/)

Brett Cannon 写了一系列关于“语法糖”的博客，解析了 80 多个语法糖特性。文章基于他在 PyCon 的演讲及博客，介绍了其中的部分内容。

4、[迎接新的 SymPy](https://oscarbenjamin.github.io/blog/czi/post1.html)

SymPy 是一个用于符号计算（symbolic computation）的库，可以处理代数、微积分、离散数学等领域的问题。这是一个系列文章，介绍它将迎来的重大变化。文章描述了 SymPy 当前存在的速度问题、为加速它而作的工作、将来的提速计划。（附：[系列第二篇：SymPy 多项式计算](https://oscarbenjamin.github.io/blog/czi/post2.html)）

5、[使用 import-linter 让你的 Python 项目架构更整洁](https://www.piglei.com/articles/use-import-linter-to-lint-proj-arch/)

在依赖关系治理方面，[import-linter](https://github.com/seddonym/import-linter) 是一个非常有用的工具。它通过提供各种类型的“契约”，让我们得以将项目内隐式的复杂依赖关系，通过配置文件显式的表达出来。文章介绍了它的入门使用，以及 6 种修复依赖关系的技巧。

6、[CPython 如何用布隆过滤器作字符串处理？](https://codeconfessions.substack.com/p/cpython-bloom-filter-usage)

CPython 在处理字符串时使用了布隆过滤器，比如 splitlines()、strip() 两个函数，文章介绍了它们的实现原理。文章还介绍了典型布隆过滤器的实现原理，以及 CPython 中布隆过滤器的实现（不到 50 行 C 代码）。

7、[Python 中 UUID 的使用](https://medium.com/@m____b____/uuids-with-python-b133cead1b4c)

介绍了`uuid` 库的几个方法：uuid1() 利用系统 MAC 地址与时间戳生成 uuid；uuid4() 生成完全随机的 uuid；uuid3() 和 uuid5() 基于常量命名空间和变量名生成 uuid，前者使用 MD5 算法，后者使用 SHA-1 算法。

8、[为什么有这么多 Python Dataframe？](https://ponder.io/why-are-there-so-many-python-dataframes/)

为什么会有 Pandas、Polars、Dask 和 PySpark 等大量的 Dataframe 库？作者认为主要的原因是它的四种角色模型：电子表格、关系数据库、二维数组/矩阵、对象，以及由此衍生出的一系列问题。

9、[使用 Python 模拟“三门问题”](https://www.dataschool.io/python-probability-simulation/)

Monty Hall 问题也被称为三门问题，是一道挑战人们直觉的概率问题。文章使用 Python 来模拟这个问题，看看需要多久才能赢取奖品。

10、[6 件可以用 Functools 模块做的很酷的事](https://pybit.es/articles/6-cool-things-you-can-do-with-the-functools-module/)

文章介绍了 functools 标准库的 6 个使用场景：@cache 缓存、@total_ordering 让你少写双下方法、partial() 冻结函数、@singledispatch 泛型函数、@wraps 装饰器、reduce() 函数。

11、[深入理解 pytest.main()：Python 测试框架的核心功能解析](https://juejin.cn/post/7281491804736831542)

`pytest.main` 是 Pytest 框架中一个非常实用的函数，用于从命令行运行测试集或者以编程方式运行测试。文章探讨了它的用法和一些常见的应用场景。

12、[7 个极佳的 Python 身份验证库](https://python.plainenglish.io/7-best-python-authentication-libraries-you-should-use-in-your-next-project-c07b668d5348)

介绍了 7 个不错的身份验证库：**Authlib、Pyjwt、Flask-login、Django-allauth、ItsDangerous、Python Social Auth、Flask-security**。（附：[中文翻译](https://juejin.cn/post/7281150086351732751)）

🎁**Python潮流周刊**🎁已免费发布了 21 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

如果你觉得周刊有价值，请表达小小心意，赞赏一下猫哥吧~~

![](https://img.pythoncat.top/support_pythoncat.png)

## 🐿️项目&资源

1、[radon：Python 代码的各种指标](https://github.com/rubik/radon)

一个 Python 代码指标分析工具，可以计算圈复杂度、原始指标、Halstead 指标、可维护性指数，可用于 CI 集成，可与 Jupyter Notebook 一起使用。（star 1.5K）

2、[agents：自主语言代理的开源框架](https://github.com/aiwaves-cn/agents)

自主语言代理（Autonomous Language Agents）指的是能够独立执行自然语言处理任务的智能代理系统。这个库支持长期短期记忆、工具使用、Web 导航、多 agent 通信、人机交互和符号控制等功能。（star 2.6K）

![](https://img.pythoncat.top/agents-cover.png)

3、[quasiqueue：一个多进程库](https://github.com/tedivm/quasiqueue)

一个用于 Python 多进程的库，便于管理长时间运行的多进程作业。可处理进程创建和清理、信号管理、跨进程通信以及其它在处理多进程时的麻烦事。

4、[pygraft：可配置的模式和知识图谱生成](https://github.com/nicolas-hbt/pygraft)

可根据用户指定的参数生成逼真的模式和知识图谱，通过使用 DL 推理器（HermiT）来确保逻辑一致性。

5、[toml-bench：在 Python 中该用哪个 toml 库？](https://github.com/pwwang/toml-bench)

这个仓库主要从多个维度比较了 **toml、tomli/tomli_w、tomlkit、pytomlpp、rtoml 和 qtoml** 这几个库，考察它们在处理数据时的行为表现以及性能。

6、[SyncDreamer：以单视角图像生成多视角一致的图像](https://github.com/liuyuan-pal/SyncDreamer)

提供一张图片，使用 Paint3D 分割前景对象，通过推理生成多个视角的图像。

7、[nanosam：使用 NVIDIA TensorRT 实时运行的 SAM 模型](https://github.com/NVIDIA-AI-IOT/nanosam)

Segment Anything（SAM）是在计算机视觉领域中对图像或视频中的任何对象进行分割的任务，以提取出具有语义或视觉特征的子区域或对象。

8、[logparser：用于日志解析的机器学习工具包](https://github.com/logpai/logparser)

国人开源作品。可自动从非结构化的日志信息中提取出结构化的关键信息。（star 1.2K）

9、[llama2.mojo：纯 Mojo 版本的 Llama 2](https://github.com/tairov/llama2.mojo)

作者将 Python 版本的 llama2.py 移植成 Mojo 版本，将性能提高了近 250 倍。（star 1.1K）

10、[bisheng：一个开放的 LLM DevOps 平台](https://github.com/dataelement/bisheng)

一款领先的开源大模型应用开发平台，中文“毕昇”，可以搭建各类丰富的大模型应用：分析报告生成、知识库问答、对话、要素提取等。

## 🐢播客&视频

1、[EuroPython 2023 的 146 个视频](https://www.youtube.com/playlist?list=PL8uoeex94UhFcwvAfWHybD7SfNgIUBRo-) 

今年 EuroPython 活动的演讲视频。

2、[Real Python 播客 #172：使用 Scalene 测量 Python 性能](https://realpython.com/podcasts/rpp/172/)

**Scalene** 是一款高性能的 CPU、GPU 和内存分析器，可以从单个函数或代码行级别分析代码，并比较在 Python 和 C 代码中花费的时间。播客嘉宾是马萨诸塞大学教授，他与学校实验室的学生开发了 Scalene。

## 🐱赞助&支持

如果你喜欢周刊，请分享给其他需要的同学，让更多人可以从中受益～

如果你觉得周刊有价值，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你想帮助周刊办得更好，欢迎向我们投稿或提出建议：[投稿/建议通道](https://github.com/chinesehuazhou/python-weekly/issues/new)

如果你是品牌方或广告主，欢迎私信我，洽谈赞助与合作事项。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。