---
title: 'Python 潮流周刊#20：三种基准测试的方法、为什么代码在函数中运行得更快？'
pubDate: 2023-09-16
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。标题取自其中两则分享，不代表全部内容都是该主题，特此声明。

本周刊由 **Python猫** 出品，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

[微信](https://img.pythoncat.top/python_cat.jpg) | [博客](https://pythoncat.top) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou) 

本周刊开通 Telegram 频道后，已有 650+ 小伙伴加入，欢迎你到来：[https://t.me/pythontrendingweekly](https://t.me/pythontrendingweekly)

## 🦄文章&教程

1、[三种对 Python 作基准测试的方法](https://superfastpython.com/benchmark-python-code/)

文章介绍了使用标准库对 Python 作基准测试的几种方法：time、timeit、cProfile 与 profile，详细介绍了几个工具的使用方法及测试数据的解读。

2、[舍弃 Poetry 和 PDM，切换成 Hatch](https://andrich.me/2023/08/switching-to-hatch/)

作者“移情别恋”了 Hatch，开始在项目中使用它。文章介绍了他喜欢 Hatch 的一些小亮点：环境隔离、命令脚本、可替代 **Tox**、可选的依赖项等。（附：[Python 任务自动化工具 tox 教程](https://pythoncat.top/posts/2020-01-06-tox)）

3、[TOML 文件格式有什么问题？](https://hitchdev.com/strictyaml/why-not/toml/)

TOML 是“改进的” INI 文件，是 Python 推荐的配置文件格式。文章提到，连 TOML 的作者也认为它是一种糟糕的格式！文章指出了它的问题：非常冗长、层次结构很难仅从语法推断、像 YAML 一样过于复杂、具有语法类型。

4、[用 Python 玩转遗传算法](https://joseprupi.github.io/misc/2023/08/19/playing_with_genetic_algorithms_in_python.html)

遗传算法（Genetic Algorithm）是一种受生物进化理论启发的优化算法，用于解决复杂的搜索和优化问题。文章用 Python 演示了这种算法的使用例子。

5、[现代 Python 的类型提示：Protocal 类](https://codebeez.nl/blogs/type-hinting-in-modern-python-the-protocol-class/)

Protocol 类是 Python 3.8 版本中引入的，用于指定一个类应该实现哪些方法，与 Java 的 Interface 相似。在保持 Python 动态类型用法的情况，使用 Protocal 可以获得部分静态类型检查的效果。

6、[tornado 的协程调度原理](https://dev.to/caipi/tornado-de-xie-cheng-diao-du-yuan-li-2h34)

Tornado 是一个高性能的 Web 框架，文章解读它的源码，主要想搞清楚：yield 暂存的状态到哪去了、重新恢复执行的“合适的时机”到底是什么、具体是怎么恢复执行的？

7、[可视化 CPython 发布过程](https://sethmlarson.dev/security-developer-in-residence-weekly-report-9)

文章基于 PEP-101 梳理了 CPython 的发布过程，绘制出了详细的流程图并给出关键步骤的解释。

![CPython构建与发布流程](https://img.pythoncat.top/2023-09-16_cpython.png)

8、[如何用 PyObjC 与 Apple Vision 框架作文本识别](https://yasoob.me/posts/how-to-use-vision-framework-via-pyobjc/)

Apple 的 Vision 框架提供了一系列预训练的模型和 API，可快速在应用中添加图像分析和计算机视觉功能。PyObjC 可实现 Python 与 Objective-C 的交互。文章将它们结合，开发了一个文本处理项目。

9、[调试 Python 中正则表达式的灾难性回溯](https://krishnanchandra.com/posts/regex-catastrophic-backtracking/)

作者使用 py-spy 定位一个 CPU 100% 占用问题，找出了罪魁祸首的正则表达式，进而探讨灾难性回溯及其解决方法，并给出了优化性能的建议写法。

10、[使用 Django 和 HTMX 开发一个数据库搜索项目](https://www.photondesigner.com/articles/database-search-django-htmx)

一篇详细的 Django 项目教程，实现一个全栈的项目。文中有作者的教程视频。

11、[异步 SqlAlchemy 和多数据库管理](https://python-bloggers.com/2023/09/asynchronous-sqlalchemy-and-multiple-databases/)

利用 asyncio 和 SqlAlchemy 库，文章探讨了如何有效地连接和管理多个数据库，获得可扩展且具有弹性的架构。文章介绍了两种实现方法。

12、[Python Fire：自动生成命令行接口](https://juejin.cn/post/7278246015193464847)

Fire 是谷歌开源的一个用于生成 CLI 的库，Github 25K star。这篇文章介绍了它的一般命令、组合命令、链式命令、复杂命令等用法。

13、[我最爱的解 LeetCode 问题的 Python 技巧](https://www.jjinux.com/2022/08/python-my-favorite-python-tricks-for.html)

文章介绍了 Python 中的一些小技巧，从初级到高级，多数与数据结构相关，在解 LeetCode 问题时很有用。

14、[为什么 Python 代码在函数中运行得更快？](https://stackabuse.com/why-does-python-code-run-faster-in-a-function/)

Python 代码分别在函数和全局模块中运行，哪个更快呢？为什么是在函数中更快呢？Python 代码执行的工作原理是什么？如何测试与优化 Python 函数的性能？

🎁**Python潮流周刊**🎁已免费发布了 20 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

如果你觉得周刊有价值，请表达小小心意，赞赏一下猫哥吧~~

![](https://img.pythoncat.top/support_pythoncat.png)

## 🐿️项目&资源

1、[hatch：时髦的可扩展的 Python 项目管理库](https://github.com/pypa/hatch)

一个 Python 项目管理工具，有标准化构建系统、强大的环境管理、轻松发布到 PyPI、版本管理、响应式 CLI、比 pipenv 和 poetry 同类工具快约 2-3 倍。（star 4.4K）

2、[keep：开源的告警管理和自动化执行平台](https://github.com/keephq/keep)

可以将所有告警整合到一个管理平台中，并编排工作流以自动化执行端到端的流程。支持对接多种数据采集平台、数据库、办公软件等，可视化编排告警处理工作流。（star 2.2K）

3、[PyPI Data 网站：查看 PyPI 的各项数据](https://py-code.org/stats)

一个神奇的网站！包含 PyPI 的各类统计数据、曲线图和饼图，例如文件总数、总大小、一些功能特性的流行趋势等等。

![PyPI数据统计](https://img.pythoncat.top/2023-09-15_pypi-data.png)

4、[strictyaml：类型安全的 YAML 解析和校验库](https://github.com/crdoconnor/strictyaml)

用于解析 YAML 的受限子集，拒绝解析丑陋的、难以阅读和不安全的 YAML 特性，有严格的标记验证和直接的类型转换，可替代 pyyaml、ruamel.yaml 和 poyo，有清晰可读的异常信息。（star 1.3K）

5、[facefusion：更先进的换脸工具](https://github.com/facefusion/facefusion)

最新开源的一个人像换脸库，star 涨得飞快！（star 6.9K）

6、[pyflyby：一套 Python 的生产力工具](https://github.com/deshaw/pyflyby)

包含一系列的小工具，功能包含用于命令行的 py、用于 IPython 的自动导入、添加缺失的 import、删除不用的 import、格式化 import、打印一组文件的 import、重命名导入，等等。

7、[instagraph：将文本内容或 URL 转换为可视化的知识图谱](https://github.com/yoheinakajima/instagraph)

可以提取复杂信息中的实体，生成它们的关系图谱。使用了 GPT-3.5，以及 Flask 来生成色彩友好的图例；响应式设计，可在任何设备上使用。

8、[textual-web：在浏览器中运行 TUI 和终端](https://github.com/Textualize/textual-web)

将 **Textual** 开发的 app 发布到网页上，也可以在浏览器中使用命令行终端。是个很有意思的项目。

9、[ziggy-pydust：用 Zig 语言构建 Python 扩展](https://github.com/fulcrum-so/ziggy-pydust)

一个开发框架，可打包用 Zig 编写的 Python 扩展模块，还包含一个 Pytest 插件可发现与运行 Zig 测试。集成了 Poetry，方便构建 wheel 和发布。支持缓冲区协议，可以实现零拷贝提升 Numpy 计算。

10、[MFTCoder：多任务微调代码大模型](https://github.com/codefuse-ai/MFTCoder)

一个开源的多任务代码大语言模型项目，包含代码大模型的模型、数据、训练等。在 HumanEval Benchmarks 的 Python Pass@1 取得了 **74.4%** 的开源 SOTA 成绩，超过 GPT-4。

## 🐱赞助&支持

如果你喜欢周刊，请分享给其他需要的同学，让更多人可以从中受益～

如果你觉得周刊有价值，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你想帮助周刊办得更好，欢迎向我们投稿或提出建议：[投稿/建议通道](https://github.com/chinesehuazhou/python-weekly/issues/new)

如果你是品牌方或广告主，欢迎私信我，洽谈赞助与合作事项。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。

