---
title: 'Python 潮流周刊#16：优雅重要么？如何写出 Pythonic 的代码？'
pubDate: 2023-08-19
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。标题取自其中两则分享，不代表全部内容都是该主题，特此声明。

本周刊由 **Python猫** 出品，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

[微信](https://img.pythoncat.top/python_cat.jpg) | [博客](https://pythoncat.top) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou) 

## 🦄文章&教程

1、[写代码时，优雅有意义吗？](https://mathspp.com/blog/pydonts/does-elegance-matter)

作者强调使用 Python 的核心特性来编写惯用的、富有变现力的、优雅的代码很重要，提出优雅不是可有可无的奢侈品。

2、[Python Asyncio实践--高并发下如何防止缓存击穿](https://so1n.me/2023/08/14/python_asyncio_concunrrency_result_share/)

文章介绍了如何基于`Asyncio.Future`的特性编写一个语言级别的防缓存击穿的工具——`Share`，并介绍它的使用和高并发下的处理方法。

3、[高效定时任务处理：深入学习 Python 中 APScheduler 库的奥秘](https://juejin.cn/post/7266663176980185144)

APScheduler 是一个强大的定时任务处理库，这篇长文详细介绍了从入门到精通的相关知识，包括创建定时任务、定时任务触发器、任务存储、并发执行、阻塞和非阻塞调度器、错误处理、立即执行任务、调度器持久化、任务监听器和移除定时任务等。

4、[CPython 开发实战：魔改 lambda 函数](https://juejin.cn/post/7266037480750071848)

文章尝试将 Python 的 lambda 函数改成 Javascript 风格的箭头函数。在编译 CPython 时，通过修改 `.asdl` 文件，重新构造抽象语法树，修改语法分析文件，并利用 **pegen** 重新生成语法分析器。

5、[CPython 是如何实现引用计数的？](https://codeconfessions.substack.com/p/cpython-reference-counting-internals)

你是否对 CPython 的底层运行原理及其内部结构感到好奇？文章通过分析源码，介绍了 CPython 是如何实现引用计数和内存管理的，涉及引用计数的机制、关键数据结构的解释、字节码指令的执行、引用计数的局限性等。

6、[使用 Importlib 实现 Python 延迟加载](https://coderslegacy.com/python-lazy-loading-with-importlib/)

延迟加载指的是在使用时再导入模块，而不是在程序刚执行时就加载。它的好处：减少启动时间、降低内存消耗、提高性能、优化资源、运行时加载。文章介绍了`importlib` 实现延迟加载的用法。。

7、[使用 Python 和 Playwright 进行端到端测试](https://sixfeetup.com/blog/end-to-end-testing-python-playwright)

端到端测试（end-to-end）指的是对程序的整个使用流程从头到尾作测试，可能发现单元测试与集成测试都无法发现的问题。这是一篇详细的入门教程，介绍了 **Playwright** 的相关用法。

8、[nogil 项目和 Faster CPython 项目](https://lwn.net/Articles/939981/)

Python 官方虽已宣布会接受 **PEP-703**，但是最终版本或许要等到 5 年后的 3.17 版本。从 2021 年起，nogil 和 Faster CPython 项目持续吸引大家的关注，这篇文章梳理了它们两年来的发展情况、一些关键性问题的处理方案和重要进展、近期社区和大公司的回应等。（附：[Python 官方第一次针对 nogil 的研讨会](https://pythoncat.top/posts/2021-11-14-GIL)、[Faster CPython 项目的首次亮相](https://pythoncat.top/posts/2021-05-16-Guido)）

9、[简单介绍 Python 的永生对象](https://engineering.fb.com/2023/08/15/developer-tools/immortal-objects-for-python-instagram-meta/)

Instagram 向 Python 贡献了 3.12 版本中的 [PEP-683](https://peps.python.org/pep-0683/)（永生对象，使用固定的引用计数），它可以绕过引用计数检查，这是多核 Python 并行处理的重要基础。文章介绍了 Instagram 遇到的内存使用问题、为解决问题而引入永生对象、并最终贡献到 CPython 的故事。

![增加共享内存，减少私有内存和写时复制](https://img.pythoncat.top/2023-08-19_immortal.png)

10、[为什么要避免在 Python 中用“import *”？](https://pybit.es/articles/why-you-should-avoid-import-in-python/)

Python 中一个文件是一个模块，拥有自己的命名空间。当使用“import *”时，这会导致“**命名空间污染**”！文章指出了遵循 PEP-8 风格的正确写法，同时建议应该用`__all__` 来定义模块中可被导出的变量名。

11、[让我们终结 Python 的依赖地狱](https://prefix.dev/blog/launching_pixi)

[pixi](https://github.com/prefix-dev/pixi) 是最新发布的用 Rust 编写的 Python 包管理器，这篇文章出自其官方博客，主要介绍为什么要开发这个项目、它提供了哪些功能、它的基本执行过程。项目当前基于 Conda 生态，暂不支持 PyPI。

12、[使用 Django Rest Framework 实现 JWT 身份验证](https://pythonguides.com/jwt-authentication-using-django-rest-framework/)

一篇非常详细的教程，介绍了 JWT 是什么以及它的工作原理，演示了如何用 DRF 实现 JWT 身份验证的全过程。

13、[增强 Django 程序：提升数据库查询的 7 个妙招](https://johnnymetz.com/posts/slow-django-database-queries/)

数据库查询是影响 Web 程序性能的主要因素之一，这篇文章介绍了 7 个提升性能的技巧：设置查询语句的超时时间、使用`assertNumQueries` 测试查询数、使用`nplusone` 捕获 N+1 查询、使用`django-zen-queries` 捕获 N+1 查询、避免对预取对象作新的查询、使用 `defer()` 防止获取大的未使用字段、避免在大字段上使用 `distinct()` 。

14、[可能让你大吃一惊的奇怪的 Python “特性”](https://martinheinz.dev/blog/103)

有时候我们会在编程语言中看到一些奇怪的现象，它们可能是一些非常冷门的“特性”，也可能会让人误以为是 bug 或者因理解错误而造成 bug。作者介绍了他的几个小发现。

15、[可汗学院如何将 Python 后端重写成 Go？](https://blog.quastor.org/p/khan-academy-rewrote-backend)

可汗学院使用 Python 做了 10 年的主力语言，然而在 2020 年前后彻底转向了 Go 阵营。这篇文章介绍了它为什么以及如何将 Python 2 后端整体重构成 Go 服务。文中引用了可汗学院总结性的一系列博客，可作延伸阅读。

16、[为什么静态语言会面临复杂性的挑战？](https://hirrolot.github.io/posts/why-static-languages-suffer-from-complexity.html#the-unfortunate-consequences-of-being-static)

这是一篇思考编程语言该如何设计的长文！作者指出现代编程语言存在“**静态-动态双形性**”问题，提出理想的编程语言应该同时具有静态和动态的特性。文章分析了 **Idris** 和 **Zig** 两种语言的做法，并指出其局限性，最后提出应该重新思考编程语言。

🎁**Python潮流周刊**🎁已免费发布了 16 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

如果你觉得周刊有价值，请表达小小心意，赞赏一下猫哥吧~~

![](https://img.pythoncat.top/support_pythoncat.png)

## 🐿️项目&资源

1、[pixi：Rust 开发的基于 Conda 的包管理器](https://github.com/prefix-dev/pixi)

一个基于 Conda 生态的包管理器，支持所有操作系统，支持多种语言的 Conda 包，拥有类似 Cargo 的命令行界面，完全用 Rust 编写。支持按照项目来安装包，也支持全局安装，此行为类似于 **pipx** 和 **condax**。

![pixi的使用演示](https://img.pythoncat.top/pixi.png)

2、[briefcase：将 Python 项目转换为独立的应用](https://github.com/beeware/briefcase)

支持打包成 Mac、Windows、Linux、Android 和 iPhone 的应用，以及使用了 PyScript 作客户端的静态 Web 站点。（star 2K）

3、[facechain：可生成数字分身的深度学习工具链](https://github.com/modelscope/facechain)

上周的热门项目，仅需三张照片即可生成个人的数字分身。底层使用了 Stable Diffusion 的文生图功能，训练时可选择多种风格的 LoRA 模型，也支持添加个性化的 prompt，实现变装效果。（star 3.2K）

4、[modelscope：将 Model-as-a-Service 概念变为现实](https://github.com/modelscope/modelscope)

“模型即服务”（MaaS）汇集 AI 社区中最先进的机器学习模型，并简化在实际应用中使用 AI 模型的流程。它已有 700+ 模型，涵盖自然语言处理、计算机视觉、语音、多模态等。（star 3.6K）

5、[viberary：基于语义的书籍搜索引擎](https://github.com/veekaybee/viberary)

不是根据体裁和书名等常规条件，而是根据提示语来搜索相关的书籍。基于[双塔语义检索模型](https://blog.reachsumit.com/posts/2023/03/two-tower-model/) ，使用 DuckDB 在本地训练数据，使用 Redis Search 模块作检索，通过 Flask API 和 Bootstrap 前端展示结果。

![书籍搜索的处理流程](https://img.pythoncat.top/tactical_app.png)

6、[polar：帮助开源维护者获得更好的资助](https://github.com/polarsource/polar)

它为开源维护者搭建一个平台，可便捷地设置、运营、推广面向支持者的增值及订阅服务，帮助开发者从开源项目中获取收入。这个项目已获得 180 万美元的种子轮投资。

7、[youre-the-os：一个游戏，让你扮演操作系统！](https://github.com/plbrault/youre-the-os)

一个很有意思的游戏！你需要扮演操作系统，管理进程、内存和 I/O 事件，不能让进程空闲太久，不然就 game over！项目依赖 Python 3.11 和 **pipenv**，也可以上这个网站[在线体验](https://plbrault.github.io/youre-the-os/) 。（star 1K）

![游戏过程的截图](https://img.pythoncat.top/in_game_screenshot.png)

8、[learndb-py：通过从头实现数据库来学习](https://github.com/spandanb/learndb-py)

这个项目从头实现一个关系型数据库，借鉴了 **sqlite** 数据库。关键的特性：支持丰富的 sql、使用`lark` 构建自定义词法分析与解析器、支持用户和代理方式连接、实现 BTree 作数据存储。

9、[mpire：比标准库更快的多进程开发库](https://github.com/sybrenjansen/mpire)

比其它多进程库更快，且功能更多：结合了 `multiprocessing.Pool` 使用写时复制的共享对象的优点、有丰富的状态管理功能、使用 tqdm 实现进度条、支持在仪表板查看进度，等等。（star 1.5K）

10、[diaphora：二进制文件的差异比对工具](https://github.com/joxeankoret/diaphora)

如何比对一个软件在两个版本间的差异？比较二进制软件的差异时，涉及哪些匹配技术？这个项目号称是目前最强的软件差异比对工具！（star 3.1K）

![iOS 9.3.5 修复一个内核漏洞的截图](https://img.pythoncat.top/diaphora.png)

11、[beartype：近实时的静态类型检查工具](https://github.com/beartype/beartype)

一个近实时（NRT）的纯 Python 运行时类型检查工具，将 Rust 和 C++ 的零成本对象带入动态类型的 Python 世界。它可有选择性地将 Python 的鸭子类型转换成静态类型，同时默认保留前者的优点。项目文档中称“你可以同时像鸭子一样嘎嘎叫，以及像熊一样咆哮”！（star 2K）

12、[cs_books：AzatAI 推荐的计算机科学书籍](https://github.com/AzatAI/cs_books)

这个仓库收录了 200 多本计算机科学类书籍，仅限教育用途！

## 🐢播客&视频

1、[超越 PEP-8 -- 漂亮易懂代码的最佳实践](https://www.youtube.com/watch?v=wf-BqAjZb8M)

这个视频出自 PyCon 2015，介绍如何写出优雅的 Python 代码。在油管上已有 8200+ 点赞。演讲者 Raymond Hettinger 参与贡献了大家熟知的很多 Python 特性，比如 enumerate() 函数、生成器表达式、OrderedDict()、条件表达式、set 对象等。

2、[只需 5 个步骤，将“勉强能用”的代码变成 Pythonic](https://www.youtube.com/watch?v=spi0N_PNznE)

写出能用的代码不应该成为最终目标，这只是一个开始！这个视频使用了\_\_getitem\_\_、\_\_len\_\_、\_\_enter\_\_ 和 \_\_exit\_\_ 等魔术方法，将难以维护的代码重构得 Pythonic。作者自称这是对上一则分享的 8 分钟浓缩版。

## 🐱赞助&支持

如果你觉得周刊有价值，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你喜欢周刊，请分享给其他需要的同学，让更多人可以从中受益～

## 🐼欢迎订阅

\- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）

\- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。

\- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！

\- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。

\- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。

\- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。