---
title: 'Python 潮流周刊#15：如何分析异步任务的性能？'
pubDate: 2023-08-12
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。标题取自其中一则分享，不代表全部内容都是该主题，特此声明。

本周刊精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

\>\>\> [微信](https://img.pythoncat.top/python_cat.jpg) | [博客](https://pythoncat.top) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou) \<\<\<

## 🦄文章&教程

1、 [如何分析 FastAPI 异步请求的性能？](https://blog.balthazar-rouberol.com/how-to-profile-a-fastapi-asynchronous-request)

**cProfile** 这种基于函数调用的分析工具无法有效分析异步操作的执行时间，文章介绍了 [pyinstrument](https://github.com/joerick/pyinstrument) 这个分析库，结合 **FastAPI.middleware** 装饰器，并使用 [speedscope](https://github.com/jlfwong/speedscope) 来可视化 FastAPI 程序的耗时情况。

![FastAPI程序耗时分析](https://img.pythoncat.top/2023-08-12_pyinstrument.png)

2、 [利用 FastAPI 的后台任务：增强性能和响应能力](https://noplacelikelocalhost.medium.com/leveraging-background-tasks-in-fastapi-enhancing-performance-and-responsiveness-6e4ad64c7d16)

介绍了 FastAPI 的 BackgroundTasks，可以创建后台任务，用于管理长时间运行的任务，而不阻塞主进程。

3、 [使用 Python 创建直方图](https://compucademy.net/creating-histograms-with-python/)

直方图又名“柱状图”，可直观查看数据的分布趋势、离散程度和异常值等信息。文中介绍了 Matplotlib、Plotly、Seaborn、Numpy 和 Pandas 等工具绘制直方图的方法，介绍各种直方图的样式和风格、处理异常值、分析时间序列数据等。

4、 [Mypy 1.5 发布了](https://mypy-lang.blogspot.com/2023/08/mypy-15-released.html)

Mypy 是 Python 的静态类型检查工具，1.5 版本主要功能有：不再支持 Python 3.7、更灵活的 TypedDict 创建和更新、可显示错误代码的文档链接、实验性改进了泛型函数的类型推断、对 Python 3.12 的部分支持，等等。

5、 [在 Linux 上运行 Python 的“Hello World”脚本时，会发生什么？](https://jvns.ca/blog/2023/08/03/behind--hello-world/)

在 py 文件中写上一句`print("hello world")`，然后在命令行执行这个文件，幕后都发生了什么呢？文章使用了 `readelf` 、`strace` 、`ldd` 、`debugfs` 、`/proc` 、`ltrace` 、`dd` 和 `stat` 等工具，详细解释了脚本被执行的过程。主要涉及操作系统相关的内容，而不是 CPython 解释器。（附：文章还引用了最近很火的 [Putting the "You" in CPU ](https://cpu.land/) ，介绍计算机是如何运行程序的，强烈推荐！）

6、 [通过对比 Python 来学习 PostScript](https://kenschutte.com/postscript-vs-python)

PostScript 是电子出版和桌面出版领域的页面描述语言，广泛用于打印机、出版和图形设备。文章将一段 PostScript 程序直译成 Python 代码，可以让你快速了解这门语言的语法。

7、 [Python 中不那么随意的性能优化](https://www.nathom.dev/blog/casual_performance_optimization_python/)

作者的一段代码，用 Rust 花了 950 毫秒，而 Python 却花 70 秒！这怎么能忍！将生成器写法改成 for 循环后，只是轻微提速，使用 Numpy 和多进程做了一些优化后，终于看到了比较可观的数据。不同代码方案的对比、Python 底层工作原理、内存使用效率问题，以及语言特性的差异。

8、 [在 Python 中创建上下文管理器](https://www.pythonmorsels.com/creating-a-context-manager/)

如何用 Python 创建自己的上下文管理器？上下文管理器是可以在 `with` 代码块中使用的对象，在进入和退出时做一些操作。文章介绍了上下文管理器的实现细节。

9、 [一个简单的模块，可以篡改 Python 解释器的数字](https://kenschutte.com/python-swap-ints)

一篇有意思的文章。导入一个模块后，可以将 8 和 9 互换，即`print(8)` 会打印出 9。文章展示了如何用 C 编写一个简单的模块，介绍了 CPython 中整数对象池的实现，并通过修改两个整数的引用，实现一个简单的篡改数字的效果。

10、 [为什么说 Python 很糟糕……](https://josvisser.substack.com/p/why-python-is-terrible)

一篇给 Python 泼冷水的文章，主要观点是认为 Python 不适合于开发大型应用。批评的点包括动态和鸭子类型、性能问题、代码维护和重构难等问题。

11、 [Python 中错误处理的最佳实践](https://pybit.es/articles/python-errors-should-not-pass-silently/)

Python 之禅说“错误不应该悄无声息地被忽略”，强调了应该直面错误和透明处理。文章指出了一些糟糕的错误处理写法，给出了尽早检查错误、快速失败处理等编程建议。

12、 [使用企业数据和 Python 构建 GPT 对话机器人](https://www.pythongasm.com/build-gpt-powered-chatbots-around-enterprise-data-with-python)

这篇教程介绍了搭建企业中 GPT 对话机器人的完整流程，包括数据索引、查询检索、集成 LLM、使用 FastAPI 开发接口、uvicorn 作部署。

13、 [Python 鸡尾酒：将上下文管理器和迭代器等量混合](https://www.bitecode.dev/p/python-cocktail-mix-a-context-manager)

**tenacity** 库提供了一种用迭代器和上下文管理器组合的写法，实现重试机制。这篇文章演示了如何用自定义的迭代器和上下文管理器，来实现同样的功能，可以让你更深入理解这两个好用的特性。

14、 [索引的力量：利用 Pandas 提高数据整理效率](https://stackabuse.com/the-power-of-indexing-boosting-data-wrangling-efficiency-with-pandas/)

Pandas 被广泛用于数据处理，文章介绍了如何高效利用索引技术，提升它整理数据的速度和效率。介绍了多种索引技术，例如基于整数的索引、布尔索引、设置新索引并重置旧索引、排序索引。

15、 [杀死 ProcessPoolExecutor](https://www.tinybird.co/blog-posts/killing-the-processpoolexecutor)

Python 不适合处理 CPU 密集型任务，文章中项目原本使用进程池来规避 GIL 问题，后使用线程、C++ 扩展和更精细调整的 GIL 控制，将内存使用量减少 50%，CPU 使用量减少约 20%，线程和进程减少约 70%，I/O 流量减少 100%。

🎁**Python潮流周刊**🎁已免费发布了 15 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

如果你觉得周刊有价值，请表达小小心意，赞赏一下猫哥吧~~

![](https://img.pythoncat.top/support_pythoncat.png)

## 🐿️项目&资源

1、 [pyinstrument：Python 的调用堆栈分析器](https://github.com/joerick/pyinstrument)

一个轻量级、无侵入的 Python 代码性能分析库，支持分析异步任务和事件循环代码，可生成多种格式的分析报告，包括文本、HTML 和火焰图。（star 5.5K）

2、 [viztracer：低开销的日志记录/调试/分析工具，可视化 Python 代码的执行](https://github.com/gaogaotiantian/viztracer)

国人开源的日志记录/调试/分析工具，支持线程、多进程、子进程和异步，支持火焰图、远程连接、虚拟调试等，有强大的前端，可流畅渲染 GB 级堆栈信息。（star 3.5K）

![可视化界面](https://img.pythoncat.top/viztracer.png)

3、 [tenacity：Python 重试库](https://github.com/jd/tenacity)

可提供简单而灵活的方式来实现可靠的重试机制，支持指定重试次数、重试间隔时间、重试的回调函数、根据不同的错误条件进行重试等功能，减少手动处理错误和异常的麻烦。（star 5.1K）

4、 [litestar：轻量、灵活且可扩展的 ASGI API 框架](https://github.com/litestar-org/litestar)

一个高性能的 ASGI API 框架，其早期版本是基于 [Starlette](https://github.com/encode/starlette) 开发的，命名为 **Starlite**，但从 2.0 版本起已完全移除 Starlette 依赖，并改名为 litestar。核心特性：基于类的控制器、依赖注入、分层中间件、插件系统、OpenAPI 3.1、内置 Trio，等等。（star 2.5K）

5、 [Make-It-3D：利用单个图像创建高保真 3D 模型](https://github.com/junshutang/Make-It-3D)

从图片中分割物体，创建高保真的 3D 几何形状，可作 360° 旋转展示。（star 1.2K）

6、 [Color-diffusion：对黑白图像进行着色的扩散模型](https://github.com/ErwannMillon/Color-diffusion)

使用 diffusion  模型对黑白图像进行着色，使用 LAB 色彩空间实现，这是 RGB 色彩空间的 3 通道替代方案。

7、 [DevOpsGPT：AI 驱动的自动化软件开发系统](https://github.com/kuafuai/DevOpsGPT)

将 LLM 与 DevOps 工具相结合，将自然语言需求转换为可工作的软件。无需繁琐的需求文档编写与沟通，缩短开发与交付时间，加速软件部署和迭代。（star 1.2K）

![自动化需求开发的流程图](https://img.pythoncat.top/intro-flow-en.png)

8、 [ILibCST：Python 的具体语法树解析器和序列化器库](https://github.com/Instagram/LibCST)

具体语法树（Concrete Syntax Tree）是在词法分析和语法分析阶段后生成的一种数据结构，可用于分析代码结构，执行语义分析、重构优化和代码生成等操作。（star 1.2K）

9、 [hypothesis：功能强大、灵活且易于使用的库，用于基于属性的测试](https://github.com/HypothesisWorks/hypothesis)

基于属性的测试（Property-based Testing）是一种软件测试方法，其中测试用例的生成和验证是基于定义的属性或规约。传统的单元测试要给定具体的测试用例，而基于属性的测试则是随机生成大量的测试数据。（star 6.8K）

## 🐢播客&视频

1、 [Python People 播客](https://pythonpeople.fm/)

这是一档新上线一个月的播客栏目，每周访谈 Python 社区里一位有突出贡献的大佬。目前已访谈的嘉宾有 Michael Kennedy（Talk Python to Me 和 Python Bytes 的主理人）、Paul Everitt（ JetBrains 和 PyCharm 的开发者倡导者）、Brett Cannon（Python 核心开发者）、Barry Warsaw（Python 核心开发者，非常早的成员）、Bob Belderbos（Pybites 的主理人）。

![](https://img.pythoncat.top/2023-08-12_python_people.png)

2、 [Talk Python To Me #426：PyScript 的新增功能](https://talkpython.fm/episodes/show/426/whats-new-in-pyscript-august-2023)

Pyscript 使 Python 能够在浏览器中运行。这期播客聊了它的最新进展。

3、 [Stack Overflow Blog #597：了解 SRE](https://stackoverflow.blog/2023/08/08/understanding-sre-ep-597/)

网站可靠性工程（Site Reliability Engineering，SRE）是什么？它和 DevOps 有什么关系？如何平衡 SRE 的原则与组织结构的关系？生成式 AI 对 SRE 会带来什么影响？

4、 [Stack Overflow Blog #593：Python 团队如何调整语言以适应 AI 的未来](https://stackoverflow.blog/2023/07/25/how-the-python-team-is-adapting-the-language-for-an-ai-future-ep-593/)

播客嘉宾是 Python 核心开发者和指导委员会成员 Pablo Galindo Salgado，讨论了如何平衡语言设计中的一致性和新功能、为什么收集社区对新版本的反馈很重要，以及为何他要专注于让 Python 更快。

## 🐱赞助&支持

如果你觉得周刊有价值，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你喜欢周刊，请分享给其他需要的同学，让更多人可以从中受益～

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。
