---
title: 'Python 潮流周刊#12：Python 中如何调试死锁问题？'
pubDate: 2023-07-22
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

本周刊精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

**周刊已开通 Telegram 频道**，欢迎加入：[https://t.me/pythontrendingweekly](https://t.me/pythontrendingweekly)

## 🦄文章&教程

1、[使用 PyStack 调试 Python 中的崩溃和死锁](https://martinheinz.dev/blog/101) (英)

介绍了一款强大的工具 **PyStack**，可以解决一些难以调试的问题，如死锁、程序挂起、段错误、Python 和 C/C++ 混合应用调试等。它支持两种调试方法：附加到运行中的进程，或分析崩溃进程的核心转储文件。

2、[介绍一个 FastAPI 项目模板](https://bitestreams.com/blog/fastapi_template/) (英)

一个非常完备的 FastAPI 项目模板，带有 CI/CD、Docker、PostgreSQL、Makefile、单元/集成测试、linting及类型检查。

3、[Python FastAPI 微服务与 Polylith 架构](https://davidvujic.blogspot.com/2023/07/python-fastapi-microservices-with-polylith.html) (英)

**Polylith** 是一种软件架构框架，核心思想是将系统分解为一个个可测试的、可重用的独立单元。作者结合 FastAPI 与 Polylith 架构，开发了一个项目模板。

4、[Python日志模块：实战应用与最佳实践](https://juejin.cn/post/7257321872425058359)

详细解析了 **logging** 模块，从基本介绍到实际应用和最佳实践，介绍了如何高效地用它记录日志，以及如何避免常见的陷阱。

5、[测量 Python 和 Rust 异步 Web 服务的性能](https://codesolid.com/benchmarking-python-and-rust-async-web-server-performance/) (英)

文章使用 **JMeter** 分别测试了 Rust 的 **Axum** 框架以及 Python 的 **Blacksheep** 框架。猜猜最终的测试结论是什么呢？

6、[dinov2_retrieval：一个基于 DINOv2 的图片检索应用](http://vra.github.io/2023/07/14/dinov2-retrieval/)

Meta 发布了 **DINOv2** 视觉预训练模型，能够准确地理解图片中的语义信息。这篇文章用它开发了一个 Python工具，能够检索若干张图片在测试数据集中最相似的图。

![检索单车与三轮车](https://img.pythoncat.top/2023-07-21_dinov2.png)

7、[隐藏在 Python 标准库中的 CLI 工具](https://til.simonwillison.net/python/stdlib-cli-tools) (英)

Python 标准库中有哪些实用的小工具，可以直接写 `python -m xxx` 调用？这篇文章使用 **ripgrep** 查找出几十个模块，并重点介绍了`http.server` 、`base64` 、`asyncio` 、`tokenize` 、`ast` 、`json.tool` 、`random` 等工具。

8、[如何在 Python 项目中使用 TailwindCSS ？](https://www.abdulmumin.com/how-to-use-tailwindcss-in-any-python-project) (英)

Tailwind 是近几年在前端很火的一个 CSS 框架，如何将它运用到 Python Web 项目中呢？文章主要介绍了`tailwindpie` 这个库，并演示如何在 Flask 项目中使用它，实现自动安装及配置 TailwindCSS。

9、[Python 元编程实用指南](https://dev.to/karishmashukla/a-practical-guide-to-metaprogramming-in-python-691) (英)

介绍 Python 中元编程的几种机制：装饰器、元类、函数及类装饰器、动态代码生成，以及常用于元编程的关键字与内置函数。

10、[CPython 是如何打印堆栈信息的？](https://blog.stealthrocket.tech/how-cpython-prints-stack-traces/) (英)

一篇硬核长文，介绍了 CPython 如何表示程序的调用栈以及如何将字节码地址解析为源代码行号。文章剖析了 CPython 的内部机制，提供了 CPython 性能分析和调试的有用信息。 

![一个hello world程序的分析](https://img.pythoncat.top/2023-07-22-cpython.png)

11、[用于路径操作的 Pathlib](https://switowski.com/blog/pathlib/) (英)

Pathlib 是 Python 中作目录相关操作的库，而且应该是最好用的一个。文章详细介绍了它的常见用法，对比了其它常用工具，并且针对一些场景作了性能分析。

12、[Stack Overflow、Shopify 及 Levels.fyi 的软件架构](https://newsletter.techworld-with-milan.com/p/stack-overflow-architecture) (英)

文章分享了三家大型网站的软件架构。

13、[10 条编写干净 Python 代码的建议](https://dev.to/alexomeyer/10-must-know-patterns-for-writing-clean-code-with-python-56bf) (英)

代码的可读性与可维护性，再怎么强调也不为过！这篇文章介绍了一些基础的原则，但却非常体现程序员的编程素养。

14、[Meta 开发者工具：支撑大规模协作的编程体系](https://engineering.fb.com/2023/06/27/developer-tools/meta-developer-tools-open-source/) (英)

Meta 的几千名开发者使用了哪些支撑大规模协作的工具呢？文章介绍了几款开源工具（[Sapling](https://engineering.fb.com/2022/11/15/open-source/sapling-source-control-scalable/) 版本控制、 [Buck2](https://engineering.fb.com/2023/04/06/open-source/buck2-open-source-large-scale-build-system/) 构建系统、 [Infer](https://fbinfer.com/)/ [RacerD](https://engineering.fb.com/2017/10/19/android/open-sourcing-racerd-fast-static-race-detection-at-scale/)/[Jest](https://jestjs.io/) 测试与静态分析），另外 Meta 官博还有一篇介绍开发者工作流的文章 [Meta 开发者工作流：探索大规模编码工具](https://developers.facebook.com/blog/post/2022/11/15/meta-developers-workflow-exploring-tools-used-to-code/) 。

🎁**Python潮流周刊**🎁已免费发布了 12 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

如果你觉得周刊有价值，请表达小小心意，赞赏一下猫哥吧~~

![](https://img.pythoncat.top/support_pythoncat.png)

## 🐿️项目&资源

1、[GitHub 上有哪些值得推荐学习的 Python 项目？](https://www.reddit.com/r/Python/comments/111y9o2/python_projects_with_best_practices_on_github/) (英)

Github 上有哪些运用了最佳实践，并且有强大而良好架构的项目？这是 Reddit 上的帖子，可去看看大家推荐了什么。

2、[python-cheatsheet: Python 知识点速查表](https://github.com/gto76/python-cheatsheet) (英)

一份非常全面的 Python 知识手册，除了 Github 仓库，还有在线网站及 PDF 版本。（star 33K）

![速查表的内容目录](https://img.pythoncat.top/2023-07-22_cheatsheet.png)

3、[pandora：潘多拉，一个让你呼吸顺畅的ChatGPT](https://github.com/pengzhile/pandora)

国人开源的项目，实现了网页版 ChatGPT 的主要操作，能解决国内访问 ChatGPT 的诸多痛点。（star 18.6K）

4、[py4web：数据库驱动的 Web 开发框架](https://github.com/web2py/py4web) (英)

这个框架可以快速开发由数据库驱动的 Web 应用，它基于流行的全栈框架 [web2py](https://github.com/web2py/web2py) ，但比后者快 10-20 倍。

![py4web的主面板](https://img.pythoncat.top/dashboard_main.png)

5、[FastAPI-Vue-Admin：基于 FastAPI+Vue 的敏捷开发框架](https://www.oschina.net/p/fastapi-vue-admin)

基于 FastAPI、Vue2.x、ElementUI、MySQL 等框架精心打造的一款模块化、高性能、企业级的敏捷开发框架，实现了可插拔的组件式开发方式。国人作品（收费），有完善的中文支持。

![项目效果预览](https://img.pythoncat.top/2023-07-22_fastapi-vue-admin.png)

6、[ChatALL：同时与ChatGPT、Bing Chat、Bard、Alpaca、Claude、讯飞星火、文心一言等聊天](https://github.com/sunner/ChatALL)

这个项目的中文名叫“**齐叨**”，可同时与多个 AI 对话，方便取得最佳答案。（star 8.2K）

![使用时的页面](https://img.pythoncat.top/chatall.png)

7、[vectordb：一个 Python 向量数据库](https://github.com/jina-ai/vectordb) (英)

纯 Python 开发的向量数据库，支持 CURD 及强大的可扩展能力（分片与复制）。使用了  [DocArray](https://github.com/docarray/docarray) 充当驱动向量搜索逻辑的引擎，使用  [Jina](https://github.com/jina-ai/jina) 保证高效和可扩展的索引服务。

8、[python-sortedcontainers：有序容器类型（有序列表、有序字典和有序集合）](https://github.com/grantjenks/python-sortedcontainers) (英)

一个纯 Python 实现的有序容器库，提供了列表、集合与字典的有序版本，API 兼容，号称经常比 C 实现更快。用户指南中提供了几份性能对比报告，数据很可观。（star 3K）

![字典读取元素的性能比较](https://img.pythoncat.top/2023-07-22_sorteddict.png)

9、[quart：一个支持异步的 Python Web 框架](https://github.com/pallets/quart) (英)

这是基于 Flask 框架而作的异步版实现，支持快速将 Flask 项目改造成支持异步。（star 2K）

10、[ShortGPT：自动生成短视频内容的 AI 框架](https://github.com/RayVentura/ShortGPT) (英)

一个强大的自动化内容生成框架，简化了视频创建、素材获取、字幕生成、画外音合成和编辑任务。（star 1.4K）

![工作原理图](https://img.pythoncat.top/shortGPT.png)

## 🐢播客&视频

1、[捕蛇者说 Ep 41：和 Penguin 聊聊 CPython 优化和大厂编译器组的工作](https://pythonhunter.org/episodes/ep41)

这期播客的嘉宾曾出现在我们周刊的第 7 期，他给 [CPython 添加返回常量指令](https://github.com/python/cpython/issues/101632) ，节目聊了他给 CPython 做的这项工作以及在腾讯做编译器开发的情况。

2、[The Python Show 07 - 访谈 Robyn Web 框架的作者](https://www.pythonshow.com/p/07-the-robyn-python-web-framework#details) (英)

**Robyn** 是用 Rust 开发的轻量级、高性能 Python Web 框架。这期播客聊了关于 Robyn 的相关话题。

3、[2023 年 Python 网络大会的 80 个视频](https://www.youtube.com/playlist?list=PLt4L3V8wVnF4GJb8dekLGTNx44FNIFwdv) (英)

Python 网络大会（Python Web Conf）今年举办了第 5 届，上周发布了相关的视频材料，涵盖主题有人工智能/机器学习、大数据、CI/CD、Serverless、安全、容器等等。

![PWC2023的节目列表](https://img.pythoncat.top/2023-07-22_webconf.png)

4、[关于 AI 内容：推荐 6 个 YouTube 频道](https://thecreatorsai.com/p/what-to-watch-about-ai-6-youtube) (英)

想要了解 AI？想观看关于 ChatGPT 的相关视频？想发现最新潮的 AI 工具？这里推荐了 6 个油管频道。

5、[除你武器 013｜我也不想工作啊，只是想找个岸上一上](https://www.xiaoyuzhoufm.com/episode/64b4f4c5d0844ea812ce31e9)

这是我本周听到最喜欢的一档播客！这期节目聊了就业与人生选择的相关话题。（如果你是高考毕业生，可去听第 11 期高考特辑 [成为状元 9 年后，我还在做高考的噩梦](https://www.xiaoyuzhoufm.com/episode/647c8bb653a5e5ea14dbffad)）

## 🐱赞助&支持

如果你觉得周刊有价值，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你喜欢周刊，请分享给其他需要的同学，让更多人可以从中受益～

## 🐼欢迎订阅

[微信](https://img.pythoncat.top/python_cat.jpg) (可加群)| [博客](https://pythoncat.top)| [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)
