---
title: 'Python潮流周刊#11：如何使用 Golang 运行 Python 代码？'
pubDate: 2023-07-15
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python 及通用技术内容，大部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

本周刊精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

**周刊已开通 Telegram 频道**，欢迎加入：[https://t.me/pythontrendingweekly](https://t.me/pythontrendingweekly)

## 🦄文章&教程

1、[使用 Golang 和 Docker 运行 Python 代码](https://soulteary.com/2023/05/21/run-python-code-with-golang-and-docker.html)

如何使用 Golang 来运行 Python 代码呢？关于 Python 版本和硬件，有哪些使用限制呢？这篇文章使用 Docker 解决环境依赖问题，使用开源项目 **cpy3**，成功用 Golang 运行 Python 代码。它有一篇续文《[使用 Golang 和 Docker 实现 Python 计算服务](https://soulteary.com/2023/05/22/using-golang-and-docker-to-implement-python-computing-services.html)》，将普通的 Python 软件包封装为高性能的可通过 **gRPC** 方式调用的服务。

2、[答案在代码中：“实现需求”的双重含义](https://www.piglei.com/articles/the-answer-is-in-the-code-fulfill-requirements/)

很多程序员容易忽略一件事：那就是阅读代码的时间会远多于写下它们的时间！这意味着**代码的可读性**非常重要，因此当我们在“实现需求”时，除了要考虑用户的功能需求外，更应多加关注如何写出可读性高的代码。

3、[减轻 Python 包管理的痛苦](https://www.bitecode.dev/p/relieving-your-python-packaging-pain) (英)

@NoHeartPen 投稿：在看了第一期中[对 conda 的吐槽](https://www.v2ex.com/t/938669#reply88) 后，开始关注这个问题，但一直没有找到比较系统的总结，看了这篇文章后终于有了大致的思路（这篇文章不仅写了「怎么做」，还写了「为什么」，让我改掉了不建虚拟环境的陋习和放弃折腾 conda）。另外，附上翻译版 [如何减轻 Python 打包之痛](https://blog.csdn.net/csdnnews/article/details/131546123) 。

4、[CuPy：将 NumPy 数组调度到 GPU 上运行](https://www.cnblogs.com/traditional/p/17536459.html)

NumPy 的作者 Travis Oliphant 曾说，如果当时给 NumPy 添加了 GPU 的支持，就没有后来的 Tensorflow、Torch 等深度学习框架什么事了。[CuPy](https://github.com/cupy/cupy) 是一个兼容 Numpy 且支持 GPU 的库（star 7K），这篇文章介绍了它的安装及数组的基础知识。

5、[Python 源码剖析：深度探索 Cpython 对象](https://segmentfault.com/a/1190000044006618)

为什么说 Python 中一切皆对象？为什么 Python 用起来比其它静态类型语言慢很多？这篇文章从 CPython 的对象构造器入手，介绍了 CPython 底层数据结构、对象创建的过程、动态性的实现方式等内容。

6、[使用 Flask + Flask RESTful 快速搭建 API 服务](https://juejin.cn/post/7252976055093592120)

一篇长文，使用 Flask + Flask RESTful 搭建一个 API 应用，使用 **Flask-SQLAlchemy** 扩展实现 ORM 操作 MySQL 数据库，基于 JWT 验证实现注册、登录以及登出接口，解决跨域问题，并使用 Docker 部署该应用。

7、[详解 Django 请求与响应：深入理解 Web Http 交互的核心机制](https://segmentfault.com/a/1190000043988232)

探讨了 Django 中的请求与响应处理，包含基础知识、生命周期、HttpRequest 和 HttpResponse 对象的详细介绍。同时，讨论了 Django 的视图和请求、响应处理，以及安全性和异步处理的考虑。最后，对比了 Django 与 Flask、FastAPI 等框架在请求响应处理上的异同。

8、[将大型 Django 项目迁移到 Mypy 的失败之旅](https://dev.to/derlin/when-plans-go-astray-my-unsuccessful-journey-of-migrating-a-large-django-project-to-mypy-3l23) (英)

作者在给一个生产项目添加 Mypy 类型检查时遇到了诸多问题：很多库不提供 pyi 类型、TypedDict 使用受限、Optional 类型需要许多断言、混合类需要实现协议、Django 模型不支持泛型。简而言之，给历史项目加上类型检查是一件痛苦的事，最好是从一开始就考虑。

9、[如何在 Python 中使用 Notion API？](https://www.python-engineer.com/posts/notion-api-python/) (英)

Notion 是一款强大的知识管理软件，这篇教程教你如何用 Python 操作 Notion 的数据库：创建集成、在数据库中创建页面、查询数据库与页面、更新页面、删除页面。

10、[最简单的使用 Rust 加速 Python 的方法](https://pythonspeed.com/articles/easiest-rust-python/) (英)

如何将 Rust 代码打包为 Python 可使用的扩展？[maturin](https://www.maturin.rs/) 和 [setuptools-rust](https://setuptools-rust.readthedocs.io/) 是主流的两种方式。但是，在做原型设计时，打包与集成过程还是挺麻烦，这篇文章介绍了一个新的库 [rustimport](https://pypi.org/project/rustimport/) ，可以直接从 Python 中导入 Rust 代码！文章介绍了它的使用方法、Rust 初学者最常见的性能错误、以及使用 **rustimport** 时的一些陷阱。

11、[Python 是如何解析空格的？](https://jayconrod.com/posts/101/how-python-parses-white-space) (英)

Python 的换行与缩进是程序结构的基础部分。空格在 Python 的语法解析中起到什么作用，词法分析器如何处理换行和缩进？Python 的空格有哪些优点和缺点？Python 如何解析代码并生成抽象语法树？

12、[如何从 Python 字典中删除重复的值？](https://pythonguides.com/remove-duplicate-values-from-a-python-dictionary/) (英)

介绍了 7 种从 Python 字典中删除重复值的方法：使用 for 循环、使用字典解析式、使用 setdefault() 方法、使用 values() 和 set() 方法、使用 collections.defaultdict()、使用列表解析式、使用 dict.fromkeys() 和 values()。

13、[如何找出 Python 代码中的性能瓶颈？](https://realpython.com/python-profiling/) (英)

什么时候该给项目作性能优化？性能调优前该关注哪些内容，应该使用什么工具？这篇文章介绍了`time` 、`timeit` 、`cProfile` 、`Pyinstrument` 、`perf` 等工具以及一些性能优化的技巧。

14、[3 个很酷的 Python 库，节省你的时间和精力](https://samuel-vidovich.medium.com/3-cool-python-libraries-that-will-save-you-time-and-effort-27fcdc6762d5) (英)

介绍了 3 个非常好用的库：[JMESPath](https://github.com/jmespath/jmespath.py) 可以很方便查询 Json 中的元素（star 1.9k），[inflection](https://github.com/jpvanhal/inflection) 可以很方便处理字符串（比如批量将驼峰式变量名修改成蛇形命名），[more-itertools](https://github.com/more-itertools/more-itertools) 类似于标准库的`itertools` 提供了很多操作可迭代对象的方法（star 3.1k）。

15、[如何管理有近 3 万个文件的超大型 Python 代码仓？](https://blog.europython.eu/kraken-technologies-how-we-organize-our-very-large-pythonmonolith/) (英)

你见过接近 3 万个文件（不含测试）的 Python 单体代码仓么？全球有 400 开发者共同开发，如何避免混乱？作者介绍了分层管理代码仓的做法、使用的架构和工具（[import-linter](https://github.com/seddonym/import-linter)）、以及克服过的一些困难。

如果你觉得周刊有帮助，请表达小小心意赞赏下猫哥吧~~

![](https://img.pythoncat.top/support_pythoncat.png)

## 🐿️项目&资源

1、[threads-net：逆向工程 Threads 的 Python API](https://github.com/dmytrostriletskyi/threads-net) (英)

新上线的 Threads 依然是本周最火爆的科技话题之一。这个项目通过逆向工程获得了它的 API，可让你使用 Python 操作 Threads 的很多功能。

2、[engblogs：用 AI 为科技公司官博作摘要，并部署成网站](https://github.com/ishan0102/engblogs) (英)

这个项目用 RSS 抓取 AWS、Apple、DeepMind、Google、Meta、Stripe 等科技公司的博客，调用 gpt-3.5 生成摘要，将数据存储在 supabase 中，并在 Vercel 上托管了一个 Next.js [网站](https://www.engblogs.dev/)。

![项目的流程示意图](https://img.pythoncat.top/engblogs.png)

3、[django-unicorn：Django 全栈的响应式组件框架](https://github.com/adamghill/django-unicorn) (英)

可以为 Djiango 模板添加现代响应式的组件功能，无需使用 Javascript 框架。支持表单验证、重定向、加载状态、部分更新、滚动触发、消息、Javascript 集成等等丰富的功能。

4、[imarkdown：轻量级的 Markdown 图片链接转换器](https://github.com/Undertone0809/imarkdown)

可以批量将图片的链接进行本地到图片服务器、图片服务器到本地、图片服务器到图片服务器的转换。（@Zeeland 投稿）

![imarkdown的执行过程图](https://img.pythoncat.top/imarkdown.png)

5、[Pangu-Weather：盘古天气的官方实现](https://github.com/198808xc/Pangu-Weather) (英)

可以通过人工智能来提升天气预报的准确度啦？！Pangu-Weather 是一个快速而准确预报全球天气的 3D 高分辨率模型。这个仓库提供了伪代码、预训练模型、推理代码等资源。

6、[PULSE：中文医疗大语言模型](https://github.com/openmedlab/PULSE)

基于 4 百万个中文医学领域和通用领域的指令微调，支持医学领域的各种自然语言处理任务，包括健康教育、医师考试问题、报告解读、医疗记录结构化以及模拟诊断和治疗。基于这个大模型，已经有不少应用，比如与 X-ray 图像模型结合的应用 **XrayPULSE** ：

![诊断与咨询X光影像](https://img.pythoncat.top/XrayPULSE.jpg)

7、[creosote：识别虚拟环境中未使用的依赖库](https://github.com/fredrikaverpil/creosote) (英)

可扫描虚拟环境中未使用的依赖库，支持 Poetry、Pipenv、PDM、 `requirements.txt` 文件以及 PEP-621 的 `pyproject.toml` 文件。

8、[MediaGPT：中文的自媒体大语言模型](https://github.com/IMOSR/MediaGPT)

一个面向自媒体创作、直播和运营等领域的大语言模型，能够理解抖音运营、短视频创作、巨量千川投放、直播运营等领域的核心概念和策略，支持内容创作、平台运营、广告投放等。

9、[MetaGPT：给定一行需求，返回 PRD、设计、任务、代码](https://github.com/geekan/MetaGPT) (英)

一个元编程框架，可以为 GPT 分配不同的角色（如产品经理/架构师/项目经理/工程师），共同协作完成复杂的软件开发任务。仅需一句话需求，就能输出用户故事/竞争分析/需求/数据结构/API/文档等。（star 3.7k）

![软件公司多角色示意图](https://img.pythoncat.top/software_company_cd.jpeg)

10、[khoj：数字大脑的 AI 个人助理](https://github.com/khoj-ai/khoj) (英)

基于个人的 Markdown 笔记、PDF 文件、Github 代码仓和照片，打造支持搜索与聊天的 AI 助理，可通过浏览器、Emacs、Obsidian 和移动设备等多种界面进行交互。

![架构图](https://img.pythoncat.top/khoj_architecture.png)

11、[aider：基于命令行的 AI 编码助手](https://github.com/paul-gauthier/aider) (英)

一个命令行聊天工具，可以让 GPT 创建新项目，或修改现有 git 代码仓中的代码。它可以轻松完成 git 提交、比较和撤消更改，无需人工复制/粘贴。（star 2.3k）

![给函数添加参数和类型注解](https://img.pythoncat.top/2023-07-15_aider.png)

12、[visprog：可视化编程，无需训练的合成视觉推理](https://github.com/allenai/visprog) (英)

一篇 CVPR 2023 最佳论文的官方实现，可以实现：基于图片内容的自然语言问答与推理、图片内对象标注、自然语言图片编辑等功能。

![visprog可以做的事情](https://img.pythoncat.top/teaser1.png)

## 🐢播客&视频

1、[Talk Python To Me Podcast #421 Python at Netflix](https://talkpython.fm/episodes/show/421/python-at-netflix) (英)

Python 在 Netflix 中有大量的使用场景，比如 CDN、需求预测和容灾、安全、机器学习等等。这期播客节目聊了 Netflix 在使用 Python 时的相关话题。另外，分享它官博上获得 8k 赞的一篇旧文《[Python at Netflix](https://netflixtechblog.com/python-at-netflix-bba45dae649e)》。

2、[Python Bytes #343 So Much Pydantic!](https://pythonbytes.fm/episodes/show/343/so-much-pydantic) (英)

这期播客聊了很多话题，其中关于 Pydantic 的有两则：V2 版本已发布、一个[awesome-pydantic](https://github.com/Kludex/awesome-pydantic) 清单，后者收录了很多使用 Pydantic 的开源项目。

## 🥂讨论&问题

1、[Pytorch有什么节省显存的小技巧？](https://www.zhihu.com/question/274635237)

知乎上的一个问题，前排有很多高赞的回答，八仙过海各显神通！

2、[如果 PEP-703 被采纳，Meta 将投入人力支持](https://discuss.python.org/t/a-fast-free-threading-python/27903/99) (英)

Python 社区今年最受瞩目的提案当属 PEP-703 了吧（我曾[在年初介绍过](https://pythoncat.top/posts/2023-02-20-GIL)）！Guido 上个月在论坛中说要是能得到 Meta 等科技公司的支持就太好了。好消息来了，上周 Meta 承诺可以提供人力支持。消息在 Twitter 和 Hacker News（[查看 HN 帖子](https://news.ycombinator.com/item?id=36643670)）等平台上，获得了激烈的讨论。

## 🐱赞助&支持

内容创作要花费大量的时间和精力，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png) 或 [买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

如果你喜欢本周刊，请转发分享给其他需要的同学，让更多人可以从中受益～

## 🐼欢迎订阅

[微信](https://img.pythoncat.top/python_cat.jpg) (可加群)| [博客](https://pythoncat.top)| [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou) 
