---
title: 'Python潮流周刊#9：如何在本地部署开源大语言模型？'
pubDate: 2023-07-01
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python 及通用技术内容，部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

首发于我的博客：[https://pythoncat.top/posts/2023-07-01-weekly](https://pythoncat.top/posts/2023-07-01-weekly)

## 🦄文章&教程

1、 [本地部署开源大模型的完整教程：LangChain + Streamlit+ Llama](https://ai.plainenglish.io/%EF%B8%8F-langchain-streamlit-llama-bringing-conversational-ai-to-your-local-machine-a1736252b172) (英)

一篇步骤清晰的教程，它使用 LangChain 及 Facebook 开源的 LLaMA 大语言模型搭建了一个基于文档的问答助手，另外使用 Streamlit 构建出一个美观的用户界面。（附一篇中文的[翻译文](https://segmentfault.com/a/1190000043935266) ）

![](https://img.pythoncat.top/2023-06-30_llm.png)

2、 [Python Asyncio 协程对象开销成本](http://so1n.me/2023/05/29/python_asyncio_lib_overhead/)

一个 Python Asyncio 协程会占用有多少内存呢？文章的测试结论是约 2Kb。另外，文中还测试了以下的问题：每秒可创建多少个裸协程？每秒可处理多少个协程？使用`uvloop` 后，创建及处理协程任务，能有多少提升？

3、 [如何使用 asyncio.Runner 执行多个协程](https://superfastpython.com/asyncio-runner/) (英)

asyncio.Runner 是 Python 3.11 中新增的功能，支持在同一事件循环中执行多个协程。文章主要内容：如何使用 asyncio.run() 运行多个协程，如何使用包装方法运行多个协程，以及如何使用 asyncio.Runner 类在同一个事件循环中以自适应甚至有条件的方式执行协程。

4、 [不使用锁的并发实现](https://hakibenita.com/django-concurrency) (英)

在并发编程中，通常需要使用锁，但是不应该滥用锁。这篇文章探讨了如何尽量不依赖锁来实现并发，演示的例子是生成短链接，主要的思想是“请求宽恕”而不是“提前检查”、使用 PostgreSQL 数据库提供的功能。

5、 [贡献 CPython 日记 (3) CPython 是如何运行的](https://zhuanlan.zhihu.com/p/639119164)

文章介绍了 CPython 是如何把 Python 代码跑起来的，主要过程：词法分析、语法分析、编译到字节码、执行字节码。

6、 [Python JIT 编译器 - 即时编译](https://coderslegacy.com/python-jit-compilers/) (英)

文章探讨了 JIT 编译的概念及其优点，并深入分析了主流的 Python JIT 编译器的优缺点（如 PyPy、Numba 和 Cython），介绍了在 Python 中使用 JIT 编译器的最佳实践和准则。

7、 [CPython、Pypy、MicroPython、Jython……都是些什么？](https://www.bitecode.dev/p/whats-the-deal-with-cpython-pypy) (英)

当我们说 Python 时，通常指的是官方实现的 CPython，但还有很多的“Python”，比如 Pypy、Jython、MicroPython、Brython、RustPython 等等，还有很多像是新“Python”的东西，比如 Nuitka、WinPython、Psyco、Pyjion 等等。文章解释了相关的概念和工具。

![](https://img.pythoncat.top/2023-07-01_python.jpeg)

8、 [Python APScheduler：感受 AsyncIOScheduler 的强大](https://coderslegacy.com/python-apscheduler-asyncioscheduler/) (英)

APScheduler 是一个调度和自动化任务工具，它的 AsyncIOScheduler 支持调度异步函数和协程，文章介绍了它的功能、优点以及如何优化异步任务调度需求。

9、 [在生成代码时避免产生技术债务](https://sourcery.ai/blog/chatgpt-maintainable-code/) (英)

GPT 和其它大语言模型可以快速生成大量代码，但这也可能导致很多的混乱代码。文章探讨了如何改进这些工具生成的代码，并将其融入到项目中的几种方法，包括采用专家角色、提供示例、遵循最佳实践、遵循标准和明确指南以及代码放置的恰当位置等。

10、 [当 NumPy 太慢时](https://pythonspeed.com/articles/numpy-is-slow/) (英)

在不考虑并行处理的情况下，如何提升 Numpy 性能？NumPy 有三个固有瓶颈（急切执行、通用编译代码和向量化导致的高内存使用率）。针对这些瓶颈，文章介绍四种解决方案：手动优化代码、使用 JAX 作即时编译、使用 Numba 作即时编译，以及使用提前编译。

11、 [Numba 教程：使用 JIT 编译加速 Python 代码](https://coderslegacy.com/python-numba-tutorial/) (英)

Numba 是一个专用的即时编译器，通过将 Python 代码编译为高效的机器代码来消除解释执行的开销，从而提升性能。文章介绍了 Numba 的功能、内部原理、主要用法和常见问题。

12、 [自动化提升 Python 代码质量](https://blog.fidelramos.net/software/python-code-quality) (英)

如何使用较少的时间和精力来提升代码的质量？文章介绍了一些提升代码质量的工具（flake8、Black、isort、mypy、bandit等），以及使用 IDE、CI 和 pre-commit 等方式自动化调用这些工具。 

13、 [使用 PandasAI 增强数据分析](https://cognibits.hashnode.dev/enhancing-data-analysis-with-pandasai) (英)

PandasAI 是最近火爆的库，为 Pandas 集成了 AI 对话功能，可简化数据操作。文章介绍了 PandasAI 作复杂查询与图表可视化的方法，以及介绍了它提供的十几个方便好用的函数。

14、 [ 写单元测试的最佳实践](https://www.codium.ai/blog/best-practices-for-writing-unit-tests/) (英)

单元测试的好处无须赘述，但是写单测却是开发者最讨厌的事情之一。文章罗列了 10 条写单元测试的最佳实践，介绍了手工写单元测试的步骤，最后介绍了使用 Codium.AI 自动化编写测试的方法。

15、 [Netflix 如何安全地迁移到 GraphQL](https://netflixtechblog.com/migrating-netflix-to-graphql-safely-8e1e4d4f1e72) (英)

Netflix 官方的一篇博客，介绍了在将手机 APP 安全地从 Falcor 迁移到 GraphQL 的过程中，所采用的三种测试策略：AB 测试、Replay 测试和 Sticky Canaries。AB 测试用于评估新功能对客户的影响，Replay 测试用于验证迁移的正确性，Sticky Canaries 用于验证性能和业务指标。

🎁**Python潮流周刊**🎁已免费发布了 9 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

## 🐿️项目&资源

1、 [PyGWalker：将 pandas 数据转换为 Tableau 样式的可视化界面](https://github.com/Kanaries/pygwalker) (中英)

一个在 Jupyter Notebook 环境中运行的可视化探索式分析工具，仅一条命令即可生成一个可交互的图形界面，以类似 Tableau/PowerBI 的方式，通过拖拽字段进行数据分析。（star 6.5K）

![](https://img.pythoncat.top/pygwalker2.png)

2、 [jnumpy：快速用 Julia 编写 Python C 扩展](https://github.com/Suzhou-Tongyuan/jnumpy) (英)

用 Julia 为 Python 写高性能的 C 扩展，提速约 200x。（@xgdgsc 投稿）

3、 [jupyter-ai：JupyterLab 的生成式 AI 扩展](https://github.com/jupyterlab/jupyter-ai) (英)

JupyterLab 官方提供的生成式 AI 扩展，主要提供了：`%%ai` 指令、原生的聊天 UI 页面、支持大量平台的大语言模型（AI21、Anthropic、Cohere、Hugging Face、OpenAI、SageMaker 等）。

4、 [broadcast-service: 一个强大的 Python 发布订阅者框架](https://github.com/Undertone0809/broadcast-service)

一个发布订阅者框架，支持同步异步调度、定时任务、主题管理、发布订阅者回调等功能。（@Zeeland 投稿）

5、 [cushy-storage: 一个基于磁盘缓存的 ORM 框架](https://github.com/Undertone0809/cushy-storage)

一个基于磁盘缓存的 ORM 框架，可对基本数据类型及自定义的数据通过 ORM 进行增删改查，支持多种序列化操作和数据压缩方式。（@Zeeland 投稿）

6、 [giskard：专用于 ML 模型的测试框架](https://github.com/Giskard-AI/giskard) (英)

如何测试机器学习模型、要涵盖哪些问题、如何实施测试？这个框架可扫描数十种漏洞（性能偏差、数据泄漏、不鲁棒性、虚假关联、过度自信、信心不足、不道德问题等），并基于结果生成特定领域的测试套件。（star 1K）

![](https://img.pythoncat.top/giskard.png)

7、 [DragGAN：基于点的交互式图像编辑](https://github.com/XingangPan/DragGAN) (英)

本周最火项目，可在图像上通过拖动点的方式，生成想要的新图像，非常惊艳！（star 28K）

![](https://img.pythoncat.top/DragGAN.gif)

8、 [plumbum: 永远不要再写 shell 脚本](https://github.com/tomerfiliba/plumbum) (英)

除了类似 shell 的语法和方便的快捷方式外，这个库还提供了本地和远程命令执行（通过 SSH）、本地和远程文件系统路径、简单的目录和环境操作、以及一个可编程的 CLI 工具包。（star 2.6K）

9、 [threestudio：用于生成 3D 内容的统一框架](https://github.com/threestudio-project/threestudio) (英)

支持用文本提示、单个图像和少量镜头图像创建 3D 内容。支持多种模型，如 ProlificDreamer、DreamFusion、Magic3D、Score Jacobian Chaining，等等。（star 1.8K）

10、 [rembg：一个删除图像背景的工具](https://github.com/danielgatis/rembg) (英)

支持删除图像的背景，支持多种使用方式（cli、库、docker）和多种强大的功能。（star 10.5K）

![](https://img.pythoncat.top/2023-07-01_rembg.png)

## 🐼关于周刊

Python 潮流周刊，由豌豆花下猫主理，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

内容创作要花费大量的时间和精力，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！如果你喜欢本周刊，请转发分享给其他需要的同学，让更多人可以从中受益～

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) (可加群)| [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)

![](https://img.pythoncat.top/pythoncat.png)
