---
title: 'Python潮流周刊#8：Python 3.13 计划将解释器提速 50%！'
pubDate: 2023-06-24
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python 及通用技术内容，部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

首发于我的博客：**[https://pythoncat.top/posts/2023-06-24-weekly](https://pythoncat.top/posts/2023-06-24-weekly)** 

## 🦄文章&教程

1、[Python 3.13 版本的计划](https://github.com/faster-cpython/ideas/blob/main/3.13/README.md) (英)

Faster CPython 项目（即香农计划）有了关于 3.13 版本的最新计划，这次的性能目标是减少解释器 50% 的耗时。涵盖三项主要工作：第 2 层的优化器、启用子解释器（PEP-554）、内存管理。

2、[为什么 Numpy 并行性很重要？](https://superfastpython.com/why-numpy-parallelism/) (英)

Numpy 是作科学计算和数据分析的最重要的库之一，并行性是提升其性能的重要手段。文章介绍了 5 种可以实现 Numpy 并行性的场景和方法：加载/保存 Numpy 数组数据、高效地计算数学函数、高效地初始化数组、并行执行数组的元素级数学运算、在进程间高效共享 Numpy 数组数据。

3、[用少于 100 行的 Rust 使 Python 变快 100 倍](https://ohadravid.github.io/posts/2023-03-rusty-python/) (英)

文章针对一个有性能问题的 Python 库，使用 Rust 重写并作了三轮优化后，提升了性能 100 倍。文中使用了 py-spy 库绘制火焰图，分析出了代码的瓶颈点，并以此作为优化的依据，可以看到前后火焰图的差别很大。

![py-spy火焰图](https://img.pythoncat.top/2023-06-23_rust.png)

4、 [将 Python 项目移植到 Rust](https://www.jelmer.uk/port-py-to-rust.html) (英)

文章指出“一步到位的移植”方式存在一些问题，从而提出“迭代式移植”的方法，并给出了一个代码示例。

5、 [设计 Pythonic 的库 API](https://benhoyt.com/writings/python-api-design/) (英)

如何设计出一个 Pythonic 的 API？在设计上有什么方法和基本原则呢？文章从代码结构、变量命名、错误处理、版本控制、类型注解等方面，给出了非常详细的介绍。文章较长，最后总结出 18 条 takeaways。

6、 [编译类型化的 Python](https://bernsteinbear.com/blog/typed-python/) (英)

Python 已支持类型提示，那能否编译 Python 代码为本地代码以提升性能呢？虽然类型提示可以提供一些性能优化，但由于 Python 的动态特性和灵活性，使得静态分析和编译非常困难。因此目前还没有一种方法可以将 Python 代码编译成本地代码以提高性能。 

7、 [pytest 的夹具很神奇！](https://www.revsys.com/tidbits/pytest-fixtures-are-magic/) (英)

夹具（fixture）是在测试前设置和准备必要数据的一种机制，可以将测试数据和测试代码分离。文章介绍了 pytest 中夹具的基本用法，以及与 Django 项目的结合使用。

8、 [探析 Python 字典的实现原理](https://just-taking-a-ride.com/inside_python_dict/chapter1.html) (英)

这是一个系列文章，支持用可视化的调试方式探析 Python字典的实现原理。这篇文章介绍了如何通过哈希表实现字典，以及如何解决哈希冲突。 

![在列表中搜索的可视化](https://img.pythoncat.top/2023-06-24_dict.png)

9、 [Flask vs Django：选择完美的 Python Web 框架](https://djangocentral.com/flask-vs-django-selecting-the-perfect-python-web-framework/) (英)

Python 最主流的两个 Web 框架是 Flask 和 Django，文章深入比较了它们的主要功能、优势与缺点、流行的插件和使用场景等，让读者更方便做出自己的选择。

10、 [为什么不告诉人们“简单地”使用 pyenv、poetry、anaconda](https://www.bitecode.dev/p/why-not-tell-people-to-simply-use) (英)

文章的要点是：介绍一个基本的 Python 打包流程，尽可能减少依赖和要求，并解决大多数用户的打包问题。文中列出了一些常见的打包问题，并提供了一些解决方案，同时指出了一些常见的打包工具（如 homebrew、pyenv、anaconda、poetry）的缺点。 

11、 [PyScript 中的 Asyncio](https://jeff.glass/post/pyscript-asyncio/) (英)

文章介绍了在 PyScript/Pyodide 中使用 `async/await/asyncio` 来编写并发代码，还介绍了 Pyodide.Webloop 的实现，该实现允许 async/await 与浏览器事件循环一起使用。

12、 [线程的问题及其解决方案](https://glyph.twistedmatrix.com/2014/02/unyielding.html) (英)

[上期周刊](https://pythoncat.top/posts/2023-06-17-weekly7)第一则分享中的三篇文章偏向于支持隐式的 async，有读者建议再呈现一些支持显式 async 的观点。这篇文章的要点是：线程会使本地推理变得困难，而本地推理是软件开发中最重要的事情之一。因此，应该避免使用线程，而使用异步编程模型，如回调、promise、协程等。同时，文章还提到了使用隐式协程的风险，因为它们可能会导致与线程相同的问题。（@Plutonium 投稿）

## 🐿️项目&资源

1、 [PyQt-Fluent-Widgets：基于 PyQt5 的 Fluent Design 风格组件库](https://github.com/zhiyiYo/PyQt-Fluent-Widgets/blob/master/docs/README_zh.md)

目前开源且美观实用的 PyQt/PySide 组件库很少，所以作者照着 WinUI3 的设计稿写了这个 Fluent Design 风格的组件库，支持亮暗主题无缝切换和自定义主题色，支持 PyQt5/PyQt6/PySide2/PySide6 ，搭配 QtDesigner 可以快速设计出美观的界面。（来自@shokokawaii）

![](https://img.pythoncat.top/Interface.jpg)

2、 [pyvibe：使用 Python 生成样式化的 HTML 页面](https://github.com/pycob/pyvibe) (英)

PyVibe是一个用于创建网页的 Python 库，让 Python 开发者快速构建前端页面，简化 UI 开发。PyVibe 返回一个 HTML 字符串，可用于静态页面、Flask 函数、Pyodide 动态客户端呈现。

![PyVibe生成标题及文本的示例](https://img.pythoncat.top/social.png)

3、 [pynecone：纯 Python 的 Web 框架](https://github.com/pynecone-io/pynecone) (英)

Pynecone 发布于 2022 年 12 月，已获得 9K 星星，可谓十分火爆。它是一个用于构建和部署 Web 程序的全栈框架，提供了 50+ 内置组件，支持创建复杂的布局和使用 CSS 的全部功能来设置样式。

![Pynecone文档及演示项目](https://img.pythoncat.top/2023-06-24_pynecone.png)

4、 [pytudes：短小精悍的 Python 编程练习内容](https://github.com/norvig/pytudes) (英)

这个项目包含了一些短小却很有挑战性的项目代码，既有“Advent of Code”历年的年度编程挑战活动的题目，也有“The Riddler”的系列数学谜题，还有文字谜题、概率问题等，甚至有使用 Python 解任何的数独题、实现一个 lisp 解释器，等等。

5、 [recognize-anything：Recognize Anything 模型和 Tag2Text 模型](https://github.com/xinyu1205/recognize-anything) (英)

Recognize Anything Model 是一种图像标记模型，可以高精度地识别任何常见类别；Tag2Text 是一种以标签为指导的视觉语言模型，可以支持字幕、检索和标签。这个项目是这两个模型的代码实现。

![对比不同模型的物体标注能力](https://img.pythoncat.top/tagging_results.jpg)

6、 [ask-multiple-pdfs：支持与多个 PDF 聊天的 Langchain 程序](https://github.com/alejandro-ao/ask-multiple-pdfs) (英)

支持使用自然语言同时与多个 PDF 文件进行对话。项目使用了 streamlit，可在浏览器中显示用户界面。

![实现原理图](https://img.pythoncat.top/PDF-LangChain.jpg)

7、 [DeepKE：用于知识图谱提取和及构建的开放工具包](https://github.com/zjunlp/DeepKE) (英)

DeepKE 是用于知识图谱构建的知识提取工具包，支持 cnSchema、低资源、文档级和多模态场景的实体、关系和属性提取。三个主要功能：命名实体识别、关系提取、属性提取。项目提供了详细的文档、教程和在线演示。

![模型的框架](https://img.pythoncat.top/architectures.png)

8、 [awesome-DevOps：精选的 DevOps 平台、工具、实践和资源的列表](https://github.com/wmariuss/awesome-devops) (英)

一个“awesome”系列仓库，收录了关于 DevOps 的方方面面的内容，包含各种平台、自动化、CI/CD、代码管理、网络服务器、数据库、监控工具、网关、混沌工程，等等。

## 🥂讨论&问题

1、 [Hacker News：Our Plan for Python 3.13](https://news.ycombinator.com/item?id=36339777) (英)

一则热门讨论，话题关于 Python 3.13 版本的开发计划。不出意外，大部分的留言都围绕着 GIL，赞成与反对声皆有。

2、 [在你最喜欢的编程语言中，有哪些很优雅的代码库？](https://news.ycombinator.com/item?id=36370684) (英)

这也是一则 HN 上的帖子，既引起了关于编程语言本身的讨论，也涉及不同编程语言生态中的一些优秀的项目。有趣的是，有三则关于 Python 的留言都推荐了我们在上文中分享的`pytudes` 项目！

## 🐼关于周刊

Python 潮流周刊，由豌豆花下猫主理，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

内容创作要花费大量的时间和精力，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！如果你喜欢本周刊，请转发分享给其他需要的同学，让更多人可以从中受益～

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) (可加群)| [RSS](https://pythoncat.top/rss.xml) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)

![](https://img.pythoncat.top/pythoncat.png)