---
title: 'Python潮流周刊#7：我讨厌用 asyncio'
pubDate: 2023-06-17
author: '豌豆花下猫'
---

你好，我是猫哥。这里记录每周值得分享的 Python 及通用技术内容，部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

首发于我的博客：https://pythoncat.top/posts/2023-06-17-weekly7

## 🦄文章&教程

1、[AsyncIO](https://charlesleifer.com/blog/asyncio) (英)

文章的作者讨厌 asyncio 库，认为使用 `async` 和 `await` 的设计十分糟糕，它与大多数库不兼容，也不满足“Python之禅”的一些标准。作者的推荐方案是 gevent，提及了它的几点好处。另外，作者还推荐了两篇相关的文章：Flask 作者 Armin Ronacher 的《[I don't understand Python's Asyncio](https://lucumr.pocoo.org/2016/10/30/i-dont-understand-asyncio)》，SQLAlchemy 作者 Mike Bayer 的《[Asynchronous Python and Databases](https://techspot.zzzeek.org/2015/02/15/asynchronous-python-and-databases/)》

2、[gevent 到底是什么？](https://eng.lyft.com/what-the-heck-is-gevent-4e87db98a8) (英)

gevent 是一个基于协程的协作式多任务 Python 框架，使用猴子补丁来协调所有代码。这篇文章是一个系列的第一篇，介绍了 gevent 的基本实现原理，第二篇是《[Gevent Correctness](https://eng.lyft.com/gevent-part-2-correctness-22e3b7998382)》，第三篇是《[Gevent Performance](https://eng.lyft.com/gevent-part-3-performance-e64303fa102b)》

3、[ReactPy 的入门教程](https://www.kdnuggets.com/2023/06/getting-started-reactpy.html) (英)

上期周刊推荐过的 ReactPy 最近很火，它支持用 Python 写 React 风格的前端应用。这里是一篇简单的入门教程。另外，建议感兴趣的同学去看[官方文档](https://reactpy.dev/docs/guides/getting-started/index.html)。

![reactpy 的 hello world 程序](https://img.pythoncat.top/2023-06-16_reactpy.png)

4、[Python 业务框架循环依赖和全局上下文的一些思考](https://qin.news/python-circular-dependency-and-global-contexts)

如何简单而优雅地解决 Python 的循环依赖问题呢？作者考察了主流 API 框架（Django、Flask、FastAPI）的上下文管理方案，然后介绍了自己框架采用的方案：借鉴了 Ray 社区中对象所有权的概念，在一个协程上实现一个简易的所有权字典。

5、[Python 函数调用的实际依赖关系跟踪](https://amakelov.github.io/blog/deps) (英)

跟踪 Python 函数调用时访问的代码和数据是一种很有用的操作，比如绘制依赖图、调试和分析性能、缓存失效。这篇文章考察了一种可能的实现方式，包含了一个少于 100 行代码的最小可行实现。作者是 MIT 的计算机科学博士。

6、[Python 3.x从基础到实战 - typing类型提示](https://juejin.cn/post/7244033665209073725)

这是一篇入门教程，通过简短的示例，介绍了 Python Typing 模块的基础用法和进阶用法。

7、[wxPython 入门教程](https://www.pythonpapers.com/p/an-intro-to-wxpython) (英)

wxPython 是跨平台的图形用户界面框架，基于 wxWidgets 库开发，在 1998 年发布。它最新发展到了 4.x 版本，这篇文章基于最新的特性作了详细的入门介绍。

![wxPython 的 hello world 程序](https://img.pythoncat.top/2023-06-15_wxpython.png)

8、[Python 装饰器的用法指导](https://juejin.cn/post/7241943960083546171)

一篇很认真的文章，介绍了装饰器的基本概念和进阶用法。在示例部分介绍了 Django 的几个很常用的装饰器（`@login_required`、`@permission_required`、`@csrf_exempt`、`@cache_page`）。

9、[在进程间共享 Numpy 数组的 7 种方式](https://superfastpython.com/numpy-share-array-processes) (英)

多进程编程时最麻烦的事情之一就是共享数据，这篇文章介绍了 7 种共享 Numpy 数组的方式：传递参数、使用全局变量、使用队列 Queue、使用管道 Pipe、使用基于 ctypes 的 RawArray、使用 Python 3.8 的 SharedMemory、使用多进程的管理器。这是一篇系统性的长文，里面还引用了作者的一些相关文章，十分推荐阅读。

10、[在 Python 中作时间序列分析的工具](https://www.timescale.com/blog/tools-for-working-with-time-series-analysis-in-python) (英)

时间序列数据（**Time-Series Data**）是指在不同时间点上收集的数据，这篇文章介绍了在 Python 中分析时间序列数据的工具，包括常用的 NumPy、pandas 和 Matplotlib，以及 Tsfresh、Sktime、AutoTS、Prophet、Timescale 等。

![](https://img.pythoncat.top/2023-06-15_time-series.png)

11、[如何快速处理缺失的数据](https://neuronize.dev/learn-handling-missing-data-in-10-minutes) (英)

在数据分析和机器学习领域，需要尽量确保数据集的完整性和准确性，因此处理缺失值是必不可少的环节。文章先介绍了数据缺失的原因和模式（完全随机丢失 、随机丢失和不随机丢失），然后介绍了处理缺失值的常用方法：删除、填充、插补。

12、[Cython 与 CPython：对比性能差异](https://coderslegacy.com/cython-vs-cpython-comparing-speed) (英)

这篇文章用 10 个不同的基准作性能比较，涵盖了多种场景及边缘情况，包括斐波那契数列、斐波那契数列（迭代）、矩阵乘法、质数生成、字符串拼接、计算均值、计算均值（未优化）、算术运算、文件操作、线性搜索、冒泡排序。猜猜最后的结论是什么呢？

13、[使用 FastAPI 进行流式处理](https://www.vidavolta.io/streaming-with-fastapi) (英)

服务器推送事件 （**Server-Sent Events**） 是一种基于 HTTP 的单向通信协议，允许服务器向客户端实时推送数据。这篇文章解释了如何使用 FastAPI 实现流式处理 JSON 事件。文章出自“*FastAPI Pro 系列*”，另外两篇文章关于[如何使用动态配置](https://www.vidavolta.io/dynamically-configure-python-apps-fastapi)、[如何加密保护 API](https://www.vidavolta.io/fastapi-api-keys)。

![SSE 示意图](https://img.pythoncat.top/2023-06-17_sse.png)

14、[20 道关于 FastAPI 中间件的面试题](https://techwasti.com/fastapi-interview-questions-on-middleware) (英)

中间件（**middleware**）是 FastAPI 中的一种机制，允许在 HTTP 请求和响应到达路由处理程序之前拦截和修改它们。文章包含 20 个与中间件、身份验证和授权相关的面试题。

15、[CPython 添加返回常量指令](https://github.com/python/cpython/issues/101632) (英)

上期周刊引发了“国内 Python 贡献者数量”的话题，@yihong0618 在推特上留言分享了 @penguin-wwy 给 CPython 提交的这个贡献。该作者发现 LOAD\_CONST + RETURN\_VALUE 高频出现在 pystats 文档中，因此提交了一个新的 **RETURN_CONST** 指令，此项贡献在 Python 3.12 基准测试中获得约 10% 的性能提升。

🎁**Python潮流周刊**🎁已免费发布了 7 期，扫描下方二维码，即可查看全部内容：

![](https://img.pythoncat.top/python_weekly_banner.png)

## 🐿️项目&资源

1、[argcomplete：命令行自动补全库](https://github.com/kislyuk/argcomplete) (英)

在使用 Python 命令或者命令行工具时，一个痛点是没有补全。使用 argcomplete 后，按 tab 键就可以自动补全。它需要与 argparse 模块一起使用，目前支持 bash 和 zsh 两种 shell。

2、[Lawyer LLaMA：中文法律 LLaMA](https://github.com/AndrewZhe/lawyer-llama)

这是一个系统性学习了中国的法律知识体系的大语言模型，能够正确理解民法、刑法、行政法、诉讼法等常见领域的法律概念，可进行基础的法律咨询，涵盖婚姻、借贷、海商、刑事等。

3、[CPM-Bee：百亿参数的中英文双语基座大模型](https://github.com/OpenBMB/CPM-Bee)

这是一个完全开源、允许商用的百亿参数中英文基座模型，采用 Transformer 自回归架构，在超万亿（trillion）高质量语料上进行预训练。在中文的 Zero-CLUE 评测基准上，它大幅超越其他模型，位列中文大模型第一。

![](https://img.pythoncat.top/2023-06-17-BMB.png)

4、[TigerBot：多语言多任务 LLM](https://github.com/TigerResearch/TigerBot)

也是国内团队开源的大语言模型，根据 OpenAI InstructGPT 论文在公开 NLP 数据集上的自动评测，TigerBot-7B 达到 OpenAI 同样大小模型的综合表现的 96%。

5、[BingAI-Client：突破限制的 New Bing](https://github.com/xbzstudio/BingAI-Client)

New Bing 集成了 ChatGPT，但是在国内使用的门槛有点高！这个项目的客户端基于 Angular，服务端基于 FastAPI 和 [EdgeGPT](https://github.com/acheong08/EdgeGPT)。在本地部署好后，运行服务端程序即可开始使用客户端。（另外推荐一个项目 [go-proxy-bingai](https://github.com/adams549659584/go-proxy-bingai)，是用 Vue3 和 Go 搭建的 New Bing 演示站点，国内可用，无需登录即可畅聊）

6、[tabby：可自托管的 AI 编码助手](https://github.com/TabbyML/tabby) (英)

这是 GitHub Copilot 的开源/本地替代品，无需 DBMS 或云服务，拥有 Web UI，支持消费级的 GPU。

![tabby的效果演示](https://img.pythoncat.top/2023-06-17-tabby.gif)

7、[pyboke：极简博客生成器](https://github.com/ahui2016/pyboke)

一个功能极简、代码极简、自带四种主题、支持生成 RSS 的静态博客生成器。项目基于 Python 3.10，主要使用的库有 arrow、click、jinja2、mistune 等。

8、[gpt-engineer](https://github.com/AntonOsika/gpt-engineer) (英)

这是一个基于 ChatGPT4 的 AI 工程师，你只用告诉它需求，然后它会问几个问题，接着生成整个项目代码。提供出来的演示视频非常惊艳！

![gpt-engineer的效果演示](https://img.pythoncat.top/2023-06-17-engineer.gif)

9、[audiocraft：音频处理和生成库](https://github.com/facebookresearch/audiocraft) (英)

这是 FaceBook 开源的一个 PyTorch 库，有最先进的 EnCodec 音频压缩器/分词器，内含文本到音乐模型 MusicGen，使用了 10K 高质量音乐曲目的内部数据集，以及 ShutterStock 和Pond5 的音乐数据。

10、[PythonGUI 教程网站](https://www.pythonguis.com) (英)

Python 中有很多开发 GUI 的库，除了前文提到的 wxPython，还有 Tkinter、PyQt、PySide、Kivy 等等。这个网站上提供了很多 GUI 相关的学习资料。

11、[CPython 实现原理](https://hai-shi.gitbook.io/cpython-internals)

这是一本用 GitBook 制作的在线电子书，翻译自微软独立研究员 Anthony Shaw 的《CPython Internals》。

![](https://img.pythoncat.top/2023-06-16_cpython.png)

## 🐢播客&视频

1、[pybites：](https://pybit.es/articles/importance-of-refactoring)[定期重构的重要性](https://pybit.es/articles/importance-of-refactoring) (英)

这期播客聊了关于重构的相关话题。

2、[三个看似一样的列表，占用内存空间竟然不一样多？](https://b23.tv/cw3Ai8V)

有三个看起来完全一样的列表：[0]*3、[0,0,0]、[0 for _ in range(3)]，但是使用 sys.getsizeof() 计算的内存却完全不同。这是为什么呢？这期 B 站视频通过分析字节码和 CPython 解释器源码，非常硬核地分析出了根本原因，值得一看！

3、[asyncio的理解与入门，搞不明白协程？看这个视频就够了](https://b23.tv/2XeGXwI)

这里呼应一下本期标题及第一则内容。asyncio 依然是最主流的异步编程库，近几年也在逐渐发展成熟，很有必要深入学习。这是一则 B 站视频，适合用于入门与加深理解。

## 🐼关于周刊

Python 潮流周刊，由豌豆花下猫主理，精心筛选国内外的 250+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

内容创作要花费大量的时间和精力，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！如果你喜欢本周刊，请转发分享给其他需要的同学，让更多人可以从中受益～

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) (可加群)| [RSS](https://pythoncat.top/rss.xml) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)

![](https://img.pythoncat.top/pythoncat.png)