---
title: 'Python潮流周刊#5：并发一百万个任务要用多少内存？'
pubDate: 2023-06-03
author: '豌豆花下猫'
---

你好，我是猫哥。这里记录每周值得分享的 Python 及通用技术内容，部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

## 🦄文章&教程

1、[并发一百万个任务要用多少内存？](https://pkolaczk.github.io/memory-consumption-of-async/)（英文）

文中测试了主流的编程语言（Rust、Go、Java、C#、Python、Node.js 和 Elixir），依次运行 1 个、1 万、10 万和 100 万个任务，统计了这些语言所消耗的内存。随着任务量增加，它们的排名出现了较大变化，让我感觉挺意外的。

![100万任务占用的内存](https://img.pythoncat.top/2023-06-02-100K.png)

2、[使用这些方法让你的 Python 并发任务执行得更好](https://towardsdatascience.com/use-these-methods-to-make-your-python-concurrent-tasks-perform-better-b693b7a633e1) （英文）

使用 asyncio 有什么最佳实践呢？这篇文章介绍了 asyncio.gather、asyncio.as_completed 和 asyncio.wait API，还介绍了 Python 3.11 中引入的新 asyncio.TaskGroup 特性。（附一篇[不完整的译文](https://juejin.cn/post/7237424021768011834)）

3、原推荐文章为拼凑且非原创，已删

4、[Python 多线程编程的终极指南](https://programmingeeksclub.com/ultimate-python-multithreading-guide) （英文）

也是一篇长文，介绍了 Python 多线程编程的方方面面，真的是一份终极指南。

5、[编程语言是如何实现并发的之并发模型篇](https://www.bmpi.dev/dev/deep-in-program-language/how-to-implement-concurrency/concurrency-model/)

依然是长文，介绍了常见的并发模型及不同编程语言是如何实现的。它的姊妹篇是《[编程语言是如何实现并发的之操作系统篇](https://www.bmpi.dev/dev/deep-in-program-language/how-to-implement-concurrency/os-scheduling/)》，都是图文并茂，资料翔实。

![并发模型](https://img.pythoncat.top/2023-06-02_concurrency.png)

6、[鹅厂程序员的 9 个生存法则](https://segmentfault.com/a/1190000043833549)

作者分享了自己工作多年对代码设计、架构设计和工作思维的经验，比如 DRY 原则、SOLID 原则、高可用设计、如何想尽一切办法“偷懒”，等等。（文中提到了面向对象编程的原则，这里顺便推荐另一位鹅厂程序员的《[Python工匠](https://github.com/piglei/one-python-craftsman)》系列的第 12-14 章）

7、[一览 Python 3.12！PEP 701 —— f-string 语法规范化](https://juejin.cn/post/7238274120881422392)

f-string 是 Python 最好用的特性之一，但它也有诸多限制。即将发布的 3.12 会对 f-string 作语法规范化，详情可查看 [PEP-701](https://peps.python.org/pep-0701/) 。这里分享的文章带大家直观地感受了这个改动在代码的词法解析（lexing）层面的不同。

8、[PyCharm：新用户界面的五大亮点](https://blog.jetbrains.com/pycharm/2023/05/five-things-to-love-about-the-new-ui/) （英文）

大家都用上 PyCharm 新的 UI 了么？这份官方教程介绍了新 UI 的使用方法及亮点。

9、[PEP-594 已被实现：Python 3.13 将移除 20 个标准库](https://discuss.python.org/t/pep-594-has-been-implemented-python-3-13-removes-20-stdlib-modules/27124) （英文）

Python 3.12 正式版本还要几个月才发布，这边 3.13 已经迫不及待地移除了 20 个标准库。值得一提的是，2to3 项目及 lib2to3 模块也将会被移除。

10、[Grasshopper：一个用于负载测试的开源 Python 库](https://innovation.alteryx.com/introducing-grasshopper-an-open-source-python-library-for-load-testing/) （英文）

Locust 是 Python 最主流的分布式负载测试库，而文章介绍的 [Grasshopper](https://github.com/alteryx/locust-grasshopper) 是新开源的基于 Locust 与 Pytest 的更全面的性能测试库。

![Grafana面板展示了Grasshopper和InfluxDB指标](https://img.pythoncat.top/Screenshot-at-Apr-28-13-09-21.png)

11、[Python 装饰器：用包装巫术增强你的代码](https://hackthedeveloper.com/python-decorator/) （英文）

Python 装饰器是增强代码行为和灵活性的强大工具，文章内容从基础到高阶，是不错的学习材料。

12、三个练手项目的实战教程：

- [用 Python 开发 Telegram 机器人](https://swiftuser.hashnode.dev/how-to-telegram-bot-with-python) （英文）：开发 tg 机器人，教程使用 Tornado 作后端，项目部署在 Render 平台上
- [花一周末用 Python 实现 DNS](https://implement-dns.wizardzines.com/index.html) （英文）：教程指导实现一个 DNS 解析器，总代码仅约 200 行，但作者给出了很多学习材料和代码讲解，你能学到的绝对够多。另外，教程最后还有 7 个练习题，可以进一步开发 DNS 解析器的功能。（Julia Evans 是一个宝藏作者，[博客](https://jvns.ca/)、[网站](https://wizardzines.com) 、[pandas-cookbook](https://github.com/jvns/pandas-cookbook) ，等等，强烈推荐！！！）
- [用 Python 构建你自己的 Git](https://www.leshenko.net/p/ugit/) （英文）：这个项目我要给它满分！教程网站设计得独特而酷炫，从最小可行项目起步，逐渐添加代码，手把手教你实现 Git 的各种功能。每章都使用 Git 的差异比对方式，明确告诉你增删了哪些代码，良心满满，全网估计找不着第二家！

![构建自己的 Git](https://img.pythoncat.top/2023-06-02_ugit.png)

## 🐿️项目&资源

1、[frogmouth：一个在终端中浏览 Markdown 的工具](https://github.com/Textualize/frogmouth) （英文）

frogmouth 可以打开本地或 URL 中的 md 文件，具有类似浏览器的导航条、历史记录、书签和目录。

2、[使用 Meta AI 的 SAM 进行图像分割的 Python GUI](https://github.com/dibrale/samist) （英文）

一个 Python 桌面程序，为 Meta 公司的 AI 模型 SAM 提供了图形界面，可以提取照片里面的物体。

3、[GirlfriendGPT：你的人工智能伴侣](https://github.com/EniasCailliau/GirlfriendGPT) （英文）

你有对象了么？这个入门项目使用 ChatGPT 构建一个 AI 伴侣， 拥有个性化的人格、声音以及自拍照！

4、[Python 进化之路.pptx](https://www.slideshare.net/Manjusaka1/python-pptx-258083055)

一份技术分享的 PPT 材料，介绍了 Python 3.7-3.11 在性能、类型体验及开发者体验方面的优化。

![Python解释器优化](https://img.pythoncat.top/2023-06-02_python_road.png)

5、[soundstorm-pytorch：在 Pytorch 中实现 SoundStorm ](https://github.com/lucidrains/soundstorm-pytorch) （英文）

SoundStorm 是 Google Deepmind 新提出的一个高效的、非自回归的音频并行生成模型。soundstorm-pytorch 使用 Pytorch 实现了这个模型。

6、[asynq：Python 的异步编程库](https://github.com/quora/asynq) （英文）

 asynq 是 Quora 开发的异步编程库，专注于对外部服务的批处理请求。对于 memcache、redis 等存储服务，它发起一次请求批量获取多个 key，比发出多次请求每次获取一个 key 要快得多。

7、[Propan：功能强大且易用的 Python 异步 Web 框架](https://github.com/Lancetnik/Propan) （英文）

一个基于 pydantic、fastapi 和 pytest 的异步框架，简化了 MQ 的代码集成，并提供了一个有用的开发工具包。其特点是基于消息架构（Messaging Architecture）设计，所以它还是个声明式的 MQ 框架。

8、[talkGPT4All：基于 GPT4All 的一个语音聊天程序](https://vra.github.io/2023/05/27/talkgpt4all-2-0/)

它利用 OpenAI 的 Whisper 模型将用户输入的语音转换为文本，再调用 GPT4All 的语言模型得到回答文本，最后利用文本转语音（TTS）的程序将回答文本朗读出来。

9、[lightly：一个用于图像自监督学习的 Python 库](https://github.com/lightly-ai/lightly) （英文）

这是一个用于自我监督学习的计算机视觉框架，以类似 PyTorch 的风格编写，支持使用 PyTorch Lightning 进行分布式训练。

![相关概念的示意图](https://img.pythoncat.top/lightly_overview.png)

## 🐢播客&视频

1、[硬地骇客：独立开发赚钱难？你需要正确的build策略](https://www.xiaoyuzhoufm.com/episode/647456af6752b5f9de6bd99c)

探讨了在海外独立开发者中最常用的 **build in public** 策略。我对这期节目很有共鸣，打算针对本周刊的一些数据、周刊的创作流程、个人知识输入及创作体系等话题，不久会做一些分享。

2、[代码之外：离开微软、人生在于体验？阅读的意义、主动和被动的人生](https://www.xiaoyuzhoufm.com/episode/646af4a66752b5f9dec561c6)

这是一档新上线的程序员闲聊播客节目，主题很随性，但常常有能打动人的片段。这里分享的是第一期，它目前已更新到第三期，第三期请的嘉宾是 Vue 的作者尤雨溪！

3、[Changelog #526：与你的朋友一起 Git](https://changelog.com/podcast/526) （英文）

这期播客聊了一些 Git 工具，如 Git-Heat-Map、Git-Sim、git-bug、GitUI，等等。因为有两个工具是用 Python 编写的，因此也聊了一些 Python 安装依赖包的话题。Brett Cannon 针对主播们的错误用法，写了一篇[回应博客](https://snarky.ca/in-response-to-the-changelog-526/) ，主要介绍了 pipx、.pyz 文件以及系统包管理器的正确使用。

4、[#418：如何在 Python 程序中加密保存](https://talkpython.fm/episodes/show/418/how-to-keep-a-secret-in-python-apps) （英文）

“Talk Python To Me”的这期播客探讨如何处理程序要用到的敏感信息，同时也聊到了日常个人密码的保存方案。我正巧本周还看到一篇《[2023-21: 我的 1Password 密钥管理实践](https://xuanwo.io/reports/2023-21/)》，它系统介绍了密码管理、SSH/Shell 集成和 CI/CD 应用等内容。

5、[吴恩达三门新的生成式 AI 课程](https://www.deeplearning.ai/short-courses/?continueFlag=40c2724537472cbb3553ce1582e0db80) （英文）

使用 OpenAI 的 ChatGPT API 构建系统、LangChain 用于开发 LLM 应用、Diffusion模型是如何工作的。

6、[MIT 的三门 Python 相关课程](https://twitter.com/python_spaces/status/1663976856578822144) （英文）

麻省理工学院的免费课程：Python 计算机科学和编程简介、经典机器学习、深度学习。

## 赞助&支持

内容创作不易，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！如果你喜欢本周刊，请转发分享给其他需要的同学～

另诚邀赞助者，欢迎通过私信联系。

## 关于周刊

Python 潮流周刊，精心筛选国内外的 200+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) | [RSS](https://pythoncat.top/rss.xml) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)

![](https://img.pythoncat.top/pythoncat.png)