---
title: 'Python潮流周刊#3：PyPI 的安全问题'
pubDate: 2023-05-27
author: '豌豆花下猫'
---

你好，我是猫哥。这里记录每周值得分享的 Python 及通用技术内容，部分为英文，已在小标题注明。（标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）


## 🦄文章&教程


1、[掌握Python面向对象编程的关键：类与对象](https://segmentfault.com/a/1190000043822529)

介绍类和对象概念，通过示例展示 Python 中的类和对象如何工作，包括定义、实例化和继承等。文章出自《Python全景系列》，目前已更新七篇。

2、[umongo + motor: 构建高效 MongoDB 应用的最佳组合](https://juejin.cn/post/7232977661207085117)

介绍如何在 Tornado 中集成 umongo 和 motor，实现用异步非阻塞的方式与 MongoDB 进行交互。文章出自《tornado 并发编程系列》，目前已更新六篇。

3、[徒手使用 LangChain 搭建一个 ChatGPT PDF 知识库](https://juejin.cn/post/7234821431804002365)

演示了如何使用 langchain 和 ChatGPT 搭建一个本地的 PDF 知识库，文中使用了 pdfplumber 处理 PDF 文件、使用 streamlit 绘制 UI 界面。知识库搭建和使用流程图如下：

![知识库的工作流](https://img.pythoncat.top/2023-05-27_langchain.png)

4、[Python 真的是靠一个 switch 来执行字节码的吗？](https://laike9m.com/blog/python-zhen-de-shi-kao-yi-ge-switch-lai-zhi-xing-zi-jie-ma-de-ma,138)

一个流行的观点说：CPython 有一个大**switch**，会根据不同的 opcode 跳到相应的 case 分支去执行字节码。文章提出了质疑，最后的结论是：只要 Python 启用了 computed goto （比如在 Mac 和 Linux 上），字节码的执行就不依赖 switch。而这个功能在 Python 3.2 中就已是默认开启的。

5、[SQLite 的文艺复兴](https://www.bmpi.dev/dev/renaissance-sqlite)

文章的开头把我震惊了：“SQLite 源码有 15 多万行，但测试代码和脚本竟有九千多万行”！文章介绍了 SQLite 的架构，以及多个基于它的开源项目，如 Litefs、sql.js、absurd-sql、postlite、sqlite3vfshttp 等等，回答了为什么 SQLite 能在如此多领域有创新的项目出现？

6、[八十行代码实现开源的 Midjourney、Stable Diffusion “咒语”作图工具](https://soulteary.com/2023/04/05/eighty-lines-of-code-to-implement-the-open-source-midjourney-and-stable-diffusion-spell-drawing-tool.html#%E5%86%99%E5%9C%A8%E5%89%8D%E9%9D%A2)

通过 Docker 和 80 行左右的 Python 代码，实现一款类似 Midjourney 官方图片解析功能 Describe 的 Prompt 工具。提供了两个版本的工具，分别支持 CPU 和 GPU 推理使用。

7、[像写 Rust 一样写 Python](https://kobzol.github.io/rust/python/2023/05/20/writing-python-like-its-rust.html)（英文）

分享了从 Rust 中学到的一些编程习惯：使用类型提示、使用数据类代替元组或字典、使用代数数据类型、使用“newtype”、使用构造函数、使用互斥锁等。总体而言，它们并不是那些“个人喜好式”的编程风格，而是切实能提升代码健壮性和可维护性的编程经验。

8、[一系列的 Flask 小贴士](https://www.patricksoftwareblog.com/flask_tips.html)（英文）

这个《Flask Tips》栏目已分享了 58 个使用 Flask 的小知识，另外其作者在最新的博文《[我开发 Flask 程序时最喜欢用的库](https://www.patricksoftwareblog.com/my_favorite_python_packages_for_flask.html)》中，介绍了 APIFairy、Frozen-Flask、Flask-SQLAlchemy 等 10 个常用的库。

9、[Celery 的诸多问题](https://steve.dignam.xyz/2023/05/20/many-problems-with-celery/)（英文）

Celery 是一个分布式任务队列库，用于实现异步处理和定时任务等功能。但它有很多“问题”，这篇文章一口气列出了 15 个，是一份避坑指南。不过，并非所有问题都有解决方案，比如说它 API 接口不够 Pythonic、没有类型检查等，这些就只能“Live with it”了……

10、[Python 借助 Gopy 库实现调用 Go 包](https://last9.io/blog/using-golang-package-in-python-using-gopy/)（英文）

作者遇到一个静态验证 PromQL 查询的需求，但没有可用的 Python 库。文章介绍了使用  Gopy 将 Go 代码编译成 wheel 文件的方法，另外也提醒几个注意事项，比如对错误的处理、操作系统的兼容性问题、调试和测试的问题。

![在Python中使用Go包的流程](https://img.pythoncat.top/2023-05-27_gopy.png)

11、[最适用于 Pandas 的文件格式](https://pythonspeed.com/articles/best-file-format-for-pandas/)（英文）

使用 Pandas 前需要加载数据，它支持非常多种数据格式，但哪种才最合适呢？文中给出了三个衡量标准（类型支持、磁盘格式、读写速率），并测试了三种数据文件（CSV、JSON 和 Parquet），你猜最后的结论是什么呢？

12、关于 PyPI 的一系列新闻/文章（英文）

PyPI 在 3 月上线了官方博客，5 月初刚宣布获得了 AWS 的 14.4 万美元赞助，用于开设一个新的安全工程师职位。巧的是本周密集出现了几件与安全相关的事情。

- 5.21，PyPI 在连续一周受到恶意软件的侵扰后，[临时暂停](https://status.python.org/incidents/qy2t9mjjcc7g)了新用户的注册及新项目的上传。（这有[一篇文章](https://programmingeeksclub.com/pypi-security-threats-implications-python-community)，提到一则有相关性的新闻，这些恶意软件可能是趁 ChatGPT 的热点，通过窃取剪贴板内容从而劫持加密货币交易）
- 5.23，PyPI [宣布移除 PGP 签名](https://blog.pypi.org/posts/2023-05-23-removing-pgp/)，因为近三年上传的签名仅有 36% 为有效的，移除这项功能有利于降低维护成本。（这有[一篇文章](https://blog.yossarian.net/2023/05/21/PGP-signatures-on-PyPI-worse-than-useless)，使用大量数据和统计图分析了 PyPI 上糟糕的 PGP 情况）
- 5.24，PyPI 发了[一篇博客](https://blog.pypi.org/posts/2023-05-24-pypi-was-subpoenaed)，披露 PSF 收到了美国司法部的三张要求提供 PyPI 用户数据的传票，在律师的建议下，他们提供了司法部索要的数据，并公开了传票的相关细节。
- 5.25，PyPI 发布《[通过双因素身份验证保护 PyPI 帐户](https://blog.pypi.org/posts/2023-05-25-securing-pypi-with-2fa)》，宣布在 2023 年底前，PyPI 上的帐户都必须启用双重验证（2FA），以此提升账户的安全性。
- 5.26，PyPI 发布《[减少 PyPI 中存储的 IP 数据](https://blog.pypi.org/posts/2023-05-26-reducing-stored-ip-data)》，介绍了团队出于不存储用户 IP 的目的而做的一些事情，试图既要保护用户的隐私，又能更好地运维管理。

## 🐿️项目&资源

1、[CyberWaifu：使用 LLM 和 TTS 实现的聊天机器人](https://github.com/Syan-Lin/CyberWaifu)

使用 LangChain 作为 LLM 主体框架，使用 go-cqhttp 进行 QQ 机器人部署，TTS 支持 vits、edge-tts，语言模型支持ChatGPT 和 Claude。

2、[FastGPT：基于 openai 搭建的知识库平台](https://github.com/c121914yu/FastGPT)

技术栈: NextJs + TS + ChakraUI + Mongo + Postgres，支持私有化部署，可以在线体验。

3、[jesth：更具可读性的数据序列化格式](https://github.com/pyrustic/jesth)（英文）

文档将这种新格式与 TOML、YAML 和 JSON 分别做了对比，并详细展示了在 Python 中的使用方法。

4、[trogon：为 CLI 程序生成友好的用户界面](https://github.com/Textualize/trogon)（英文）

命令行程序本就是无界面的，但是这对于用户来说不够友好。这个项目可以生成美观的界面，用于编辑和运行命令。

![友好的用户界面](https://img.pythoncat.top/2023-05-27_cli.png)

5、[ipyflow：用于 Jupyter 笔记本的响应式 Python 内核](https://github.com/ipyflow/ipyflow)（英文）

可在交互式会话期间，跟踪符号和单元格之间的数据流关系，支持的功能：显示执行建议、支持响应式执行、语法拓展、集成了 ipywidgets，等等。

6、[solara：一个纯 python、React-风格的框架](https://github.com/widgetti/solara)（英文）

solara 可使用 Reacton（纯 Python 实现的 React）创建基于 ipywidget 的程序。可用在 Jupyter Notebook，也可以作为独立的 Web 程序在 FastAPI 等框架中使用。

7、[Python 3.12 的 beta 1 版本已发布](https://pythoninsider.blogspot.com/2023/05/python-3120-beta-1-released.html)（英文）

3.12 的最终版本计划在 10 月 2 日发布，目前发布了 beta 1 版本，意味着不会再加入新功能。总体而言，这个版本更为精简了（删除了很多函数、类和方法），性能方面也有很多优化。值得一提的是，这个版本虽然引入了 PEP-684（每个子解释器的独立 GIL），但需要等 3.13 版本实现 PEP-554（标准库中的多解释器）后，才真正的可用。

8、[对比 Python 与 Rust 的编程习惯用法](https://programming-idioms.org/cheatsheet/Python/Rust)（英文）

这是一个有意思的网站，可比较不同编程语言在 300 多项习惯用法上的区别，提升学习效率。我们这里比较了 Python 和 Rust，在网站首页可选的语言有 30 种。

![Python与Rust的惯用法对比](https://img.pythoncat.top/2023-05-27_idioms.png)

## 🐢播客&视频

1、[哈佛大学的 Python 编程入门课程](https://www.edx.org/course/cs50s-introduction-to-programming-with-python)（英文）

哈佛大学计算机科学专业的入门课程，向初学者介绍计算机科学和编程基础，以及如何使用 Python 进行编程。目前已有 50 万人参与学习。

2、[推荐 10 个最好用的 Django 插件](https://pybit.es/articles/django-plugin-recommendations-by-antonio-mele-top-10-picks-for-web-development/)（英文）

这期视频中，《Django by Example》书籍的作者推荐了 10 个 Django 插件，例如 Django Debug Toolbar、Django REST Framework、Django Channels，等等。

## 🥂讨论&问题

1、[Windows 要支持 tar、7-zip、rar、gz 等格式啦？](https://tech.slashdot.org/story/23/05/23/1940217/28-years-later-windows-finally-supports-rar-files)（英文）

来自一则匿名爆料，Windows 要利用开源项目 libarchive 实现对 rar 等格式的支持了。这会是真的么？

2、[构建 API 的最佳语言——TS/JS vs. Python](https://www.reddit.com/r/Python/comments/13nfyir/best_language_for_building_apis_tsjs_vs_py/)（英文）

从可维护性、优雅性、灵活性和开发速度的角度来看，这两种语言的 API 开发体验哪种更好？

## 赞助&支持

内容创作不易，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！如果你喜欢本周刊，请转发分享给其他需要的同学～

另诚邀赞助者，欢迎通过私信联系。

## 关于周刊

Python 潮流周刊，精心筛选国内外的 200+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) | [RSS](https://pythoncat.top/rss.xml) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)

![](https://img.pythoncat.top/pythoncat.png)