---
title: 'Python潮流周刊#2：Rust 让 Python 再次伟大'
pubDate: 2023-05-20
author: '豌豆花下猫'
---

这里记录每周值得分享的 Python 及通用技术内容，部分为英文，已在小标题注明。（本期标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

## 🦄文章&教程

1、[Python修饰器的函数式编程](http://coolshell.cn/articles/11265.html)

介绍了装饰器的实现原理、带参装饰器、多装饰器、类装饰器和几个典型的示例。文章发布于 2014 年，代码用的还是 Python 2。之所以分享这篇文章，因为它是[左耳朵耗子](https://coolshell.cn/haoel)唯一以 Python 为话题的文章，而且写得详细到位。

2、[asyncio 的一些高级用法](https://www.cnblogs.com/traditional/p/17403428.html)

出自我们的老朋友@**古明地觉** 的新系列《asyncio 系列》，半个月内已连载 14 篇。真想问问他是如何做到如此高产又高质量的？！文章回答了：如何设计既能接收协程又能接收普通 Python 函数的 API，如何强制事件循环的迭代，如何在不传递参数的情况下在任务之间传递状态……

3、[Nginx+uWSGI 部署 Django 以及负载均衡操作](https://segmentfault.com/a/1190000043790186)

介绍了 uWSGI 和 Nginx 的配置，实现对 Django 服务的反向代理及负载均衡。该文出自仍在连载的《Django 系列》，目前该系列包含 44 篇文章，能作为系统学习 Django 的参考材料。

4、[Rye:一个实验性质的Python包管理系统](http://vra.github.io/2023/05/17/rye-intro/)

Python 目前的包管理工具多得让人眼花缭乱，而 Conda 和操作系统的包管理器也存在诸多问题（本周刊第一期就有两则相关内容）。Flask 作者 Armin Ronacher 用 Rust 开发的 rye，借鉴了 Rust 包管理的经验，试图提供一个标准化的解决方案。这篇文章介绍了 rye 的安装及使用。

5、[PyInstaller：将你的Python代码打包成独立应用程序](https://juejin.cn/post/7232571353123487802)

PyInstaller 可将 Python 程序打包为一个可执行文件，支持多个平台如 Windows、Mac 和 Linux。这是一篇简单清晰的使用教程，除了基础介绍外，难得的是它还介绍了两种打包方式的优缺点，以及打包后常见的 5 个问题。

6、[如何在 Python 中实现真正的多线程](https://martinheinz.dev/blog/97)（英文）

Python 3.12 即将推出“Per-Interpreter GIL（PEP-684）”特性，它允许 Python 实现真正的并行处理。代码虽然已在 alpha 版本中，但目前只能通过 C-API 使用。文章使用 CPython 的`test` 模块演示了子解释器的示例。

7、[GIL vs. nogil: 改动一行代码，提升十倍 I/O 性能](https://www.backblaze.com/blog/python-gil-vs-nogil-boost-i-o-performance-10x-with-one-line-change/)（英文）

[nogil 项目](https://pythoncat.top/posts/2021-11-14-GIL)是另一个试图实现真正多线程的方案，这篇文章测试发现 CPython 3.9-nogil 在单文件和多文件的情况下，比未修改的 CPython 3.9 分别快 2.5 倍和 10 倍。nogil 项目最新的进展是形成了正式的 PEP-703，相关介绍[在此](https://pythoncat.top/posts/2023-02-20-GIL)。

![](https://img.pythoncat.top/2023-05-18_gil.png)

8、[如何在 PyCharm 中创建一个密码生成器？](https://blog.jetbrains.com/pycharm/2023/05/create-passphrase-generator-in-pycharm/)（英文）

PyCharm 官方推出的文章教程，指导在 PyCharm 中创建项目、导入包、使用 Typer 库创建 CLI 应用、运行和调试代码、创建和编辑运行配置，适合于新人学习练手。另外，[PyCharm 2023.1.2](https://blog.jetbrains.com/pycharm/2023/05/pycharm-2023-1-2-is-out) 版本刚刚发布，可以去尝鲜！

9、[Python 元类教程（带示例）](https://coderslegacy.com/python-metaclass-tutorial/)（英文）

在 Python 中，一切都是对象，包括**类**。元类是 Python 的一项强大功能，允许你在运行时动态地创建类（实际是创建一个`type` 类型的对象）。文章探讨元类的基础知识，以及更高级的功能和示例。

10、[当在终端输入“ls”后会发生什么？](https://www.warp.dev/blog/what-happens-when-you-open-a-terminal-and-enter-ls)（英文）

有一道很常见的面试题：“当在浏览器输入 google.com 后会发生什么？”由于见得多了，每个人都能回答个一二，但是，经常跟终端打交道的我们，能否回答这个问题呢：当在终端输入命令后会发生什么？文章主要介绍了终端的历史、启动过程、命令的解析和执行过程。

## 🐿️项目&资源

1、[WingetUI：更好用的包管理器 UI](https://github.com/marticliment/WingetUI)（英文）

该项目的目标是为 Win 10-11 中最常见的 CLI 包管理器（如 Winget、Scoop 和 Chocolatey）创建一个直观的 GUI。已支持软件包的安装、更新和卸载、排队安装、消息通知、黑暗模式、导入/导出等功能。

2、[pandas-ai：支持 AI 功能的 Pandas](https://github.com/gventuri/pandas-ai)（英文）

Pandas 无疑是目前最流行的数据分析和处理工具，当它结合了生成式 AI 的能力后，会不会更好用呢？答案似乎是的！pandasai 项目支持用文字的方式操作 Pandas 的数据对象，可简化很多 Pandas 库的操作。

3、[promptulate：一个强大的 LLM Prompt Layer 框架](https://github.com/Undertone0809/promptulate)

一个专为 Prompt Engineer 设计的 LLM Prompt Layer 框架，支持连续对话、角色预设、对话存储、工具扩展等功能，可以无需代理直接访问，开箱即用。 通过 promptulate，你可以轻松构建起属于自己的 GPT 应用程序。

4、[MicroPython：面向微控制器和嵌入式系统的 Python](https://github.com/micropython/micropython/releases/tag/v1.20.0)（英文）

MicroPython 新发布了 1.20 版本，引入了一个新的轻量级包管理器，减小了代码大小，并增加了对许多新板的支持。另外，LWN 的[这篇文章](https://lwn.net/Articles/931051)对此版本做了介绍，文章还提到 Anaconda 有可能在 Q2 将 PyScript 的运行时从 Pyodide 替换为 MicroPython。

5、[DB-GPT：以数据库为基础的 GPT 实验项目](https://github.com/csunny/DB-GPT)

使用本地化的 GPT 大模型与你的数据和环境交互，无数据泄露风险，100% 私密，100% 安全。基于 FastChat 构建大模型运行环境，并提供 vicuna 作为基础的大语言模型，通过 LangChain 提供私域知识库问答能力，支持插件模式，在设计上原生支持 Auto-GPT 插件。

![](https://img.pythoncat.top/DB-GPT.png)

## 🐢播客&视频

1、[Ep 40. Rust 和 PyO3：让 Python 再次伟大](https://pythonhunter.org/episodes/ep40)

断更许久的《捕蛇者说》播客回归了！本期的嘉宾是 PyO3 项目的维护者，他的另一个身份是 wechatpy 的作者。Rust 和 PyO3 项目能放大 Python 的优势，并能改造 Python 的应用生态。我们曾推荐过性能最快的代码分析工具 [Ruff](https://pythoncat.top/posts/2023-04-09-ruff)，另外 Flask 作者新开发的包管理工具 [rye](https://github.com/mitsuhiko/rye)，它们都是 Rust 与 Python 结合的产物。（题外话：看到了捕蛇者说的三位主播发推/发博缅怀左耳朵耗子，想不到他对 Python 圈子有这么多渊源。R.I.P）

2、[Talk Python to Me #415: Future of Pydantic and FastAPI](https://talkpython.fm/episodes/show/415/future-of-pydantic-and-fastapi)（英文）

Pydantic 2.0 使用 Rust 重写了核心及顶层的代码，将对构建在其之上的库产生积极的影响，比如 FastAPI。播客邀请了 Pydantic 的 Samuel Colvin 以及 FastAPI 的 Sebastián Ramírez 一起采访，话题度很新！

3、[再访《流畅的 Python》作者 Luciano Ramalho](https://www.thoughtworks.com/insights/podcasts/technology-podcasts/fluent-python-revisited)（英文）

我在上个月推荐过新上市的《流畅的 Python》中文第二版（[链接](https://pythoncat.top/posts/2023-04-28-fluent)），这里补充两则相关材料。这期播客来自 thoughtworks，是在《Fluent Python》英文第二版上市前的访谈，介绍了关于 Python 发展、不同语言的对比、新书的变化等。另外，他们还在 2020 年新书写作期间录了[一期“The future of Python”](https://www.thoughtworks.com/insights/podcasts/technology-podcasts/future-python)，两期播客都有完整的文字稿。

4、[最常用的七种分布式系统模式](https://youtu.be/nH4qjmP2KEE)（英文）

一则简短的科普视频，介绍了七种分布式系统模式：Ambassador、Circuit Breaker、CQRS、Event Sourcing、Leader Election、Publisher/Subscriber、Sharding。视频中的动画和图例都非常直观和舒适，让人赏心悦目。

![](https://img.pythoncat.top/2023-05-20_pattern.png)

## 🥂讨论&问题

1、[作为程序员，有什么提升生活/工作体验的 App、硬件、服务？](https://www.v2ex.com/t/940584)

V2ex 上的一个帖子，大家对这样的话题似乎很有发言欲。我在此最想推荐的 APP 是 Feedly 和 Substack，用于阅读 RSS 和 Newsletter。Feedly 对本周刊的素材采集帮助极大！（心愿：依靠读者的打赏，让我用上 Feedly Pro+ 的 AI 功能！）

2、[rye 应该存在么？](https://github.com/mitsuhiko/rye/discussions/6)（英文）

前文已提到过 rye，那么，mitsuhiko 是出于什么考虑而开发了它呢？它想解决什么样的问题，想打造出一款什么样的工具呢？Python 官方对包管理会有什么发展支持呢？Github 上的这个问题引起了广泛的讨论。

3、[你是怎样开始程序员职业生涯的？](https://www.v2ex.com/t/940195)

V2ex 上的帖子，楼主分享了自己从读书到就业前几年的故事，评论区有不少人分享了自己的经历。你是如何开始自己的程序员之路的呢？

## 赞助&支持

内容创作不易，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！

另诚邀广告主，欢迎通过私信联系。

## 关于周刊

Python 潮流周刊，精心筛选国内外的 200+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) | [RSS](https://pythoncat.top/rss.xml) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly)

![](https://img.pythoncat.top/pythoncat.png)

