---
title: 'Python潮流周刊#1：如何系统地自学Python？'
pubDate: 2023-05-13
author: '豌豆花下猫'
---

这里记录每周值得分享的 Python 及通用技术内容，部分内容为英文，已在小标题注明。（本期标题取自其中一则分享，不代表全部内容都是该主题，特此声明。）

## 🦄文章&教程

1、[编程语言的错误处理模式](https://pythoncat.top/posts/2023-05-08-error)

文章讨论了编程中处理错误的四种常见方法：返回错误代码（C、Go）、异常（Java、C＃、Python、C++）、回调函数（JavaScript）和 Result 对象（Haskell、Rust、Kotlin）。对每种方法进行了分析，介绍了它们的优缺点以及使用时需要注意的地方。

2、[深入理解 Python 虚拟机：描述器实现原理与源码分析](https://github.com/Chang-LeHung/dive-into-cpython/blob/master/obsy/03decriptor.md)

文章介绍了描述器的实现原理，分析了 CPython 源码中描述器相关的字节码指令，并使用 Python 代码解释了描述器的执行逻辑。文章出自 Github 上的《深入理解 Python 虚拟机系列》，该系列已含 20+ 文章。

3、[人工智能 AI 孙燕姿模型应用实践](https://v3u.cn/a_id_310)

最近 AI 孙燕姿太火了！文章基于 Python3.10 和开源库 so-vits-svc（高表现力的语音合成模型）、Spleeter（人声和伴奏分离）和 FFMPEG（声音与伴奏合并），手把手演示了让 AI 孙燕姿演唱歌曲。（PS.由于担心侵权风险，so-vits-svc 项目已经归档了）

4、[用 C 语言写一个 Python 包](https://juejin.cn/post/7229485914219642941)

文章介绍了 Python 的 C 语言 API 相关特性，最后实现了一个模仿官方 `datetime` 的 C 扩展模块。文章出自《Python 之 C 语言 API 系列教程》的第一篇，该系列目前已更新两篇。

5、[Python 工具箱系列文章](https://www.cnblogs.com/shanxihualu/p/17391082.html)

这是一个系列文章，目前包含 31 篇文章，最近介绍的几个工具是数据库相关的：Neo4j（一个 NoSQL 图数据库，使用 Py2neo 操作）、PostgreSQL（一个关系型数据库，使用 Psycopg2 操作）、MongoDB、Access、ClickHouse、Redis 等。

6、[PEP-713：可调用的模块](https://peps.python.org/pep-0713)（英文）

Łukasz Langa 发起的新提案，提议支持在模块的全局命名空间中定义一个\_\_call\_\_对象以使模块可直接调用，\_\_call\_\_对象可以是一个标准函数或任意可调用对象。提案目前是草稿状态，未采纳。

7、[“Externally managed environments”：当 PEP-668 影响了 pip](https://pythonspeed.com/articles/externally-managed-environment-pep-668)（英文）

在较新 Linux 系统上使用 pip install 时可能遇到“externally managed environment”错误。原因：Linux 发行版已预装某些 Python 包，pip install 可能导致系统包冲突。解决方法：开发时用虚拟环境；Docker 里不用系统 Python；需最新工具时用 pipx。Python 包管理较为痛苦，短时间内难以改善。

8、[Bevy v2.0：Python 的依赖注入框架](https://blog.zech.codes/bevy-v2)（英文）

Bevy v2.0 是一个强大的依赖注入框架，可以帮助简化 Python 应用程序的管理。文章介绍了三种解决依赖关系的方法：全局变量、参数传递和依赖注入。Bevy v2.0 使用的方法包括参数注入、属性注入、仓库和依赖构造函数等。

## 🐿️项目&资源

最近几个月，乘着人工智能的东风，Github 上天天都被 AI 相关的项目屠榜，相信读者们已经从各种渠道看到过那些知名的以 Python 为主的开源项目了。因此，为了不撞车，本周刊主要收录一些小而美的项目。本期以中文开发者的项目为主。

1、[「数字生命」的服务端](https://github.com/zixiiu/Digital_Life_Server)

一个“有生命的”语音助手 Python 项目，支持与前端通信、语音识别、chatGPT 接入和语音合成。前端部分可渲染人物动画、录音和播放声音。

2、[一个基于VITS的简单易用的语音转换（变声器）框架](https://github.com/RVC-Project/Retrieval-based-Voice-Conversion-WebUI)

具有以下特点：使用 top1 检索替换输入源特征为训练集特征来杜绝音色泄漏；即便在相对较差的显卡上也能快速训练；使用少量数据进行训练也能得到较好结果（推荐至少收集 10 分钟低底噪语音数据）；可以通过模型融合来改变音色（借助 ckpt 处理选项卡中的 ckpt-merge）；简单易用的网页界面；可调用 UVR5 模型来快速分离人声和伴奏。

3、[电子书翻译器（Calibre 插件）](https://github.com/bookfere/Ebook-Translator-Calibre-Plugin)

一个可以将电子书翻译成指定语言（原文译文对照）的 Calibre 插件。支持多种翻译引擎，包括 Google 翻译、ChatGPT 以及 DeepL。支持所有 Calibre 所支持的电子书格式（输入格式 48 种，输出格式 20 种）。支持批量翻译、支持缓存续译、提供大量自定义设置。

4、[跨平台的超轻量级嵌入式 Python 引擎](https://github.com/pikasTech/PikaPython/blob/master/README_zh.md)

一个完全重写的超轻量级 Python 引擎，零依赖，零配置，可以在 Flash ≤ 64KB，RAM≤ 4KB 的平台下运行，极易部署和扩展，具有大量的中文文档和视频资料。

## 🐢播客&视频

1、[硬地骇客：大厂程序员构建 “小生意”，更加从容应对裁员潮](https://www.xiaoyuzhoufm.com/episode/6446499294d78eb3f74a01d8)

"每一位 hacker，每一位开发者，每一位程序员，都值得拥有一个属于自己的小生意”。这档播客已发布了几期关于独立开发者的话题，对作为程序员的我们，在技术、产品、创业等方面会有所启发。

2、[Talk Python To Me #414：漫步创业之路](https://talkpython.fm/episodes/show/414/a-stroll-down-startup-lane)（英文）

在 4 月的 PyCon 上，有一个专门展示新型 Python 创业公司的展台，叫做 Startup Row。在这期节目中，主播与这些公司的创始人分别聊了 5-10 分钟，这期节目同时包含了播客和视频。

3、[PythonBytes #335：应该开始用 mojo 了么？](https://pythonbytes.fm/episodes/show/335/should-you-get-your-mojo-on)（英文）

Mojo 是 LLVM 及 Swift 之父新开发的 AI 编程语言，号称比 Python 快 35000 倍。Mojo 已支持 Python 的许多核心特性，包括 async/await、错误处理、可变参数等等，但是它仍然处于早期阶段，缺少许多功能，比如还不支持类！

4、[ChatGPT提示工程师｜AI大神吴恩达教你写提示词](https://www.bilibili.com/video/BV14M4y147yH)（英文）

鼎鼎大名的吴恩达联合 OpenAI，推出了一个面向开发者的 ChatGPT 提示词课程。这是 B 站上的链接，配有双语字幕。

## 🥂讨论&问题

1、[如何系统地自学Python？](https://www.zhihu.com/question/29138020)

知乎上的一个热门问题，已有 7.4 万人关注和 1200+ 回答。

2、[[吐槽] conda 真是太难用了！ 如何优雅地管理 Python 环境？](https://www.v2ex.com/t/938669#reply88)

v2ex 上的一个帖子，吐槽使用 Conda 遇到了各种问题，包括安装后找不到命令、安装依赖卡住不动、影响系统更新等等。

3、[允许在 for 循环的循环头中使用推导式语法](https://discuss.python.org/t/allow-comprehension-syntax-in-loop-header-of-for-loop/25864)（英文）

这个帖子提出了一个想法：让 Python 的 for 循环支持推导式语法“for i in x if i % 2 == 0:”。

## 赞助&支持

内容创作要花费大量的时间和精力，如果你觉得有帮助，请随意[赞赏](https://img.pythoncat.top/wechat_code.png)、[买杯咖啡](https://www.buymeacoffee.com/pythoncat) 进行支持！如果你喜欢本周刊，请转发分享给其他需要的同学，让更多人可以从中受益～

另诚邀广告主，欢迎通过私信联系。

## 关于周刊

Python 潮流周刊，精心筛选国内外的 200+ 信息源，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等内容。愿景：帮助所有读者精进 Python 技术，并增长职业和副业的收入。

周刊在 Github [开源](https://github.com/chinesehuazhou/python-weekly)，可以通过 issue [投稿](https://github.com/chinesehuazhou/python-weekly/issues/new)。

订阅方式：[Python猫](https://img.pythoncat.top/python_cat.jpg) (可加群)| [RSS](https://pythoncat.top/rss.xml) | [邮件](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)
