package com.chikeandroid.debtmanager.util.validator;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.chikeandroid.debtmanager.R;
import com.chikeandroid.debtmanager.util.ValidationUtil;

/**
 * Created by Chike on 4/11/2017.
 */

public class EditTextIntegerValidator extends EditTextValidator {

    private final Context mContext;

    public EditTextIntegerValidator(EditText editText, Context context) {
        super(editText);
        mContext = context;

        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                // do nothing
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                ValidationUtil.isInValid(EditTextIntegerValidator.this);
            }

            @Override
            public void afterTextChanged(Editable editable) {
                // do nothing
            }
        });
    }

    @Override
    public boolean isValid() {
        if (ValidationUtil.isEmpty(this)) {
            setErrorMessage(String.format(mContext.getString(R.string.required_field), "Amount"));
            return false;
        }
        return true;
    }
}
