import { PackageJson, SetRequired } from 'type-fest';
import { Run, Result, ReportingDescriptor } from 'sarif';
import { RunOptions } from '../types/cli.js';
import { TaskListError, TaskAction, Task } from '../types/tasks.js';
import { CheckupConfig } from '../types/config.js';
import { FilePathArray } from '../utils/file-path-array.js';

export type RequiredRun = SetRequired<Run, 'tool' | 'results'>;
export type RequiredResult = SetRequired<Result, 'message' | 'ruleId' | 'kind' | 'level'>;

export interface CheckupLogBuilderArgs {
  analyzedPackageJson: PackageJson;
  options: RunOptions;
  paths?: FilePathArray;
}

export type RuleResults = {
  rule: ReportingDescriptor;
  results: Result[];
};

export interface AnnotationArgs {
  config: CheckupConfig;
  executedTasks: Task[];
  actions: TaskAction[];
  errors: TaskListError[];
  timings: Record<string, number>;
}
