<p align="center">
	<a href="https://fretboarder.app">
		<img src="./docs/banner.png" alt="A white icon of a an acoustic guitar and a white text saying Fretboarder over a bright blue background.">
	</a>
</p>

<p align="center">Ride your fretboard and take your guitar skills to the next level! 🤘</p>

<img src="https://raw.githubusercontent.com/cheap-glitch/fretboarder/develop/docs/screenshot.png" alt="A screenshot of the app in usage.">

> Fretboarder is a web app to visualize  the layout of scales and arpeggios on a
> variety of fretboards. It  aims to help players get a  better grasp on scales,
> and ultimately to become a flexible learning and practicing tool for musicians
> interested in music theory and improvisation.


## Highlights

🎸 **Customize the instrument**

Choose between a  variety of instruments (from ukulele to  11-string guitar) and
tunings,  set  the  length  of  the fretboard,  and  switch  between  left-  and
right-handed fretting.

🍰 **Overlay scales and arpeggios**

The main feature  that distinguishes Fretboarder from other similar  apps is the
ability to  display several sequences  of notes on  the same fretboard.  You can
overlap scales  and arpeggios, display  their intersections and  select specific
positions on the neck.

💻 **Use on any device**

The UI has been designed to be simple and intuitive, and to work on both desktop
and mobile devices. Dark mode included!


## Contributing

Contributions are welcomed! See [CONTRIBUTING.md](CONTRIBUTING.md).


## Supporting the app

<p><a href="https://www.patreon.com/cheap_glitch"><img src="https://c5.patreon.com/external/logo/become_a_patron_button@2x.png" width="160" alt="Become a patron!"></a></p>

You can support my work on Fretboarder by donating on my [Patreon](https://www.patreon.com/cheap_glitch)
or my [PayPal](https://paypal.me/CheapGlitch) page. Plenty of cool features are coming, such as:
  * an audio player to listen to the scales
  * a tool to help learn & practice positions
  * a chord chart builder to follow along with backtracks
  * and more!


## Credits & acknowledgements

The dark mode colorscheme is heavily borrowed from the [Vue Dark Mode](https://www.growthbunker.dev/vuedarkmode) project.


## License

This software is distributed under the [Mozilla Public License 2.0](https://www.mozilla.org/en-US/MPL/2.0).


## Other related tools & resources

  * [All Guitar Chords](http://www.all-guitar-chords.com) - A compilation of scales, chords, arpeggios, licks, and more
  * [ChordMaster 2000](http://chordmaster.tardate.com) - A tool to practice and memorize chords
  * [ChordPic](https://chordpic.com) - A chord diagram generator, with lots of options to fine-tune the looks
  * [Fretmap](https://fretmap.app) - A very nice looking fretboard visualizer
  * [Glorious Voice Leader](https://www.gloriousvoiceleader.com) - Helps you find chord voicings that lead smoothly from one chord to the next
  * [Guitar Practice Loop](https://www.guitarpracticeloops.com) - Practice various scales with accompanying audio
  * [Guitar Recorder](https://1j01.github.io/guitar) - Display and compose ASCII tablatures with an interactive fretboard
  * [Guitar Scientist](https://www.guitarscientist.com/generator) - A fretboard diagram generator with tons of options to customize the result
  * [GuitarStreams](https://guitarstreams.com/tool/fretboard) - An interactive fretboard for guitar and ukulele players
  * [JGuitar](https://jguitar.com) - An extensive collection of tools regarding chords and music theory
  * [Johann](https://scribbletune.github.io/johann/#/guitar) - A fretboard visualizer (with an accompanying piano version)
