import React from 'react'

export const CreateReactAppSvg = ({ ...rest }) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 170.96 159.93'
      width='1em'
      height='1em'
      {...rest}
    >
      <path
        fill='#09d3ac'
        d='M141.35,73.27c0-6.89-8.11-13-20.58-16.73,3-12.67,1.69-22.75-4.28-26.16a9.55,9.55,0,0,0-4.79-1.2c-5.57,0-12.61,3.89-19.72,10.62-7.11-6.68-14.13-10.55-19.69-10.55a9.46,9.46,0,0,0-4.86,1.22c-5.94,3.42-7.17,13.44-4.21,26.05-12.41,3.71-20.48,9.77-20.5,16.63s8.12,13,20.59,16.72c-3,12.68-1.7,22.75,4.28,26.16a9.41,9.41,0,0,0,4.78,1.2c5.58,0,12.62-3.89,19.73-10.62,7.1,6.68,14.12,10.55,19.69,10.55a9.59,9.59,0,0,0,4.86-1.22c5.94-3.42,7.16-13.44,4.21-26C133.27,86.18,141.34,80.12,141.35,73.27ZM96.56,42.06c8.19-7.33,13.31-8.12,15.13-8.12h0a4.71,4.71,0,0,1,2.42.58c2.86,1.63,4,7.38,3.09,15a56.73,56.73,0,0,1-1,5.79,97.7,97.7,0,0,0-12.58-2.07,98.47,98.47,0,0,0-8.24-10.08C95.75,42.79,96.15,42.42,96.56,42.06ZM71.77,78.94c.78,1.5,1.61,3,2.47,4.51S76,86.49,77,88c-2.71-.39-5.34-.88-7.84-1.46C69.86,84,70.75,81.5,71.77,78.94ZM69,59.9c2.53-.59,5.18-1.08,7.93-1.46-1,1.48-1.86,3-2.76,4.59s-1.69,3-2.46,4.52Q70.18,63.65,69,59.9Zm5.21,13.34q1.86-3.93,4.09-7.86c1.5-2.62,3.11-5.17,4.77-7.61,2.91-.22,5.91-.34,9-.33s6,.12,8.89.35c1.66,2.42,3.25,5,4.75,7.55s2.88,5.22,4.12,7.83c-1.23,2.62-2.6,5.25-4.08,7.85s-3.11,5.18-4.77,7.62c-2.91.23-5.91.34-9,.34s-6-.13-8.89-.36c-1.66-2.42-3.26-4.94-4.76-7.55S75.5,75.85,74.25,73.24Zm32.86-14.77c2.72.38,5.35.87,7.84,1.45-.74,2.47-1.62,5-2.64,7.55-.79-1.5-1.61-3-2.48-4.51S108,59.93,107.11,58.47Zm2.76,24.92q1.29-2.27,2.46-4.53c1,2.6,2,5.16,2.7,7.66-2.52.59-5.17,1.07-7.92,1.45Q108.52,85.75,109.87,83.39ZM92,46.56c1.8,1.92,3.57,4,5.3,6.23-1.71-.07-3.46-.12-5.23-.12s-3.58,0-5.33.12C88.45,50.57,90.2,48.48,92,46.56Zm-22.18-12A4.82,4.82,0,0,1,72.29,34a13.11,13.11,0,0,1,5.19,1.31,39.07,39.07,0,0,1,10,6.78l1.17,1.07a98.49,98.49,0,0,0-8.16,10,98.88,98.88,0,0,0-12.65,2.06c-.44-1.94-.8-3.84-1-5.67C65.8,42,67,36.24,69.81,34.6ZM64.53,85.26a58.75,58.75,0,0,1-5.54-2c-7.1-3-11.5-6.85-11.5-10.14S51.91,66,59,63.05a57.63,57.63,0,0,1,5.44-1.94A97.93,97.93,0,0,0,69,73.25,98.72,98.72,0,0,0,64.53,85.26Zm23,19.1c-8.19,7.33-13.31,8.11-15.14,8.11a4.69,4.69,0,0,1-2.42-.58c-2.86-1.63-4-7.38-3.09-15a56.07,56.07,0,0,1,1-5.78,99.51,99.51,0,0,0,12.58,2.06,97.17,97.17,0,0,0,8.24,10.08Zm4.57-4.51c-1.8-1.92-3.57-4-5.31-6.23,1.72.08,3.47.12,5.24.12s3.58,0,5.33-.11C95.63,95.85,93.87,97.93,92.09,99.85Zm22.18,12a4.82,4.82,0,0,1-2.48.59c-1.82,0-7-.8-15.16-8.1l-1.17-1.07a98.44,98.44,0,0,0,8.15-10,97,97,0,0,0,12.66-2.06c.44,1.94.79,3.84,1,5.67C118.27,104.42,117.12,110.18,114.27,111.81Zm10.8-28.44c-1.71.7-3.52,1.35-5.44,1.93a98.54,98.54,0,0,0-4.57-12.14,98.1,98.1,0,0,0,4.49-12,58.75,58.75,0,0,1,5.54,2c7.09,3,11.5,6.85,11.49,10.14S132.17,80.42,125.07,83.37ZM92,82.39a9.18,9.18,0,1,0-9.17-9.19A9.17,9.17,0,0,0,92,82.39ZM31,17.88V128.53H153.07V17.88ZM148.3,123.77H35.78V22.65H148.3Zm-85-33.9c-3,12.68-1.7,22.75,4.28,26.16a9.41,9.41,0,0,0,4.78,1.2c5.58,0,12.62-3.89,19.73-10.62,7.1,6.68,14.12,10.55,19.69,10.55a9.59,9.59,0,0,0,4.86-1.22c5.94-3.42,7.16-13.44,4.21-26,12.41-3.72,20.48-9.78,20.49-16.63s-8.11-13-20.58-16.73c3-12.67,1.69-22.75-4.28-26.16a9.55,9.55,0,0,0-4.79-1.2c-5.57,0-12.61,3.89-19.72,10.62-7.11-6.68-14.13-10.55-19.69-10.55a9.46,9.46,0,0,0-4.86,1.22c-5.94,3.42-7.17,13.44-4.21,26.05-12.41,3.71-20.48,9.77-20.5,16.63S50.84,86.13,63.31,89.87Zm24.21,14.49c-8.19,7.33-13.31,8.11-15.14,8.11a4.69,4.69,0,0,1-2.42-.58c-2.86-1.63-4-7.38-3.09-15a56.07,56.07,0,0,1,1-5.78,99.51,99.51,0,0,0,12.58,2.06,97.17,97.17,0,0,0,8.24,10.08Zm24.79-36.89c-.79-1.5-1.61-3-2.48-4.51s-1.8-3-2.72-4.49c2.72.38,5.35.87,7.84,1.45C114.21,62.39,113.33,64.92,112.31,67.47Zm2.72,19c-2.52.59-5.17,1.07-7.92,1.45q1.41-2.22,2.76-4.58t2.46-4.53C113.37,81.46,114.28,84,115,86.52Zm-5.21-13.35c-1.23,2.62-2.6,5.25-4.08,7.85s-3.11,5.18-4.77,7.62c-2.91.23-5.91.34-9,.34s-6-.13-8.89-.36c-1.66-2.42-3.26-4.94-4.76-7.55s-2.87-5.22-4.12-7.83q1.86-3.93,4.09-7.86c1.5-2.62,3.11-5.17,4.77-7.61,2.91-.22,5.91-.34,9-.33s6,.12,8.89.35c1.66,2.42,3.25,5,4.75,7.55S108.58,70.56,109.82,73.17ZM77,88c-2.71-.39-5.34-.88-7.84-1.46.74-2.46,1.63-5,2.65-7.55.78,1.5,1.61,3,2.47,4.51S76,86.49,77,88ZM74.21,63c-.87,1.5-1.69,3-2.46,4.52Q70.18,63.65,69,59.9c2.53-.59,5.18-1.08,7.93-1.46C76,59.92,75.11,61.45,74.21,63ZM92.09,99.85c-1.8-1.92-3.57-4-5.31-6.23,1.72.08,3.47.12,5.24.12s3.58,0,5.33-.11C95.63,95.85,93.87,97.93,92.09,99.85Zm22.18,12a4.82,4.82,0,0,1-2.48.59c-1.82,0-7-.8-15.16-8.1l-1.17-1.07a98.44,98.44,0,0,0,8.15-10,97,97,0,0,0,12.66-2.06c.44,1.94.79,3.84,1,5.67C118.27,104.42,117.12,110.18,114.27,111.81Zm5.28-50.66a58.75,58.75,0,0,1,5.54,2c7.09,3,11.5,6.85,11.49,10.14s-4.41,7.16-11.51,10.11c-1.71.7-3.52,1.35-5.44,1.93a98.54,98.54,0,0,0-4.57-12.14A98.1,98.1,0,0,0,119.55,61.15Zm-23-19.09c8.19-7.33,13.31-8.12,15.13-8.12h0a4.71,4.71,0,0,1,2.42.58c2.86,1.63,4,7.38,3.09,15a56.73,56.73,0,0,1-1,5.79,97.7,97.7,0,0,0-12.58-2.07,98.47,98.47,0,0,0-8.24-10.08C95.75,42.79,96.15,42.42,96.56,42.06ZM92,46.56c1.8,1.92,3.57,4,5.3,6.23-1.71-.07-3.46-.12-5.23-.12s-3.58,0-5.33.12C88.45,50.57,90.2,48.48,92,46.56Zm-22.18-12A4.82,4.82,0,0,1,72.29,34a13.11,13.11,0,0,1,5.19,1.31,39.07,39.07,0,0,1,10,6.78l1.17,1.07a98.49,98.49,0,0,0-8.16,10,98.88,98.88,0,0,0-12.65,2.06c-.44-1.94-.8-3.84-1-5.67C65.8,42,67,36.24,69.81,34.6ZM59,63.05a57.63,57.63,0,0,1,5.44-1.94A97.93,97.93,0,0,0,69,73.25a98.72,98.72,0,0,0-4.49,12,58.75,58.75,0,0,1-5.54-2c-7.1-3-11.5-6.85-11.5-10.14S51.91,66,59,63.05Zm33,1a9.18,9.18,0,1,0,9.17,9.19A9.17,9.17,0,0,0,92,64Zm0,0a9.18,9.18,0,1,0,9.17,9.19A9.17,9.17,0,0,0,92,64Zm0,0a9.18,9.18,0,1,0,9.17,9.19A9.17,9.17,0,0,0,92,64Zm49.35,9.24c0-6.89-8.11-13-20.58-16.73,3-12.67,1.69-22.75-4.28-26.16a9.55,9.55,0,0,0-4.79-1.2c-5.57,0-12.61,3.89-19.72,10.62-7.11-6.68-14.13-10.55-19.69-10.55a9.46,9.46,0,0,0-4.86,1.22c-5.94,3.42-7.17,13.44-4.21,26.05-12.41,3.71-20.48,9.77-20.5,16.63s8.12,13,20.59,16.72c-3,12.68-1.7,22.75,4.28,26.16a9.41,9.41,0,0,0,4.78,1.2c5.58,0,12.62-3.89,19.73-10.62,7.1,6.68,14.12,10.55,19.69,10.55a9.59,9.59,0,0,0,4.86-1.22c5.94-3.42,7.16-13.44,4.21-26C133.27,86.18,141.34,80.12,141.35,73.27ZM96.56,42.06c8.19-7.33,13.31-8.12,15.13-8.12h0a4.71,4.71,0,0,1,2.42.58c2.86,1.63,4,7.38,3.09,15a56.73,56.73,0,0,1-1,5.79,97.7,97.7,0,0,0-12.58-2.07,98.47,98.47,0,0,0-8.24-10.08C95.75,42.79,96.15,42.42,96.56,42.06ZM71.77,78.94c.78,1.5,1.61,3,2.47,4.51S76,86.49,77,88c-2.71-.39-5.34-.88-7.84-1.46C69.86,84,70.75,81.5,71.77,78.94ZM69,59.9c2.53-.59,5.18-1.08,7.93-1.46-1,1.48-1.86,3-2.76,4.59s-1.69,3-2.46,4.52Q70.18,63.65,69,59.9Zm5.21,13.34q1.86-3.93,4.09-7.86c1.5-2.62,3.11-5.17,4.77-7.61,2.91-.22,5.91-.34,9-.33s6,.12,8.89.35c1.66,2.42,3.25,5,4.75,7.55s2.88,5.22,4.12,7.83c-1.23,2.62-2.6,5.25-4.08,7.85s-3.11,5.18-4.77,7.62c-2.91.23-5.91.34-9,.34s-6-.13-8.89-.36c-1.66-2.42-3.26-4.94-4.76-7.55S75.5,75.85,74.25,73.24Zm32.86-14.77c2.72.38,5.35.87,7.84,1.45-.74,2.47-1.62,5-2.64,7.55-.79-1.5-1.61-3-2.48-4.51S108,59.93,107.11,58.47Zm2.76,24.92q1.29-2.27,2.46-4.53c1,2.6,2,5.16,2.7,7.66-2.52.59-5.17,1.07-7.92,1.45Q108.52,85.75,109.87,83.39ZM92,46.56c1.8,1.92,3.57,4,5.3,6.23-1.71-.07-3.46-.12-5.23-.12s-3.58,0-5.33.12C88.45,50.57,90.2,48.48,92,46.56Zm-22.18-12A4.82,4.82,0,0,1,72.29,34a13.11,13.11,0,0,1,5.19,1.31,39.07,39.07,0,0,1,10,6.78l1.17,1.07a98.49,98.49,0,0,0-8.16,10,98.88,98.88,0,0,0-12.65,2.06c-.44-1.94-.8-3.84-1-5.67C65.8,42,67,36.24,69.81,34.6ZM64.53,85.26a58.75,58.75,0,0,1-5.54-2c-7.1-3-11.5-6.85-11.5-10.14S51.91,66,59,63.05a57.63,57.63,0,0,1,5.44-1.94A97.93,97.93,0,0,0,69,73.25,98.72,98.72,0,0,0,64.53,85.26Zm23,19.1c-8.19,7.33-13.31,8.11-15.14,8.11a4.69,4.69,0,0,1-2.42-.58c-2.86-1.63-4-7.38-3.09-15a56.07,56.07,0,0,1,1-5.78,99.51,99.51,0,0,0,12.58,2.06,97.17,97.17,0,0,0,8.24,10.08Zm4.57-4.51c-1.8-1.92-3.57-4-5.31-6.23,1.72.08,3.47.12,5.24.12s3.58,0,5.33-.11C95.63,95.85,93.87,97.93,92.09,99.85Zm22.18,12a4.82,4.82,0,0,1-2.48.59c-1.82,0-7-.8-15.16-8.1l-1.17-1.07a98.44,98.44,0,0,0,8.15-10,97,97,0,0,0,12.66-2.06c.44,1.94.79,3.84,1,5.67C118.27,104.42,117.12,110.18,114.27,111.81Zm10.8-28.44c-1.71.7-3.52,1.35-5.44,1.93a98.54,98.54,0,0,0-4.57-12.14,98.1,98.1,0,0,0,4.49-12,58.75,58.75,0,0,1,5.54,2c7.09,3,11.5,6.85,11.49,10.14S132.17,80.42,125.07,83.37ZM92,82.39a9.18,9.18,0,1,0-9.17-9.19A9.17,9.17,0,0,0,92,82.39Zm-69.32,54.5V26.2L17.89,31V141.66H139.94l4.78-4.77Z'
      />
    </svg>
  )
}

export const NextjsSvg = ({ ...rest }) => {
  return (
    <svg width='1em' height='1em' viewBox='0 0 148 90' {...rest}>
      <path
        d='M34.992 23.495h27.855v2.219H37.546v16.699h23.792v2.219H37.546v18.334h25.591v2.219H34.992v-41.69zm30.35 0h2.96l13.115 18.334 13.405-18.334L113.055.207 83.1 43.756l15.436 21.429H95.46L81.417 45.683 67.316 65.185h-3.018L79.85 43.756 65.343 23.495zm34.297 2.219v-2.219h31.742v2.219h-14.623v39.47h-2.554v-39.47H99.64zM.145 23.495h3.192l44.011 66.003L29.16 65.185 2.814 26.648l-.116 38.537H.145v-41.69zm130.98 38.801c-.523 0-.914-.405-.914-.928 0-.524.391-.929.913-.929.528 0 .913.405.913.929 0 .523-.385.928-.913.928zm2.508-2.443H135c.019.742.56 1.24 1.354 1.24.888 0 1.391-.535 1.391-1.539v-6.356h1.391v6.362c0 1.808-1.043 2.849-2.77 2.849-1.62 0-2.732-1.01-2.732-2.556zm7.322-.08h1.379c.118.853.95 1.395 2.149 1.395 1.117 0 1.937-.58 1.937-1.377 0-.685-.521-1.097-1.708-1.377l-1.155-.28c-1.62-.38-2.36-1.166-2.36-2.487 0-1.602 1.304-2.668 3.26-2.668 1.82 0 3.15 1.066 3.23 2.58h-1.354c-.13-.828-.85-1.346-1.894-1.346-1.1 0-1.832.53-1.832 1.34 0 .642.472 1.01 1.64 1.284l.987.243c1.838.43 2.596 1.178 2.596 2.53 0 1.72-1.33 2.799-3.453 2.799-1.987 0-3.323-1.029-3.422-2.637z'
        fill='#000'
        fillRule='nonzero'
      ></path>
    </svg>
  )
}

export const RedwoodSvg = ({ ...rest }) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 60 60'
      fill='none'
      width='1em'
      height='1em'
      {...rest}
    >
      <path
        fill='#fff'
        fillRule='evenodd'
        d='M26.59.85C24.3 2 19.5 4.2 16.9 5.95c-2.6 1.77-2.28 3.41-3.41 4.55a89.36 89.36 0 0 1-6.83 5.67c-2.28 1.7-1.71 6.24-2.28 7.94-.57 1.7-1.7 5.68-2.28 7.38-.57 1.7 1.14 3.97 2.28 6.24s3.98 8.51 5.12 10.78c1.14 2.27 4.55 1.14 7.4 3.4a100.2 100.2 0 0 0 9.68 6.81c2.84 1.7 3.98 1.7 6.82 0 2.85-1.7 6.83-4.54 9.68-6.8 2.85-2.27 6.26-1.14 7.4-3.41 1.14-2.27 3.98-8.51 5.12-10.78 1.14-2.27 2.85-4.54 2.28-6.24-.57-1.7-1.71-5.67-2.28-7.38-.57-1.7 0-6.24-2.28-7.94a84.1 84.1 0 0 1-6.83-5.67c-1.9-1.8-1.13-2.84-3.41-4.54-2.28-1.7-7.4-3.97-9.68-5.1a7.28 7.28 0 0 0-6.82 0Z'
        clipRule='evenodd'
      />
      <path
        fill='#BF4722'
        fillRule='evenodd'
        d='m18.61 10.1 10.6 7.42c.23.16.51.25.8.26.29 0 .57-.1.8-.26l10.6-7.45a1.5 1.5 0 0 0-.2-2.54L30.62 2.15c-.4-.2-.87-.2-1.27 0L18.79 7.53c-.46.23-.77.7-.8 1.23-.04.53.2 1.04.62 1.34Zm15 9.75c0 .5.23.95.62 1.23l8.5 5.96a1.4 1.4 0 0 0 1.76-.12l7.12-6.54a1.5 1.5 0 0 0-.07-2.27l-6.8-5.58a1.41 1.41 0 0 0-1.7-.07l-8.8 6.18c-.4.28-.63.73-.63 1.2Zm-21.12 8.1a1.52 1.52 0 0 1-.24 2.39l-5.07 3.12a1.4 1.4 0 0 1-1.64-.11 1.52 1.52 0 0 1-.47-1.62l1.87-6.06c.15-.48.52-.85 1-.98.46-.14.97-.02 1.33.33l3.22 2.93Zm27.5.64-9.17-6.44a1.4 1.4 0 0 0-1.6 0l-9.18 6.44a1.52 1.52 0 0 0-.14 2.34l9.16 8.41a1.41 1.41 0 0 0 1.91 0l9.16-8.4c.33-.32.5-.76.48-1.22a1.48 1.48 0 0 0-.62-1.13Zm-24.45-1.67-7.12-6.54c-.32-.3-.5-.73-.48-1.17 0-.44.2-.85.54-1.13l6.8-5.61c.5-.4 1.19-.43 1.71-.07l8.8 6.18a1.5 1.5 0 0 1 0 2.5l-8.48 5.96c-.55.38-1.28.33-1.77-.12Zm36.53 9.4-7.25-4.46a1.4 1.4 0 0 0-1.69.17l-8.85 8.11a1.52 1.52 0 0 0 .42 2.5l12.28 5.1c.17.08.35.12.53.12.57 0 1.09-.35 1.32-.89l3.8-8.75a1.5 1.5 0 0 0-.56-1.9Zm1-10.65 1.88 6.06h-.02c.14.45.06.95-.2 1.33a1.43 1.43 0 0 1-1.9.4l-5.08-3.12c-.4-.24-.66-.66-.7-1.13a1.5 1.5 0 0 1 .48-1.26l3.22-2.94a1.4 1.4 0 0 1 1.33-.33c.47.14.85.51 1 1ZM26.21 41.51c.09-.5-.09-1.02-.46-1.37l-8.85-8.1a1.4 1.4 0 0 0-1.7-.18l-7.24 4.46c-.62.39-.87 1.2-.57 1.9l3.81 8.75a1.42 1.42 0 0 0 1.85.77l12.27-5.1c.47-.2.8-.62.89-1.13Zm4.35 2.5 9.85 4.09c.48.21.81.67.87 1.21a1.5 1.5 0 0 1-.62 1.4l-9.86 7.02a1.4 1.4 0 0 1-.8.27c-.29 0-.57-.1-.8-.27l-9.86-7.03a1.5 1.5 0 0 1 .29-2.6l9.85-4.1c.34-.14.73-.14 1.08 0Z'
        clipRule='evenodd'
      />
    </svg>
  )
}

export const BlitzSvg = ({ ...rest }) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      width='1em'
      height='1em'
      viewBox='0 0 60 60'
      fill='none'
      {...rest}
    >
      <path
        fill='#6700EB'
        d='M39.12 30h9.92L26.64.33a.8.8 0 0 0-1.34.11l-5.64 10.93a.8.8 0 0 0 .07.85l9.78 13a12.02 12.02 0 0 0 9.6 4.8ZM19.92 30H10l22.39 29.68a.8.8 0 0 0 1.35-.11l5.64-10.93a.8.8 0 0 0-.07-.85l-9.79-13a12.02 12.02 0 0 0-9.6-4.8Z'
      />
    </svg>
  )
}

export const GatsbySvg = ({ ...rest }) => {
  return (
    <svg width='1em' height='1em' fill='none' viewBox='0 0 48 48' {...rest}>
      <path
        fill='#fff'
        d='M41.282 24h-11v3.143h7.543c-1.1 4.715-4.557 8.643-9.114 10.215L10.64 19.286c1.885-5.5 7.228-9.428 13.357-9.428 4.714 0 8.957 2.357 11.628 5.971l2.357-2.043c-3.142-4.243-8.171-7.071-13.985-7.071-8.172 0-15.086 5.814-16.815 13.514l20.743 20.743c7.543-1.886 13.357-8.8 13.357-16.971zm-34.571.158c0 4.4 1.729 8.643 5.028 11.943 3.3 3.3 7.7 5.028 11.943 5.028L6.711 24.158z'
      ></path>
      <path
        fill='#639'
        d='M24 2C11.9 2 2 11.9 2 24s9.9 22 22 22 22-9.9 22-22S36.1 2 24 2zM11.743 36.257c-3.3-3.3-5.029-7.7-5.029-11.943l17.129 16.972c-4.4-.157-8.8-1.729-12.1-5.029zm16.028 4.557L7.186 20.23C8.914 12.529 15.829 6.714 24 6.714c5.814 0 10.843 2.829 13.986 7.072l-2.357 2.043C32.957 12.214 28.714 9.857 24 9.857c-6.129 0-11.314 3.929-13.357 9.429l18.071 18.071c4.557-1.571 8.015-5.5 9.115-10.214h-7.543V24h11c0 8.171-5.815 15.086-13.515 16.814z'
      ></path>
    </svg>
  )
}

export const RemixSvg = ({ ...props }) => {
  return (
    <svg
      viewBox='0 0 659 165'
      version='1.1'
      xmlns='http://www.w3.org/2000/svg'
      xmlnsXlink='http://www.w3.org/1999/xlink'
      aria-labelledby='remix-run-logo-title'
      role='img'
      width='1em'
      height='1em'
      fill='#000'
      {...props}
    >
      <title id='remix-run-logo-title'>Remix Logo</title>
      <path d='M0 161V136H45.5416C53.1486 136 54.8003 141.638 54.8003 145V161H0Z M133.85 124.16C135.3 142.762 135.3 151.482 135.3 161H92.2283C92.2283 158.927 92.2653 157.03 92.3028 155.107C92.4195 149.128 92.5411 142.894 91.5717 130.304C90.2905 111.872 82.3473 107.776 67.7419 107.776H54.8021H0V74.24H69.7918C88.2407 74.24 97.4651 68.632 97.4651 53.784C97.4651 40.728 88.2407 32.816 69.7918 32.816H0V0H77.4788C119.245 0 140 19.712 140 51.2C140 74.752 125.395 90.112 105.665 92.672C122.32 96 132.057 105.472 133.85 124.16Z' />
      <path d='M229.43 120.576C225.59 129.536 218.422 133.376 207.158 133.376C194.614 133.376 184.374 126.72 183.35 112.64H263.478V101.12C263.478 70.1437 243.254 44.0317 205.11 44.0317C169.526 44.0317 142.902 69.8877 142.902 105.984C142.902 142.336 169.014 164.352 205.622 164.352C235.83 164.352 256.822 149.76 262.71 123.648L229.43 120.576ZM183.862 92.6717C185.398 81.9197 191.286 73.7277 204.598 73.7277C216.886 73.7277 223.542 82.4317 224.054 92.6717H183.862Z' />
      <path d='M385.256 66.5597C380.392 53.2477 369.896 44.0317 349.672 44.0317C332.52 44.0317 320.232 51.7117 314.088 64.2557V47.1037H272.616V161.28H314.088V105.216C314.088 88.0638 318.952 76.7997 332.52 76.7997C345.064 76.7997 348.136 84.9917 348.136 100.608V161.28H389.608V105.216C389.608 88.0638 394.216 76.7997 408.04 76.7997C420.584 76.7997 423.4 84.9917 423.4 100.608V161.28H464.872V89.5997C464.872 65.7917 455.656 44.0317 424.168 44.0317C404.968 44.0317 391.4 53.7597 385.256 66.5597Z' />
      <path d='M478.436 47.104V161.28H519.908V47.104H478.436ZM478.18 36.352H520.164V0H478.18V36.352Z' />
      <path d='M654.54 47.1035H611.788L592.332 74.2395L573.388 47.1035H527.564L568.78 103.168L523.98 161.28H566.732L589.516 130.304L612.3 161.28H658.124L613.068 101.376L654.54 47.1035Z' />
    </svg>
  )
}

export const ViteSvg = ({ ...props }) => {
  return (
    <svg
      width='1em'
      height='1em'
      viewBox='0 0 410 404'
      fill='none'
      xmlns='http://www.w3.org/2000/svg'
      {...props}
    >
      <title id='vite-logo-title'>Vite Logo</title>
      <path
        d='M399.641 59.5246L215.643 388.545C211.844 395.338 202.084 395.378 198.228 388.618L10.5817 59.5563C6.38087 52.1896 12.6802 43.2665 21.0281 44.7586L205.223 77.6824C206.398 77.8924 207.601 77.8904 208.776 77.6763L389.119 44.8058C397.439 43.2894 403.768 52.1434 399.641 59.5246Z'
        fill='url(#paint0_linear)'
      />
      <path
        d='M292.965 1.5744L156.801 28.2552C154.563 28.6937 152.906 30.5903 152.771 32.8664L144.395 174.33C144.198 177.662 147.258 180.248 150.51 179.498L188.42 170.749C191.967 169.931 195.172 173.055 194.443 176.622L183.18 231.775C182.422 235.487 185.907 238.661 189.532 237.56L212.947 230.446C216.577 229.344 220.065 232.527 219.297 236.242L201.398 322.875C200.278 328.294 207.486 331.249 210.492 326.603L212.5 323.5L323.454 102.072C325.312 98.3645 322.108 94.137 318.036 94.9228L279.014 102.454C275.347 103.161 272.227 99.746 273.262 96.1583L298.731 7.86689C299.767 4.27314 296.636 0.855181 292.965 1.5744Z'
        fill='url(#paint1_linear)'
      />
      <defs>
        <linearGradient
          id='paint0_linear'
          x1='6.00017'
          y1='32.9999'
          x2='235'
          y2='344'
          gradientUnits='userSpaceOnUse'
        >
          <stop stopColor='#41D1FF' />
          <stop offset='1' stopColor='#BD34FE' />
        </linearGradient>
        <linearGradient
          id='paint1_linear'
          x1='194.651'
          y1='8.81818'
          x2='236.076'
          y2='292.989'
          gradientUnits='userSpaceOnUse'
        >
          <stop stopColor='#FFEA83' />
          <stop offset='0.0833333' stopColor='#FFDD35' />
          <stop offset='1' stopColor='#FFA800' />
        </linearGradient>
      </defs>
    </svg>
  )
}

export const MeteorSvg = ({ ...props }) => {
  return (
    <svg
      width='1em'
      height='1em'
      viewBox='0 0 12 12'
      fill='none'
      xmlns='http://www.w3.org/2000/svg'
      {...props}
    >
      <g clipPath='url(#clip0_1_2)'>
        <path
          d='M11.412 7.77271C11.2401 7.96125 11.0163 7.7998 11.0163 7.7998L6.00445 2.28898L11.4515 7.39635C11.4515 7.39635 11.5835 7.58488 11.412 7.77271V7.77271ZM10.8517 5.98725L8.58016 3.48211L11.0668 5.79801C11.0668 5.79801 11.1322 5.8863 11.0473 5.97459C10.9623 6.06252 10.8513 5.98725 10.8513 5.98725H10.8517ZM11.2229 9.3109C10.9775 9.58034 10.6568 9.34959 10.6568 9.34959L3.48271 1.46203L11.28 8.77238C11.28 8.77238 11.469 9.04182 11.2233 9.31055L11.2229 9.3109ZM10.4866 10.6384C10.2412 10.9078 9.92044 10.6771 9.92044 10.6771L0.5 0.5L10.5433 10.0999C10.5433 10.0999 10.732 10.369 10.4869 10.6384H10.4866ZM9.12741 11.3693C8.88198 11.6388 8.56126 11.408 8.56126 11.408L1.38687 3.52045L9.18448 10.8308C9.18448 10.8308 9.37319 11.1002 9.12776 11.3697L9.12741 11.3693ZM7.48532 11.3897C7.31345 11.5776 7.08967 11.4165 7.08967 11.4165L2.07781 5.90635L7.52486 11.0137C7.52486 11.0137 7.65651 11.2019 7.48532 11.3901V11.3897ZM5.79923 10.9381C5.71433 11.026 5.6033 10.9507 5.6033 10.9507L3.3318 8.44525L5.81883 10.7615C5.81883 10.7615 5.88414 10.8494 5.79923 10.9381Z'
          fill='#FF6A3E'
        />
      </g>
      <defs>
        <clipPath id='clip0_1_2'>
          <rect width='12' height='12' fill='white' />
        </clipPath>
      </defs>
    </svg>
  )
}
