# ⚠️ Attention

This repository has been moved to
[Chakra UI Repository](https://github.com/chakra-ui/chakra-ui/tree/main/website)
Please refer to the new repository for the latest changes.

---

<p align="center">
  <a href="https://github.com/chakra-ui/chakra-ui">
    <img src="https://raw.githubusercontent.com/chakra-ui/chakra-ui/main/media/logo-colored@2x.png?raw=true" alt="Chakra logo" width="300" />
  </a>
</p>

<h1 align="center">Build Accessible React Apps with Speed ⚡️</h1>

<br>

<p align="center">
  <img alt="Bundle Size" src="https://badgen.net/bundlephobia/minzip/@chakra-ui/react"/>
  <img alt="Language grade: JavaScript" src="https://img.shields.io/lgtm/grade/javascript/g/chakra-ui/chakra-ui.svg?logo=lgtm&logoWidth=18"/>
  <a href="https://github.com/chakra-ui/chakra-ui/blob/main/LICENSE">
  <img alt="MIT License" src="https://img.shields.io/github/license/chakra-ui/chakra-ui"/>
  </a>
  <img alt="NPM Downloads" src="https://img.shields.io/npm/dm/@chakra-ui/react.svg?style=flat"/>
  <img alt="Github Stars" src="https://badgen.net/github/stars/chakra-ui/chakra-ui" />
  <a href="https://discord.gg/chakra-ui">
    <img alt="Discord" src="https://img.shields.io/discord/660863154703695893.svg?label=&logo=discord&logoColor=ffffff&color=7389D8&labelColor=6A7EC2" />
  </a>
</p>
<br />

Chakra UI provides a set of accessible, reusable, and composable React
components that make it super easy to create websites and apps.

## This is the Chakra UI documentation repo

It's the https://chakra-ui.com website for the latest version of Chakra UI. For
older versions head over here

- v1: https://v1.chakra-ui.com
- v0: https://v0.chakra-ui.com

## Features 🚀

- Ease of Styling: Chakra UI contains a set of layout components like `Box` and
  `Stack` that make it easy to style your components by passing props.
  [Learn more](https://chakra-ui.com/style-props)
- Flexible & composable: Chakra UI components are built on top of a React UI
  Primitive for endless composability.
- Accessible. Chakra UI components follow the WAI-ARIA guidelines specifications
  and have the right `aria-*` attributes.
- Dark Mode 😍: Most components in Chakra UI are dark mode compatible.

## Support Chakra UI 💖

By donating \$5 or more you can support the ongoing development of this project.
We'll appreciate some support. Thank you to all our supporters! 🙏
[[Contribute](https://opencollective.com/chakra-ui/contribute)]

### Individuals

<a href="https://opencollective.com/chakra-ui"><img src="https://opencollective.com/chakra-ui/individuals.svg?width=890"></a>

### Organizations

Support this project with your organization. Your logo will show up here with a
link to your website.
[[Contribute](https://opencollective.com/chakra-ui/contribute)]

<a href="https://opencollective.com/chakra-ui/organization/0/website"><img src="https://opencollective.com/chakra-ui/organization/0/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/1/website"><img src="https://opencollective.com/chakra-ui/organization/1/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/2/website"><img src="https://opencollective.com/chakra-ui/organization/2/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/3/website"><img src="https://opencollective.com/chakra-ui/organization/3/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/4/website"><img src="https://opencollective.com/chakra-ui/organization/4/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/5/website"><img src="https://opencollective.com/chakra-ui/organization/5/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/6/website"><img src="https://opencollective.com/chakra-ui/organization/6/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/7/website"><img src="https://opencollective.com/chakra-ui/organization/7/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/8/website"><img src="https://opencollective.com/chakra-ui/organization/8/avatar.svg?avatarHeight=130"></a>
<a href="https://opencollective.com/chakra-ui/organization/9/website"><img src="https://opencollective.com/chakra-ui/organization/9/avatar.svg?avatarHeight=130"></a>

## Testimonials

> People throw React component libraries and design systems at me regularly.
> This might be the best one I've seen. The APIs are simple but composable and
> the accessibility on the couple components I looked is complete.
>
> Great work @thesegunadebayo, really inspiring work. –
> [Ryan Florence](https://twitter.com/ryanflorence/status/1169260008069947392)

> Awesome new open-source component library from @thesegunadebayo. Really
> impressive stuff! –
> [Colm Tuite](https://twitter.com/colmtuite/status/1169622886052782081)

> This is incredible work. Amazing job Segun! –
> [Lee Robinson](https://twitter.com/leeerob/status/1169330130361159682)

> Chakra UI is glorious! I love the consistent use of focus styling and the
> subtle animation –
> [Guillermo ▲](https://twitter.com/rauchg/status/1169632334389248000)

## Contributing

Feel like contributing? That's awesome! We have a
[contributing guide](./CONTRIBUTING.md) to help guide you.

## Contributors ✨

Thanks goes to these wonderful people

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/segunadebayo"><img src="https://avatars2.githubusercontent.com/u/6916170?v=4?s=64" width="64px;" alt="Segun Adebayo"/><br /><sub><b>Segun Adebayo</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=segunadebayo" title="Code">💻</a> <a href="#maintenance-segunadebayo" title="Maintenance">🚧</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=segunadebayo" title="Documentation">📖</a> <a href="#example-segunadebayo" title="Examples">💡</a> <a href="#design-segunadebayo" title="Design">🎨</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tioluwani94"><img src="https://avatars1.githubusercontent.com/u/11310046?v=4?s=64" width="64px;" alt="Tioluwani Kolawole"/><br /><sub><b>Tioluwani Kolawole</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=tioluwani94" title="Documentation">📖</a> <a href="#example-tioluwani94" title="Examples">💡</a> <a href="#maintenance-tioluwani94" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://adrianaleixandre.com"><img src="https://avatars3.githubusercontent.com/u/920212?v=4?s=64" width="64px;" alt="Adrian Aleixandre"/><br /><sub><b>Adrian Aleixandre</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=Vynlar" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=Vynlar" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lee-reinhardt"><img src="https://avatars1.githubusercontent.com/u/980089?v=4?s=64" width="64px;" alt="Lee"/><br /><sub><b>Lee</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=lee-reinhardt" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kripod"><img src="https://avatars3.githubusercontent.com/u/14854048?v=4?s=64" width="64px;" alt="Kristóf Poduszló"/><br /><sub><b>Kristóf Poduszló</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=kripod" title="Code">💻</a> <a href="#ideas-kripod" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Akripod" title="Bug reports">🐛</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=kripod" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://chanchan.io"><img src="https://avatars1.githubusercontent.com/u/1954752?v=4?s=64" width="64px;" alt="Mark Chandler"/><br /><sub><b>Mark Chandler</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=with-heart" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=with-heart" title="Tests">⚠️</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=with-heart" title="Documentation">📖</a> <a href="#maintenance-with-heart" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/christiannwamba"><img src="https://avatars2.githubusercontent.com/u/8108337?v=4?s=64" width="64px;" alt="Christian Nwamba"/><br /><sub><b>Christian Nwamba</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=christiannwamba" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/codebender828"><img src="https://avatars3.githubusercontent.com/u/21237954?s=60&v=4?s=64" width="64px;" alt="Jonathan Bakebwa"/><br /><sub><b>Jonathan Bakebwa</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=codebender828" title="Documentation">📖</a> <a href="#ideas-codebender828" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/tayormi/"><img src="https://avatars2.githubusercontent.com/u/13835725?v=4?s=64" width="64px;" alt="Temitope Ajiboye"/><br /><sub><b>Temitope Ajiboye</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=tayormi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://jessachandler.com"><img src="https://avatars3.githubusercontent.com/u/7316730?v=4?s=64" width="64px;" alt="jess"/><br /><sub><b>jess</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=monkeywithacupcake" title="Documentation">📖</a> <a href="#fundingFinding-monkeywithacupcake" title="Funding Finding">🔍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://trevorblades.com"><img src="https://avatars0.githubusercontent.com/u/1216917?v=4?s=64" width="64px;" alt="Trevor Blades"/><br /><sub><b>Trevor Blades</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=trevorblades" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=trevorblades" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Atrevorblades" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://santialbo.com"><img src="https://avatars3.githubusercontent.com/u/1557563?v=4?s=64" width="64px;" alt="Santi Albo"/><br /><sub><b>Santi Albo</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=santialbo" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=santialbo" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sebqq"><img src="https://avatars1.githubusercontent.com/u/33039909?v=4?s=64" width="64px;" alt="Sebastian Trebunak"/><br /><sub><b>Sebastian Trebunak</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=sebqq" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=sebqq" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://jasonmiazga.com"><img src="https://avatars2.githubusercontent.com/u/181441?v=4?s=64" width="64px;" alt="Jason Miazga"/><br /><sub><b>Jason Miazga</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jmiazga" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jmiazga" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://tony@git-pull.com"><img src="https://avatars0.githubusercontent.com/u/26336?s=460&v=4?s=64" width="64px;" alt="Tony Narlock"/><br /><sub><b>Tony Narlock</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=tony" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=tony" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://kenna.xyz"><img src="https://avatars2.githubusercontent.com/u/32865577?s=460&u=a8d1696f5095b153948a3c8a3e5507b09fe9bceb&v=4?s=64" width="64px;" alt="Makenna Smutz"/><br /><sub><b>Makenna Smutz</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=KenzoBenzo" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=KenzoBenzo" title="Documentation">📖</a> <a href="#ideas-KenzoBenzo" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nainardev"><img src="https://avatars2.githubusercontent.com/u/59839368?s=460&u=94aefbf6a1452b57c2bc1b103bab34acbe9244b7&v=4?s=64" width="64px;" alt="Mohamed Nainar"/><br /><sub><b>Mohamed Nainar</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=nainardev" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mustaphaturhan"><img src="https://avatars0.githubusercontent.com/u/11398393?s=460&u=1d915beadb5df52c00f667e08f8ecc65e4ee2e1e&v=4?s=64" width="64px;" alt="Mustafa Turhan"/><br /><sub><b>Mustafa Turhan</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=mustaphaturhan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://twitter.com/kimroen"><img src="https://avatars3.githubusercontent.com/u/520420?s=460&v=4?s=64" width="64px;" alt="Kim Røen"/><br /><sub><b>Kim Røen</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=kimroen" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jatwork"><img src="https://avatars0.githubusercontent.com/u/11546793?s=460&u=8987e6cf833d07800cc372fa66444851744fe255&v=4?s=64" width="64px;" alt="Jeremy Lu"/><br /><sub><b>Jeremy Lu</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jatwork" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jatwork" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://ivan.dalmet.fr"><img src="https://avatars3.githubusercontent.com/u/9749061?s=460&v=4?s=64" width="64px;" alt="Ivan Dalmet"/><br /><sub><b>Ivan Dalmet</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ivan-dalmet" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ivan-dalmet" title="Code">💻</a> <a href="#plugin-ivan-dalmet" title="Plugin/utility libraries">🔌</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mrmckeb"><img src="https://avatars3.githubusercontent.com/u/5043083?v=4?s=64" width="64px;" alt="Brody McKee"/><br /><sub><b>Brody McKee</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=mrmckeb" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.patrickcason.com"><img src="https://avatars1.githubusercontent.com/u/1297930?v=4?s=64" width="64px;" alt="Patrick Cason"/><br /><sub><b>Patrick Cason</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=cereallarceny" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://habd.as"><img src="https://avatars3.githubusercontent.com/u/65664227?v=4?s=64" width="64px;" alt="balibebas"/><br /><sub><b>balibebas</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=balibebas" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://navin-moorthy.github.io/"><img src="https://avatars0.githubusercontent.com/u/39694575?v=4?s=64" width="64px;" alt="Navin Moorthy"/><br /><sub><b>Navin Moorthy</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=navin-moorthy" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=navin-moorthy" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.timkindberg.com"><img src="https://avatars0.githubusercontent.com/u/168046?v=4?s=64" width="64px;" alt="Tim Kindberg"/><br /><sub><b>Tim Kindberg</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=timkindberg" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/iodar"><img src="https://avatars3.githubusercontent.com/u/47027105?v=4?s=64" width="64px;" alt="iodar"/><br /><sub><b>iodar</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=iodar" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://lcdsmao.dev"><img src="https://avatars3.githubusercontent.com/u/13031690?v=4?s=64" width="64px;" alt="MAO YUFENG"/><br /><sub><b>MAO YUFENG</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=lcdsmao" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://jiepeng.me"><img src="https://avatars3.githubusercontent.com/u/10325111?v=4?s=64" width="64px;" alt="Peng Jie"/><br /><sub><b>Peng Jie</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=neighborhood999" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=neighborhood999" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/antonjb"><img src="https://avatars2.githubusercontent.com/u/1066856?v=4?s=64" width="64px;" alt="Anton"/><br /><sub><b>Anton</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=antonjb" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/damnjan"><img src="https://avatars2.githubusercontent.com/u/2204518?v=4?s=64" width="64px;" alt="Damnjan Lukovic"/><br /><sub><b>Damnjan Lukovic</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=damnjan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://mitchinson.dev"><img src="https://avatars2.githubusercontent.com/u/33632286?v=4?s=64" width="64px;" alt="Ben Mitchinson"/><br /><sub><b>Ben Mitchinson</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=bmitchinson" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://simo.sh"><img src="https://avatars1.githubusercontent.com/u/1344906?v=4?s=64" width="64px;" alt="Simo Aleksandrov"/><br /><sub><b>Simo Aleksandrov</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=fr3fou" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/CodinCat"><img src="https://avatars3.githubusercontent.com/u/3193344?v=4?s=64" width="64px;" alt="CodinCat"/><br /><sub><b>CodinCat</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=CodinCat" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://keremciu.github.io/"><img src="https://avatars0.githubusercontent.com/u/1593488?v=4?s=64" width="64px;" alt="Kerem Sevencan"/><br /><sub><b>Kerem Sevencan</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=keremciu" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/harveyhalwin"><img src="https://avatars2.githubusercontent.com/u/41739034?v=4?s=64" width="64px;" alt="harveyhalwin"/><br /><sub><b>harveyhalwin</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=harveyhalwin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://benyou.me"><img src="https://avatars3.githubusercontent.com/u/31636863?v=4?s=64" width="64px;" alt="Mansour benyoucef"/><br /><sub><b>Mansour benyoucef</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=benyou1969" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://atgarrison.com"><img src="https://avatars1.githubusercontent.com/u/11062725?v=4?s=64" width="64px;" alt="Andrew Garrison"/><br /><sub><b>Andrew Garrison</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=andrewgarrison" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://carlosvini.github.io/"><img src="https://avatars2.githubusercontent.com/u/4670443?v=4?s=64" width="64px;" alt="Carlos Rodrigues"/><br /><sub><b>Carlos Rodrigues</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=carlosvini" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.dwightwatson.com"><img src="https://avatars3.githubusercontent.com/u/1100408?v=4?s=64" width="64px;" alt="Dwight Watson"/><br /><sub><b>Dwight Watson</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=dwightwatson" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ChasinHues"><img src="https://avatars1.githubusercontent.com/u/13565648?v=4?s=64" width="64px;" alt="ChasinHues"/><br /><sub><b>ChasinHues</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ChasinHues" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://pablorocha.me"><img src="https://avatars1.githubusercontent.com/u/11415340?v=4?s=64" width="64px;" alt="Pablo Rocha"/><br /><sub><b>Pablo Rocha</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=joserocha3" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://frontendwizard.dev"><img src="https://avatars1.githubusercontent.com/u/1124448?v=4?s=64" width="64px;" alt="Juliano Farias"/><br /><sub><b>Juliano Farias</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=frontendwizard" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sivertschou"><img src="https://avatars3.githubusercontent.com/u/31168035?v=4?s=64" width="64px;" alt="Sivert Schou Olsen"/><br /><sub><b>Sivert Schou Olsen</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=sivertschou" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lazandrei19"><img src="https://avatars1.githubusercontent.com/u/3816519?v=4?s=64" width="64px;" alt="Andrei Lazarescu"/><br /><sub><b>Andrei Lazarescu</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=lazandrei19" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.adrianoresende.com.br"><img src="https://avatars1.githubusercontent.com/u/798755?v=4?s=64" width="64px;" alt="Adriano Resende"/><br /><sub><b>Adriano Resende</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=adrianoresende" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://victorwpbastos.github.io"><img src="https://avatars3.githubusercontent.com/u/1017515?v=4?s=64" width="64px;" alt="Victor Bastos"/><br /><sub><b>Victor Bastos</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=victorwpbastos" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Zaynex"><img src="https://avatars0.githubusercontent.com/u/13745971?v=4?s=64" width="64px;" alt="Vincent"/><br /><sub><b>Vincent</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=Zaynex" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.candiceczech.com"><img src="https://avatars0.githubusercontent.com/u/25373313?v=4?s=64" width="64px;" alt="Candice"/><br /><sub><b>Candice</b></sub></a><br /><a href="#design-candicecz" title="Design">🎨</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Acandicecz" title="Bug reports">🐛</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=candicecz" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://davebauman.io"><img src="https://avatars3.githubusercontent.com/u/3084806?v=4?s=64" width="64px;" alt="Dave Bauman"/><br /><sub><b>Dave Bauman</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=baumandm" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TimKolberger"><img src="https://avatars2.githubusercontent.com/u/16899513?v=4?s=64" width="64px;" alt="TimKolberger"/><br /><sub><b>TimKolberger</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3ATimKolberger" title="Bug reports">🐛</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=TimKolberger" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=TimKolberger" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/iskanderbroere"><img src="https://avatars2.githubusercontent.com/u/25477294?v=4?s=64" width="64px;" alt="iskanderbroere"/><br /><sub><b>iskanderbroere</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=iskanderbroere" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.strajk.me"><img src="https://avatars3.githubusercontent.com/u/697301?v=4?s=64" width="64px;" alt="Pavel 'Strajk' Dolecek"/><br /><sub><b>Pavel 'Strajk' Dolecek</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=Strajk" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/keshav-bohra-17032753/"><img src="https://avatars3.githubusercontent.com/u/44581314?v=4?s=64" width="64px;" alt="Keshav Bohra"/><br /><sub><b>Keshav Bohra</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=keshav-bohr" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/okezieuc"><img src="https://avatars3.githubusercontent.com/u/53785400?v=4?s=64" width="64px;" alt="okezieuc"/><br /><sub><b>okezieuc</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=okezieuc" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/claytonfaria"><img src="https://avatars1.githubusercontent.com/u/65756578?v=4?s=64" width="64px;" alt="Clayton Faria"/><br /><sub><b>Clayton Faria</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=claytonfaria" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ellisio"><img src="https://avatars1.githubusercontent.com/u/127468?v=4?s=64" width="64px;" alt="Andrew Ellis"/><br /><sub><b>Andrew Ellis</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ellisio" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Aellisio" title="Bug reports">🐛</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ellisio" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ifeoma-imoh"><img src="https://avatars2.githubusercontent.com/u/60473225?v=4?s=64" width="64px;" alt="Ifeoma Imoh"/><br /><sub><b>Ifeoma Imoh</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ifeoma-imoh" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/SpencerDuball"><img src="https://avatars0.githubusercontent.com/u/22606045?v=4?s=64" width="64px;" alt="Spencer Duball"/><br /><sub><b>Spencer Duball</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=SpencerDuball" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jacobarriola.com"><img src="https://avatars0.githubusercontent.com/u/1371573?v=4?s=64" width="64px;" alt="Jacob Arriola"/><br /><sub><b>Jacob Arriola</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jacobarriola" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jkenley.me"><img src="https://avatars0.githubusercontent.com/u/8725648?v=4?s=64" width="64px;" alt="Kenley Jean"/><br /><sub><b>Kenley Jean</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=bedjiken" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://umarcodes.xyz/"><img src="https://avatars2.githubusercontent.com/u/20203468?v=4?s=64" width="64px;" alt="Umar Gora"/><br /><sub><b>Umar Gora</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=umxr" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/milescm"><img src="https://avatars1.githubusercontent.com/u/33818414?v=4?s=64" width="64px;" alt="Hong Suk Woo"/><br /><sub><b>Hong Suk Woo</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=milescm" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://trendy-resume.now.sh/"><img src="https://avatars2.githubusercontent.com/u/32605822?v=4?s=64" width="64px;" alt="Junho Yeo"/><br /><sub><b>Junho Yeo</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=junhoyeo" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://tyneo.net/fr/"><img src="https://avatars2.githubusercontent.com/u/1290679?v=4?s=64" width="64px;" alt="Samuel Kauffmann"/><br /><sub><b>Samuel Kauffmann</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=skauffmann" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/yicru"><img src="https://avatars3.githubusercontent.com/u/37892222?v=4?s=64" width="64px;" alt="yuichiro miyamae"/><br /><sub><b>yuichiro miyamae</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=yicru" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/songheewon"><img src="https://avatars1.githubusercontent.com/u/44194990?v=4?s=64" width="64px;" alt="songheewon"/><br /><sub><b>songheewon</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=songheewon" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vipranarayan14"><img src="https://avatars2.githubusercontent.com/u/17687018?v=4?s=64" width="64px;" alt="Prasanna Venkatesh T S"/><br /><sub><b>Prasanna Venkatesh T S</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=vipranarayan14" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/anthowm"><img src="https://avatars3.githubusercontent.com/u/5764698?v=4?s=64" width="64px;" alt="anthowm"/><br /><sub><b>anthowm</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=anthowm" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dananw"><img src="https://avatars1.githubusercontent.com/u/31610272?v=4?s=64" width="64px;" alt="Danan Wijaya"/><br /><sub><b>Danan Wijaya</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=dananw" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/shubham-kaushal"><img src="https://avatars3.githubusercontent.com/u/63925481?v=4?s=64" width="64px;" alt="Shubham Kaushal"/><br /><sub><b>Shubham Kaushal</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=shubham-kaushal" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/petter"><img src="https://avatars0.githubusercontent.com/u/25374940?v=4?s=64" width="64px;" alt="Petter Sæther Moen"/><br /><sub><b>Petter Sæther Moen</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=petter" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://nygaard.dev"><img src="https://avatars3.githubusercontent.com/u/20663884?v=4?s=64" width="64px;" alt="Herman Nygaard"/><br /><sub><b>Herman Nygaard</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=HermanNygaard" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jnmsl"><img src="https://avatars0.githubusercontent.com/u/44583047?v=4?s=64" width="64px;" alt="jnmsl"/><br /><sub><b>jnmsl</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jnmsl" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://sampoder.com"><img src="https://avatars3.githubusercontent.com/u/39828164?v=4?s=64" width="64px;" alt="Sam Poder"/><br /><sub><b>Sam Poder</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=sampoder" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dominictwlee"><img src="https://avatars2.githubusercontent.com/u/34794189?v=4?s=64" width="64px;" alt="Dominic Lee"/><br /><sub><b>Dominic Lee</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=dominictwlee" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=dominictwlee" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jungaretti.com"><img src="https://avatars.githubusercontent.com/u/19893438?v=4?s=64" width="64px;" alt="JP Ungaretti"/><br /><sub><b>JP Ungaretti</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jungaretti" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/eintxaurtieta"><img src="https://avatars.githubusercontent.com/u/24615080?v=4?s=64" width="64px;" alt="Endika Intxaurtieta"/><br /><sub><b>Endika Intxaurtieta</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=eintxaurtieta" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://anantja.in"><img src="https://avatars.githubusercontent.com/u/509059?v=4?s=64" width="64px;" alt="Anant Jain"/><br /><sub><b>Anant Jain</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=anantja-in" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://medium.com/@tomchentw"><img src="https://avatars.githubusercontent.com/u/922234?v=4?s=64" width="64px;" alt="Tom Chen"/><br /><sub><b>Tom Chen</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=tomchentw" title="Documentation">📖</a> <a href="#infra-tomchentw" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/emiranda04"><img src="https://avatars.githubusercontent.com/u/11409613?v=4?s=64" width="64px;" alt="Ernie Miranda"/><br /><sub><b>Ernie Miranda</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=emiranda04" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bjoluc"><img src="https://avatars.githubusercontent.com/u/25661029?v=4?s=64" width="64px;" alt="bjoluc"/><br /><sub><b>bjoluc</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=bjoluc" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/psujit"><img src="https://avatars.githubusercontent.com/u/17481888?v=4?s=64" width="64px;" alt="Sujit Pradhan"/><br /><sub><b>Sujit Pradhan</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=psujit" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=psujit" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://abhishekashyap.tech/"><img src="https://avatars.githubusercontent.com/u/29458374?v=4?s=64" width="64px;" alt="Abhishek Kashyap"/><br /><sub><b>Abhishek Kashyap</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=abhishekashyap" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/imalbert"><img src="https://avatars.githubusercontent.com/u/12537973?v=4?s=64" width="64px;" alt="imalbert"/><br /><sub><b>imalbert</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=imalbert" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://hasibhassan.com"><img src="https://avatars.githubusercontent.com/u/67892792?v=4?s=64" width="64px;" alt="Hasib Hassan"/><br /><sub><b>Hasib Hassan</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=hasibhassan" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://jamie.rolfs.sh"><img src="https://avatars.githubusercontent.com/u/288160?v=4?s=64" width="64px;" alt="Jamie Rolfs"/><br /><sub><b>Jamie Rolfs</b></sub></a><br /><a href="#ideas-jrolfs" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jrolfs" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jrolfs" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/spidertwin2"><img src="https://avatars.githubusercontent.com/u/29196888?v=4?s=64" width="64px;" alt="Surabhi Gupta"/><br /><sub><b>Surabhi Gupta</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=spidertwin2" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/wadewadewadewadewadewade"><img src="https://avatars.githubusercontent.com/u/23270394?v=4?s=64" width="64px;" alt="Wade McDaniel"/><br /><sub><b>Wade McDaniel</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=wadewadewadewadewadewade" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://amilkar.dev"><img src="https://avatars.githubusercontent.com/u/71573508?v=4?s=64" width="64px;" alt="Amilkar Munoz"/><br /><sub><b>Amilkar Munoz</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=soloamilkar" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://joaopaulo-developer.vercel.app/"><img src="https://avatars.githubusercontent.com/u/64229622?v=4?s=64" width="64px;" alt="João Paulo Rodrigues"/><br /><sub><b>João Paulo Rodrigues</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=joaorodrs" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://develmonk.com"><img src="https://avatars.githubusercontent.com/u/1308847?v=4?s=64" width="64px;" alt="Avery Freeman"/><br /><sub><b>Avery Freeman</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=averyfreeman" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://schulz.codes"><img src="https://avatars.githubusercontent.com/u/3123354?v=4?s=64" width="64px;" alt="Daniel Schulz"/><br /><sub><b>Daniel Schulz</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Atakethefake" title="Bug reports">🐛</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=takethefake" title="Code">💻</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=takethefake" title="Documentation">📖</a> <a href="#ideas-takethefake" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://nikolovlazar.com"><img src="https://avatars.githubusercontent.com/u/5396211?v=4?s=64" width="64px;" alt="Lazar Nikolov"/><br /><sub><b>Lazar Nikolov</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=lazarnikolov94" title="Documentation">📖</a> <a href="#example-lazarnikolov94" title="Examples">💡</a> <a href="#maintenance-lazarnikolov94" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://tuckermassad.com"><img src="https://avatars.githubusercontent.com/u/22939424?v=4?s=64" width="64px;" alt="Tucker Massad"/><br /><sub><b>Tucker Massad</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=TuckerMassad" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/HDisc"><img src="https://avatars.githubusercontent.com/u/43948163?v=4?s=64" width="64px;" alt="hamasu"/><br /><sub><b>hamasu</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=HDisc" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://creativedesignsguru.com/"><img src="https://avatars.githubusercontent.com/u/5209935?v=4?s=64" width="64px;" alt="Remi W."/><br /><sub><b>Remi W.</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ixartz" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://estheragbaje.dev/"><img src="https://avatars.githubusercontent.com/u/53586167?v=4?s=64" width="64px;" alt="Folasade Agbaje"/><br /><sub><b>Folasade Agbaje</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=estheragbaje" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://johann-ehlers.eu"><img src="https://avatars.githubusercontent.com/u/21695702?v=4?s=64" width="64px;" alt="Johann Ehlers"/><br /><sub><b>Johann Ehlers</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=noobinthisgame" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/YenTingWu"><img src="https://avatars.githubusercontent.com/u/57777349?v=4?s=64" width="64px;" alt="YenTing Wu"/><br /><sub><b>YenTing Wu</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=YenTingWu" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sohamsshah"><img src="https://avatars.githubusercontent.com/u/47717492?v=4?s=64" width="64px;" alt="Soham Shah"/><br /><sub><b>Soham Shah</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=sohamsshah" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/wattanx"><img src="https://avatars.githubusercontent.com/u/43837308?v=4?s=64" width="64px;" alt="wattanx"/><br /><sub><b>wattanx</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=wattanx" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://rodrigomaia.me"><img src="https://avatars.githubusercontent.com/u/2081077?v=4?s=64" width="64px;" alt="Rodrigo Maia"/><br /><sub><b>Rodrigo Maia</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=rodrimaia" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.raravind.com"><img src="https://avatars.githubusercontent.com/u/26651561?v=4?s=64" width="64px;" alt="Aravind Ramalingam"/><br /><sub><b>Aravind Ramalingam</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=6aravind" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MustafaHaddara"><img src="https://avatars.githubusercontent.com/u/11722214?v=4?s=64" width="64px;" alt="Mustafa Haddara"/><br /><sub><b>Mustafa Haddara</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=MustafaHaddara" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bryg217"><img src="https://avatars.githubusercontent.com/u/23528307?v=4?s=64" width="64px;" alt="Bryan Guillen"/><br /><sub><b>Bryan Guillen</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=bryg217" title="Documentation">📖</a> <a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Abryg217" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://cloudx.com"><img src="https://avatars.githubusercontent.com/u/1536740?v=4?s=64" width="64px;" alt="Axel Navarro"/><br /><sub><b>Axel Navarro</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=navarroaxel" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/aacevski"><img src="https://avatars.githubusercontent.com/u/44305048?v=4?s=64" width="64px;" alt="Andrej"/><br /><sub><b>Andrej</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=aacevski" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.giacomorebonato.com"><img src="https://avatars.githubusercontent.com/u/630796?v=4?s=64" width="64px;" alt="Giacomo Rebonato"/><br /><sub><b>Giacomo Rebonato</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=giacomorebonato" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ashalfarhan"><img src="https://avatars.githubusercontent.com/u/70800415?v=4?s=64" width="64px;" alt="Ashal Farhan"/><br /><sub><b>Ashal Farhan</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=ashalfarhan" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://czyz.it"><img src="https://avatars.githubusercontent.com/u/24492356?v=4?s=64" width="64px;" alt="Bartek Czyż"/><br /><sub><b>Bartek Czyż</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Abartekczyz" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://imadatyatalah.vercel.app"><img src="https://avatars.githubusercontent.com/u/70093484?v=4?s=64" width="64px;" alt="Imad Atyat-Alah"/><br /><sub><b>Imad Atyat-Alah</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=imadatyatalah" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/AnishDe12020"><img src="https://avatars.githubusercontent.com/u/63192115?v=4?s=64" width="64px;" alt="Anish De"/><br /><sub><b>Anish De</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=AnishDe12020" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://gillespie59.github.io/"><img src="https://avatars.githubusercontent.com/u/555768?v=4?s=64" width="64px;" alt="Emmanuel DEMEY"/><br /><sub><b>Emmanuel DEMEY</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=EmmanuelDemey" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://dev.to/puku0x"><img src="https://avatars.githubusercontent.com/u/2607019?v=4?s=64" width="64px;" alt="Noriyuki Shinpuku"/><br /><sub><b>Noriyuki Shinpuku</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=puku0x" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/StuartReeve"><img src="https://avatars.githubusercontent.com/u/10670873?v=4?s=64" width="64px;" alt="StuartReeve"/><br /><sub><b>StuartReeve</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=StuartReeve" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/SatyaAchanta"><img src="https://avatars.githubusercontent.com/u/8125473?v=4?s=64" width="64px;" alt="Satya Achanta"/><br /><sub><b>Satya Achanta</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3ASatyaAchanta" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/bintay"><img src="https://avatars.githubusercontent.com/u/13704341?v=4?s=64" width="64px;" alt="Ben "/><br /><sub><b>Ben </b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=bintay" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rodrigofuentes"><img src="https://avatars.githubusercontent.com/u/7374840?v=4?s=64" width="64px;" alt="Rodrigo Fuentes"/><br /><sub><b>Rodrigo Fuentes</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Arodrigofuentes" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/yuschick"><img src="https://avatars.githubusercontent.com/u/563226?v=4?s=64" width="64px;" alt="Daniel Yuschick"/><br /><sub><b>Daniel Yuschick</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=yuschick" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://bbovenzi.com/"><img src="https://avatars.githubusercontent.com/u/4600967?v=4?s=64" width="64px;" alt="Brent Bovenzi"/><br /><sub><b>Brent Bovenzi</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=bbovenzi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jakeboone02"><img src="https://avatars.githubusercontent.com/u/366438?v=4?s=64" width="64px;" alt="Jake Boone"/><br /><sub><b>Jake Boone</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jakeboone02" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Patrick-Ullrich"><img src="https://avatars.githubusercontent.com/u/6193042?v=4?s=64" width="64px;" alt="Patrick Ullrich"/><br /><sub><b>Patrick Ullrich</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=Patrick-Ullrich" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://aboveyunhai@gmail.com"><img src="https://avatars.githubusercontent.com/u/35160613?v=4?s=64" width="64px;" alt="aboveyunhai"/><br /><sub><b>aboveyunhai</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=aboveyunhai" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://natecation.com"><img src="https://avatars.githubusercontent.com/u/10874225?v=4?s=64" width="64px;" alt="Nathan H. Leung"/><br /><sub><b>Nathan H. Leung</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=nathanhleung" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://danilowoz.com"><img src="https://avatars.githubusercontent.com/u/4838076?v=4?s=64" width="64px;" alt="Danilo Woznica"/><br /><sub><b>Danilo Woznica</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Adanilowoz" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/aaarichter"><img src="https://avatars.githubusercontent.com/u/2707029?v=4?s=64" width="64px;" alt="aaarichter"/><br /><sub><b>aaarichter</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Aaaarichter" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/m4x3d"><img src="https://avatars.githubusercontent.com/u/44474134?v=4?s=64" width="64px;" alt="Max F."/><br /><sub><b>Max F.</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=m4x3d" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/curdin"><img src="https://avatars.githubusercontent.com/u/31509?v=4?s=64" width="64px;" alt="Curdin Krummenacher"/><br /><sub><b>Curdin Krummenacher</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=curdin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://tylerpweb.dev"><img src="https://avatars.githubusercontent.com/u/65234762?v=4?s=64" width="64px;" alt="Tyler Pfledderer"/><br /><sub><b>Tyler Pfledderer</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=TylerAPfledderer" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/moloughlin"><img src="https://avatars.githubusercontent.com/u/3859277?v=4?s=64" width="64px;" alt="Matthew O'Loughlin "/><br /><sub><b>Matthew O'Loughlin </b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=moloughlin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jacob.omg.lol"><img src="https://avatars.githubusercontent.com/u/29145479?v=4?s=64" width="64px;" alt="Jacob Marshall"/><br /><sub><b>Jacob Marshall</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jacobhq" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/aroyan"><img src="https://avatars.githubusercontent.com/u/43630681?v=4?s=64" width="64px;" alt="Aroyan"/><br /><sub><b>Aroyan</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Aaroyan" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://lucas-mesquita.tech"><img src="https://avatars.githubusercontent.com/u/31039396?v=4?s=64" width="64px;" alt="Lucas Mesquita"/><br /><sub><b>Lucas Mesquita</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=Luccasoli" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://stephane-ruhlmann.com"><img src="https://avatars.githubusercontent.com/u/6011018?v=4?s=64" width="64px;" alt="Stephane Ruhlmann"/><br /><sub><b>Stephane Ruhlmann</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=stephane-ruhlmann" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/aiji42"><img src="https://avatars.githubusercontent.com/u/6711766?v=4?s=64" width="64px;" alt="AijiUejima"/><br /><sub><b>AijiUejima</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=aiji42" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/angie"><img src="https://avatars.githubusercontent.com/u/6738119?v=4?s=64" width="64px;" alt="Angie Merryweather"/><br /><sub><b>Angie Merryweather</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Aangie" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://linkedin.com/in/rezamajidi"><img src="https://avatars.githubusercontent.com/u/7690415?v=4?s=64" width="64px;" alt="Reza"/><br /><sub><b>Reza</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=rezamajidi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://mottox2.com"><img src="https://avatars.githubusercontent.com/u/7007253?v=4?s=64" width="64px;" alt="Yuki Takemoto"/><br /><sub><b>Yuki Takemoto</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Amottox2" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/samuliasmala"><img src="https://avatars.githubusercontent.com/u/14218719?v=4?s=64" width="64px;" alt="Samuli Asmala"/><br /><sub><b>Samuli Asmala</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=samuliasmala" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/lucasferronato"><img src="https://avatars.githubusercontent.com/u/43012047?v=4?s=64" width="64px;" alt="Lucas Ferronato"/><br /><sub><b>Lucas Ferronato</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=LFerronato" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://kolbysisk.com"><img src="https://avatars.githubusercontent.com/u/1395078?v=4?s=64" width="64px;" alt="Kolby Sisk"/><br /><sub><b>Kolby Sisk</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3AKolbySisk" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://theskinnycoder.me"><img src="https://avatars.githubusercontent.com/u/64031854?v=4?s=64" width="64px;" alt="Rahul SriRam"/><br /><sub><b>Rahul SriRam</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=theskinnycoder" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://aashutosh.dev"><img src="https://avatars.githubusercontent.com/u/21199234?v=4?s=64" width="64px;" alt="Aashutosh Rathi"/><br /><sub><b>Aashutosh Rathi</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Aaashutoshrathi" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sitogi"><img src="https://avatars.githubusercontent.com/u/20895397?v=4?s=64" width="64px;" alt="sitogi"/><br /><sub><b>sitogi</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/issues?q=author%3Asitogi" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lejara"><img src="https://avatars.githubusercontent.com/u/16671822?v=4?s=64" width="64px;" alt="Leption"/><br /><sub><b>Leption</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=lejara" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.heatherwarnke.com/"><img src="https://avatars.githubusercontent.com/u/42837789?v=4?s=64" width="64px;" alt="Heather Warnke"/><br /><sub><b>Heather Warnke</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=hwarnke21" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/HariVP03"><img src="https://avatars.githubusercontent.com/u/54934631?v=4?s=64" width="64px;" alt="Hari Vishnu Parashar"/><br /><sub><b>Hari Vishnu Parashar</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=HariVP03" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://kelvinwelter.com"><img src="https://avatars.githubusercontent.com/u/37090245?v=4?s=64" width="64px;" alt="Kelvin Welter"/><br /><sub><b>Kelvin Welter</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=kelvinwelter" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://pybash.xyz"><img src="https://avatars.githubusercontent.com/u/67195650?v=4?s=64" width="64px;" alt="PyBash"/><br /><sub><b>PyBash</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=pybash1" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/umrkhn"><img src="https://avatars.githubusercontent.com/u/75561750?v=4?s=64" width="64px;" alt="Umar Abid"/><br /><sub><b>Umar Abid</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=umrkhn" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/BigDog1400"><img src="https://avatars.githubusercontent.com/u/63280663?v=4?s=64" width="64px;" alt="Isaac"/><br /><sub><b>Isaac</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=BigDog1400" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jakegiganti"><img src="https://avatars.githubusercontent.com/u/7992623?v=4?s=64" width="64px;" alt="Jake Giganti"/><br /><sub><b>Jake Giganti</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=jakegiganti" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kkudose"><img src="https://avatars.githubusercontent.com/u/2448738?v=4?s=64" width="64px;" alt="K Kudose"/><br /><sub><b>K Kudose</b></sub></a><br /><a href="https://github.com/chakra-ui/chakra-ui-docs/commits?author=kkudose" title="Documentation">📖</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

([emoji key](https://allcontributors.org/docs/en/emoji-key)):

This project follows the
[all-contributors](https://github.com/all-contributors/all-contributors)
specification. Contributions of any kind welcome!

## Testing supported by

<img width="200" src="https://cdn.worldvectorlogo.com/logos/browserstack.svg" alt="BrowserStack"/>

## License

MIT © [Segun Adebayo](https://github.com/segunadebayo)
