/******************************************************************************
 *
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *****************************************************************************
 * Originally developed and contributed by Ittiam Systems Pvt. Ltd, Bangalore
*/
/**
*******************************************************************************
* @file
*  ih264_typedefs.h
*
* @brief
*  Type definitions used in the code
*
* @author
*  Ittiam
*
* @remarks
*  None
*
*******************************************************************************
*/

#ifndef _IH264_TYPEDEFS_H_
#define _IH264_TYPEDEFS_H_

#include <stdint.h>
/*****************************************************************************/
/* Unsigned data types                                                       */
/*****************************************************************************/
typedef uint8_t   UWORD8;
typedef uint16_t  UWORD16;
typedef uint32_t  UWORD32;
typedef uint64_t  UWORD64;


/*****************************************************************************/
/* Signed data types                                                         */
/*****************************************************************************/
typedef int8_t     WORD8;
typedef int16_t    WORD16;
typedef int32_t    WORD32;
typedef int64_t    WORD64;

/*****************************************************************************/
/* Miscellaneous data types                                                  */
/*****************************************************************************/
typedef char            CHAR;
typedef double          DOUBLE;

#endif /*   _IH264_TYPEDEFS_H_ */
