<!--
Copyright (c) 2014-2024, Chris Pressey, Cat's Eye Technologies.
This file is distributed under a 2-clause BSD license.  See LICENSES/ dir.
SPDX-License-Identifier: LicenseRef-BSD-2-Clause-X-SixtyPical
-->

This directory contains SixtyPical example programs
specifically for the Commodore 64.

There are subdirectories for more elaborate demos:

*   [demo-game](demo-game/): a little game-like program written as a
    "can we write something you'd see in practice?" test case for SixtyPical.
    
*   [ribos](ribos/): a well-commented example of a C64 raster interrupt
    routine. Originally written with the P65 assembler (which has since
    been reborn as [Ophis][]).
    
    The second version of Ribos has been translated to SixtyPical.
    
*   [petulant](petulant/): "The PETulant Cursor", a tiny (44 bytes)
    "display hack". Originally written in the late 80's. Rewritten with
    the P65 assembler (now Ophis) and re-released on April 1st, 2008 (a
    hint as to its nature).
    
    Translated to SixtyPical (in 2018), after adding some optimizations
    to the SixtyPical compiler, the resulting executable is still 44 bytes!

[Ophis]: http://michaelcmartin.github.io/Ophis/
