export function writeWithPreamble(
  filePath: string,
  fileContent: string,
) {
  return Deno.writeTextFile(
    filePath,
    "# THIS FILE IS AUTOGENERATED. DO NOT EDIT IT BY HAND.\n" + fileContent,
  );
}

export function updateReadme({
  readme,
  section,
  newContent,
}: {
  readme: string;
  section: string;
  newContent: string;
}): string {
  const preamble =
    "<!-- the following section is auto-generated, do not edit -->";
  const startMarker = `<!-- AUTOGEN:${section.toUpperCase()} START -->`;
  const endMarker = `<!-- AUTOGEN:${section.toUpperCase()} END -->`;
  const wrapped = `${startMarker}\n${preamble}\n${newContent}\n${endMarker}`;

  if (!(readme.includes(startMarker) && readme.includes(endMarker))) {
    throw new Error("Markers not found in README.md");
  }

  const pre = readme.split(startMarker)[0];
  const end = readme.split(endMarker)[1];
  return pre + wrapped + end;
}
