<?php
namespace catchAdmin\cms\tables\forms;

use catchAdmin\cms\model\Category as CategoryModel;
use catchAdmin\cms\support\DynamicFormFields;
use catcher\library\form\Form;
use catcher\Utils;

abstract class BaseForm extends Form
{
    protected $table = null;

    public function create(): array
    {
        $fields = parent::create(); // TODO: Change the autogenerated stub

        if ($this->table) {
            return array_merge($fields, (new DynamicFormFields())->build(Utils::tableWithPrefix($this->table)));
        }

        return $fields;
    }
}