<?php
// +----------------------------------------------------------------------
// | Catch-CMS Design On 2020
// +----------------------------------------------------------------------
// | CatchAdmin [Just Like ～ ]
// +----------------------------------------------------------------------
// | Copyright (c) 2017~2020 http://catchadmin.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( https://github.com/yanwenwu/catch-admin/blob/master/LICENSE.txt )
// +----------------------------------------------------------------------
// | Author: JaguarJack [ njphper@gmail.com ]
// +----------------------------------------------------------------------

namespace catchAdmin\cms\model;

use catchAdmin\cms\model\events\BannersEvent;

class Banners extends BaseModel
{
    use BannersEvent;

    // 表名
    public $name = 'cms_banners';
    // 数据库字段映射
    public $field = array(
        'id',
        // banner 标题
        'title',
        // banner 图片
        'banner_img',
        // 默认 0 代表首页展示
        'category_id',
        // 链接地址
        'link_to',
        // 创建人ID
        'creator_id',
        // 创建时间
        'created_at',
        // 更新时间
        'updated_at',
        // 软删除
        'deleted_at',
    );

    public function getList()
    {
        return $this->catchSearch()
            ->field($this->aliasField('*'))
            ->catchLeftJoin(Category::class, 'id', 'category_id', ['name as category'])
            ->catchOrder()
            ->creator()
            ->paginate();
    }
}