# Mago: The Oxidized PHP Toolchain

**Mago** is a modern toolchain for PHP that brings inspiration from the Rust programming language ecosystem. Designed for developers who value speed, reliability, and convenience, Mago is here to enhance your PHP development experience with powerful tools for **formatting**, **linting**, and more.

_Note: This project was previously named “Fennec” before being rebranded due to a naming conflict._

---

## Disclaimer

> Mago is in an early stage of development. Many features are not yet implemented, and existing functionality may change, break, or stop working without notice.

---

## 🚀 What is Mago?

Mago is a comprehensive toolchain for PHP, built to simplify and improve code quality. It offers:

- **Formatter**: Automatically format your PHP code to match consistent, modern styles.
- **Linter**: Catch errors and enforce best practices with customizable rules.
- **CLI**: A command-line interface to integrate Mago seamlessly into your workflow.

Mago aims to be fast, efficient, and easy to use, enabling developers to focus on writing great PHP code.

---

## 🌟 Features

- **Modern PHP Support**: Designed for PHP 8.3 and later, with plans for customizable PHP version targeting.
- **High Performance**: Written in Rust for exceptional speed and reliability.
- **Powerful CLI**: A simple yet flexible interface to run Mago commands.
- **Customizable**: Configure the formatter, linter, and other tools to suit your coding style and project needs.
- **Inspired by the Best**: Built with inspiration from tools like Clippy, OXC, and Psalm.

---

## 📖 Documentation

### Quick Links

- [Getting Started](/getting-started/index.md): Learn how to install and use Mago.
- [Formatter](/formatter/index.md): Automatically format your PHP code.
- [Linter](/linter/index.md): Enforce coding standards and find potential issues.

## 🌐 Community

Have questions or ideas? Join the Mago community on Discord to connect with other developers and stay up-to-date on the latest developments.

[Join the Mago Discord server](https://discord.gg/mwyyjr27eu)

## 📝 License

Mago is open-source software, available under the [MIT](https://github.com/carthage-software/mago/blob/main/LICENSE-MIT) or [Apache 2.0](https://github.com/carthage-software/mago/blob/main/LICENSE-APACHE) licenses. Choose the one that works best for your project.
