pub const ANONYMOUS_CLASS_NAME: &str = "class@anonymous";

/// List of all PHP extensions and their functions.
///
/// This list is not exhaustive and may not be up-to-date.
pub const EXTENSION_FUNCTIONS: [(&str, &[&str]); 48] = [
    (
        "Core",
        &[
            "zend_version",
            "func_num_args",
            "func_get_arg",
            "func_get_args",
            "strlen",
            "strcmp",
            "strncmp",
            "strcasecmp",
            "strncasecmp",
            "error_reporting",
            "define",
            "defined",
            "get_class",
            "get_called_class",
            "get_parent_class",
            "is_subclass_of",
            "is_a",
            "get_class_vars",
            "get_object_vars",
            "get_mangled_object_vars",
            "get_class_methods",
            "method_exists",
            "property_exists",
            "class_exists",
            "interface_exists",
            "trait_exists",
            "enum_exists",
            "function_exists",
            "class_alias",
            "get_included_files",
            "get_required_files",
            "trigger_error",
            "user_error",
            "set_error_handler",
            "restore_error_handler",
            "set_exception_handler",
            "restore_exception_handler",
            "get_declared_classes",
            "get_declared_traits",
            "get_declared_interfaces",
            "get_defined_functions",
            "get_defined_vars",
            "get_resource_type",
            "get_resource_id",
            "get_resources",
            "get_loaded_extensions",
            "get_defined_constants",
            "debug_backtrace",
            "debug_print_backtrace",
            "extension_loaded",
            "get_extension_funcs",
            "gc_mem_caches",
            "gc_collect_cycles",
            "gc_enabled",
            "gc_enable",
            "gc_disable",
            "gc_status",
        ],
    ),
    (
        "date",
        &[
            "strtotime",
            "date",
            "idate",
            "gmdate",
            "mktime",
            "gmmktime",
            "checkdate",
            "strftime",
            "gmstrftime",
            "time",
            "localtime",
            "getdate",
            "date_create",
            "date_create_immutable",
            "date_create_from_format",
            "date_create_immutable_from_format",
            "date_parse",
            "date_parse_from_format",
            "date_get_last_errors",
            "date_format",
            "date_modify",
            "date_add",
            "date_sub",
            "date_timezone_get",
            "date_timezone_set",
            "date_offset_get",
            "date_diff",
            "date_time_set",
            "date_date_set",
            "date_isodate_set",
            "date_timestamp_set",
            "date_timestamp_get",
            "timezone_open",
            "timezone_name_get",
            "timezone_name_from_abbr",
            "timezone_offset_get",
            "timezone_transitions_get",
            "timezone_location_get",
            "timezone_identifiers_list",
            "timezone_abbreviations_list",
            "timezone_version_get",
            "date_interval_create_from_date_string",
            "date_interval_format",
            "date_default_timezone_set",
            "date_default_timezone_get",
            "date_sunrise",
            "date_sunset",
            "date_sun_info",
        ],
    ),
    (
        "libxml",
        &[
            "libxml_set_streams_context",
            "libxml_use_internal_errors",
            "libxml_get_last_error",
            "libxml_get_errors",
            "libxml_clear_errors",
            "libxml_disable_entity_loader",
            "libxml_set_external_entity_loader",
            "libxml_get_external_entity_loader",
        ],
    ),
    (
        "openssl",
        &[
            "openssl_x509_export_to_file",
            "openssl_x509_export",
            "openssl_x509_fingerprint",
            "openssl_x509_check_private_key",
            "openssl_x509_verify",
            "openssl_x509_parse",
            "openssl_x509_checkpurpose",
            "openssl_x509_read",
            "openssl_x509_free",
            "openssl_pkcs12_export_to_file",
            "openssl_pkcs12_export",
            "openssl_pkcs12_read",
            "openssl_csr_export_to_file",
            "openssl_csr_export",
            "openssl_csr_sign",
            "openssl_csr_new",
            "openssl_csr_get_subject",
            "openssl_csr_get_public_key",
            "openssl_pkey_new",
            "openssl_pkey_export_to_file",
            "openssl_pkey_export",
            "openssl_pkey_get_public",
            "openssl_get_publickey",
            "openssl_pkey_free",
            "openssl_free_key",
            "openssl_pkey_get_private",
            "openssl_get_privatekey",
            "openssl_pkey_get_details",
            "openssl_pbkdf2",
            "openssl_pkcs7_verify",
            "openssl_pkcs7_encrypt",
            "openssl_pkcs7_sign",
            "openssl_pkcs7_decrypt",
            "openssl_pkcs7_read",
            "openssl_cms_verify",
            "openssl_cms_encrypt",
            "openssl_cms_sign",
            "openssl_cms_decrypt",
            "openssl_cms_read",
            "openssl_private_encrypt",
            "openssl_private_decrypt",
            "openssl_public_encrypt",
            "openssl_public_decrypt",
            "openssl_error_string",
            "openssl_sign",
            "openssl_verify",
            "openssl_seal",
            "openssl_open",
            "openssl_get_md_methods",
            "openssl_get_cipher_methods",
            "openssl_get_curve_names",
            "openssl_digest",
            "openssl_encrypt",
            "openssl_decrypt",
            "openssl_cipher_iv_length",
            "openssl_cipher_key_length",
            "openssl_dh_compute_key",
            "openssl_pkey_derive",
            "openssl_random_pseudo_bytes",
            "openssl_spki_new",
            "openssl_spki_verify",
            "openssl_spki_export",
            "openssl_spki_export_challenge",
            "openssl_get_cert_locations",
        ],
    ),
    (
        "pcre",
        &[
            "preg_match",
            "preg_match_all",
            "preg_replace",
            "preg_filter",
            "preg_replace_callback",
            "preg_replace_callback_array",
            "preg_split",
            "preg_quote",
            "preg_grep",
            "preg_last_error",
            "preg_last_error_msg",
        ],
    ),
    (
        "zlib",
        &[
            "ob_gzhandler",
            "zlib_get_coding_type",
            "gzfile",
            "gzopen",
            "readgzfile",
            "zlib_encode",
            "zlib_decode",
            "gzdeflate",
            "gzencode",
            "gzcompress",
            "gzinflate",
            "gzdecode",
            "gzuncompress",
            "gzwrite",
            "gzputs",
            "gzrewind",
            "gzclose",
            "gzeof",
            "gzgetc",
            "gzpassthru",
            "gzseek",
            "gztell",
            "gzread",
            "gzgets",
            "deflate_init",
            "deflate_add",
            "inflate_init",
            "inflate_add",
            "inflate_get_status",
            "inflate_get_read_len",
        ],
    ),
    ("bcmath", &["bcadd", "bcsub", "bcmul", "bcdiv", "bcmod", "bcpowmod", "bcpow", "bcsqrt", "bccomp", "bcscale"]),
    (
        "bz2",
        &[
            "bzopen",
            "bzread",
            "bzwrite",
            "bzflush",
            "bzclose",
            "bzerrno",
            "bzerrstr",
            "bzerror",
            "bzcompress",
            "bzdecompress",
        ],
    ),
    (
        "calendar",
        &[
            "cal_days_in_month",
            "cal_from_jd",
            "cal_info",
            "cal_to_jd",
            "easter_date",
            "easter_days",
            "frenchtojd",
            "gregoriantojd",
            "jddayofweek",
            "jdmonthname",
            "jdtofrench",
            "jdtogregorian",
            "jdtojewish",
            "jdtojulian",
            "jdtounix",
            "jewishtojd",
            "juliantojd",
            "unixtojd",
        ],
    ),
    (
        "ctype",
        &[
            "ctype_alnum",
            "ctype_alpha",
            "ctype_cntrl",
            "ctype_digit",
            "ctype_lower",
            "ctype_graph",
            "ctype_print",
            "ctype_punct",
            "ctype_space",
            "ctype_upper",
            "ctype_xdigit",
        ],
    ),
    (
        "curl",
        &[
            "curl_close",
            "curl_copy_handle",
            "curl_errno",
            "curl_error",
            "curl_escape",
            "curl_unescape",
            "curl_multi_setopt",
            "curl_exec",
            "curl_file_create",
            "curl_getinfo",
            "curl_init",
            "curl_upkeep",
            "curl_multi_add_handle",
            "curl_multi_close",
            "curl_multi_errno",
            "curl_multi_exec",
            "curl_multi_getcontent",
            "curl_multi_info_read",
            "curl_multi_init",
            "curl_multi_remove_handle",
            "curl_multi_select",
            "curl_multi_strerror",
            "curl_pause",
            "curl_reset",
            "curl_setopt_array",
            "curl_setopt",
            "curl_share_close",
            "curl_share_errno",
            "curl_share_init",
            "curl_share_setopt",
            "curl_share_strerror",
            "curl_strerror",
            "curl_version",
        ],
    ),
    ("dom", &["dom_import_simplexml"]),
    ("FFI", &[]),
    ("fileinfo", &["finfo_open", "finfo_close", "finfo_set_flags", "finfo_file", "finfo_buffer", "mime_content_type"]),
    (
        "filter",
        &[
            "filter_has_var",
            "filter_input",
            "filter_var",
            "filter_input_array",
            "filter_var_array",
            "filter_list",
            "filter_id",
        ],
    ),
    (
        "hash",
        &[
            "hash",
            "hash_file",
            "hash_hmac",
            "hash_hmac_file",
            "hash_init",
            "hash_update",
            "hash_update_stream",
            "hash_update_file",
            "hash_final",
            "hash_copy",
            "hash_algos",
            "hash_hmac_algos",
            "hash_pbkdf2",
            "hash_equals",
            "hash_hkdf",
            "mhash_get_block_size",
            "mhash_get_hash_name",
            "mhash_keygen_s2k",
            "mhash_count",
            "mhash",
        ],
    ),
    (
        "intl",
        &[
            "intlcal_create_instance",
            "intlcal_get_keyword_values_for_locale",
            "intlcal_get_now",
            "intlcal_get_available_locales",
            "intlcal_get",
            "intlcal_get_time",
            "intlcal_set_time",
            "intlcal_add",
            "intlcal_set_time_zone",
            "intlcal_after",
            "intlcal_before",
            "intlcal_set",
            "intlcal_roll",
            "intlcal_clear",
            "intlcal_field_difference",
            "intlcal_get_actual_maximum",
            "intlcal_get_actual_minimum",
            "intlcal_get_day_of_week_type",
            "intlcal_get_first_day_of_week",
            "intlcal_get_least_maximum",
            "intlcal_get_greatest_minimum",
            "intlcal_get_locale",
            "intlcal_get_maximum",
            "intlcal_get_minimal_days_in_first_week",
            "intlcal_set_minimal_days_in_first_week",
            "intlcal_get_minimum",
            "intlcal_get_time_zone",
            "intlcal_get_type",
            "intlcal_get_weekend_transition",
            "intlcal_in_daylight_time",
            "intlcal_is_lenient",
            "intlcal_is_set",
            "intlcal_is_equivalent_to",
            "intlcal_is_weekend",
            "intlcal_set_first_day_of_week",
            "intlcal_set_lenient",
            "intlcal_get_repeated_wall_time_option",
            "intlcal_equals",
            "intlcal_get_skipped_wall_time_option",
            "intlcal_set_repeated_wall_time_option",
            "intlcal_set_skipped_wall_time_option",
            "intlcal_from_date_time",
            "intlcal_to_date_time",
            "intlcal_get_error_code",
            "intlcal_get_error_message",
            "intlgregcal_create_instance",
            "intlgregcal_set_gregorian_change",
            "intlgregcal_get_gregorian_change",
            "intlgregcal_is_leap_year",
            "collator_create",
            "collator_compare",
            "collator_get_attribute",
            "collator_set_attribute",
            "collator_get_strength",
            "collator_set_strength",
            "collator_sort",
            "collator_sort_with_sort_keys",
            "collator_asort",
            "collator_get_locale",
            "collator_get_error_code",
            "collator_get_error_message",
            "collator_get_sort_key",
            "intl_get_error_code",
            "intl_get_error_message",
            "intl_is_failure",
            "intl_error_name",
            "datefmt_create",
            "datefmt_get_datetype",
            "datefmt_get_timetype",
            "datefmt_get_calendar",
            "datefmt_set_calendar",
            "datefmt_get_timezone_id",
            "datefmt_get_calendar_object",
            "datefmt_get_timezone",
            "datefmt_set_timezone",
            "datefmt_set_pattern",
            "datefmt_get_pattern",
            "datefmt_get_locale",
            "datefmt_set_lenient",
            "datefmt_is_lenient",
            "datefmt_format",
            "datefmt_format_object",
            "datefmt_parse",
            "datefmt_localtime",
            "datefmt_get_error_code",
            "datefmt_get_error_message",
            "numfmt_create",
            "numfmt_format",
            "numfmt_parse",
            "numfmt_format_currency",
            "numfmt_parse_currency",
            "numfmt_set_attribute",
            "numfmt_get_attribute",
            "numfmt_set_text_attribute",
            "numfmt_get_text_attribute",
            "numfmt_set_symbol",
            "numfmt_get_symbol",
            "numfmt_set_pattern",
            "numfmt_get_pattern",
            "numfmt_get_locale",
            "numfmt_get_error_code",
            "numfmt_get_error_message",
            "grapheme_strlen",
            "grapheme_strpos",
            "grapheme_stripos",
            "grapheme_strrpos",
            "grapheme_strripos",
            "grapheme_substr",
            "grapheme_strstr",
            "grapheme_stristr",
            "grapheme_extract",
            "idn_to_ascii",
            "idn_to_utf8",
            "locale_get_default",
            "locale_set_default",
            "locale_get_primary_language",
            "locale_get_script",
            "locale_get_region",
            "locale_get_keywords",
            "locale_get_display_script",
            "locale_get_display_region",
            "locale_get_display_name",
            "locale_get_display_language",
            "locale_get_display_variant",
            "locale_compose",
            "locale_parse",
            "locale_get_all_variants",
            "locale_filter_matches",
            "locale_canonicalize",
            "locale_lookup",
            "locale_accept_from_http",
            "msgfmt_create",
            "msgfmt_format",
            "msgfmt_format_message",
            "msgfmt_parse",
            "msgfmt_parse_message",
            "msgfmt_set_pattern",
            "msgfmt_get_pattern",
            "msgfmt_get_locale",
            "msgfmt_get_error_code",
            "msgfmt_get_error_message",
            "normalizer_normalize",
            "normalizer_is_normalized",
            "normalizer_get_raw_decomposition",
            "resourcebundle_create",
            "resourcebundle_get",
            "resourcebundle_count",
            "resourcebundle_locales",
            "resourcebundle_get_error_code",
            "resourcebundle_get_error_message",
            "intltz_count_equivalent_ids",
            "intltz_create_default",
            "intltz_create_enumeration",
            "intltz_create_time_zone",
            "intltz_create_time_zone_id_enumeration",
            "intltz_from_date_time_zone",
            "intltz_get_canonical_id",
            "intltz_get_display_name",
            "intltz_get_dst_savings",
            "intltz_get_equivalent_id",
            "intltz_get_error_code",
            "intltz_get_error_message",
            "intltz_get_gmt",
            "intltz_get_id",
            "intltz_get_offset",
            "intltz_get_raw_offset",
            "intltz_get_region",
            "intltz_get_tz_data_version",
            "intltz_get_unknown",
            "intltz_get_windows_id",
            "intltz_get_id_for_windows_id",
            "intltz_has_same_rules",
            "intltz_to_date_time_zone",
            "intltz_use_daylight_time",
            "transliterator_create",
            "transliterator_create_from_rules",
            "transliterator_list_ids",
            "transliterator_create_inverse",
            "transliterator_transliterate",
            "transliterator_get_error_code",
            "transliterator_get_error_message",
        ],
    ),
    ("json", &["json_encode", "json_decode", "json_validate", "json_last_error", "json_last_error_msg"]),
    (
        "mbstring",
        &[
            "mb_language",
            "mb_internal_encoding",
            "mb_http_input",
            "mb_http_output",
            "mb_detect_order",
            "mb_substitute_character",
            "mb_preferred_mime_name",
            "mb_parse_str",
            "mb_output_handler",
            "mb_str_split",
            "mb_strlen",
            "mb_strpos",
            "mb_strrpos",
            "mb_stripos",
            "mb_strripos",
            "mb_strstr",
            "mb_strrchr",
            "mb_stristr",
            "mb_strrichr",
            "mb_substr_count",
            "mb_substr",
            "mb_strcut",
            "mb_strwidth",
            "mb_strimwidth",
            "mb_convert_encoding",
            "mb_convert_case",
            "mb_strtoupper",
            "mb_strtolower",
            "mb_detect_encoding",
            "mb_list_encodings",
            "mb_encoding_aliases",
            "mb_encode_mimeheader",
            "mb_decode_mimeheader",
            "mb_convert_kana",
            "mb_convert_variables",
            "mb_encode_numericentity",
            "mb_decode_numericentity",
            "mb_send_mail",
            "mb_get_info",
            "mb_check_encoding",
            "mb_scrub",
            "mb_ord",
            "mb_chr",
            "mb_str_pad",
            "mb_regex_encoding",
            "mb_ereg",
            "mb_eregi",
            "mb_ereg_replace",
            "mb_eregi_replace",
            "mb_ereg_replace_callback",
            "mb_split",
            "mb_ereg_match",
            "mb_ereg_search",
            "mb_ereg_search_pos",
            "mb_ereg_search_regs",
            "mb_ereg_search_init",
            "mb_ereg_search_getregs",
            "mb_ereg_search_getpos",
            "mb_ereg_search_setpos",
            "mb_regex_set_options",
        ],
    ),
    (
        "pcntl",
        &[
            "pcntl_fork",
            "pcntl_waitpid",
            "pcntl_wait",
            "pcntl_signal",
            "pcntl_signal_get_handler",
            "pcntl_signal_dispatch",
            "pcntl_sigprocmask",
            "pcntl_wifexited",
            "pcntl_wifstopped",
            "pcntl_wifcontinued",
            "pcntl_wifsignaled",
            "pcntl_wexitstatus",
            "pcntl_wtermsig",
            "pcntl_wstopsig",
            "pcntl_exec",
            "pcntl_alarm",
            "pcntl_get_last_error",
            "pcntl_errno",
            "pcntl_getpriority",
            "pcntl_setpriority",
            "pcntl_strerror",
            "pcntl_async_signals",
        ],
    ),
    (
        "SPL",
        &[
            "class_implements",
            "class_parents",
            "class_uses",
            "spl_autoload",
            "spl_autoload_call",
            "spl_autoload_extensions",
            "spl_autoload_functions",
            "spl_autoload_register",
            "spl_autoload_unregister",
            "spl_classes",
            "spl_object_hash",
            "spl_object_id",
            "iterator_apply",
            "iterator_count",
            "iterator_to_array",
        ],
    ),
    (
        "session",
        &[
            "session_name",
            "session_module_name",
            "session_save_path",
            "session_id",
            "session_create_id",
            "session_regenerate_id",
            "session_decode",
            "session_encode",
            "session_destroy",
            "session_unset",
            "session_gc",
            "session_get_cookie_params",
            "session_write_close",
            "session_abort",
            "session_reset",
            "session_status",
            "session_register_shutdown",
            "session_commit",
            "session_set_save_handler",
            "session_cache_limiter",
            "session_cache_expire",
            "session_set_cookie_params",
            "session_start",
        ],
    ),
    ("PDO", &["pdo_drivers"]),
    ("pdo_pgsql", &[]),
    (
        "pgsql",
        &[
            "pg_connect",
            "pg_pconnect",
            "pg_connect_poll",
            "pg_close",
            "pg_dbname",
            "pg_last_error",
            "pg_errormessage",
            "pg_options",
            "pg_port",
            "pg_tty",
            "pg_host",
            "pg_version",
            "pg_parameter_status",
            "pg_ping",
            "pg_query",
            "pg_exec",
            "pg_query_params",
            "pg_prepare",
            "pg_execute",
            "pg_num_rows",
            "pg_numrows",
            "pg_num_fields",
            "pg_numfields",
            "pg_affected_rows",
            "pg_cmdtuples",
            "pg_last_notice",
            "pg_field_table",
            "pg_field_name",
            "pg_fieldname",
            "pg_field_size",
            "pg_fieldsize",
            "pg_field_type",
            "pg_fieldtype",
            "pg_field_type_oid",
            "pg_field_num",
            "pg_fieldnum",
            "pg_fetch_result",
            "pg_result",
            "pg_fetch_row",
            "pg_fetch_assoc",
            "pg_fetch_array",
            "pg_fetch_object",
            "pg_fetch_all",
            "pg_fetch_all_columns",
            "pg_result_seek",
            "pg_field_prtlen",
            "pg_fieldprtlen",
            "pg_field_is_null",
            "pg_fieldisnull",
            "pg_free_result",
            "pg_freeresult",
            "pg_last_oid",
            "pg_getlastoid",
            "pg_trace",
            "pg_untrace",
            "pg_lo_create",
            "pg_locreate",
            "pg_lo_unlink",
            "pg_lounlink",
            "pg_lo_open",
            "pg_loopen",
            "pg_lo_close",
            "pg_loclose",
            "pg_lo_read",
            "pg_loread",
            "pg_lo_write",
            "pg_lowrite",
            "pg_lo_read_all",
            "pg_loreadall",
            "pg_lo_import",
            "pg_loimport",
            "pg_lo_export",
            "pg_loexport",
            "pg_lo_seek",
            "pg_lo_tell",
            "pg_lo_truncate",
            "pg_set_error_verbosity",
            "pg_set_client_encoding",
            "pg_setclientencoding",
            "pg_client_encoding",
            "pg_clientencoding",
            "pg_end_copy",
            "pg_put_line",
            "pg_copy_to",
            "pg_copy_from",
            "pg_escape_string",
            "pg_escape_bytea",
            "pg_unescape_bytea",
            "pg_escape_literal",
            "pg_escape_identifier",
            "pg_result_error",
            "pg_result_error_field",
            "pg_connection_status",
            "pg_transaction_status",
            "pg_connection_reset",
            "pg_cancel_query",
            "pg_connection_busy",
            "pg_send_query",
            "pg_send_query_params",
            "pg_send_prepare",
            "pg_send_execute",
            "pg_get_result",
            "pg_result_status",
            "pg_get_notify",
            "pg_get_pid",
            "pg_socket",
            "pg_consume_input",
            "pg_flush",
            "pg_meta_data",
            "pg_convert",
            "pg_insert",
            "pg_update",
            "pg_delete",
            "pg_select",
            "pg_set_error_context_visibility",
        ],
    ),
    (
        "standard",
        &[
            "set_time_limit",
            "header_register_callback",
            "ob_start",
            "ob_flush",
            "ob_clean",
            "ob_end_flush",
            "ob_end_clean",
            "ob_get_flush",
            "ob_get_clean",
            "ob_get_contents",
            "ob_get_level",
            "ob_get_length",
            "ob_list_handlers",
            "ob_get_status",
            "ob_implicit_flush",
            "output_reset_rewrite_vars",
            "output_add_rewrite_var",
            "stream_wrapper_register",
            "stream_register_wrapper",
            "stream_wrapper_unregister",
            "stream_wrapper_restore",
            "array_push",
            "krsort",
            "ksort",
            "count",
            "sizeof",
            "natsort",
            "natcasesort",
            "asort",
            "arsort",
            "sort",
            "rsort",
            "usort",
            "uasort",
            "uksort",
            "end",
            "prev",
            "next",
            "reset",
            "current",
            "pos",
            "key",
            "min",
            "max",
            "array_walk",
            "array_walk_recursive",
            "in_array",
            "array_search",
            "extract",
            "compact",
            "array_fill",
            "array_fill_keys",
            "range",
            "shuffle",
            "array_pop",
            "array_shift",
            "array_unshift",
            "array_splice",
            "array_slice",
            "array_merge",
            "array_merge_recursive",
            "array_replace",
            "array_replace_recursive",
            "array_keys",
            "array_key_first",
            "array_key_last",
            "array_values",
            "array_count_values",
            "array_column",
            "array_reverse",
            "array_pad",
            "array_flip",
            "array_change_key_case",
            "array_unique",
            "array_intersect_key",
            "array_intersect_ukey",
            "array_intersect",
            "array_uintersect",
            "array_intersect_assoc",
            "array_uintersect_assoc",
            "array_intersect_uassoc",
            "array_uintersect_uassoc",
            "array_diff_key",
            "array_diff_ukey",
            "array_diff",
            "array_udiff",
            "array_diff_assoc",
            "array_diff_uassoc",
            "array_udiff_assoc",
            "array_udiff_uassoc",
            "array_multisort",
            "array_rand",
            "array_sum",
            "array_product",
            "array_reduce",
            "array_filter",
            "array_map",
            "array_key_exists",
            "key_exists",
            "array_chunk",
            "array_combine",
            "array_is_list",
            "base64_encode",
            "base64_decode",
            "constant",
            "ip2long",
            "long2ip",
            "getenv",
            "putenv",
            "getopt",
            "flush",
            "sleep",
            "usleep",
            "time_nanosleep",
            "time_sleep_until",
            "get_current_user",
            "get_cfg_var",
            "error_log",
            "error_get_last",
            "error_clear_last",
            "call_user_func",
            "call_user_func_array",
            "forward_static_call",
            "forward_static_call_array",
            "register_shutdown_function",
            "highlight_file",
            "show_source",
            "php_strip_whitespace",
            "highlight_string",
            "ini_get",
            "ini_get_all",
            "ini_set",
            "ini_alter",
            "ini_restore",
            "ini_parse_quantity",
            "set_include_path",
            "get_include_path",
            "print_r",
            "connection_aborted",
            "connection_status",
            "ignore_user_abort",
            "getservbyname",
            "getservbyport",
            "getprotobyname",
            "getprotobynumber",
            "register_tick_function",
            "unregister_tick_function",
            "is_uploaded_file",
            "move_uploaded_file",
            "parse_ini_file",
            "parse_ini_string",
            "sys_getloadavg",
            "get_browser",
            "crc32",
            "crypt",
            "strptime",
            "gethostname",
            "gethostbyaddr",
            "gethostbyname",
            "gethostbynamel",
            "dns_check_record",
            "checkdnsrr",
            "dns_get_record",
            "dns_get_mx",
            "getmxrr",
            "net_get_interfaces",
            "ftok",
            "hrtime",
            "md5",
            "md5_file",
            "getmyuid",
            "getmygid",
            "getmypid",
            "getmyinode",
            "getlastmod",
            "sha1",
            "sha1_file",
            "openlog",
            "closelog",
            "syslog",
            "inet_ntop",
            "inet_pton",
            "metaphone",
            "header",
            "header_remove",
            "setrawcookie",
            "setcookie",
            "http_response_code",
            "headers_sent",
            "headers_list",
            "htmlspecialchars",
            "htmlspecialchars_decode",
            "html_entity_decode",
            "htmlentities",
            "get_html_translation_table",
            "assert",
            "assert_options",
            "bin2hex",
            "hex2bin",
            "strspn",
            "strcspn",
            "nl_langinfo",
            "strcoll",
            "trim",
            "rtrim",
            "chop",
            "ltrim",
            "wordwrap",
            "explode",
            "implode",
            "join",
            "strtok",
            "strtoupper",
            "strtolower",
            "str_increment",
            "str_decrement",
            "basename",
            "dirname",
            "pathinfo",
            "stristr",
            "strstr",
            "strchr",
            "strpos",
            "stripos",
            "strrpos",
            "strripos",
            "strrchr",
            "str_contains",
            "str_starts_with",
            "str_ends_with",
            "chunk_split",
            "substr",
            "substr_replace",
            "quotemeta",
            "ord",
            "chr",
            "ucfirst",
            "lcfirst",
            "ucwords",
            "strtr",
            "strrev",
            "similar_text",
            "addcslashes",
            "addslashes",
            "stripcslashes",
            "stripslashes",
            "str_replace",
            "str_ireplace",
            "hebrev",
            "nl2br",
            "strip_tags",
            "setlocale",
            "parse_str",
            "str_getcsv",
            "str_repeat",
            "count_chars",
            "strnatcmp",
            "localeconv",
            "strnatcasecmp",
            "substr_count",
            "str_pad",
            "sscanf",
            "str_rot13",
            "str_shuffle",
            "str_word_count",
            "str_split",
            "strpbrk",
            "substr_compare",
            "utf8_encode",
            "utf8_decode",
            "opendir",
            "dir",
            "closedir",
            "chdir",
            "chroot",
            "getcwd",
            "rewinddir",
            "readdir",
            "scandir",
            "glob",
            "exec",
            "system",
            "passthru",
            "escapeshellcmd",
            "escapeshellarg",
            "shell_exec",
            "proc_nice",
            "flock",
            "get_meta_tags",
            "pclose",
            "popen",
            "readfile",
            "rewind",
            "rmdir",
            "umask",
            "fclose",
            "feof",
            "fgetc",
            "fgets",
            "fread",
            "fopen",
            "fscanf",
            "fpassthru",
            "ftruncate",
            "fstat",
            "fseek",
            "ftell",
            "fflush",
            "fsync",
            "fdatasync",
            "fwrite",
            "fputs",
            "mkdir",
            "rename",
            "copy",
            "tempnam",
            "tmpfile",
            "file",
            "file_get_contents",
            "unlink",
            "file_put_contents",
            "fputcsv",
            "fgetcsv",
            "realpath",
            "fnmatch",
            "sys_get_temp_dir",
            "fileatime",
            "filectime",
            "filegroup",
            "fileinode",
            "filemtime",
            "fileowner",
            "fileperms",
            "filesize",
            "filetype",
            "file_exists",
            "is_writable",
            "is_writeable",
            "is_readable",
            "is_executable",
            "is_file",
            "is_dir",
            "is_link",
            "stat",
            "lstat",
            "chown",
            "chgrp",
            "lchown",
            "lchgrp",
            "chmod",
            "touch",
            "clearstatcache",
            "disk_total_space",
            "disk_free_space",
            "diskfreespace",
            "realpath_cache_get",
            "realpath_cache_size",
            "sprintf",
            "printf",
            "vprintf",
            "vsprintf",
            "fprintf",
            "vfprintf",
            "fsockopen",
            "pfsockopen",
            "http_build_query",
            "image_type_to_mime_type",
            "image_type_to_extension",
            "getimagesize",
            "getimagesizefromstring",
            "phpinfo",
            "phpversion",
            "phpcredits",
            "php_sapi_name",
            "php_uname",
            "php_ini_scanned_files",
            "php_ini_loaded_file",
            "iptcembed",
            "iptcparse",
            "levenshtein",
            "readlink",
            "linkinfo",
            "symlink",
            "link",
            "mail",
            "abs",
            "ceil",
            "floor",
            "round",
            "sin",
            "cos",
            "tan",
            "asin",
            "acos",
            "atan",
            "atanh",
            "atan2",
            "sinh",
            "cosh",
            "tanh",
            "asinh",
            "acosh",
            "expm1",
            "log1p",
            "pi",
            "is_finite",
            "is_nan",
            "intdiv",
            "is_infinite",
            "pow",
            "exp",
            "log",
            "log10",
            "sqrt",
            "hypot",
            "deg2rad",
            "rad2deg",
            "bindec",
            "hexdec",
            "octdec",
            "decbin",
            "decoct",
            "dechex",
            "base_convert",
            "number_format",
            "fmod",
            "fdiv",
            "microtime",
            "gettimeofday",
            "getrusage",
            "pack",
            "unpack",
            "password_get_info",
            "password_hash",
            "password_needs_rehash",
            "password_verify",
            "password_algos",
            "proc_open",
            "proc_close",
            "proc_terminate",
            "proc_get_status",
            "quoted_printable_decode",
            "quoted_printable_encode",
            "soundex",
            "stream_select",
            "stream_context_create",
            "stream_context_set_params",
            "stream_context_get_params",
            "stream_context_set_option",
            "stream_context_set_options",
            "stream_context_get_options",
            "stream_context_get_default",
            "stream_context_set_default",
            "stream_filter_prepend",
            "stream_filter_append",
            "stream_filter_remove",
            "stream_socket_client",
            "stream_socket_server",
            "stream_socket_accept",
            "stream_socket_get_name",
            "stream_socket_recvfrom",
            "stream_socket_sendto",
            "stream_socket_enable_crypto",
            "stream_socket_shutdown",
            "stream_socket_pair",
            "stream_copy_to_stream",
            "stream_get_contents",
            "stream_supports_lock",
            "stream_set_write_buffer",
            "set_file_buffer",
            "stream_set_read_buffer",
            "stream_set_blocking",
            "socket_set_blocking",
            "stream_get_meta_data",
            "socket_get_status",
            "stream_get_line",
            "stream_resolve_include_path",
            "stream_get_wrappers",
            "stream_get_transports",
            "stream_is_local",
            "stream_isatty",
            "stream_set_chunk_size",
            "stream_set_timeout",
            "socket_set_timeout",
            "gettype",
            "get_debug_type",
            "settype",
            "intval",
            "floatval",
            "doubleval",
            "boolval",
            "strval",
            "is_null",
            "is_resource",
            "is_bool",
            "is_int",
            "is_integer",
            "is_long",
            "is_float",
            "is_double",
            "is_numeric",
            "is_string",
            "is_array",
            "is_object",
            "is_scalar",
            "is_callable",
            "is_iterable",
            "is_countable",
            "uniqid",
            "parse_url",
            "urlencode",
            "urldecode",
            "rawurlencode",
            "rawurldecode",
            "get_headers",
            "stream_bucket_make_writeable",
            "stream_bucket_prepend",
            "stream_bucket_append",
            "stream_bucket_new",
            "stream_get_filters",
            "stream_filter_register",
            "convert_uuencode",
            "convert_uudecode",
            "var_dump",
            "var_export",
            "debug_zval_dump",
            "serialize",
            "unserialize",
            "memory_get_usage",
            "memory_get_peak_usage",
            "memory_reset_peak_usage",
            "version_compare",
            "dl",
            "cli_set_process_title",
            "cli_get_process_title",
        ],
    ),
    (
        "posix",
        &[
            "posix_kill",
            "posix_getpid",
            "posix_getppid",
            "posix_getuid",
            "posix_setuid",
            "posix_geteuid",
            "posix_seteuid",
            "posix_getgid",
            "posix_setgid",
            "posix_getegid",
            "posix_setegid",
            "posix_getgroups",
            "posix_getlogin",
            "posix_getpgrp",
            "posix_setsid",
            "posix_setpgid",
            "posix_getpgid",
            "posix_getsid",
            "posix_uname",
            "posix_times",
            "posix_ctermid",
            "posix_ttyname",
            "posix_isatty",
            "posix_getcwd",
            "posix_mkfifo",
            "posix_mknod",
            "posix_access",
            "posix_getgrnam",
            "posix_getgrgid",
            "posix_getpwnam",
            "posix_getpwuid",
            "posix_getrlimit",
            "posix_setrlimit",
            "posix_get_last_error",
            "posix_errno",
            "posix_strerror",
            "posix_initgroups",
            "posix_sysconf",
            "posix_pathconf",
            "posix_fpathconf",
        ],
    ),
    (
        "random",
        &[
            "lcg_value",
            "mt_srand",
            "srand",
            "rand",
            "mt_rand",
            "mt_getrandmax",
            "getrandmax",
            "random_bytes",
            "random_int",
        ],
    ),
    (
        "readline",
        &[
            "readline",
            "readline_info",
            "readline_add_history",
            "readline_clear_history",
            "readline_list_history",
            "readline_read_history",
            "readline_write_history",
            "readline_completion_function",
            "readline_callback_handler_install",
            "readline_callback_read_char",
            "readline_callback_handler_remove",
            "readline_redisplay",
            "readline_on_new_line",
        ],
    ),
    ("Reflection", &[]),
    ("Phar", &[]),
    ("shmop", &["shmop_open", "shmop_read", "shmop_close", "shmop_size", "shmop_write", "shmop_delete"]),
    ("SimpleXML", &["simplexml_load_file", "simplexml_load_string", "simplexml_import_dom"]),
    (
        "sockets",
        &[
            "socket_select",
            "socket_create_listen",
            "socket_accept",
            "socket_set_nonblock",
            "socket_set_block",
            "socket_listen",
            "socket_close",
            "socket_write",
            "socket_read",
            "socket_getsockname",
            "socket_getpeername",
            "socket_create",
            "socket_connect",
            "socket_strerror",
            "socket_bind",
            "socket_recv",
            "socket_send",
            "socket_recvfrom",
            "socket_sendto",
            "socket_get_option",
            "socket_getopt",
            "socket_set_option",
            "socket_setopt",
            "socket_create_pair",
            "socket_shutdown",
            "socket_atmark",
            "socket_last_error",
            "socket_clear_error",
            "socket_import_stream",
            "socket_export_stream",
            "socket_sendmsg",
            "socket_recvmsg",
            "socket_cmsg_space",
            "socket_addrinfo_lookup",
            "socket_addrinfo_connect",
            "socket_addrinfo_bind",
            "socket_addrinfo_explain",
        ],
    ),
    (
        "sodium",
        &[
            "sodium_crypto_aead_aes256gcm_is_available",
            "sodium_crypto_aead_chacha20poly1305_decrypt",
            "sodium_crypto_aead_chacha20poly1305_encrypt",
            "sodium_crypto_aead_chacha20poly1305_keygen",
            "sodium_crypto_aead_chacha20poly1305_ietf_decrypt",
            "sodium_crypto_aead_chacha20poly1305_ietf_encrypt",
            "sodium_crypto_aead_chacha20poly1305_ietf_keygen",
            "sodium_crypto_aead_xchacha20poly1305_ietf_decrypt",
            "sodium_crypto_aead_xchacha20poly1305_ietf_keygen",
            "sodium_crypto_aead_xchacha20poly1305_ietf_encrypt",
            "sodium_crypto_auth",
            "sodium_crypto_auth_keygen",
            "sodium_crypto_auth_verify",
            "sodium_crypto_box",
            "sodium_crypto_box_keypair",
            "sodium_crypto_box_seed_keypair",
            "sodium_crypto_box_keypair_from_secretkey_and_publickey",
            "sodium_crypto_box_open",
            "sodium_crypto_box_publickey",
            "sodium_crypto_box_publickey_from_secretkey",
            "sodium_crypto_box_seal",
            "sodium_crypto_box_seal_open",
            "sodium_crypto_box_secretkey",
            "sodium_crypto_core_ristretto255_add",
            "sodium_crypto_core_ristretto255_from_hash",
            "sodium_crypto_core_ristretto255_is_valid_point",
            "sodium_crypto_core_ristretto255_random",
            "sodium_crypto_core_ristretto255_scalar_add",
            "sodium_crypto_core_ristretto255_scalar_complement",
            "sodium_crypto_core_ristretto255_scalar_invert",
            "sodium_crypto_core_ristretto255_scalar_mul",
            "sodium_crypto_core_ristretto255_scalar_negate",
            "sodium_crypto_core_ristretto255_scalar_random",
            "sodium_crypto_core_ristretto255_scalar_reduce",
            "sodium_crypto_core_ristretto255_scalar_sub",
            "sodium_crypto_core_ristretto255_sub",
            "sodium_crypto_kx_keypair",
            "sodium_crypto_kx_publickey",
            "sodium_crypto_kx_secretkey",
            "sodium_crypto_kx_seed_keypair",
            "sodium_crypto_kx_client_session_keys",
            "sodium_crypto_kx_server_session_keys",
            "sodium_crypto_generichash",
            "sodium_crypto_generichash_keygen",
            "sodium_crypto_generichash_init",
            "sodium_crypto_generichash_update",
            "sodium_crypto_generichash_final",
            "sodium_crypto_kdf_derive_from_key",
            "sodium_crypto_kdf_keygen",
            "sodium_crypto_pwhash",
            "sodium_crypto_pwhash_str",
            "sodium_crypto_pwhash_str_verify",
            "sodium_crypto_pwhash_str_needs_rehash",
            "sodium_crypto_pwhash_scryptsalsa208sha256",
            "sodium_crypto_pwhash_scryptsalsa208sha256_str",
            "sodium_crypto_pwhash_scryptsalsa208sha256_str_verify",
            "sodium_crypto_scalarmult",
            "sodium_crypto_scalarmult_ristretto255",
            "sodium_crypto_scalarmult_ristretto255_base",
            "sodium_crypto_secretbox",
            "sodium_crypto_secretbox_keygen",
            "sodium_crypto_secretbox_open",
            "sodium_crypto_secretstream_xchacha20poly1305_keygen",
            "sodium_crypto_secretstream_xchacha20poly1305_init_push",
            "sodium_crypto_secretstream_xchacha20poly1305_push",
            "sodium_crypto_secretstream_xchacha20poly1305_init_pull",
            "sodium_crypto_secretstream_xchacha20poly1305_pull",
            "sodium_crypto_secretstream_xchacha20poly1305_rekey",
            "sodium_crypto_shorthash",
            "sodium_crypto_shorthash_keygen",
            "sodium_crypto_sign",
            "sodium_crypto_sign_detached",
            "sodium_crypto_sign_ed25519_pk_to_curve25519",
            "sodium_crypto_sign_ed25519_sk_to_curve25519",
            "sodium_crypto_sign_keypair",
            "sodium_crypto_sign_keypair_from_secretkey_and_publickey",
            "sodium_crypto_sign_open",
            "sodium_crypto_sign_publickey",
            "sodium_crypto_sign_secretkey",
            "sodium_crypto_sign_publickey_from_secretkey",
            "sodium_crypto_sign_seed_keypair",
            "sodium_crypto_sign_verify_detached",
            "sodium_crypto_stream",
            "sodium_crypto_stream_keygen",
            "sodium_crypto_stream_xor",
            "sodium_crypto_stream_xchacha20",
            "sodium_crypto_stream_xchacha20_keygen",
            "sodium_crypto_stream_xchacha20_xor",
            "sodium_crypto_stream_xchacha20_xor_ic",
            "sodium_add",
            "sodium_compare",
            "sodium_increment",
            "sodium_memcmp",
            "sodium_memzero",
            "sodium_pad",
            "sodium_unpad",
            "sodium_bin2hex",
            "sodium_hex2bin",
            "sodium_bin2base64",
            "sodium_base642bin",
            "sodium_crypto_scalarmult_base",
        ],
    ),
    (
        "sysvmsg",
        &[
            "msg_get_queue",
            "msg_send",
            "msg_receive",
            "msg_remove_queue",
            "msg_stat_queue",
            "msg_set_queue",
            "msg_queue_exists",
        ],
    ),
    ("sysvsem", &["sem_get", "sem_acquire", "sem_release", "sem_remove"]),
    (
        "sysvshm",
        &["shm_attach", "shm_detach", "shm_has_var", "shm_remove", "shm_put_var", "shm_get_var", "shm_remove_var"],
    ),
    ("tokenizer", &["token_get_all", "token_name"]),
    (
        "xml",
        &[
            "xml_parser_create",
            "xml_parser_create_ns",
            "xml_set_object",
            "xml_set_element_handler",
            "xml_set_character_data_handler",
            "xml_set_processing_instruction_handler",
            "xml_set_default_handler",
            "xml_set_unparsed_entity_decl_handler",
            "xml_set_notation_decl_handler",
            "xml_set_external_entity_ref_handler",
            "xml_set_start_namespace_decl_handler",
            "xml_set_end_namespace_decl_handler",
            "xml_parse",
            "xml_parse_into_struct",
            "xml_get_error_code",
            "xml_error_string",
            "xml_get_current_line_number",
            "xml_get_current_column_number",
            "xml_get_current_byte_index",
            "xml_parser_free",
            "xml_parser_set_option",
            "xml_parser_get_option",
        ],
    ),
    ("xmlreader", &[]),
    (
        "xmlwriter",
        &[
            "xmlwriter_open_uri",
            "xmlwriter_open_memory",
            "xmlwriter_set_indent",
            "xmlwriter_set_indent_string",
            "xmlwriter_start_comment",
            "xmlwriter_end_comment",
            "xmlwriter_start_attribute",
            "xmlwriter_end_attribute",
            "xmlwriter_write_attribute",
            "xmlwriter_start_attribute_ns",
            "xmlwriter_write_attribute_ns",
            "xmlwriter_start_element",
            "xmlwriter_end_element",
            "xmlwriter_full_end_element",
            "xmlwriter_start_element_ns",
            "xmlwriter_write_element",
            "xmlwriter_write_element_ns",
            "xmlwriter_start_pi",
            "xmlwriter_end_pi",
            "xmlwriter_write_pi",
            "xmlwriter_start_cdata",
            "xmlwriter_end_cdata",
            "xmlwriter_write_cdata",
            "xmlwriter_text",
            "xmlwriter_write_raw",
            "xmlwriter_start_document",
            "xmlwriter_end_document",
            "xmlwriter_write_comment",
            "xmlwriter_start_dtd",
            "xmlwriter_end_dtd",
            "xmlwriter_write_dtd",
            "xmlwriter_start_dtd_element",
            "xmlwriter_end_dtd_element",
            "xmlwriter_write_dtd_element",
            "xmlwriter_start_dtd_attlist",
            "xmlwriter_end_dtd_attlist",
            "xmlwriter_write_dtd_attlist",
            "xmlwriter_start_dtd_entity",
            "xmlwriter_end_dtd_entity",
            "xmlwriter_write_dtd_entity",
            "xmlwriter_output_memory",
            "xmlwriter_flush",
        ],
    ),
    ("xsl", &[]),
    (
        "zip",
        &[
            "zip_open",
            "zip_close",
            "zip_read",
            "zip_entry_open",
            "zip_entry_close",
            "zip_entry_read",
            "zip_entry_name",
            "zip_entry_compressedsize",
            "zip_entry_filesize",
            "zip_entry_compressionmethod",
        ],
    ),
    (
        "iconv",
        &[
            "iconv_strlen",
            "iconv_substr",
            "iconv_strpos",
            "iconv_strrpos",
            "iconv_mime_encode",
            "iconv_mime_decode",
            "iconv_mime_decode_headers",
            "iconv",
            "iconv_set_encoding",
            "iconv_get_encoding",
        ],
    ),
    ("raphf", &["raphf\\stat_persistent_handles", "raphf\\clean_persistent_handles"]),
    (
        "uv",
        &[
            "uv_update_time",
            "uv_ref",
            "uv_unref",
            "uv_loop_new",
            "uv_default_loop",
            "uv_stop",
            "uv_run",
            "uv_ip4_addr",
            "uv_ip6_addr",
            "uv_ip4_name",
            "uv_ip6_name",
            "uv_write",
            "uv_write2",
            "uv_shutdown",
            "uv_close",
            "uv_now",
            "uv_loop_delete",
            "uv_read_start",
            "uv_read_stop",
            "uv_err_name",
            "uv_strerror",
            "uv_is_active",
            "uv_is_closing",
            "uv_is_readable",
            "uv_is_writable",
            "uv_walk",
            "uv_guess_handle",
            "uv_idle_init",
            "uv_idle_start",
            "uv_idle_stop",
            "uv_timer_init",
            "uv_timer_start",
            "uv_timer_stop",
            "uv_timer_again",
            "uv_timer_set_repeat",
            "uv_timer_get_repeat",
            "uv_tcp_init",
            "uv_tcp_open",
            "uv_tcp_nodelay",
            "uv_tcp_bind",
            "uv_tcp_bind6",
            "uv_listen",
            "uv_accept",
            "uv_tcp_connect",
            "uv_tcp_connect6",
            "uv_udp_init",
            "uv_udp_open",
            "uv_udp_bind",
            "uv_udp_bind6",
            "uv_udp_set_multicast_loop",
            "uv_udp_set_multicast_ttl",
            "uv_udp_send",
            "uv_udp_send6",
            "uv_udp_recv_start",
            "uv_udp_recv_stop",
            "uv_udp_set_membership",
            "uv_udp_set_broadcast",
            "uv_poll_init",
            "uv_poll_init_socket",
            "uv_poll_start",
            "uv_poll_stop",
            "uv_fs_poll_init",
            "uv_fs_poll_start",
            "uv_fs_poll_stop",
            "uv_tcp_getsockname",
            "uv_tcp_getpeername",
            "uv_udp_getsockname",
            "uv_tcp_simultaneous_accepts",
            "uv_pipe_init",
            "uv_pipe_bind",
            "uv_pipe_open",
            "uv_pipe_connect",
            "uv_pipe_pending_instances",
            "uv_pipe_pending_count",
            "uv_pipe_pending_type",
            "uv_stdio_new",
            "uv_spawn",
            "uv_process_kill",
            "uv_process_get_pid",
            "uv_kill",
            "uv_getaddrinfo",
            "uv_rwlock_init",
            "uv_rwlock_rdlock",
            "uv_rwlock_tryrdlock",
            "uv_rwlock_rdunlock",
            "uv_rwlock_wrlock",
            "uv_rwlock_trywrlock",
            "uv_rwlock_wrunlock",
            "uv_mutex_init",
            "uv_mutex_lock",
            "uv_mutex_trylock",
            "uv_mutex_unlock",
            "uv_sem_init",
            "uv_sem_post",
            "uv_sem_wait",
            "uv_sem_trywait",
            "uv_prepare_init",
            "uv_prepare_start",
            "uv_prepare_stop",
            "uv_check_init",
            "uv_check_start",
            "uv_check_stop",
            "uv_async_init",
            "uv_async_send",
            "uv_fs_open",
            "uv_fs_read",
            "uv_fs_write",
            "uv_fs_close",
            "uv_fs_fsync",
            "uv_fs_fdatasync",
            "uv_fs_ftruncate",
            "uv_fs_mkdir",
            "uv_fs_rmdir",
            "uv_fs_unlink",
            "uv_fs_rename",
            "uv_fs_utime",
            "uv_fs_futime",
            "uv_fs_chmod",
            "uv_fs_fchmod",
            "uv_fs_chown",
            "uv_fs_fchown",
            "uv_fs_link",
            "uv_fs_symlink",
            "uv_fs_readlink",
            "uv_fs_stat",
            "uv_fs_lstat",
            "uv_fs_fstat",
            "uv_fs_readdir",
            "uv_fs_scandir",
            "uv_fs_sendfile",
            "uv_fs_event_init",
            "uv_tty_init",
            "uv_tty_get_winsize",
            "uv_tty_set_mode",
            "uv_tty_reset_mode",
            "uv_loadavg",
            "uv_uptime",
            "uv_cpu_info",
            "uv_interface_addresses",
            "uv_get_free_memory",
            "uv_get_total_memory",
            "uv_hrtime",
            "uv_exepath",
            "uv_cwd",
            "uv_chdir",
            "uv_resident_set_memory",
            "uv_signal_init",
            "uv_signal_start",
            "uv_signal_stop",
        ],
    ),
    (
        "Zend OPcache",
        &[
            "opcache_reset",
            "opcache_get_status",
            "opcache_compile_file",
            "opcache_invalidate",
            "opcache_get_configuration",
            "opcache_is_script_cached",
        ],
    ),
];
