use mago_token::TokenKind;

pub const CAST_TYPES: [(&[u8], TokenKind); 12] = [
    (b"(int)", TokenKind::IntCast),
    (b"(integer)", TokenKind::IntegerCast),
    (b"(double)", TokenKind::DoubleCast),
    (b"(float)", TokenKind::FloatCast),
    (b"(real)", TokenKind::RealCast),
    (b"(bool)", TokenKind::BoolCast),
    (b"(boolean)", TokenKind::BooleanCast),
    (b"(string)", TokenKind::StringCast),
    (b"(binary)", TokenKind::BinaryCast),
    (b"(array)", TokenKind::ArrayCast),
    (b"(object)", TokenKind::ObjectCast),
    (b"(unset)", TokenKind::UnsetCast),
];

pub const KEYWORD_TYPES: [(&[u8], TokenKind); 85] = [
    (b"eval", TokenKind::Eval),
    (b"die", TokenKind::Die),
    (b"empty", TokenKind::Empty),
    (b"isset", TokenKind::Isset),
    (b"unset", TokenKind::Unset),
    (b"exit", TokenKind::Exit),
    (b"enddeclare", TokenKind::EndDeclare),
    (b"endswitch", TokenKind::EndSwitch),
    (b"endwhile", TokenKind::EndWhile),
    (b"endforeach", TokenKind::EndForeach),
    (b"endfor", TokenKind::EndFor),
    (b"endif", TokenKind::EndIf),
    (b"from", TokenKind::From),
    (b"and", TokenKind::And),
    (b"or", TokenKind::Or),
    (b"xor", TokenKind::Xor),
    (b"print", TokenKind::Print),
    (b"readonly", TokenKind::Readonly),
    (b"global", TokenKind::Global),
    (b"match", TokenKind::Match),
    (b"abstract", TokenKind::Abstract),
    (b"array", TokenKind::Array),
    (b"as", TokenKind::As),
    (b"break", TokenKind::Break),
    (b"case", TokenKind::Case),
    (b"catch", TokenKind::Catch),
    (b"callable", TokenKind::Callable),
    (b"class", TokenKind::Class),
    (b"clone", TokenKind::Clone),
    (b"continue", TokenKind::Continue),
    (b"const", TokenKind::Const),
    (b"declare", TokenKind::Declare),
    (b"default", TokenKind::Default),
    (b"do", TokenKind::Do),
    (b"echo", TokenKind::Echo),
    (b"elseif", TokenKind::ElseIf),
    (b"else", TokenKind::Else),
    (b"enum", TokenKind::Enum),
    (b"extends", TokenKind::Extends),
    (b"false", TokenKind::False),
    (b"finally", TokenKind::Finally),
    (b"final", TokenKind::Final),
    (b"fn", TokenKind::Fn),
    (b"foreach", TokenKind::Foreach),
    (b"for", TokenKind::For),
    (b"function", TokenKind::Function),
    (b"goto", TokenKind::Goto),
    (b"if", TokenKind::If),
    (b"include_once", TokenKind::IncludeOnce),
    (b"include", TokenKind::Include),
    (b"implements", TokenKind::Implements),
    (b"interface", TokenKind::Interface),
    (b"instanceof", TokenKind::Instanceof),
    (b"namespace", TokenKind::Namespace),
    (b"new", TokenKind::New),
    (b"null", TokenKind::Null),
    (b"private", TokenKind::Private),
    (b"protected", TokenKind::Protected),
    (b"public", TokenKind::Public),
    (b"require_once", TokenKind::RequireOnce),
    (b"require", TokenKind::Require),
    (b"return", TokenKind::Return),
    (b"static", TokenKind::Static),
    (b"switch", TokenKind::Switch),
    (b"throw", TokenKind::Throw),
    (b"trait", TokenKind::Trait),
    (b"true", TokenKind::True),
    (b"try", TokenKind::Try),
    (b"use", TokenKind::Use),
    (b"var", TokenKind::Var),
    (b"yield", TokenKind::Yield),
    (b"while", TokenKind::While),
    (b"insteadof", TokenKind::Insteadof),
    (b"list", TokenKind::List),
    (b"self", TokenKind::Self_),
    (b"parent", TokenKind::Parent),
    (b"__dir__", TokenKind::DirConstant),
    (b"__file__", TokenKind::FileConstant),
    (b"__line__", TokenKind::LineConstant),
    (b"__function__", TokenKind::FunctionConstant),
    (b"__class__", TokenKind::ClassConstant),
    (b"__method__", TokenKind::MethodConstant),
    (b"__trait__", TokenKind::TraitConstant),
    (b"__namespace__", TokenKind::NamespaceConstant),
    (b"__halt_compiler", TokenKind::HaltCompiler),
];
