# Mago: The Oxidized PHP Toolchain

**Mago** is a comprehensive toolchain for PHP that helps developers write better code. Inspired by the Rust ecosystem, Mago brings convenience, reliability, and an exceptional developer experience to PHP projects of all sizes.

## Disclaimer

> [!WARNING]
> Mago is in an early stage of development. Many features are not yet implemented, and existing functionality may change, break, or stop working without notice.
> While we are not actively promoting or advertising the project, we are working in public to share our progress with the community.

## Features

- Analyze and Lint: Identify issues in your codebase with customizable rules and plugins.
- Automated Fixes: Apply fixes for lint issues to maintain a clean codebase.
- Consistent Formatting: Standardize your code style with powerful formatting tools.
- Semantic Checks: Ensure code correctness with robust semantic analysis.
- AST Visualization: Explore your code’s structure with abstract syntax tree (AST) parsing.

## Get Started

Visit our documentation website to learn how to install, configure, and use Mago effectively:

[Mago Documentation](https://mago.carthage.software/):

- [Getting Started](https://mago.carthage.software/#/getting-started)
- [Installation Guide](https://mago.carthage.software/#/getting-started/installation)
- [Configuration Guide](https://mago.carthage.software/#/getting-started/configuration)
- [CLI Commands](https://mago.carthage.software/#/getting-started/cli)

## Community and Contributions

### How You Can Help

Mago is a community-driven project, and we’d love for you to join us! Here are some ways you can contribute:

- _Suggest Ideas_: Have an idea for Mago? We’re open to suggestions that can make the toolchain even better!
- _Help Write Documentation_: Clear, user-friendly documentation is key to making Mago accessible to everyone. If you enjoy writing or organizing docs, we'd love your help.
- _Contribute Code_: Join us in building Mago! Please discuss any feature or bug fixes in the issues first to ensure we coordinate effectively.
- _Sponsor the Project_: If you’d like to support Mago financially, consider sponsoring [@azjezz](https://github.com/azjezz). Every contribution helps!
- _Help with Art_: Mago could use a logo! We’d appreciate the help of a skilled artist to create an original logo for Mago. (Please note that AI-generated art will not be accepted.)

### Join the Mago Community

Got questions, feedback, or ideas? Join the Mago community on Discord to connect with other developers and stay up-to-date.

[Join Here](https://discord.gg/mwyyjr27eu)

### Inspiration

Mago is inspired by several tools and projects that have significantly contributed to the development community:

- [Clippy](https://github.com/rust-lang/rust-clippy): A collection of lints to catch common mistakes and improve your Rust code.
- [OXC](https://github.com/oxc-project/oxc/): A JavaScript toolchain written in Rust.
- [php-rust-tools/parser](https://github.com/php-rust-tools/parser/): A PHP parser written in Rust, which influenced our parsing approach.
- [slackhq/hakana](https://github.com/slackhq/hakana/): A static analysis tool for HackLang written in Rust, by the creator of [Psalm](https://github.com/vimeo/psalm).

These tools have inspired us and helped shape Mago's design and functionality.

### Acknowledgements

We would like to acknowledge the following PHP tools that have greatly helped hundreds of thousands of PHP developers in their journey,
ourselves included:

- [PHP CS Fixer](https://github.com/PHP-CS-Fixer/PHP-CS-Fixer): A tool to automatically fix PHP Coding Standards issues.
- [Psalm](https://github.com/vimeo/psalm): A static analysis tool for finding errors in PHP applications.
- [PHPStan](https://github.com/phpstan/phpstan): PHP Static Analysis Tool.
- [PHP_CodeSniffer](https://github.com/squizlabs/PHP_CodeSniffer): Detects violations of a defined set of coding standards.

While Mago is intended to be a comprehensive toolchain that may eventually replace some of these tools,
we deeply appreciate their contributions and the foundation they have built for the PHP community.

## License

Mago is licensed under either of

- MIT License (MIT) - see [LICENSE-MIT](./LICENSE-MIT) file for details
- Apache License, Version 2.0 (Apache-2.0) - see [LICENSE-APACHE](./LICENSE-APACHE) file for details

at your option.

## Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in Mago by you shall be dual licensed as above, without any additional terms or conditions.

---

Thank you for your interest in Mago. We look forward to sharing our progress and collaborating with the community as the project evolves.
