<h2>第三方支付（支付宝、微信）</h2>
<p>支付宝、微信支付业务流程：</p>
<p><img src="https://i.imgur.com/ePUjwNH.png" /></p>
<p>支付宝支付开发流程：</p>
<pre><code>1：申请支付宝支付账户
2：如果是集成的支付宝接口，必须还要申请开通支付服务
3：开通服务后，平台会生成2个字符串编码
    1个partnerId(合作伙伴ID),还有1个securityCode(安全码)
4：调用支付宝接口，然后进行跳转（回调函数）
5：付款后,支付宝会自动的去调用前面提供的[notify_url]参数中的url
6：支付宝将付款信息返回系统
7：如果确认收到支付宝发来的客户付款信息，则返回&quot;success&quot;，
      这样子支付宝就知道系统已经收到信息了；否则返回&quot;fail&quot;，
      这样支付宝会过一段时间后再次发来。其实，只有当支付宝收到&quot;success&quot;的
      返回信息后才会停止发送付款信息，否则会自动的每隔一段时间就调用接口
8：根据付款信息，进行自己的业务处理
</code></pre>

<p>json：</p>
<p>微信支付开发流程：</p>
<pre><code>1：开通微信支付账户
2：获取APPID和key
3： appsecret 32位 用于获取access_token
4： APPKEY  128位  用于支付过程中生成app_signature 
5： PartnerKey 微信公众平台模块生成的商户秘钥 
6：获取access_token  调用各接口都使用这个值
7：正常情况下access_token有效期为7200秒，重复获取将导致上次获取的
    access_token失效
8： APP可以使用APPID和APPSecet调用接口来获取Access_token
      (那两个值在开放平台后台获得)注意调用接口时需使用Https协议
9：调用接口http: GET https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&amp;
           appid=APPID&amp;secret=APPSECRET
10：access_toke填写 client_credential 
11：正常情况下返回 {&quot;access_token&quot;:&quot;ACCESS_TOKEN&quot;,&quot;expires_in&quot;:7200} 
      错误情况下返回{&quot;errcode&quot;:40013,&quot;errmsg&quot;:&quot;invalid appid&quot;} 
12：生成待支付订单，用第二步请求的access_token作为参数，
    通过微信开放平台接口生成预支付订单
13：回调函数，业务处理
</code></pre>

<p>Token：</p>
<pre><code>public class Token{

    private String json;
    private Object code;
    private Object msg;

    增加getter和setter方法

}
</code></pre>

<p>测试平台：</p>
<pre><code>沙箱环境：

    1：需要去开发者平台，单独去下载一套测试APP（和正式的支付宝APP，一模一样）（这套APP，目前只支持安卓）
        IOS如何测试？
            做成支付的H5页面，绕过苹果支付
    2：自动提供一个收款人和付款人账户
        收款人：15922222222     0
        付款人：15911111111     99999RMB（虚拟币）
</code></pre>

<p>支付示例代码：</p>
<pre><code>支付核心代码，参考文档《支付宝支付流程核心代码.doc》
微信支付核心代码，参考文档《微信支付流程核心代码.doc》
</code></pre>

<p>开发者平台地址：</p>
<p><a href="https://docs.open.alipay.com/200/105518/">https://docs.open.alipay.com/200/105518/</a></p>
<p>抢购、秒杀、抢红包业务处理：</p>
<pre><code>需求：有3个产品、每个产品1元，商家余额0（余额表）-----最终3元


场景：

    第一个客户抢到：商家余额0-----1元------余额1元
    第二个客户抢到：商家余额1-----1元------余额2元
    第三个客户抢到：商家余额2-----1元------余额3元


并发场景：

    第一个客户抢到：商家余额0-----1元------余额1元
    第二个客户抢到：商家余额0-----1元------余额1元
    第三个客户抢到：商家余额0-----1元------余额1元

解决方案：

    只需要在余额表中，增加一个字段version===0

    第一个客户抢到：商家余额0，version=0-----1元，重新查询version=0------余额1元，version =  1
    第二个客户抢到：商家余额0，version=0-----1元，重新查询version=1------重新查询出余额，然后余额=2元，version=2
    第三个客户抢到：商家余额0，version=0-----1元，重新查询version=2------重新查询出余额，然后余额=3元，version=3
</code></pre>

<p>抢红包：</p>
<pre><code>2元----封装到redis即可

    利用了redis是单进程的性能

        redis在50W并发情况下，读写速度平均为9W/S

            50W*9W/S-----单机
            ----集群

业务：

    2---5个人，金额随机

    1---------2元-----0.2---1.8
    2---------1.8----0.5----1.3
    3---------1.3----1------0.3
    4---------0.3----0.2----0.1
    5---------0.1-----0.1-----0


代码逻辑：

    1：java调用redis
    2：将数字金额以string字符的格式存放到redis中（key，2元）
    3：写一个从1-5之间随机取值的算法
    4：获取随机值，然后从redis中获取金额（0.0-2.0之间随机取值）
    5：是将2减去随机值，然后继续存放到redis中
    循环3,4,5
</code></pre>
