/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.cache.jcache.interceptor.AnnotationJCacheOperationSource;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.cache.jcache.interceptor.KeyGeneratorAdapter;
import org.springframework.cache.jcache.interceptor.SimpleExceptionCacheResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class DefaultJCacheOperationSource
extends AnnotationJCacheOperationSource
implements InitializingBean,
ApplicationContextAware {
    private CacheManager cacheManager;
    private KeyGenerator keyGenerator = new SimpleKeyGenerator();
    private KeyGenerator adaptedKeyGenerator;
    private CacheResolver cacheResolver;
    private CacheResolver exceptionCacheResolver;
    private ApplicationContext applicationContext;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setCacheResolver(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    public CacheResolver getCacheResolver() {
        return this.cacheResolver;
    }

    public void setExceptionCacheResolver(CacheResolver exceptionCacheResolver) {
        this.exceptionCacheResolver = exceptionCacheResolver;
    }

    public CacheResolver getExceptionCacheResolver() {
        return this.exceptionCacheResolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Assert.state((this.cacheResolver != null && this.exceptionCacheResolver != null || this.cacheManager != null ? 1 : 0) != 0, (String)"'cacheManager' is required if cache resolvers are not set.");
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"The application context was not injected as it should.");
        this.adaptedKeyGenerator = new KeyGeneratorAdapter((JCacheOperationSource)this, this.keyGenerator);
        if (this.cacheResolver == null) {
            this.cacheResolver = new SimpleCacheResolver(this.cacheManager);
        }
        if (this.exceptionCacheResolver == null) {
            this.exceptionCacheResolver = new SimpleExceptionCacheResolver(this.cacheManager);
        }
    }

    @Override
    protected <T> T getBean(Class<T> type) {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type);
        if (map.size() == 1) {
            return (T)map.values().iterator().next();
        }
        return (T)BeanUtils.instantiateClass(type);
    }

    @Override
    protected CacheResolver getDefaultCacheResolver() {
        return this.cacheResolver;
    }

    @Override
    protected CacheResolver getDefaultExceptionCacheResolver() {
        return this.exceptionCacheResolver;
    }

    @Override
    protected KeyGenerator getDefaultKeyGenerator() {
        return this.adaptedKeyGenerator;
    }
}

