/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class ServletUriComponentsBuilder
extends UriComponentsBuilder {
    private String originalPath;

    protected ServletUriComponentsBuilder() {
    }

    protected ServletUriComponentsBuilder(ServletUriComponentsBuilder other) {
        super((UriComponentsBuilder)other);
        this.originalPath = other.originalPath;
    }

    public static ServletUriComponentsBuilder fromContextPath(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.initFromRequest(request);
        builder.replacePath(ServletUriComponentsBuilder.prependForwardedPrefix(request, request.getContextPath()));
        return builder;
    }

    public static ServletUriComponentsBuilder fromServletMapping(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromContextPath(request);
        if (StringUtils.hasText((String)new UrlPathHelper().getPathWithinServletMapping(request))) {
            builder.path(request.getServletPath());
        }
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequestUri(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.initFromRequest(request);
        builder.initPath(ServletUriComponentsBuilder.prependForwardedPrefix(request, request.getRequestURI()));
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequest(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.initFromRequest(request);
        builder.initPath(ServletUriComponentsBuilder.prependForwardedPrefix(request, request.getRequestURI()));
        builder.query(request.getQueryString());
        return builder;
    }

    private static ServletUriComponentsBuilder initFromRequest(HttpServletRequest request) {
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest((HttpRequest)httpRequest).build();
        String scheme = uriComponents.getScheme();
        String host = uriComponents.getHost();
        int port = uriComponents.getPort();
        ServletUriComponentsBuilder builder = new ServletUriComponentsBuilder();
        builder.scheme(scheme);
        builder.host(host);
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            builder.port(port);
        }
        return builder;
    }

    private static String prependForwardedPrefix(HttpServletRequest request, String path) {
        String prefix = request.getHeader("X-Forwarded-Prefix");
        if (StringUtils.hasText((String)prefix)) {
            path = prefix + path;
        }
        return path;
    }

    public static ServletUriComponentsBuilder fromCurrentContextPath() {
        return ServletUriComponentsBuilder.fromContextPath(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentServletMapping() {
        return ServletUriComponentsBuilder.fromServletMapping(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequestUri() {
        return ServletUriComponentsBuilder.fromRequestUri(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequest() {
        return ServletUriComponentsBuilder.fromRequest(ServletUriComponentsBuilder.getCurrentRequest());
    }

    protected static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((requestAttributes != null ? 1 : 0) != 0, (String)"Could not find current request via RequestContextHolder");
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)requestAttributes);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"Could not find current HttpServletRequest");
        return servletRequest;
    }

    private void initPath(String path) {
        this.originalPath = path;
        this.replacePath(path);
    }

    public String removePathExtension() {
        String extension = null;
        if (this.originalPath != null) {
            String filename = WebUtils.extractFullFilenameFromUrlPath((String)this.originalPath);
            extension = StringUtils.getFilenameExtension((String)filename);
            if (!StringUtils.isEmpty((Object)extension)) {
                int end = this.originalPath.length() - (extension.length() + 1);
                this.replacePath(this.originalPath.substring(0, end));
            }
            this.originalPath = null;
        }
        return extension;
    }

    protected Object clone() {
        return new ServletUriComponentsBuilder(this);
    }
}

