/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.parser.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.SqlUtil;
import com.github.pagehelper.parser.SqlServer;
import com.github.pagehelper.parser.impl.AbstractParser;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;

public class SqlServerParser
extends AbstractParser {
    private static final SqlServer pageSql = new SqlServer();
    protected static final String WITHNOLOCK = ", PAGEWITHNOLOCK";

    @Override
    public String getCountSql(String sql) {
        sql = sql.replaceAll("((?i)with\\s*\\(nolock\\))", WITHNOLOCK);
        sql = super.getCountSql(sql);
        sql = sql.replace(WITHNOLOCK, " with(nolock)");
        return sql;
    }

    @Override
    public boolean isSupportedMappedStatementCache() {
        return false;
    }

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        return boundSql.getParameterMappings();
    }

    @Override
    public String getPageSql(String sql) {
        Page page = SqlUtil.getLocalPage();
        sql = sql.replaceAll("((?i)with\\s*\\(nolock\\))", WITHNOLOCK);
        sql = pageSql.convertToPageSql(sql, page.getStartRow(), page.getPageSize());
        sql = sql.replace(WITHNOLOCK, " with(nolock)");
        return sql;
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        return super.setPageParameter(ms, parameterObject, boundSql, page);
    }
}

