/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValueGen;

public class ElementNameValuePairGen {
    private int nameIdx;
    private ElementValueGen value;
    private ConstantPool cpool;

    public ElementNameValuePairGen(ElementNameValuePairGen nvp, ConstantPool cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        this.nameIdx = copyPoolEntries ? cpool.addUtf8(nvp.getNameString()) : nvp.getNameIndex();
        this.value = ElementValueGen.copy(nvp.getValue(), cpool, copyPoolEntries);
    }

    protected ElementNameValuePairGen(int idx, ElementValueGen value, ConstantPool cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.cpool = cpool;
    }

    public ElementNameValuePairGen(String name, ElementValueGen value, ConstantPool cpool) {
        this.nameIdx = cpool.addUtf8(name);
        this.value = value;
        this.cpool = cpool;
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.nameIdx);
        this.value.dump(dos);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        return ((ConstantUtf8)this.cpool.getConstant(this.nameIdx)).getBytes();
    }

    public final ElementValueGen getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getNameString()) + "=" + this.value.stringifyValue());
        return sb.toString();
    }
}

