/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    public int handle;
    Tree parent;
    String[] strings;
    Image[] images;
    Font font;
    Font[] cellFont;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int[] cellBackground;
    int[] cellForeground;

    public TreeItem(Tree tree, int n) {
        this(tree, n, 0, -65534, 0);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(tree, n, 0, TreeItem.findPrevious(tree, n2), 0);
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, n, treeItem.handle, -65534, 0);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, n, treeItem.handle, TreeItem.findPrevious(treeItem, n2), 0);
    }

    TreeItem(Tree tree, int n, int n2, int n3, int n4) {
        super(tree, n);
        this.parent = tree;
        tree.createItem(this, n2, n3, n4);
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static int findPrevious(Tree tree, int n) {
        if (tree == null) {
            return 0;
        }
        if (n < 0) {
            SWT.error(6);
        }
        if (n == 0) {
            return -65535;
        }
        int n2 = tree.handle;
        int n3 = OS.SendMessage(n2, 4362, 0, 0);
        int n4 = tree.findItem(n3, n - 1);
        if (n4 == 0) {
            SWT.error(6);
        }
        return n4;
    }

    static int findPrevious(TreeItem treeItem, int n) {
        if (treeItem == null) {
            return 0;
        }
        if (n < 0) {
            SWT.error(6);
        }
        if (n == 0) {
            return -65535;
        }
        Tree tree = treeItem.parent;
        int n2 = tree.handle;
        int n3 = treeItem.handle;
        int n4 = OS.SendMessage(n2, 4362, 4, n3);
        int n5 = tree.findItem(n4, n - 1);
        if (n5 == 0) {
            SWT.error(6);
        }
        return n5;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        if ((this.parent.style & 0x20) != 0) {
            int n = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 24;
            tVITEM.stateMask = 61440;
            tVITEM.state = 4096;
            tVITEM.hItem = this.handle;
            OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
        }
        this.foreground = -1;
        this.background = -1;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 4362, 4, this.handle);
        if (n3 == 0) {
            this.error(6);
        }
        if ((n3 = this.parent.findItem(n3, n)) == 0) {
            this.error(6);
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.clear(n3, tVITEM);
        if (bl) {
            n3 = OS.SendMessage(n2, 4362, 4, n3);
            this.parent.clearAll(n3, tVITEM, bl);
        }
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 4362, 4, this.handle);
        if (n2 == 0) {
            return;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.clearAll(n2, tVITEM, bl);
    }

    void destroyWidget() {
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.releaseItem(this.handle, tVITEM, false);
        this.parent.destroyItem(this, this.handle);
        this.releaseHandle();
    }

    int fontHandle(int n) {
        if (this.cellFont != null && this.cellFont[n] != null) {
            return this.cellFont[n].handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return -1;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background == -1) {
            return this.parent.getBackground();
        }
        return Color.win32_new(this.display, this.background);
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getBackground();
        }
        int n3 = this.cellBackground != null ? this.cellBackground[n] : -1;
        return n3 == -1 ? this.getBackground() : Color.win32_new(this.display, n3);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(0, true, false, false);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n, true, true, true);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    RECT getBounds(int n, boolean bl, boolean bl2, boolean bl3) {
        return this.getBounds(n, bl, bl2, bl3, false, true, 0);
    }

    RECT getBounds(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) {
        int n3;
        if (!bl && !bl2) {
            return new RECT();
        }
        int n4 = this.parent.handle;
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1;
            this.parent.ignoreCustomDraw = true;
            OS.SendMessage(n4, OS.TVM_SETITEM, 0, tVITEM);
            this.parent.ignoreCustomDraw = false;
        }
        boolean bl6 = n == 0;
        int n5 = 0;
        int n6 = this.parent.hwndHeader;
        if (n6 != 0) {
            n5 = OS.SendMessage(n6, 4608, 0, 0);
            bl6 = n == OS.SendMessage(n6, 4623, 0, 0);
        }
        RECT rECT = new RECT();
        if (bl6) {
            Object object;
            n3 = n5 == 0 && bl && bl2 && bl3 && bl4 ? 1 : 0;
            if (!OS.TreeView_GetItemRect(n4, this.handle, rECT, n3 == 0)) {
                return new RECT();
            }
            if (bl2 && !bl4) {
                if (OS.SendMessage(n4, 4360, 0, 0) != 0) {
                    object = this.parent.getImageSize();
                    rECT.left -= ((Point)object).x + 3;
                    if (!bl) {
                        rECT.right = rECT.left + ((Point)object).x;
                    }
                } else if (!bl) {
                    rECT.right = rECT.left;
                }
            }
            if ((bl3 || bl4 || bl5) && n6 != 0) {
                object = new RECT();
                if (n5 != 0) {
                    if (OS.SendMessage(n6, 4615, n, (RECT)object) == 0) {
                        return new RECT();
                    }
                } else {
                    ((RECT)object).right = this.parent.scrollWidth;
                    if (((RECT)object).right == 0) {
                        object = rECT;
                    }
                }
                if (bl3 && bl5) {
                    rECT.right = ((RECT)object).right;
                }
                if (bl4) {
                    rECT.left = ((RECT)object).left;
                }
                if (bl5 && ((RECT)object).right < rECT.right) {
                    rECT.right = ((RECT)object).right;
                }
            }
        } else {
            if (n < 0 || n >= n5) {
                return new RECT();
            }
            RECT rECT2 = new RECT();
            if (OS.SendMessage(n6, 4615, n, rECT2) == 0) {
                return new RECT();
            }
            if (!OS.TreeView_GetItemRect(n4, this.handle, rECT, false)) {
                return new RECT();
            }
            rECT.left = rECT2.left;
            if (bl3 && bl2 && bl5) {
                rECT.right = rECT2.right;
            } else {
                Object object;
                rECT.right = rECT2.left;
                Image image = null;
                if (n == 0) {
                    image = this.image;
                } else if (this.images != null) {
                    image = this.images[n];
                }
                if (image != null) {
                    object = this.parent.getImageSize();
                    rECT.right += ((Point)object).x;
                }
                if (bl) {
                    if (bl3 && bl5) {
                        rECT.left = rECT.right + 3;
                        rECT.right = rECT2.right;
                    } else {
                        Object object2 = n == 0 ? this.text : (object = this.strings != null ? this.strings[n] : null);
                        if (object != null) {
                            RECT rECT3 = new RECT();
                            TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), (String)object, false);
                            int n7 = 3104;
                            int n8 = n2;
                            int n9 = 0;
                            if (n2 == 0) {
                                n8 = OS.GetDC(n4);
                                n9 = this.fontHandle(n);
                                if (n9 == -1) {
                                    n9 = OS.SendMessage(n4, 49, 0, 0);
                                }
                                n9 = OS.SelectObject(n8, n9);
                            }
                            OS.DrawText(n8, tCHAR, tCHAR.length(), rECT3, n7);
                            if (n2 == 0) {
                                OS.SelectObject(n8, n9);
                                OS.ReleaseDC(n4, n8);
                            }
                            if (bl2) {
                                rECT.right += rECT3.right - rECT3.left + 9;
                            } else {
                                rECT.left = rECT.right + 3;
                                rECT.right = rECT.left + (rECT3.right - rECT3.left) + 3;
                            }
                        }
                    }
                }
                if (bl5 && rECT2.right < rECT.right) {
                    rECT.right = rECT2.right;
                }
            }
        }
        int n10 = n3 = this.parent.linesVisible && n5 != 0 ? 1 : 0;
        if (bl || !bl2) {
            rECT.right = Math.max(rECT.left, rECT.right - n3);
        }
        rECT.bottom = Math.max(rECT.top, rECT.bottom - n3);
        return rECT;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        int n2 = OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        return n2 != 0 && (tVITEM.state >> 12 & 1) == 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = 0;
        if (OS.IsWinCE) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = this.handle;
            tVITEM.mask = 8;
            OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
            n2 = tVITEM.state;
        } else {
            n2 = OS.SendMessage(n, 4391, this.handle, 32);
        }
        return (n2 & 0x20) != 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground == -1) {
            return this.parent.getForeground();
        }
        return Color.win32_new(this.display, this.foreground);
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getForeground();
        }
        int n3 = this.cellForeground != null ? this.cellForeground[n] : -1;
        return n3 == -1 ? this.getForeground() : Color.win32_new(this.display, n3);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        int n2 = OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        return n2 != 0 && tVITEM.state >> 12 > 2;
    }

    public TreeItem getItem(int n) {
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n4 = OS.SendMessage(n3 = this.parent.handle, 4362, 4, this.handle)) == 0) {
            this.error(6);
        }
        if ((n2 = this.parent.findItem(n4, n)) == 0) {
            this.error(6);
        }
        return this.parent._getItem(n2);
    }

    public int getItemCount() {
        int n;
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = OS.SendMessage(n = this.parent.handle, 4362, 4, this.handle)) == 0) {
            return 0;
        }
        return this.parent.getItemCount(n2);
    }

    public TreeItem[] getItems() {
        int n;
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = OS.SendMessage(n = this.parent.handle, 4362, 4, this.handle)) == 0) {
            return new TreeItem[0];
        }
        return this.parent.getItems(n2);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getImage();
        }
        if (this.images != null && n >= 0 && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n, false, true, false);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 4362, 3, this.handle);
        return n2 != 0 ? this.parent._getItem(n2) : null;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getText();
        }
        if (this.strings != null && n >= 0 && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n, true, false, true);
        if (n == 0) {
            rECT.left += 2;
        }
        rECT.left = Math.min(rECT.left, rECT.right);
        rECT.right -= 3;
        int n2 = Math.max(0, rECT.right - rECT.left);
        int n3 = Math.max(0, rECT.bottom - rECT.top);
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public int indexOf(TreeItem treeItem) {
        int n;
        int n2;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        return (n2 = OS.SendMessage(n = this.parent.handle, 4362, 4, this.handle)) == 0 ? -1 : this.parent.findIndex(n2, treeItem.handle);
    }

    void redraw() {
        RECT rECT;
        boolean bl;
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n = this.parent.handle;
        if (!OS.IsWindowVisible(n)) {
            return;
        }
        boolean bl2 = bl = (this.parent.style & 0x10010000) != 0;
        if (!bl) {
            int n2 = this.parent.hwndHeader;
            if (n2 != 0) {
                boolean bl3 = bl = OS.SendMessage(n2, 4608, 0, 0) != 0;
            }
            if (!bl && (this.parent.hooks(40) || this.parent.hooks(42))) {
                bl = true;
            }
        }
        if (OS.TreeView_GetItemRect(n, this.handle, rECT = new RECT(), !bl)) {
            OS.InvalidateRect(n, rECT, true);
        }
    }

    void redraw(int n, boolean bl, boolean bl2) {
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (!OS.IsWindowVisible(n2)) {
            return;
        }
        boolean bl3 = n == 0 && bl && bl2;
        RECT rECT = this.getBounds(n, bl, bl2, true, bl3, true, 0);
        OS.InvalidateRect(n2, rECT, true);
    }

    void releaseChildren(boolean bl) {
        if (bl) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 20;
            this.parent.releaseItems(this.handle, tVITEM);
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        tVITEM.hItem = OS.SendMessage(n, 4362, 4, this.handle);
        while (tVITEM.hItem != 0) {
            TreeItem treeItem;
            OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
            TreeItem treeItem2 = treeItem = tVITEM.lParam != -1 ? this.parent.items[tVITEM.lParam] : null;
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.dispose();
            } else {
                this.parent.releaseItem(tVITEM.hItem, tVITEM, false);
                this.parent.destroyItem(null, tVITEM.hItem);
            }
            tVITEM.hItem = OS.SendMessage(n, 4362, 4, this.handle);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.background == n) {
            return;
        }
        this.background = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n3 = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellBackground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellBackground[n] == n3) {
            return;
        }
        this.cellBackground[n] = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n, true, true);
    }

    public void setChecked(boolean bl) {
        RECT rECT;
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        int n2 = tVITEM.state >> 12;
        if (bl) {
            if ((n2 & 1) != 0) {
                ++n2;
            }
        } else if ((n2 & 1) == 0) {
            --n2;
        }
        if (tVITEM.state == (n2 <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tVITEM.state = n2;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(n) && OS.TreeView_GetItemRect(n, this.handle, rECT = new RECT(), false)) {
            OS.InvalidateRect(n, rECT, true);
        }
    }

    public void setExpanded(boolean bl) {
        Object object;
        int n;
        int n2;
        int n3;
        Object object2;
        this.checkWidget();
        int n4 = this.parent.handle;
        if (OS.SendMessage(n4, 4362, 4, this.handle) == 0) {
            return;
        }
        int n5 = 0;
        if (OS.IsWinCE) {
            object2 = new TVITEM();
            ((TVITEM)object2).hItem = this.handle;
            ((TVITEM)object2).mask = 8;
            OS.SendMessage(n4, OS.TVM_GETITEM, 0, (TVITEM)object2);
            n5 = ((TVITEM)object2).state;
        } else {
            n5 = OS.SendMessage(n4, 4391, this.handle, 32);
        }
        if ((n5 & 0x20) != 0 == bl) {
            return;
        }
        object2 = null;
        RECT[] rECTArray = null;
        SCROLLINFO sCROLLINFO = null;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        int n8 = OS.SendMessage(n4, 4362, 5, 0);
        if (bl3 && n8 != 0) {
            sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 23;
            if (!OS.GetScrollInfo(n4, 0, sCROLLINFO)) {
                sCROLLINFO = null;
            }
            if (this.parent.drawCount == 0 && OS.IsWindowVisible(n4)) {
                n3 = 1;
                n6 = OS.SendMessage(n4, 4368, 0, 0);
                rECTArray = new RECT[n6 + 1];
                n2 = n8;
                n = 0;
                while (n2 != 0 && (n3 != 0 || n2 != this.handle) && n < n6) {
                    object = new RECT();
                    if (OS.TreeView_GetItemRect(n4, n2, (RECT)object, true)) {
                        rECTArray[n++] = object;
                    }
                    n2 = OS.SendMessage(n4, 4362, 6, n2);
                }
                if (n3 != 0 || n2 != this.handle) {
                    bl2 = true;
                    n6 = n;
                    n7 = n2;
                    object2 = new RECT();
                    OS.GetClientRect(n4, (RECT)object2);
                    int n9 = this.parent.topHandle();
                    OS.UpdateWindow(n9);
                    OS.DefWindowProc(n9, 11, 0, 0);
                    if (n4 != n9) {
                        OS.UpdateWindow(n4);
                        OS.DefWindowProc(n4, 11, 0, 0);
                    }
                }
            }
        }
        n3 = OS.SendMessage(n4, 4362, 9, 0);
        this.parent.ignoreExpand = true;
        OS.SendMessage(n4, 4354, bl ? 2 : 1, this.handle);
        this.parent.ignoreExpand = false;
        if (bl3 && n8 != 0) {
            int n10;
            n2 = 0;
            if (!bl) {
                RECT rECT = new RECT();
                while (n8 != 0 && !OS.TreeView_GetItemRect(n4, n8, rECT, false)) {
                    n8 = OS.SendMessage(n4, 4362, 3, n8);
                    n2 = 1;
                }
            }
            n = 1;
            if (n8 != 0) {
                OS.SendMessage(n4, 4363, 5, n8);
                int n11 = n = n8 != OS.SendMessage(n4, 4362, 5, 0) ? 1 : 0;
            }
            if (n2 == 0 && n == 0 && sCROLLINFO != null) {
                object = new SCROLLINFO();
                ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
                ((SCROLLINFO)object).fMask = 23;
                if (OS.GetScrollInfo(n4, 0, (SCROLLINFO)object) && sCROLLINFO.nPos != ((SCROLLINFO)object).nPos) {
                    n10 = OS.MAKELPARAM(4, sCROLLINFO.nPos);
                    OS.SendMessage(n4, 276, n10, 0);
                }
            }
            if (bl2) {
                int n12;
                boolean bl4 = false;
                if (n2 == 0 && n == 0) {
                    RECT rECT = new RECT();
                    OS.GetClientRect(n4, rECT);
                    if (OS.EqualRect((RECT)object2, rECT)) {
                        n12 = n8;
                        int n13 = 0;
                        while (n12 != 0 && n13 < n6) {
                            RECT rECT2 = new RECT();
                            if (OS.TreeView_GetItemRect(n4, n12, rECT2, true) && !OS.EqualRect(rECT2, rECTArray[n13])) break;
                            n12 = OS.SendMessage(n4, 4362, 6, n12);
                            ++n13;
                        }
                        bl4 = n13 == n6 && n12 == n7;
                    }
                }
                n10 = this.parent.topHandle();
                OS.DefWindowProc(n10, 11, 1, 0);
                if (n4 != n10) {
                    OS.DefWindowProc(n4, 11, 1, 0);
                }
                if (bl4) {
                    RECT rECT;
                    this.parent.updateScrollBar();
                    SCROLLINFO sCROLLINFO2 = new SCROLLINFO();
                    sCROLLINFO2.cbSize = SCROLLINFO.sizeof;
                    sCROLLINFO2.fMask = 23;
                    if (OS.GetScrollInfo(n4, 1, sCROLLINFO2)) {
                        OS.SetScrollInfo(n4, 1, sCROLLINFO2, true);
                    }
                    if (this.handle == n7 && OS.TreeView_GetItemRect(n4, n7, rECT = new RECT(), false)) {
                        OS.InvalidateRect(n4, rECT, true);
                    }
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(n10, null, true);
                    if (n4 != n10) {
                        OS.InvalidateRect(n4, null, true);
                    }
                } else {
                    n12 = 1157;
                    OS.RedrawWindow(n10, null, 0, n12);
                }
            }
        }
        if ((n2 = OS.SendMessage(n4, 4362, 9, 0)) != n3) {
            Event event = new Event();
            if (n2 != 0) {
                event.item = this.parent._getItem(n2);
                this.parent.hAnchor = n2;
            }
            this.parent.sendEvent(13, event);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        if (font != null) {
            this.parent.customDraw = true;
        }
        this.font = font;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            return;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 17;
        tVITEM.hItem = this.handle;
        tVITEM.pszText = -1;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
    }

    public void setFont(int n, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            this.cellFont = new Font[n2];
        }
        if (this.cellFont[n] == font) {
            return;
        }
        if (this.cellFont[n] != null && this.cellFont[n].equals(font)) {
            return;
        }
        this.cellFont[n] = font;
        if (font != null) {
            this.parent.customDraw = true;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            int n3 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1;
            OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
        } else {
            this.redraw(n, true, false);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n3 = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellForeground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellForeground[n] == n3) {
            return;
        }
        this.cellForeground[n] = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n, true, false);
    }

    public void setGrayed(boolean bl) {
        RECT rECT;
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        int n2 = tVITEM.state >> 12;
        if (bl) {
            if (n2 <= 2) {
                n2 += 2;
            }
        } else if (n2 > 2) {
            n2 -= 2;
        }
        if (tVITEM.state == (n2 <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tVITEM.state = n2;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(n) && OS.TreeView_GetItemRect(n, this.handle, rECT = new RECT(), false)) {
            OS.InvalidateRect(n, rECT, true);
        }
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        Image image2 = null;
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            image2 = this.image;
            super.setImage(image);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.images == null && n != 0) {
            this.images = new Image[n2];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            image2 = this.images[n];
            this.images[n] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.imageIndex(image, n);
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            int n3 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 50;
            tVITEM.hItem = this.handle;
            tVITEM.iSelectedImage = -1;
            tVITEM.iImage = -1;
            tVITEM.mask |= 1;
            tVITEM.pszText = -1;
            OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
        } else {
            boolean bl = image == null && image2 != null || image != null && image2 == null;
            this.redraw(n, bl, true);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 4362, 4, this.handle);
        this.parent.setItemCount(n, this.handle, n3);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.strings == null && n != 0) {
            this.strings = new String[n2];
            this.strings[0] = this.text;
        }
        if (this.strings != null) {
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            int n3 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1;
            OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
        } else {
            this.redraw(n, true, false);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void sort() {
        this.checkWidget();
        if ((this.parent.style & 0x10000000) != 0) {
            return;
        }
        this.parent.sort(this.handle, false);
    }
}

