/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMUPDOWN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.UDACCEL;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int hwndText;
    int hwndUpDown;
    boolean ignoreModify;
    int pageIncrement;
    int digits;
    static final int EditProc;
    static final TCHAR EditClass;
    static final int UpDownProc;
    static final TCHAR UpDownClass;

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        UpDownClass = new TCHAR(0, "msctls_updown32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, EditClass, wNDCLASS);
        EditProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo(0, UpDownClass, wNDCLASS);
        UpDownProc = wNDCLASS.lpfnWndProc;
    }

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n == this.hwndText) {
            return OS.CallWindowProc(EditProc, n, n2, n3, n4);
        }
        if (n == this.hwndUpDown) {
            return OS.CallWindowProc(UpDownProc, n, n2, n3, n4);
        }
        return OS.DefWindowProc(this.handle, n2, n3, n4);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    boolean checkHandle(int n) {
        return n == this.handle || n == this.hwndText || n == this.hwndUpDown;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        int n = OS.GetModuleHandle(null);
        int n2 = (this.style & 0x800) != 0 ? 512 : 0;
        int n3 = 1409286272;
        if ((this.style & 8) != 0) {
            n3 |= 0x800;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            n2 |= 0x400000;
        }
        this.hwndText = OS.CreateWindowEx(n2, EditClass, null, n3, 0, 0, 0, 0, this.handle, 0, n, null);
        if (this.hwndText == 0) {
            this.error(2);
        }
        OS.SetWindowLongPtr(this.hwndText, -12, this.hwndText);
        int n4 = 0x50000010;
        if ((this.style & 0x40) != 0) {
            n4 |= 1;
        }
        if ((this.style & 0x800) != 0) {
            n4 = (this.style & 0x4000000) != 0 ? (n4 |= 8) : (n4 |= 4);
        }
        this.hwndUpDown = OS.CreateWindowEx(0, UpDownClass, null, n4, 0, 0, 0, 0, this.handle, 0, n, null);
        if (this.hwndUpDown == 0) {
            this.error(2);
        }
        int n5 = 19;
        this.SetWindowPos(this.hwndText, this.hwndUpDown, 0, 0, 0, 0, n5);
        OS.SetWindowLongPtr(this.hwndUpDown, -12, this.hwndUpDown);
        if (OS.IsDBLocale) {
            int n6 = OS.ImmGetContext(this.handle);
            OS.ImmAssociateContext(this.hwndText, n6);
            OS.ImmAssociateContext(this.hwndUpDown, n6);
            OS.ImmReleaseContext(this.handle, n6);
        }
        OS.SendMessage(this.hwndUpDown, 1135, 0, 100);
        OS.SendMessage(this.hwndUpDown, OS.IsWinCE ? 1127 : 1137, 0, 0);
        this.pageIncrement = 10;
        this.digits = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), "0", true);
        OS.SetWindowText(this.hwndText, tCHAR);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    int borderHandle() {
        return this.hwndText;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n == -1 || n2 == -1) {
            int n6;
            Object object;
            n3 = 0;
            int n7 = OS.GetDC(this.hwndText);
            int n8 = OS.SendMessage(this.hwndText, 49, 0, 0);
            if (n8 != 0) {
                n3 = OS.SelectObject(n7, n8);
            }
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n7, tEXTMETRIC);
            n5 = tEXTMETRIC.tmHeight;
            RECT rECT = new RECT();
            int[] nArray = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
            String string = String.valueOf(nArray[0]);
            if (this.digits > 0) {
                object = new StringBuffer();
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append(this.getDecimalSeparator());
                n6 = this.digits - string.length();
                while (n6 >= 0) {
                    ((StringBuffer)object).append("0");
                    --n6;
                }
                string = ((StringBuffer)object).toString();
            }
            object = new TCHAR(this.getCodePage(), string, false);
            n6 = 11264;
            OS.DrawText(n7, (TCHAR)object, ((TCHAR)object).length(), rECT, n6);
            n4 = rECT.right - rECT.left;
            if (n8 != 0) {
                OS.SelectObject(n7, n3);
            }
            OS.ReleaseDC(this.hwndText, n7);
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n5);
        if (n2 == -1) {
            n3 = OS.GetSystemMetrics(20) + 2 * this.getBorderWidth();
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                n3 += (this.style & 0x800) != 0 ? 1 : 3;
            }
            rectangle.height = Math.max(rectangle.height, n3);
        }
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = OS.GetWindowLong(this.hwndText, -16);
        int n6 = OS.GetWindowLong(this.hwndText, -20);
        OS.AdjustWindowRectEx(rECT, n5, false, n6);
        n3 = rECT.right - rECT.left;
        n4 = rECT.bottom - rECT.top;
        int n7 = OS.SendMessage(this.hwndText, 212, 0, 0);
        n -= OS.LOWORD(n7);
        n3 += OS.LOWORD(n7) + OS.HIWORD(n7);
        if ((this.style & 0x800) != 0) {
            --n;
            --n2;
            n3 += 2;
            n4 += 2;
        }
        return new Rectangle(n, n2, n3 += OS.GetSystemMetrics(2), n4);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.hwndText, 769, 0, 0);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.hwndText, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        OS.EnableWindow(this.hwndText, bl);
        OS.EnableWindow(this.hwndUpDown, bl);
    }

    void deregister() {
        super.deregister();
        this.display.removeControl(this.hwndText);
        this.display.removeControl(this.hwndUpDown);
    }

    boolean hasFocus() {
        int n = OS.GetFocus();
        if (n == this.handle) {
            return true;
        }
        if (n == this.hwndText) {
            return true;
        }
        return n == this.hwndUpDown;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    String getDecimalSeparator() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n = OS.GetLocaleInfo(1024, 14, tCHAR, 4);
        return n != 0 ? tCHAR.toString(0, n - 1) : ".";
    }

    public int getIncrement() {
        this.checkWidget();
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage(this.hwndUpDown, 1132, 1, uDACCEL);
        return uDACCEL.nInc;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
        return nArray[0];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray, null);
        return nArray[0];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0));
        }
        return OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
    }

    int getSelectionText() {
        int n = OS.GetWindowTextLength(this.hwndText);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.hwndText, tCHAR, n + 1);
        String string = tCHAR.toString(0, n);
        try {
            int n2;
            Object object;
            if (this.digits > 0) {
                object = this.getDecimalSeparator();
                int n3 = string.indexOf((String)object);
                if (n3 != -1) {
                    int n4;
                    int n5;
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3 + 1);
                    if (string3.length() > this.digits) {
                        string3 = string3.substring(0, this.digits);
                    } else {
                        n5 = this.digits - string3.length();
                        n4 = 0;
                        while (n4 < n5) {
                            string3 = String.valueOf(string3) + "0";
                            ++n4;
                        }
                    }
                    n5 = Integer.parseInt(string2);
                    n4 = Integer.parseInt(string3);
                    int n6 = 0;
                    while (n6 < this.digits) {
                        n5 *= 10;
                        ++n6;
                    }
                    n2 = n5 + n4;
                } else {
                    n2 = Integer.parseInt(string);
                }
            } else {
                n2 = Integer.parseInt(string);
            }
            object = new int[1];
            int[] nArray = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, nArray, (int[])object);
            if (nArray[0] <= n2 && n2 <= object[0]) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA(this.hwndText);
        if (n2 == 0) {
            return 0;
        }
        if (n >= n2) {
            return n2;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA(this.hwndText, byArray, n2 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.hwndText, 770, 0, 0);
    }

    void register() {
        super.register();
        this.display.addControl(this.hwndText, this);
        this.display.addControl(this.hwndUpDown, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndUpDown = 0;
        this.hwndText = 0;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, n3, n4, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        char c = event.character;
        int n5 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n5 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.hwndText, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(this.hwndText, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(this.hwndText, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n6 = OS.GetWindowTextLength(this.hwndText);
                if (nArray[0] == n6) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(this.hwndText, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(this.hwndText, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n6);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(this.hwndText, 177, nArray[0], nArray2[0]);
        OS.SendMessage(this.hwndText, 194, 0, (TCHAR)object);
        return false;
    }

    void setBackgroundImage(int n) {
        super.setBackgroundImage(n);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    public void setDigits(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == this.digits) {
            return;
        }
        this.digits = n;
        int n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0)) : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
        this.setSelection(n2, false, true, false);
    }

    void setForegroundPixel(int n) {
        super.setForegroundPixel(n);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.GetProcessHeap();
        int n3 = OS.SendMessage(this.hwndUpDown, 1132, 0, null);
        int n4 = OS.HeapAlloc(n2, 8, UDACCEL.sizeof * n3);
        OS.SendMessage(this.hwndUpDown, 1132, n3, n4);
        int n5 = -1;
        UDACCEL uDACCEL = new UDACCEL();
        int n6 = 0;
        while (n6 < n3) {
            int n7 = n4 + n6 * UDACCEL.sizeof;
            OS.MoveMemory(uDACCEL, n7, UDACCEL.sizeof);
            if (n5 == -1) {
                n5 = uDACCEL.nInc;
            }
            uDACCEL.nInc = uDACCEL.nInc * n / n5;
            OS.MoveMemory(n7, uDACCEL, UDACCEL.sizeof);
            ++n6;
        }
        OS.SendMessage(this.hwndUpDown, 1131, n3, n4);
        OS.HeapFree(n2, 0, n4);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray, null);
        if (n <= nArray[0]) {
            return;
        }
        int n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0)) : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
        OS.SendMessage(this.hwndUpDown, 1135, nArray[0], n);
        if (n2 > n) {
            this.setSelection(n, true, true, false);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
        if (n >= nArray[0]) {
            return;
        }
        int n2 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0)) : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
        OS.SendMessage(this.hwndUpDown, 1135, n, nArray[0]);
        if (n2 < n) {
            this.setSelection(n, true, true, false);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
        n = Math.min(Math.max(nArray2[0], n), nArray[0]);
        this.setSelection(n, true, true, false);
    }

    void setSelection(int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            OS.SendMessage(this.hwndUpDown, OS.IsWinCE ? 1127 : 1137, 0, n);
        }
        if (bl2) {
            int n2;
            Object object;
            String string = String.valueOf(n);
            if (this.digits > 0) {
                object = this.getDecimalSeparator();
                int n3 = string.length() - this.digits;
                StringBuffer stringBuffer = new StringBuffer();
                if (n3 > 0) {
                    stringBuffer.append(string.substring(0, n3));
                    stringBuffer.append((String)object);
                    stringBuffer.append(string.substring(n3));
                } else {
                    stringBuffer.append("0");
                    stringBuffer.append((String)object);
                    while (n3++ < 0) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                string = stringBuffer.toString();
            }
            if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n2 = OS.GetWindowTextLength(this.hwndText), null)) == null) {
                return;
            }
            object = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.hwndText, (TCHAR)object);
        }
        if (bl3) {
            this.postEvent(13);
        }
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.hwndText, string);
        shell.setToolTipText(this.hwndUpDown, string);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 <= n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        this.setIncrement(n5);
        this.pageIncrement = n6;
        this.digits = n4;
        OS.SendMessage(this.hwndUpDown, 1135, n2, n3);
        this.setSelection(n, true, true, false);
    }

    void subclass() {
        super.subclass();
        int n = this.display.windowProc;
        OS.SetWindowLongPtr(this.hwndText, -4, n);
        OS.SetWindowLongPtr(this.hwndUpDown, -4, n);
    }

    void unsubclass() {
        super.unsubclass();
        OS.SetWindowLongPtr(this.hwndText, -4, EditProc);
        OS.SetWindowLongPtr(this.hwndUpDown, -4, UpDownProc);
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        int n3 = 0;
        if (this.digits > 0) {
            String string2 = this.getDecimalSeparator();
            n3 = string.indexOf(string2);
            if (n3 != -1) {
                string = String.valueOf(string.substring(0, n3)) + string.substring(n3 + 1);
            }
            n3 = 0;
        }
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) break;
            ++n3;
        }
        boolean bl = event2.doit = n3 == string.length();
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFFFFDFF;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        if (n == this.hwndText || n == this.hwndUpDown) {
            LRESULT lRESULT = null;
            switch (n2) {
                case 258: {
                    lRESULT = this.wmChar(n, n3, n4);
                    break;
                }
                case 646: {
                    lRESULT = this.wmIMEChar(n, n3, n4);
                    break;
                }
                case 256: {
                    lRESULT = this.wmKeyDown(n, n3, n4);
                    break;
                }
                case 257: {
                    lRESULT = this.wmKeyUp(n, n3, n4);
                    break;
                }
                case 262: {
                    lRESULT = this.wmSysChar(n, n3, n4);
                    break;
                }
                case 260: {
                    lRESULT = this.wmSysKeyDown(n, n3, n4);
                    break;
                }
                case 261: {
                    lRESULT = this.wmSysKeyUp(n, n3, n4);
                    break;
                }
                case 533: {
                    lRESULT = this.wmCaptureChanged(n, n3, n4);
                    break;
                }
                case 515: {
                    lRESULT = this.wmLButtonDblClk(n, n3, n4);
                    break;
                }
                case 513: {
                    lRESULT = this.wmLButtonDown(n, n3, n4);
                    break;
                }
                case 514: {
                    lRESULT = this.wmLButtonUp(n, n3, n4);
                    break;
                }
                case 521: {
                    lRESULT = this.wmMButtonDblClk(n, n3, n4);
                    break;
                }
                case 519: {
                    lRESULT = this.wmMButtonDown(n, n3, n4);
                    break;
                }
                case 520: {
                    lRESULT = this.wmMButtonUp(n, n3, n4);
                    break;
                }
                case 673: {
                    lRESULT = this.wmMouseHover(n, n3, n4);
                    break;
                }
                case 675: {
                    lRESULT = this.wmMouseLeave(n, n3, n4);
                    break;
                }
                case 512: {
                    lRESULT = this.wmMouseMove(n, n3, n4);
                    break;
                }
                case 518: {
                    lRESULT = this.wmRButtonDblClk(n, n3, n4);
                    break;
                }
                case 516: {
                    lRESULT = this.wmRButtonDown(n, n3, n4);
                    break;
                }
                case 517: {
                    lRESULT = this.wmRButtonUp(n, n3, n4);
                    break;
                }
                case 525: {
                    lRESULT = this.wmXButtonDblClk(n, n3, n4);
                    break;
                }
                case 523: {
                    lRESULT = this.wmXButtonDown(n, n3, n4);
                    break;
                }
                case 524: {
                    lRESULT = this.wmXButtonUp(n, n3, n4);
                    break;
                }
                case 7: {
                    lRESULT = this.wmSetFocus(n, n3, n4);
                    break;
                }
                case 8: {
                    lRESULT = this.wmKillFocus(n, n3, n4);
                    break;
                }
                case 15: {
                    lRESULT = this.wmPaint(n, n3, n4);
                    break;
                }
                case 791: {
                    lRESULT = this.wmPrint(n, n3, n4);
                    break;
                }
                case 123: {
                    lRESULT = this.wmContextMenu(n, n3, n4);
                    break;
                }
                case 199: 
                case 768: 
                case 770: 
                case 771: 
                case 772: {
                    if (n != this.hwndText) break;
                    lRESULT = this.wmClipboard(n, n2, n3, n4);
                }
            }
            if (lRESULT != null) {
                return lRESULT.value;
            }
            return this.callWindowProc(n, n2, n3, n4);
        }
        return super.windowProc(n, n2, n3, n4);
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        super.WM_ERASEBKGND(n, n2);
        this.drawBackground(n);
        return LRESULT.ONE;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        return null;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        OS.SetFocus(this.hwndText);
        return null;
    }

    LRESULT WM_SETFONT(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFONT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.SendMessage(this.hwndText, 48, n, n2);
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n3 = OS.LOWORD(n2);
        int n4 = OS.HIWORD(n2);
        int n5 = OS.GetSystemMetrics(2);
        int n6 = n3 - n5;
        int n7 = OS.GetSystemMetrics(45);
        int n8 = 52;
        this.SetWindowPos(this.hwndText, 0, 0, 0, n6 + n7, n4, n8);
        this.SetWindowPos(this.hwndUpDown, 0, n6, 0, n5, n4, n8);
        return lRESULT;
    }

    LRESULT wmChar(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmChar(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 13: {
                this.postEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n, int n2, int n3, int n4) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n2) {
            case 768: 
            case 771: {
                OS.SendMessage(n, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(n, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(n, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.SendMessage(n, 176, nArray, nArray2);
                OS.CallWindowProc(EditProc, n, n2, n3, n4);
                int n5 = OS.GetWindowTextLength(n);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(n, 176, (int[])object, nArray3);
                if (n5 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n5 + 1);
                    OS.GetWindowText(n, tCHAR, n5 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, n, n2, n3, n4);
                this.ignoreModify = false;
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    OS.CallWindowProc(EditProc, n, n2, n3, n4);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n2 == 12) {
                    int n6 = OS.GetProcessHeap();
                    int n7 = ((TCHAR)object).length() * TCHAR.sizeof;
                    int n8 = OS.HeapAlloc(n6, 8, n7);
                    OS.MoveMemory(n8, (TCHAR)object, n7);
                    int n9 = OS.CallWindowProc(EditProc, n, n2, n3, n8);
                    OS.HeapFree(n6, 0, n8);
                    return new LRESULT(n9);
                }
                OS.SendMessage(n, 194, 0, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = OS.HIWORD(n);
        switch (n3) {
            case 768: {
                int n4;
                if (this.ignoreModify) break;
                int n5 = this.getSelectionText();
                if (n5 != -1 && (n4 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0)) : OS.SendMessage(this.hwndUpDown, 1138, 0, 0)) != n5) {
                    this.setSelection(n5, true, false, true);
                }
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(n, n2);
    }

    LRESULT wmKeyDown(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage(this.hwndUpDown, 1132, 1, uDACCEL);
        int n4 = 0;
        switch (n2) {
            case 38: {
                n4 = uDACCEL.nInc;
                break;
            }
            case 40: {
                n4 = -uDACCEL.nInc;
                break;
            }
            case 33: {
                n4 = this.pageIncrement;
                break;
            }
            case 34: {
                n4 = -this.pageIncrement;
            }
        }
        if (n4 != 0) {
            int n5 = this.getSelectionText();
            if (n5 != -1) {
                n5 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0)) : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
            }
            int n6 = n5 + n4;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
            if ((this.style & 0x40) != 0) {
                if (n6 < nArray2[0]) {
                    n6 = nArray[0];
                }
                if (n6 > nArray[0]) {
                    n6 = nArray2[0];
                }
            }
            if (n5 != (n6 = Math.min(Math.max(nArray2[0], n6), nArray[0]))) {
                this.setSelection(n6, true, true, true);
            }
        }
        switch (n2) {
            case 38: 
            case 40: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmKillFocus(int n, int n2, int n3) {
        int n4 = this.getSelectionText();
        if (n4 == -1) {
            n4 = OS.IsWinCE ? OS.LOWORD(OS.SendMessage(this.hwndUpDown, 1128, 0, 0)) : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
            this.setSelection(n4, false, true, false);
        }
        return super.wmKillFocus(n, n2, n3);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n, int n2) {
        switch (nMHDR.code) {
            case -722: {
                NMUPDOWN nMUPDOWN = new NMUPDOWN();
                OS.MoveMemory(nMUPDOWN, n2, NMUPDOWN.sizeof);
                int n3 = nMUPDOWN.iPos + nMUPDOWN.iDelta;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
                if ((this.style & 0x40) != 0) {
                    if (n3 < nArray2[0]) {
                        n3 = nArray[0];
                    }
                    if (n3 > nArray[0]) {
                        n3 = nArray2[0];
                    }
                }
                if ((n3 = Math.min(Math.max(nArray2[0], n3), nArray[0])) != nMUPDOWN.iPos) {
                    this.setSelection(n3, true, true, true);
                }
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(nMHDR, n, n2);
    }

    LRESULT wmScrollChild(int n, int n2) {
        int n3 = OS.LOWORD(n);
        switch (n3) {
            case 4: {
                this.postEvent(13);
            }
        }
        return super.wmScrollChild(n, n2);
    }
}

