/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    String text = "";
    static final int CLIENT_INSET = 3;
    static final int GroupProc;
    static final TCHAR GroupClass;

    static {
        GroupClass = new TCHAR(0, OS.IsWinCE ? "BUTTON" : "SWT_GROUP", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        if (OS.IsWinCE) {
            OS.GetClassInfo(0, GroupClass, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
        } else {
            TCHAR tCHAR = new TCHAR(0, "BUTTON", true);
            OS.GetClassInfo(0, tCHAR, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
            int n = OS.GetModuleHandle(null);
            if (!OS.GetClassInfo(n, GroupClass, wNDCLASS)) {
                int n2 = OS.GetProcessHeap();
                wNDCLASS.hInstance = n;
                wNDCLASS.style &= 0xFFFFFFFC;
                int n3 = GroupClass.length() * TCHAR.sizeof;
                int n4 = OS.HeapAlloc(n2, 8, n3);
                OS.MoveMemory(n4, GroupClass, n3);
                wNDCLASS.lpszClassName = n4;
                OS.RegisterClass(wNDCLASS);
                OS.HeapFree(n2, 0, n4);
            }
        }
    }

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        switch (n2) {
            case 513: 
            case 515: {
                return OS.DefWindowProc(n, n2, n3, n4);
            }
        }
        return OS.CallWindowProc(GroupProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        int n3 = this.text.length();
        if (n3 != 0) {
            String string = this.text;
            if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
                string = " " + string + " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            int n4 = 0;
            int n5 = OS.GetDC(this.handle);
            int n6 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n6 != 0) {
                n4 = OS.SelectObject(n5, n6);
            }
            RECT rECT = new RECT();
            int n7 = 1056;
            OS.DrawText(n5, tCHAR, -1, rECT, n7);
            if (n6 != 0) {
                OS.SelectObject(n5, n4);
            }
            OS.ReleaseDC(this.handle, n5);
            point.x = Math.max(point.x, rECT.right - rECT.left + 18);
        }
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        int n6 = OS.GetDC(this.handle);
        int n7 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n7 != 0) {
            n5 = OS.SelectObject(n6, n7);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n6, tEXTMETRIC);
        if (n7 != 0) {
            OS.SelectObject(n6, n5);
        }
        OS.ReleaseDC(this.handle, n6);
        rectangle.x -= 3;
        rectangle.y -= tEXTMETRIC.tmHeight;
        rectangle.width += 6;
        rectangle.height += tEXTMETRIC.tmHeight + 3;
        return rectangle;
    }

    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        this.state |= 0x200;
        this.state &= 0xFFFFFFFD;
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            String string = bl || this.text.length() == 0 ? this.text : " " + this.text + " ";
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n = 0;
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n3 != 0) {
            n = OS.SelectObject(n2, n3);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n2, tEXTMETRIC);
        if (n3 != 0) {
            OS.SelectObject(n2, n);
        }
        OS.ReleaseDC(this.handle, n2);
        int n4 = 3;
        int n5 = tEXTMETRIC.tmHeight;
        int n6 = Math.max(0, rECT.right - 6);
        int n7 = Math.max(0, rECT.bottom - n5 - 3);
        return new Rectangle(n4, n5, n6, n7);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char c) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
    }

    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || OS.IsWindowEnabled(this.handle) || string.length() == 0)) {
            string = " " + string + " ";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
    }

    int widgetStyle() {
        return super.widgetStyle() | 7 | 0x2000000 | 0x4000000;
    }

    TCHAR windowClass() {
        return GroupClass;
    }

    int windowProc() {
        return GroupProc;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.drawBackground(n);
        return LRESULT.ONE;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        LRESULT lRESULT = super.WM_NCHITTEST(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = this.callWindowProc(this.handle, 132, n, n2);
        if (n3 == -1) {
            n3 = 1;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_MOUSEMOVE(int n, int n2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int n, int n2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n3 = OS.SaveDC(n);
            int n4 = this.callWindowProc(this.handle, 792, n, n2);
            OS.RestoreDC(n, n3);
            return new LRESULT(n4);
        }
        return lRESULT;
    }

    LRESULT WM_UPDATEUISTATE(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = this.findImageControl() != null;
        if (!bl) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                boolean bl3 = bl = this.findThemeControl() != null;
            }
            if (!bl) {
                boolean bl4 = bl = this.findBackgroundControl() != null;
            }
        }
        if (bl) {
            OS.InvalidateRect(this.handle, null, false);
            int n3 = OS.DefWindowProc(this.handle, 296, n, n2);
            return new LRESULT(n3);
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        if (n4 == n6 && n5 == n7) {
            return lRESULT;
        }
        if (n4 != n6) {
            n3 = n6;
            if (n4 < n6) {
                n3 = n4;
            }
            OS.SetRect(rECT, n3 - 3, 0, n4, n5);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n5 != n7) {
            n3 = n7;
            if (n5 < n7) {
                n3 = n5;
            }
            if (n4 < n6) {
                n6 -= 3;
            }
            OS.SetRect(rECT, 0, n3 - 3, n6, n5);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }
}

