/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Calendar;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int DateTimeProc;
    static final TCHAR DateTimeClass;
    static final int CalendarProc;
    static final TCHAR CalendarClass;
    static final int MARGIN = 4;
    static final int MAX_DIGIT = 9;
    static final int MAX_DAY = 31;
    static final int MAX_12HOUR = 12;
    static final int MAX_24HOUR = 24;
    static final int MAX_MINUTE = 60;
    static final int MONTH_DAY_YEAR = 0;
    static final int DAY_MONTH_YEAR = 1;
    static final int YEAR_MONTH_DAY = 2;
    static final char SINGLE_QUOTE = '\'';
    static final char DAY_FORMAT_CONSTANT = 'd';
    static final char MONTH_FORMAT_CONSTANT = 'M';
    static final char YEAR_FORMAT_CONSTANT = 'y';
    static final char HOURS_FORMAT_CONSTANT = 'h';
    static final char MINUTES_FORMAT_CONSTANT = 'm';
    static final char SECONDS_FORMAT_CONSTANT = 's';
    static final char AMPM_FORMAT_CONSTANT = 't';
    static final int[] MONTH_NAMES;

    static {
        DateTimeClass = new TCHAR(0, "SysDateTimePick32", true);
        CalendarClass = new TCHAR(0, "SysMonthCal32", true);
        INITCOMMONCONTROLSEX iNITCOMMONCONTROLSEX = new INITCOMMONCONTROLSEX();
        iNITCOMMONCONTROLSEX.dwSize = INITCOMMONCONTROLSEX.sizeof;
        iNITCOMMONCONTROLSEX.dwICC = 256;
        OS.InitCommonControlsEx(iNITCOMMONCONTROLSEX);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, DateTimeClass, wNDCLASS);
        DateTimeProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo(0, CalendarClass, wNDCLASS);
        CalendarProc = wNDCLASS.lpfnWndProc;
        MONTH_NAMES = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    }

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
        if ((this.style & 0x8000) != 0) {
            String string = (this.style & 0x20) != 0 ? this.getCustomShortDateFormat() : this.getCustomShortTimeFormat();
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.SendMessage(this.handle, OS.DTM_SETFORMAT, 0, tCHAR);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(this.windowProc(), n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        n = DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0);
        return DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            Object object;
            if ((this.style & 0x400) != 0) {
                object = new RECT();
                OS.SendMessage(this.handle, 4105, 0, (RECT)object);
                n3 = ((RECT)object).right;
                n4 = ((RECT)object).bottom;
            } else {
                int n5;
                int n6;
                object = new TCHAR(this.getCodePage(), 128);
                int n7 = 0;
                int n8 = OS.GetDC(this.handle);
                int n9 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n9 != 0) {
                    n7 = OS.SelectObject(n8, n9);
                }
                RECT rECT = new RECT();
                int n10 = 11264;
                SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
                if ((this.style & 0x20) != 0) {
                    int n11;
                    int n12;
                    sYSTEMTIME.wMonth = 1;
                    sYSTEMTIME.wDay = 1;
                    n6 = 0;
                    n5 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    while (n14 <= 9) {
                        sYSTEMTIME.wYear = (short)(2000 + n14);
                        n12 = OS.GetDateFormat(1024, 1, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n12 == 0) {
                            object = new TCHAR(this.getCodePage(), n12);
                            OS.GetDateFormat(1024, 1, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n8, (TCHAR)object, n12, rECT, n10);
                        if (rECT.right - rECT.left >= n3) {
                            n3 = rECT.right - rECT.left;
                            n13 = n5;
                            n5 = n6;
                            n6 = n14;
                        }
                        n4 = Math.max(n4, rECT.bottom - rECT.top);
                        ++n14;
                    }
                    n6 = n6 > 1 ? n6 * 1000 + n6 * 100 + n6 * 10 + n6 : (n5 > 1 ? n5 * 1000 + n6 * 100 + n6 * 10 + n6 : n13 * 1000 + n6 * 100 + n6 * 10 + n6);
                    sYSTEMTIME.wYear = (short)n6;
                    n6 = 0;
                    n3 = 0;
                    n14 = 0;
                    while (n14 < MONTH_NAMES.length) {
                        n12 = MONTH_NAMES[n14];
                        n11 = OS.GetLocaleInfo(1024, n12, (TCHAR)object, ((TCHAR)object).length());
                        if (n11 == 0) {
                            object = new TCHAR(this.getCodePage(), n11);
                            OS.GetLocaleInfo(1024, n12, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n8, (TCHAR)object, n11, rECT, n10);
                        if (rECT.right - rECT.left > n3) {
                            n3 = rECT.right - rECT.left;
                            n6 = n14;
                        }
                        n4 = Math.max(n4, rECT.bottom - rECT.top);
                        n14 = (short)(n14 + 1);
                    }
                    sYSTEMTIME.wMonth = (short)(n6 + 1);
                    n14 = (this.style & 0x10000) != 0 ? 1 : ((this.style & 0x8000) != 0 ? 8 : 2);
                    n3 = 0;
                    n12 = 1;
                    while (n12 <= 31) {
                        sYSTEMTIME.wDay = (short)n12;
                        n11 = OS.GetDateFormat(1024, n14, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n11 == 0) {
                            object = new TCHAR(this.getCodePage(), n11);
                            OS.GetDateFormat(1024, n14, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n8, (TCHAR)object, n11, rECT, n10);
                        n3 = Math.max(n3, rECT.right - rECT.left);
                        n4 = Math.max(n4, rECT.bottom - rECT.top);
                        if ((this.style & 0x8000) == 0) {
                            n12 = (short)(n12 + 1);
                            continue;
                        }
                        break;
                    }
                } else if ((this.style & 0x80) != 0) {
                    int n15;
                    n6 = (this.style & 0x8000) != 0 ? 2 : 0;
                    n5 = 0;
                    int n16 = this.is24HourTime() ? 24 : 12;
                    int n17 = 0;
                    while (n17 < n16) {
                        sYSTEMTIME.wHour = (short)n17;
                        n15 = OS.GetTimeFormat(1024, n6, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n15 == 0) {
                            object = new TCHAR(this.getCodePage(), n15);
                            OS.GetTimeFormat(1024, n6, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n8, (TCHAR)object, n15, rECT, n10);
                        if (rECT.right - rECT.left > n3) {
                            n3 = rECT.right - rECT.left;
                            n5 = n17;
                        }
                        n4 = Math.max(n4, rECT.bottom - rECT.top);
                        n17 = (short)(n17 + 1);
                    }
                    sYSTEMTIME.wHour = (short)n5;
                    n5 = 0;
                    n3 = 0;
                    n17 = 0;
                    while (n17 < 60) {
                        sYSTEMTIME.wMinute = (short)n17;
                        n15 = OS.GetTimeFormat(1024, n6, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n15 == 0) {
                            object = new TCHAR(this.getCodePage(), n15);
                            OS.GetTimeFormat(1024, n6, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n8, (TCHAR)object, n15, rECT, n10);
                        if (rECT.right - rECT.left > n3) {
                            n3 = rECT.right - rECT.left;
                            n5 = n17;
                        }
                        n4 = Math.max(n4, rECT.bottom - rECT.top);
                        n17 = (short)(n17 + 1);
                    }
                    sYSTEMTIME.wMinute = (short)n5;
                    sYSTEMTIME.wSecond = (short)n5;
                    n17 = OS.GetTimeFormat(1024, n6, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                    if (n17 == 0) {
                        object = new TCHAR(this.getCodePage(), n17);
                        OS.GetTimeFormat(1024, n6, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                    }
                    rECT.bottom = 0;
                    rECT.right = 0;
                    rECT.top = 0;
                    rECT.left = 0;
                    OS.DrawText(n8, (TCHAR)object, n17, rECT, n10);
                    n3 = rECT.right - rECT.left;
                    n4 = Math.max(n4, rECT.bottom - rECT.top);
                }
                if (n9 != 0) {
                    OS.SelectObject(n8, n7);
                }
                OS.ReleaseDC(this.handle, n8);
                n6 = OS.GetSystemMetrics(2);
                n3 += n6 + 4;
                n5 = OS.GetSystemMetrics(20);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n5 += 7;
                }
                n4 = Math.max(n4, n5);
            }
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n18 = this.getBorderWidth();
        return new Point(n3 += n18 * 2, n4 += n18 * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if ((this.style & 0x800) == 0) {
            int n = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, n &= 0xFFFDFDFF);
        }
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    String getComputeSizeString() {
        if ((this.style & 0x20) != 0) {
            if ((this.style & 0x8000) != 0) {
                return this.getCustomShortDateFormat();
            }
            if ((this.style & 0x10000) != 0) {
                return this.getShortDateFormat();
            }
            if ((this.style & 0x10000000) != 0) {
                return this.getLongDateFormat();
            }
        }
        if ((this.style & 0x80) != 0) {
            if ((this.style & 0x8000) != 0) {
                return this.getCustomShortTimeFormat();
            }
            return this.getTimeFormat();
        }
        return "";
    }

    String getCustomShortDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n = OS.GetLocaleInfo(1024, 4102, tCHAR, 80);
        return n != 0 ? tCHAR.toString(0, n - 1) : "M/yyyy";
    }

    String getCustomShortTimeFormat() {
        StringBuffer stringBuffer = new StringBuffer(this.getTimeFormat());
        int n = stringBuffer.length();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c == '\'') {
                bl = !bl;
            } else if (c == 's' && !bl) {
                n3 = n2 + 1;
                while (n3 < n && stringBuffer.charAt(n3) == 's') {
                    ++n3;
                }
                while (n2 > 0 && stringBuffer.charAt(n2) != 'm') {
                    --n2;
                }
                ++n2;
                break;
            }
            ++n2;
        }
        if (n2 < n3) {
            stringBuffer.delete(n2, n3);
        }
        return stringBuffer.toString();
    }

    String getLongDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n = OS.GetLocaleInfo(1024, 32, tCHAR, 80);
        return n > 0 ? tCHAR.toString(0, n - 1) : "dddd, MMMM dd, yyyy";
    }

    String getShortDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n = OS.GetLocaleInfo(1024, 31, tCHAR, 80);
        return n > 0 ? tCHAR.toString(0, n - 1) : "M/d/yyyy";
    }

    int getShortDateFormatOrdering() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n = OS.GetLocaleInfo(1024, 33, tCHAR, 4);
        if (n > 0) {
            String string = tCHAR.toString(0, n - 1);
            return Integer.parseInt(string);
        }
        return 0;
    }

    String getTimeFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n = OS.GetLocaleInfo(1024, 4099, tCHAR, 80);
        return n > 0 ? tCHAR.toString(0, n - 1) : "h:mm:ss tt";
    }

    boolean is24HourTime() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n = OS.GetLocaleInfo(1024, 35, tCHAR, 4);
        if (n > 0) {
            String string = tCHAR.toString(0, n - 1);
            return Integer.parseInt(string) != 0;
        }
        return true;
    }

    public int getDay() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n, 0, sYSTEMTIME);
        return sYSTEMTIME.wDay;
    }

    public int getHours() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n, 0, sYSTEMTIME);
        return sYSTEMTIME.wHour;
    }

    public int getMinutes() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n, 0, sYSTEMTIME);
        return sYSTEMTIME.wMinute;
    }

    public int getMonth() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n, 0, sYSTEMTIME);
        return sYSTEMTIME.wMonth - 1;
    }

    String getNameText() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds());
        return calendar.getTime().toString();
    }

    public int getSeconds() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n, 0, sYSTEMTIME);
        return sYSTEMTIME.wSecond;
    }

    public int getYear() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n, 0, sYSTEMTIME);
        return sYSTEMTIME.wYear;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setDay(int n) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        n2 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wDay = (short)n;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
    }

    public void setHours(int n) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        n2 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wHour = (short)n;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
    }

    public void setMinutes(int n) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        n2 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wMinute = (short)n;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
    }

    public void setMonth(int n) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        n2 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wMonth = (short)(n + 1);
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
    }

    public void setSeconds(int n) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        n2 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wSecond = (short)n;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
    }

    public void setYear(int n) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        n2 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wYear = (short)n;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x10000;
        if ((this.style & 0x400) != 0) {
            return n | 0x10;
        }
        n &= 0xFDFFFFFF;
        if ((this.style & 0x80) != 0) {
            n |= 9;
        }
        if ((this.style & 0x20) != 0) {
            n |= ((this.style & 0x10000) != 0 ? 12 : 4) | 1;
        }
        return n;
    }

    TCHAR windowClass() {
        return (this.style & 0x400) != 0 ? CalendarClass : DateTimeClass;
    }

    int windowProc() {
        return (this.style & 0x400) != 0 ? CalendarProc : DateTimeProc;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n, int n2) {
        switch (nMHDR.code) {
            case -759: 
            case -749: {
                this.sendEvent(13);
            }
        }
        return super.wmNotifyChild(nMHDR, n, n2);
    }
}

