/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    void clearArea(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            RECT rECT = new RECT();
            OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
            int n5 = OS.GetDCEx(this.handle, 0, 26);
            this.drawBackground(n5, rECT);
            OS.ReleaseDC(this.handle, n5);
        }
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = gC.handle;
        int n6 = this.background == -1 ? gC.getBackground().handle : -1;
        this.drawBackground(n5, rECT, n6);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8;
        boolean bl2;
        this.checkWidget();
        this.forceResize();
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n3, n4, n3 + n5, n4 + n6);
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        if (OS.IntersectRect(rECT2, rECT, rECT2)) {
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.handle);
            } else {
                n8 = 384;
                OS.RedrawWindow(this.handle, null, 0, n8);
            }
        }
        n8 = n - n3;
        int n9 = n2 - n4;
        if (this.findImageControl() != null) {
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n7 = 1029;
                if (bl) {
                    n7 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0, n7);
            }
            OS.OffsetRect(rECT, n8, n9);
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n7 = 1029;
                if (bl) {
                    n7 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0, n7);
            }
        } else {
            n7 = 6;
            OS.ScrollWindowEx(this.handle, n8, n9, rECT, null, 0, null, n7);
        }
        if (bl) {
            Control[] controlArray = this._getChildren();
            int n10 = 0;
            while (n10 < controlArray.length) {
                Control control = controlArray[n10];
                Rectangle rectangle = control.getBounds();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) >= Math.max(n3, rectangle.x) && Math.min(n4 + n6, rectangle.y + rectangle.height) >= Math.max(n4, rectangle.y)) {
                    control.setLocation(rectangle.x + n8, rectangle.y + n9);
                }
                ++n10;
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        if (n2 == Display.SWT_RESTORECARET && (this.state & 2) != 0 && this.caret != null) {
            this.caret.killFocus();
            this.caret.setFocus();
            return 1;
        }
        return super.windowProc(n, n2, n3, n4);
    }

    LRESULT WM_IME_COMPOSITION(int n, int n2) {
        POINT pOINT;
        short s;
        short s2;
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_COMPOSITION(n, n2)) != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION == OS.VERSION(5, 1) && OS.IsDBLocale && (s2 = OS.PRIMARYLANGID(s = OS.GetSystemDefaultUILanguage())) == 18 && this.caret != null && this.caret.isFocusCaret() && OS.GetCaretPos(pOINT = new POINT())) {
            COMPOSITIONFORM cOMPOSITIONFORM = new COMPOSITIONFORM();
            cOMPOSITIONFORM.dwStyle = 2;
            cOMPOSITIONFORM.x = pOINT.x;
            cOMPOSITIONFORM.y = pOINT.y;
            int n3 = OS.ImmGetContext(this.handle);
            OS.ImmSetCompositionWindow(n3, cOMPOSITIONFORM);
            OS.ImmReleaseContext(this.handle, n3);
        }
        return super.WM_IME_COMPOSITION(n, n2);
    }

    LRESULT WM_IME_COMPOSITION_START(int n, int n2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_COMPOSITION_START(n, n2)) != null) {
            return lRESULT;
        }
        return super.WM_IME_COMPOSITION_START(n, n2);
    }

    LRESULT WM_IME_ENDCOMPOSITION(int n, int n2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_ENDCOMPOSITION(n, n2)) != null) {
            return lRESULT;
        }
        return super.WM_IME_ENDCOMPOSITION(n, n2);
    }

    LRESULT WM_INPUTLANGCHANGE(int n, int n2) {
        LRESULT lRESULT = super.WM_INPUTLANGCHANGE(n, n2);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setIMEFont();
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_KILLFOCUS(n, n2)) != null) {
            return lRESULT;
        }
        lRESULT = super.WM_KILLFOCUS(n, n2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_LBUTTONDOWN(n, n2)) != null) {
            return lRESULT;
        }
        return super.WM_LBUTTONDOWN(n, n2);
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGED(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGED(n, n2);
        boolean bl2 = bl = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        return lRESULT;
    }
}

