/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BUTTON_IMAGELIST;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    String message = "";
    Image image;
    Image image2;
    Image disabledImage;
    ImageList imageList;
    boolean ignoreMouse;
    static final int MARGIN = 4;
    static final int CHECK_WIDTH;
    static final int CHECK_HEIGHT;
    static final int ICON_WIDTH = 128;
    static final int ICON_HEIGHT = 128;
    static final boolean COMMAND_LINK = false;
    static final int ButtonProc;
    static final TCHAR ButtonClass;

    static {
        Object object;
        ButtonClass = new TCHAR(0, "BUTTON", true);
        int n = OS.LoadBitmap(0, 32759);
        if (n == 0) {
            CHECK_WIDTH = OS.GetSystemMetrics(OS.IsWinCE ? 49 : 2);
            CHECK_HEIGHT = OS.GetSystemMetrics(OS.IsWinCE ? 50 : 20);
        } else {
            object = new BITMAP();
            OS.GetObject(n, BITMAP.sizeof, (BITMAP)object);
            OS.DeleteObject(n);
            CHECK_WIDTH = ((BITMAP)object).bmWidth / 4;
            CHECK_HEIGHT = ((BITMAP)object).bmHeight / 3;
        }
        object = new WNDCLASS();
        OS.GetClassInfo(0, ButtonClass, (WNDCLASS)object);
        ButtonProc = ((WNDCLASS)object).lpfnWndProc;
    }

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    void _setImage(Image image) {
        if ((this.style & 0x400000) != 0) {
            return;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = null;
            if (image != null) {
                int n;
                this.imageList = new ImageList(this.style & 0x4000000);
                if (OS.IsWindowEnabled(this.handle)) {
                    this.imageList.add(image);
                } else {
                    if (this.disabledImage != null) {
                        this.disabledImage.dispose();
                    }
                    this.disabledImage = new Image((Device)this.display, image, 1);
                    this.imageList.add(this.disabledImage);
                }
                BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
                bUTTON_IMAGELIST.himl = this.imageList.getHandle();
                int n2 = n = OS.GetWindowLong(this.handle, -16);
                n2 &= 0xFFFFFCFF;
                if ((this.style & 0x4000) != 0) {
                    n2 |= 0x100;
                }
                if ((this.style & 0x1000000) != 0) {
                    n2 |= 0x300;
                }
                if ((this.style & 0x20000) != 0) {
                    n2 |= 0x200;
                }
                if (this.text.length() == 0) {
                    if ((this.style & 0x4000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 4;
                    }
                    if ((this.style & 0x20000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 1;
                    }
                } else {
                    bUTTON_IMAGELIST.uAlign = 0;
                    bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
                    bUTTON_IMAGELIST.margin_right = 4;
                    n2 &= 0xFFFFFCFF;
                    n2 |= 0x100;
                }
                if (n2 != n) {
                    OS.SetWindowLong(this.handle, -16, n2);
                    OS.InvalidateRect(this.handle, null, true);
                }
                OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
            } else {
                OS.SendMessage(this.handle, 5634, 0, 0);
            }
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n;
            if (this.image2 != null) {
                this.image2.dispose();
            }
            this.image2 = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (image != null) {
                Rectangle rectangle;
                switch (image.type) {
                    case 0: {
                        rectangle = image.getBounds();
                        ImageData imageData = image.getImageData();
                        switch (imageData.getTransparencyType()) {
                            case 4: {
                                if (rectangle.width <= 128 && rectangle.height <= 128) {
                                    this.image2 = new Image((Device)this.display, imageData, imageData.getTransparencyMask());
                                    n3 = this.image2.handle;
                                    n4 = 64;
                                    n5 = 1;
                                    break;
                                }
                            }
                            case 1: {
                                this.image2 = new Image((Device)this.display, rectangle.width, rectangle.height);
                                GC gC = new GC(this.image2);
                                gC.setBackground(this.getBackground());
                                gC.fillRectangle(rectangle);
                                gC.drawImage(image, 0, 0);
                                gC.dispose();
                                n3 = this.image2.handle;
                                n4 = 128;
                                n5 = 0;
                                break;
                            }
                            case 0: {
                                n3 = image.handle;
                                n4 = 128;
                                n5 = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        n3 = image.handle;
                        n4 = 64;
                        n5 = 1;
                    }
                }
                if ((this.style & 0x4000000) != 0 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                    rectangle = image.getBounds();
                    int n6 = OS.GetDC(this.handle);
                    int n7 = OS.CreateCompatibleDC(n6);
                    int n8 = OS.CreateCompatibleBitmap(n6, rectangle.width, rectangle.height);
                    int n9 = OS.SelectObject(n7, n8);
                    OS.SetLayout(n7, 1);
                    if (n5 == 0) {
                        int n10 = OS.CreateCompatibleDC(n6);
                        int n11 = OS.SelectObject(n10, n3);
                        OS.SetLayout(n7, 0);
                        OS.BitBlt(n7, 0, 0, rectangle.width, rectangle.height, n10, 0, 0, 0xCC0020);
                        OS.SelectObject(n10, n11);
                        OS.DeleteDC(n10);
                    } else {
                        Control control = this.findBackgroundControl();
                        if (control == null) {
                            control = this;
                        }
                        int n12 = OS.CreateSolidBrush(control.getBackgroundPixel());
                        int n13 = OS.SelectObject(n7, n12);
                        OS.PatBlt(n7, 0, 0, rectangle.width, rectangle.height, 15728673);
                        OS.DrawIconEx(n7, 0, 0, n3, 0, 0, 0, 0, 3);
                        OS.SelectObject(n7, n13);
                        OS.DeleteObject(n12);
                    }
                    OS.SelectObject(n7, n9);
                    OS.DeleteDC(n7);
                    OS.ReleaseDC(this.handle, n6);
                    if (this.image2 != null) {
                        this.image2.dispose();
                    }
                    this.image2 = Image.win32_new(this.display, 0, n8);
                    n4 = 128;
                    n5 = 0;
                    n3 = n8;
                }
            }
            int n14 = n = OS.GetWindowLong(this.handle, -16);
            n &= 0xFFFFFF3F;
            if ((n |= n4) != n14) {
                OS.SetWindowLong(this.handle, -16, n);
            }
            OS.SendMessage(this.handle, 247, n5, n3);
        }
    }

    void _setText(String string) {
        Object object;
        int n;
        int n2 = n = OS.GetWindowLong(this.handle, -16);
        if (OS.COMCTL32_MAJOR >= 6) {
            n2 &= 0xFFFFFCFF;
            if ((this.style & 0x4000) != 0) {
                n2 |= 0x100;
            }
            if ((this.style & 0x1000000) != 0) {
                n2 |= 0x300;
            }
            if ((this.style & 0x20000) != 0) {
                n2 |= 0x200;
            }
            if (this.imageList != null) {
                object = new BUTTON_IMAGELIST();
                ((BUTTON_IMAGELIST)object).himl = this.imageList.getHandle();
                if (string.length() == 0) {
                    if ((this.style & 0x4000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 4;
                    }
                    if ((this.style & 0x20000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 1;
                    }
                } else {
                    ((BUTTON_IMAGELIST)object).uAlign = 0;
                    ((BUTTON_IMAGELIST)object).margin_left = this.computeLeftMargin();
                    ((BUTTON_IMAGELIST)object).margin_right = 4;
                    n2 &= 0xFFFFFCFF;
                    n2 |= 0x100;
                }
                OS.SendMessage(this.handle, 5634, 0, (BUTTON_IMAGELIST)object);
            }
        } else {
            n2 &= 0xFFFFFF3F;
        }
        if (n2 != n) {
            OS.SetWindowLong(this.handle, -16, n2);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            string = OS.IsWindowEnabled(this.handle) ? string : " " + string + " ";
        }
        object = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, (TCHAR)object);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ButtonProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    void click() {
        this.ignoreMouse = true;
        OS.SendMessage(this.handle, 245, 0, 0);
        this.ignoreMouse = false;
    }

    int computeLeftMargin() {
        if (OS.COMCTL32_MAJOR < 6) {
            return 4;
        }
        if ((this.style & 0xA) == 0) {
            return 4;
        }
        int n = 0;
        if (this.image != null && this.text.length() != 0) {
            Rectangle rectangle = this.image.getBounds();
            n += rectangle.width + 8;
            int n2 = 0;
            int n3 = OS.GetDC(this.handle);
            int n4 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n4 != 0) {
                n2 = OS.SelectObject(n3, n4);
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), this.text, true);
            RECT rECT = new RECT();
            int n5 = 1056;
            OS.DrawText(n3, tCHAR, -1, rECT, n5);
            n += rECT.right - rECT.left;
            if (n4 != 0) {
                OS.SelectObject(n3, n2);
            }
            OS.ReleaseDC(this.handle, n3);
            OS.GetClientRect(this.handle, rECT);
            n = Math.max(4, (rECT.right - rECT.left - n) / 2);
        }
        return n;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getBorderWidth();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                n3 += OS.GetSystemMetrics(2);
                n4 += OS.GetSystemMetrics(20);
            } else {
                n3 += OS.GetSystemMetrics(21);
                n4 += OS.GetSystemMetrics(3);
            }
        } else if ((this.style & 0x400000) != 0) {
            SIZE sIZE = new SIZE();
            if (n != -1) {
                sIZE.cx = n;
                OS.SendMessage(this.handle, 5633, 0, sIZE);
                n3 = sIZE.cx;
                n4 = sIZE.cy;
            } else {
                OS.SendMessage(this.handle, 5633, 0, sIZE);
                n3 = sIZE.cy;
                n4 = sIZE.cy;
                sIZE.cy = 0;
                while (sIZE.cy != n4) {
                    sIZE.cx = n3++;
                    sIZE.cy = 0;
                    OS.SendMessage(this.handle, 5633, 0, sIZE);
                }
            }
        } else {
            int n6;
            int n7 = 0;
            boolean bl2 = this.image != null;
            boolean bl3 = true;
            if (OS.COMCTL32_MAJOR < 6 && (this.style & 8) == 0) {
                n6 = OS.GetWindowLong(this.handle, -16);
                boolean bl4 = bl2 = (n6 & 0xC0) != 0;
                if (bl2) {
                    bl3 = false;
                }
            }
            if (bl2 && this.image != null) {
                Rectangle rectangle = this.image.getBounds();
                n3 = rectangle.width;
                if (bl3 && this.text.length() != 0) {
                    n3 += 8;
                }
                n4 = rectangle.height;
                n7 = 8;
            }
            if (bl3) {
                n6 = 0;
                int n8 = OS.GetDC(this.handle);
                int n9 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n9 != 0) {
                    n6 = OS.SelectObject(n8, n9);
                }
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n8, tEXTMETRIC);
                int n10 = this.text.length();
                if (n10 == 0) {
                    n4 = Math.max(n4, tEXTMETRIC.tmHeight);
                } else {
                    n7 = Math.max(8, tEXTMETRIC.tmAveCharWidth);
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), this.text, true);
                    RECT rECT = new RECT();
                    int n11 = 1056;
                    OS.DrawText(n8, tCHAR, -1, rECT, n11);
                    n3 += rECT.right - rECT.left;
                    n4 = Math.max(n4, rECT.bottom - rECT.top);
                }
                if (n9 != 0) {
                    OS.SelectObject(n8, n6);
                }
                OS.ReleaseDC(this.handle, n8);
            }
            if ((this.style & 0x30) != 0) {
                n3 += CHECK_WIDTH + n7;
                n4 = Math.max(n4, CHECK_HEIGHT + 3);
            }
            if ((this.style & 0xA) != 0) {
                n3 += 12;
                n4 += 10;
            }
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
                this.state |= 0x100;
            } else if ((this.style & 0xA) == 0) {
                this.state |= 0x100;
            }
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.style & 0x10) != 0) {
            this.state |= 0x200;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && (this.style & 0xA) != 0) {
            this.state |= 0x200;
        }
    }

    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNTEXT);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            boolean bl2;
            int n = OS.GetWindowLong(this.handle, -16);
            boolean bl3 = bl2 = (n & 0xC0) != 0;
            if (!bl2) {
                String string = bl ? this.text : " " + this.text + " ";
                TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
                OS.SetWindowText(this.handle, tCHAR);
            }
        }
        if (OS.COMCTL32_MAJOR >= 6 && this.imageList != null) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0, bUTTON_IMAGELIST);
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = new ImageList(this.style & 0x4000000);
            if (OS.IsWindowEnabled(this.handle)) {
                this.imageList.add(this.image);
            } else {
                if (this.disabledImage != null) {
                    this.disabledImage.dispose();
                }
                this.disabledImage = new Image((Device)this.display, this.image, 1);
                this.imageList.add(this.disabledImage);
            }
            bUTTON_IMAGELIST.himl = this.imageList.getHandle();
            OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 1) != 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int n = OS.SendMessage(this.handle, 240, 0, 0);
        return (n & 1) != 0;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    boolean isTabItem() {
        if ((this.style & 8) != 0) {
            return this.isTabGroup();
        }
        return super.isTabItem();
    }

    boolean mnemonicHit(char c) {
        if (!this.setFocus()) {
            return false;
        }
        if ((this.style & 0x10) == 0) {
            this.click();
        }
        return true;
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
        this.disabledImage = null;
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        this.text = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (this != control) {
                control.setRadioSelection(false);
            }
            ++n;
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        int n2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            OS.InvalidateRect(this.handle, null, true);
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n3 = n2 = OS.GetWindowLong(this.handle, -16);
        n3 &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            n3 |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n3 |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n3 |= 0x200;
        }
        if (OS.COMCTL32_MAJOR >= 6 && this.imageList != null) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            bUTTON_IMAGELIST.himl = this.imageList.getHandle();
            if (this.text.length() == 0) {
                if ((this.style & 0x4000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 0;
                }
                if ((this.style & 0x1000000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 4;
                }
                if ((this.style & 0x20000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 1;
                }
            } else {
                bUTTON_IMAGELIST.uAlign = 0;
                bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
                bUTTON_IMAGELIST.margin_right = 4;
                n3 &= 0xFFFFFCFF;
                n3 |= 0x100;
            }
            OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
        }
        if (n3 != n2) {
            OS.SetWindowLong(this.handle, -16, n3);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    void setDefault(boolean bl) {
        if ((this.style & 8) == 0) {
            return;
        }
        int n = this.menuShell().handle;
        int n2 = OS.GetWindowLong(this.handle, -16);
        if (bl) {
            n2 |= 1;
            OS.SendMessage(n, 1025, this.handle, 0);
        } else {
            n2 &= 0xFFFFFFFE;
            OS.SendMessage(n, 1025, 0, 0);
        }
        OS.SendMessage(this.handle, 244, n2, 1);
    }

    boolean setFixedFocus() {
        if ((this.style & 0x10) != 0 && !this.getSelection()) {
            return false;
        }
        return super.setFixedFocus();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (OS.COMCTL32_VERSION >= OS.VERSION(6, 1) && (this.style & 0x400000) != 0) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            OS.SendMessage(this.handle, 5641, 0, cArray);
        }
    }

    boolean setRadioFocus() {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return this.setFocus();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    boolean setSavedFocus() {
        if ((this.style & 0x10) != 0 && !this.getSelection()) {
            return false;
        }
        return super.setSavedFocus();
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int n = bl ? 1 : 0;
        int n2 = OS.GetWindowLong(this.handle, -16);
        OS.SendMessage(this.handle, 241, n, 0);
        OS.SetWindowLong(this.handle, -16, n2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        this._setText(string);
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            n |= 0x8000;
        }
        if ((this.style & 4) != 0) {
            return n | 0xB;
        }
        if ((this.style & 0x4000) != 0) {
            n |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n |= 0x200;
        }
        if ((this.style & 8) != 0) {
            return n | 0x10000;
        }
        if ((this.style & 0x20) != 0) {
            return n | 2 | 0x10000;
        }
        if ((this.style & 0x10) != 0) {
            return n | 4;
        }
        if ((this.style & 2) != 0) {
            return n | 0x1000 | 2 | 0x10000;
        }
        if ((this.style & 0x400000) != 0) {
            return n | 0xE | 0x10000;
        }
        return n | 0x10000;
    }

    TCHAR windowClass() {
        return ButtonClass;
    }

    int windowProc() {
        return ButtonProc;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6 && (this.style & 0x30) != 0 && this.findImageControl() != null) {
            this.drawBackground(n);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 4) != 0) {
            return new LRESULT(256);
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n, n2);
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(n, n2);
    }

    LRESULT WM_LBUTTONUP(int n, int n2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(n, n2);
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        int n3 = 0;
        if ((this.style & 0x10) != 0) {
            n3 = OS.GetWindowLong(this.handle, -16);
        }
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if ((this.style & 0x10) != 0) {
            OS.SetWindowLong(this.handle, -16, n3);
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && (this.style & 0xA) != 0 && this.imageList != null && this.text.length() != 0) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0, bUTTON_IMAGELIST);
            bUTTON_IMAGELIST.uAlign = 0;
            bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
            bUTTON_IMAGELIST.margin_right = 4;
            OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
        }
        return lRESULT;
    }

    LRESULT WM_SYSCOLORCHANGE(int n, int n2) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.image2 != null) {
            this._setImage(this.image);
        }
        return lRESULT;
    }

    LRESULT WM_UPDATEUISTATE(int n, int n2) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (this.style & 0x32) != 0) {
            boolean bl;
            boolean bl2 = bl = this.findImageControl() != null;
            if (!bl) {
                if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    boolean bl3 = bl = this.findThemeControl() != null;
                }
                if (!bl) {
                    boolean bl4 = bl = this.findBackgroundControl() != null;
                }
            }
            if (bl) {
                OS.InvalidateRect(this.handle, null, false);
                int n3 = OS.DefWindowProc(this.handle, 296, n, n2);
                return new LRESULT(n3);
            }
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = OS.HIWORD(n);
        switch (n3) {
            case 0: 
            case 5: {
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) != 0) {
                        this.setSelection(!this.getSelection());
                    } else {
                        this.selectRadio();
                    }
                }
                this.postEvent(13);
            }
        }
        return super.wmCommandChild(n, n2);
    }

    LRESULT wmColorChild(int n, int n2) {
        LRESULT lRESULT = super.wmColorChild(n, n2);
        if (OS.COMCTL32_MAJOR < 6 && (this.style & 0x30) != 0 && this.findImageControl() != null) {
            OS.SetBkMode(n, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return lRESULT;
    }

    LRESULT wmDrawChild(int n, int n2) {
        if ((this.style & 4) == 0) {
            return super.wmDrawChild(n, n2);
        }
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, DRAWITEMSTRUCT.sizeof);
        RECT rECT = new RECT();
        OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, dRAWITEMSTRUCT.bottom);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n3 = 9;
            switch (this.style & 0x24480) {
                case 128: {
                    n3 = 1;
                    break;
                }
                case 1024: {
                    n3 = 5;
                    break;
                }
                case 16384: {
                    n3 = 9;
                    break;
                }
                case 131072: {
                    n3 = 13;
                }
            }
            if (!this.getEnabled()) {
                n3 += 3;
            }
            if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
                n3 += 2;
            }
            OS.DrawThemeBackground(this.display.hScrollBarTheme(), dRAWITEMSTRUCT.hDC, 1, n3, rECT, null);
        } else {
            int n4 = 2;
            switch (this.style & 0x24480) {
                case 128: {
                    n4 = 0;
                    break;
                }
                case 1024: {
                    n4 = 1;
                    break;
                }
                case 16384: {
                    n4 = 2;
                    break;
                }
                case 131072: {
                    n4 = 3;
                }
            }
            if (!this.getEnabled()) {
                n4 |= 0x100;
            }
            if ((this.style & 0x800000) == 0x800000) {
                n4 |= 0x4000;
            }
            if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
                n4 |= 0x200;
            }
            OS.DrawFrameControl(dRAWITEMSTRUCT.hDC, rECT, 3, n4);
        }
        return null;
    }
}

