/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    public int hPalette = 0;
    int[] colorRefCount;
    int systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    TEXTMETRIC metrics;
    int[] pixels;
    int[] scripts;
    int[] gdipToken;
    boolean disposed;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            this.create(deviceData);
            this.init();
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.systemFont = this.getSystemFont().handle;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    /*
     * Exception decompiling
     */
    void checkGDIP() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 90->94)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void create(DeviceData deviceData) {
    }

    int computePixels(float f) {
        int n = this.internal_new_GC(null);
        int n2 = -((int)(0.5f + f * (float)OS.GetDeviceCaps(n, 90) / 72.0f));
        this.internal_dispose_GC(n, null);
        return n2;
    }

    float computePoints(LOGFONT lOGFONT, int n) {
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 90);
        int n4 = 0;
        if (lOGFONT.lfHeight > 0) {
            int n5 = OS.SelectObject(n2, n);
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n2, tEXTMETRIC);
            OS.SelectObject(n2, n5);
            n4 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
        } else {
            n4 = -lOGFONT.lfHeight;
        }
        this.internal_dispose_GC(n2, null);
        return (float)n4 * 72.0f / (float)n3;
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == object) {
                    this.objects[n] = null;
                    this.errors[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    int EnumFontFamProc(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = (n3 & 1) == 0;
        boolean bl3 = bl = n4 == 1;
        if (bl2 == bl) {
            Object object;
            if (this.nFonts == this.logFonts.length) {
                object = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, object, 0, this.nFonts);
                this.logFonts = object;
                int[] nArray = new int[((LOGFONT[])object).length];
                System.arraycopy(this.pixels, 0, nArray, 0, this.nFonts);
                this.pixels = nArray;
            }
            if ((object = this.logFonts[this.nFonts]) == null) {
                object = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory((LOGFONT)object, n, LOGFONT.sizeof);
            this.logFonts[this.nFonts] = object;
            if (object.lfHeight > 0) {
                OS.MoveMemory(this.metrics, n2, TEXTMETRIC.sizeof);
                this.pixels[this.nFonts] = object.lfHeight - this.metrics.tmInternalLeading;
            } else {
                this.pixels[this.nFonts] = -object.lfHeight;
            }
            ++this.nFonts;
        }
        return 1;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 8);
        int n3 = OS.GetDeviceCaps(n, 10);
        this.internal_dispose_GC(n, null);
        return new Rectangle(0, 0, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n = 0;
                int n2 = this.objects.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.objects[n3] != null) {
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                deviceData.objects = new Object[n];
                deviceData.errors = new Error[n];
                int n4 = 0;
                while (n4 < n2) {
                    if (this.objects[n4] != null) {
                        deviceData.objects[n3] = this.objects[n4];
                        deviceData.errors[n3] = this.errors[n4];
                        ++n3;
                    }
                    ++n4;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 12);
        int n3 = OS.GetDeviceCaps(n, 14);
        this.internal_dispose_GC(n, null);
        return n2 * n3;
    }

    public Point getDPI() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 88);
        int n3 = OS.GetDeviceCaps(n, 90);
        this.internal_dispose_GC(n, null);
        return new Point(n2, n3);
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        int n = callback.getAddress();
        if (n == 0) {
            SWT.error(3);
        }
        this.metrics = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        this.pixels = new int[this.nFonts];
        this.logFonts = new LOGFONT[this.nFonts];
        int n2 = 0;
        while (n2 < this.logFonts.length) {
            this.logFonts[n2] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            ++n2;
        }
        this.nFonts = 0;
        n2 = 0;
        int n3 = this.internal_new_GC(null);
        if (string == null) {
            OS.EnumFontFamilies(n3, null, n, bl ? 1 : 0);
            n2 = this.nFonts;
            int n4 = 0;
            while (n4 < n2) {
                LOGFONT lOGFONT = this.logFonts[n4];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(n3, ((LOGFONTW)lOGFONT).lfFaceName, n, bl ? 1 : 0);
                } else {
                    OS.EnumFontFamiliesA(n3, ((LOGFONTA)lOGFONT).lfFaceName, n, bl ? 1 : 0);
                }
                ++n4;
            }
        } else {
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.EnumFontFamilies(n3, tCHAR, n, bl ? 1 : 0);
        }
        int n5 = OS.GetDeviceCaps(n3, 90);
        this.internal_dispose_GC(n3, null);
        int n6 = 0;
        FontData[] fontDataArray = new FontData[this.nFonts - n2];
        int n7 = n2;
        while (n7 < this.nFonts) {
            FontData fontData = FontData.win32_new(this.logFonts[n7], (float)this.pixels[n7] * 72.0f / (float)n5);
            int n8 = 0;
            while (n8 < n6) {
                if (fontData.equals(fontDataArray[n8])) break;
                ++n8;
            }
            if (n8 == n6) {
                fontDataArray[n6++] = fontData;
            }
            ++n7;
        }
        if (n6 != fontDataArray.length) {
            FontData[] fontDataArray2 = new FontData[n6];
            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n6);
            fontDataArray = fontDataArray2;
        }
        callback.dispose();
        this.logFonts = null;
        this.pixels = null;
        this.metrics = null;
        return fontDataArray;
    }

    String getLastError() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(n) + "]";
    }

    String getLastErrorText() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        int n2 = 4864;
        int[] nArray = new int[1];
        int n3 = OS.FormatMessage(n2, 0, n, 1024, nArray, 0, 0);
        if (n3 == 0) {
            return " [GetLastError=0x" + Integer.toHexString(n) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n3);
        OS.MoveMemory(tCHAR, nArray[0], n3 * TCHAR.sizeof);
        if (nArray[0] != 0) {
            OS.LocalFree(nArray[0]);
        }
        return tCHAR.toString(0, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 0xFFFFFF;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 255;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 65280;
                break;
            }
            case 6: {
                n2 = 32768;
                break;
            }
            case 7: {
                n2 = 65535;
                break;
            }
            case 8: {
                n2 = 32896;
                break;
            }
            case 9: {
                n2 = 0xFF0000;
                break;
            }
            case 10: {
                n2 = 0x800000;
                break;
            }
            case 11: {
                n2 = 0xFF00FF;
                break;
            }
            case 12: {
                n2 = 0x800080;
                break;
            }
            case 13: {
                n2 = 0xFFFF00;
                break;
            }
            case 14: {
                n2 = 0x808000;
                break;
            }
            case 15: {
                n2 = 0xC0C0C0;
                break;
            }
            case 16: {
                n2 = 0x808080;
            }
        }
        return Color.win32_new(this, n2);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int n = OS.GetStockObject(13);
        return Font.win32_new(this, n);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        if (!OS.IsWinCE) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.ScriptGetProperties(nArray, nArray2);
            this.scripts = new int[nArray2[0]];
            OS.MoveMemory(this.scripts, nArray[0], this.scripts.length * OS.PTR_SIZEOF);
        }
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 38);
        int n3 = OS.GetDeviceCaps(n, 12);
        int n4 = OS.GetDeviceCaps(n, 14);
        if ((n2 & 0x100) == 0 || (n3 *= n4) != 8) {
            this.internal_dispose_GC(n, null);
            return;
        }
        int n5 = OS.GetDeviceCaps(n, 106);
        int n6 = OS.GetDeviceCaps(n, 104);
        if (OS.IsWinCE && n5 == 0 && n6 >= 20) {
            n5 = 20;
        }
        this.colorRefCount = new int[n6];
        byte[] byArray = new byte[4 + 4 * n6];
        byArray[0] = 0;
        byArray[1] = 3;
        byArray[2] = 0;
        byArray[3] = 1;
        byte[] byArray2 = new byte[4 * n6];
        OS.GetSystemPaletteEntries(n, 0, n6, byArray2);
        System.arraycopy(byArray2, 0, byArray, 4, 4 * n6);
        int n7 = 0;
        while (n7 < n5 / 2) {
            this.colorRefCount[n7] = 1;
            this.colorRefCount[n6 - 1 - n7] = 1;
            ++n7;
        }
        this.internal_dispose_GC(n, null);
        this.hPalette = OS.CreatePalette(byArray);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        if (OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            return OS.AddFontResourceEx(tCHAR, 16, 0) != 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == null) {
                    this.objects[n] = object;
                    this.errors[n] = new Error();
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    protected void release() {
        if (this.gdipToken != null) {
            Gdip.GdiplusShutdown(this.gdipToken[0]);
        }
        this.gdipToken = null;
        this.scripts = null;
        if (this.hPalette != 0) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
    }
}

