# Roadmap for 2024 and a retrospective for 2023

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/3564)

<!-- toc -->

## Table of contents

-   [Abstract](#abstract)
-   [Proposal](#proposal)
-   [Retrospective on 2023](#retrospective-on-2023)

<!-- tocstop -->

## Abstract

We propose a roadmap for 2024 focused on a working Carbon toolchain that
supports Carbon ↔ C++ interop.

## Proposal

We propose the following goals for 2024:

-   Implementing enough in the toolchain to build meaningful code on the Carbon
    side of interop.
-   Teaching the toolchain to compile enough C++ code (by way of Clang) to build
    meaningful code on the C++ side of interop.
-   Implementing the interop itself between Carbon and C++ code.
-   Sharing various aspects of this with the broader Carbon, C++, and open
    source communities.

This focuses significantly more on implementation than we have done in previous
years, which is a response to feedback that folks looking at Carbon and trying
to evaluate or contribute are increasingly blocked on the lack of implementation
support -- either of language features or compiler functionality. We also think
the design is far enough along to support this level of implementation, making
it an effective time to adopt this more focused roadmap.

The full details are in the updated [roadmap] document.

[roadmap]: /docs/project/roadmap.md

## Retrospective on 2023

Our [roadmap for 2023] focused on getting both the language and tools ready for
evaluation, and building of context in the C++ community to support that
evaluation. We executed on this really well, but with mixed results.

[Roadmap for 2023]:
    https://github.com/carbon-language/carbon-lang/blob/840cb1bed7cf9bd57e000cb4a61e986c383d3038/docs/project/roadmap.md

On getting ready for evaluation, we made fantastic progress on getting the
language (design) ready. We have [milestone definitions], and closed the most critical
gaps in the design from the start of the year. The remaining gaps are either lower
risk, almost finished, or really need interop to effectively explore.

[milestone definitions]: /docs/project/milestones.md

The tooling side also made fantastic progress, but has a lot further to go and
forms the focus for 2024.

We also engaged more deeply with the C++ community on the technical
underpinnings, but the response highlighted that until we have (much) more
complete tooling, we're going to struggle to deepen our engagement with the
external community, and especially struggle to broaden that engagement to larger
communities.

Both the amount remaining on the tooling side of things, and the fact that it
has proved a limiting factor in external engagement, are driving our priorities
for this year.

Breaking down the specific key results we aimed at for 2023:

-   A concrete definition of our MVP for evaluation, the 0.1 language
    -   [Done][mvp-milestone]!
-   Complete design coverage of the 0.1 language's necessary features
    -   High risk, non-interop features are mostly done! The rest is taking a
        back seat to getting the toolchain & interop ready.
-   Complete 0.1 language implementation in the Carbon Explorer
    -   There was nuance in this result: we only needed to complete as much
        design validation as needed to have confidence in the design's cohesion
        and behavior. We think the explorer got there in 2023 and have
        [pivoted][toolchain-pivot] fully to the toolchain, so this is somewhat
        by construction done.
-   A toolchain that can build a minimal mixed C++ and Carbon program
    -   As called out in the 2023 roadmap, we didn't expect to be able to
        complete this by the end of 2023, and indeed, this has turned into our
        focus for 2024.
-   Give talks at 2-3 conferences covering 3-4 different Carbon topics
    -   We only got to one conference, but we did cover 3+ topics this year.
        We're hoping as we have a more complete toolchain we'll have more
        relevant topics for more conferences.

[mvp-milestone]:
    /docs/project/milestones.md#milestone-01-a-minimum-viable-product-mvp-for-evaluation
[toolchain-pivot]: /proposals/p3532.md

Overall, 2023 was pretty amazing, and we hit some of the most important
milestones in the project over the past year.
