# Introduce a new Conduct Team

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/####)

<!-- toc -->

## Table of contents

-   [Abstract](#abstract)
-   [Problem](#problem)
-   [Background](#background)
-   [Proposal](#proposal)
-   [Details](#details)
    -   [Strategy for a sustainable Conduct Team](#strategy-for-a-sustainable-conduct-team)
    -   [What we are looking for in Conduct team members](#what-we-are-looking-for-in-conduct-team-members)
    -   [Initial team members](#initial-team-members)
    -   [Process](#process)
-   [Rationale](#rationale)
-   [Alternatives considered](#alternatives-considered)
    -   [Make no changes](#make-no-changes)
    -   [Have some overlap between Carbon leads and the Conduct team](#have-some-overlap-between-carbon-leads-and-the-conduct-team)
    -   [Keep the restriction on new conduct team members accessing prior reports](#keep-the-restriction-on-new-conduct-team-members-accessing-prior-reports)

<!-- tocstop -->

## Abstract

The Carbon Project relied on the three leads to handle conduct concerns
initially as it bootstrapped its community team and expertise. We now have an
active and effective community lead and team of moderators. Our community lead
has worked to train and ramp up a new and independent conduct team.

This proposal both provides an overview of the process and hands off conduct
handling to the new team! Going forward, we expect routine updates to the
conduct team to happen without full proposals as they allow trained folks to
rotate in and out of this difficult but essential role on the project.

Last but not least, making these changes uncovered a restriction in the Code of
Conduct itself that we expect to be problematic to adhere to going forward.
While well intentioned, it has a bunch of unanticipated effects that made both
current and new conduct teams want to remove it. A related section has had its
wording strengthened to try and address the underlying motivation at least
partially.

## Problem

-   Our Code of Conduct team is made up of those with the highest power in the
    community (Carbon leads), and our current framework does not allow for clear
    accountability in terms of their own conduct due to this lack of separation.
-   The diversity of backgrounds and perspectives is limited among our current
    CoC team.
-   The Carbon leads have limited time and availability to intervene in urgent
    and important misconduct situations.

So, it is time to build a specialized team to deal with escalations which is not
subordinate to the Carbon leads, and is able to handle diverse misconduct
escalations in an adequate and timely manner. This means we can recruit and/or
train people from diverse backgrounds to handle such escalations for the Carbon
community, and provide competent support to the leads, the rest of the
moderation team, and everyone else in the community.

## Background

Our Code of Conduct:
https://github.com/carbon-language/carbon-lang/blob/trunk/CODE_OF_CONDUCT.md

Our current CoC team:

-   Chandler Carruth (@chandlerc on Discord and GitHub)
-   Kate Gregory (@KateGregory on Discord and GitHub)
-   Richard Smith (@zygoloid on Discord and GitHub)

## Proposal

Create a new [Conduct Team](/docs/project/teams/conduct_team.md) as follows:

-   Recruit and train 5+ potential new conduct team members to deal with
    conduct-related escalations on behalf of and for the Carbon community, and
    replace the current CoC team as soon as enough members are ready.
-   We should always have at least 3 conduct team members available to respond
    promptly, even factoring in vacations, getting sick, or other normal
    disruptions.
-   Subsequent updates to the exact members will be managed by the new conduct
    team themselves, and without full proposals but just PRs to update the
    relevant documentation.

Also remove a restriction on how reports are shared with new conduct team
members going forward (but _not_ retroactively, which would violate our past
promise). While this restriction was well intentioned, it isn't a restriction
that the conduct team can effectively uphold going forward. For example, it
would prevent informing new conduct team members of people banned because of
bad-faith reports. We understand that reports are sensitive, and have
strengthened our statements around keeping them confidential and only using them
as needed.

## Details

### Strategy for a sustainable Conduct Team

The Carbon community needs a **distinct, qualified, empowered, and diverse**
Code of Conduct team.

This crucial and particularly straining work needs to be shared among the team,
so all members get enough support and rest. The proposal is for a member
rotation strategy. Carbon's long-term goal should be to have 5+ trained Conduct
Team members, so at least 3 are available to discuss and act upon incident
reports in a timely and adequate manner.

The initial team was recruited by our Community lead and pulls from the current
trained moderator pool. We propose that the Conduct team itself is responsible
to continue recruiting both new Conduct team members and new moderators to make
both efforts sustainable. They will work toward better representation, embracing
both broad and intersectional diversity.

### What we are looking for in Conduct team members

Team members need a track record showing:

-   Effective and constructive engagement with online, technical, and/or
    open-source software communities
-   Advanced moderation and mediation skills
-   Intercultural competence
-   Extensive knowledge of human diversity and systemic discrimination forms
-   Proficient written English communication skills

Other essential things we prioritize for all team members:

-   Kindness
-   Thoughtfulness, including while dealing with highly sensitive information
-   Prioritizing the most vulnerable
-   Readiness to have uncomfortable conversations, including sparking them
-   Resilience in the face of abuse, including when becoming a target
-   Verified Discord and GitHub user account
-   Readiness to use Google Drive collaboration tools
-   Readiness to deal with every escalation reported to the team while on duty

High-value things we look for but are not necessary:

-   Personal experience of marginalization in tech communities (for example
    based on ability/disability, race/ethnicity, gender identity, lifestyle,
    first language, etc.)
-   Already active in the C++ or Carbon community
-   Figure of authority in some relevant domain
-   Non-corporate working experience

Note that it is _not_ important to be good at coding or a native English speaker
to be effective as a member of the team.

### Initial team members

-   Allison Poppe (@acpoppe on Discord and GitHub)
-   Céline Dedaj (@celineausberlin on Discord and GitHub)
-   Christopher Di Bella (@cjdb on Discord and GitHub)
-   Lexi Bromfield (@lexinadia on Discord and @lexi-nadia on GitHub)
-   flysand (@flysand on Discord and @flysand7 on GitHub)

### Process

Selection and sourcing:

-   Candidates were identified and recruited by our Community lead.
-   Candidates met with both Carbon leads and the Community lead individually to
    make sure everyone was comfortable with the role and responsibilities
    involved.

Onboarding and support:

-   New members will have access to coaching and mentoring from the Community
    lead as a diversity, equity and inclusion specialist, and general support by
    a senior moderation team member.
-   The project organizes regular informal moderation meetups to learn with and
    from each other, including a book club.

Exit:

-   This work tends to be straining and that each person's involvement may only
    be temporary.
-   Both the Carbon leads and the newly formed conduct team will make sure that
    individual conduct team members feel safe to leave the team and community
    when they need to step out by developing a bench of candidates.

## Rationale

-   [Community and culture](/docs/project/goals.md#community-and-culture)
    -   The Carbon project needs to have an effective and scalable process for
        handling conduct concerns to continue to be an inclusive and welcoming
        community.
    -   Having a separate team focused on these concerns both enables more
        specialized skills and can provide a more effective path to hold the
        Carbon leads accountable to the same conduct standards.

## Alternatives considered

### Make no changes

This would leave the fundamental problems of both scale and external
accountability unresolved.

### Have some overlap between Carbon leads and the Conduct team

We considered having some amount of overlap between the leads and the conduct
team on an ongoing basis. While this would help ensure that the Carbon leads are
aware and attending to the community, culture, and conduct needs of the project,
it ultimately had a number of disadvantages that made us decide to have a fully
separate team:

-   The Conduct team can and should focus their energy and leverage their
    special skills at evaluating conduct challenges. This is different from the
    focus, skills, and priorities of the leads.
-   The leads want to encourage the conduct team to hold the leads own conduct
    accountable to the rest of the community, and so want to keep the conduct
    team especially as independent as possible.
-   Even if in practice no conflict arises, having a _visible_ separation is
    valuable to the community to build trust.
-   Having two fully independent groups helps facilitate them each helping,
    supporting, empowering, and when necessary, challenging the other.

### Keep the restriction on new conduct team members accessing prior reports

We considered this, as we are very sympathetic to ensuring community members
feel safe making reports, even though the composition of the conduct team might
change in the future.

Unfortunately, we weren't able to find an effective restriction in this space
that still allowed the conduct team to effectively respond to conduct concerns.
We have tried to further clarify the expectations on the narrow and limited ways
in which it is ever appropriate for this information to be used. Misusing
conduct reports, much like other abuses of the Code of Conduct's process, is
itself a serious violation of the code.
