# Generics overview

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/524)

<!-- toc -->

## Table of contents

-   [Problem](#problem)
-   [Background](#background)
-   [Proposal](#proposal)
-   [Rationale based on Carbon's goals](#rationale-based-on-carbons-goals)
-   [Alternatives considered](#alternatives-considered)

<!-- tocstop -->

## Problem

We want to Carbon to have a high quality generics feature that achieves the
goals set out in [#24](https://github.com/carbon-language/carbon-lang/pull/24).
This is too big a feature to land in a single proposal. This proposal specifies
the feature at the level of an overview description. This overview document is
intended to act as a starting point for people interested in the generics
feature by providing:

-   a high-level description of the generics feature, and
-   pointers to documents that go deeper into individual topics.

## Background

This is a follow on to these previous generics proposals:

-   [Generics goals #24](https://github.com/carbon-language/carbon-lang/pull/24)
-   [Generics terminology #447](https://github.com/carbon-language/carbon-lang/pull/447)

The content for this proposal was extracted from a larger
[Generics combined draft proposal](https://github.com/carbon-language/carbon-lang/pull/36).

## Proposal

This is a proposal to add
[this overview document](/docs/design/generics/overview.md).

## Rationale based on Carbon's goals

Much of this rationale was captured in the
[Generics goals proposal](https://github.com/carbon-language/carbon-lang/pull/24).

## Alternatives considered

Alternatives considered will be in a future proposal. Some of them can be seen
in a rough form in
[#36](https://github.com/carbon-language/carbon-lang/pull/36).
