# Generics terminology

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/447)

## Problem

To talk about generics as a programming language feature, you need a lot of
specialized terminology. We need to agree on the words we are using and their
meaning before we can meaningfully talk about the design of the feature itself.

There a number of problems a glossary solves:

-   Not everyone knows every term, so having a single place to look them up will
    improve the ease of understanding, ease of contributing, and accessibility
    of the project.
-   There may not be widespread agreement on the meaning of some terms. In
    particular, individual programming languages tend to assign very specific
    meanings to terms used within their ecosystem.
-   Some terms may be used in multiple ways, but we only use the term with one
    specific meaning.
-   Some terms are our invention and we need to introduce them.

## Proposal

See the [generics terminology document](../docs/design/generics/terminology.md).

## Rationale

This gives a common vocabulary for discussing the design of the generics
feature.
