# GitHub Discussions

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/444)

<!-- toc -->

## Table of contents

-   [Problem](#problem)
-   [Background](#background)
-   [Proposal](#proposal)
-   [Alternatives considered](#alternatives-considered)
    -   [Keep using Discourse Forums](#keep-using-discourse-forums)
    -   [Try to maintain history](#try-to-maintain-history)
        -   [Caveats](#caveats)
-   [Rationale based on Carbon's goals](#rationale-based-on-carbons-goals)

<!-- tocstop -->

## Problem

Right now we run our own Discourse Forums (broken link:
`https://forums.carbon-lang.dev/`).
[GitHub Discussions](https://docs.github.com/en/discussions) was recently
released, and should be evaluated for appropriateness as a replacement.

## Background

[GitHub Discussions](https://docs.github.com/en/discussions) is a new forum
solution offered by GitHub. Although it was initially only for public
repositories, as of March, it is
[available to private repositories](https://github.blog/2021-03-09-github-discussions-now-available-for-private-repositories/).

Developers can
[preview in carbon-lang](https://github.com/carbon-language/carbon-lang/discussions).

Discourse Forums (broken link: `https://forums.carbon-lang.dev/`) are currently
used by Carbon. These run on a Google Cloud instance owned by Carbon team.

## Proposal

We should shut down the Discourse Forums and adapt GitHub Discussions to our
needs. GitHub Discussions categories and documentation should be updated
accordingly, alongside evolution process changes.

Discourse Forums should be frozen and eventually shut down once we are confident
in the switch. History can manually copied from the frozen instance as needed,
and discarded otherwise.

## Alternatives considered

### Keep using Discourse Forums

Advantages:

-   Discourse's UI is better in some places:
    -   Easy drag-and-click UI for quoting.
    -   Easy to navigate to the original post of a quote.
    -   Less noisy notifications because it's separate from other discussion,
        such as issues and PRs.
        -   However, notifications will all be in one place.
    -   Preview is visible while writing, whereas GitHub uses a tab.
    -   More advanced search support.
-   Discourse Forums has categories and subcategories.
    -   GitHub Discussions only has categories.
-   Discourse Forums has controllable settings for many things.
    -   GitHub Discussions offers fewer options, although simplicity is
        sometimes better.
-   Keeps existing history.
-   [Swift](https://forums.swift.org/) and [Rust](https://users.rust-lang.org/)
    are prominent examples also using Discourse.
-   Avoids handing more control to GitHub.

Disadvantages:

-   GitHub's UI is better in some places:
    -   Responses to responses are threaded in-place, which may be appreciated
        by some.
    -   Links to issues and PRs will work more seamlessly, with tooltips.
    -   Discourse Forums has nuisance warnings about similar posts and @-ing to
        many people in a group, which cannot be disabled. These get in the way
        of frequent posters.
    -   When copying links, Discourse Forums' URL updates made it easy to
        accidentally link to a specific post; GitHub makes that require a
        deliberate action.
    -   There is direct support for filing issues based on discussions.
    -   Supports voting on posts and sorting by vote, for more types of
        discussions, particularly Q&A.
-   Discourse Forums is a now unnecessary split in communication mechanisms.
    -   GitHub is the only possible direction of consolidation: we already use
        GitHub for issues and PR discussion, and moving that to Discourse is
        infeasible.
-   Running Discourse Forums ourselves requires significant maintenance, and
    [still has configuration issues](https://github.com/carbon-language/carbon-lang/issues/356).

### Try to maintain history

We've deliberately not put much into Discourse Forums, and GitHub issues are
already a focus of discussion. There's not enough history to justify significant
investment into making a copy.

#### Caveats

The contributor wiki (broken link:
`https://forums.carbon-lang.dev/t/contributor-directory-wiki/134/2`) can be
moved to [GitHub's wiki](https://github.com/carbon-language/carbon-lang/wiki).

## Rationale based on Carbon's goals

-   [Community and culture](/docs/project/goals.md#community-and-culture):

    -   GitHub Discussions offers a way to consolidate tools and make community
        forums easier to find.
