# 2021 Roadmap

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/253)

## Objective for 2021: speed up Carbon development

The main objective of the Carbon project in 2021 is to speed up the development
of the project, even while it remains both an experiment and private. This will
require improving at least two dimensions:

-   Increase the investment by existing individuals and organizations.
-   Increase the breadth of different individuals and organizations investing in
    Carbon.

We expect to make progress on this objective in 2021 primarily by making
Carbon's design more concrete and with a more specific and easily understood
value proposition. As a result, our key results are primarily around specific
artifacts that we think will help support the scaling up of Carbon development
efforts.

We also need to identify key missing participants and onboard them
throughout 2021.

## Key results in 2021

There are several milestones that we believe are on the critical path to
successfully achieving our main goal for the year, and point to concrete areas
of focus for the project.

### Broaden core team representation so no organization is >50%

Our goal is that no single organization makes up >50% of the core team to ensure
that we are including as broad and representative a set of perspectives in the
evolution of Carbon as possible.

### Example ports of C++ libraries to Carbon (100% of [woff2](https://github.com/google/woff2), 99% of [RE2](https://github.com/google/re2))

The first part of this result is that all of the woff2 library is ported to
Carbon in a way that exports the same C++ API. There should be no gaps in this
port given that woff2 has a very simple C++ API and uses few C++ language
features.

RE2 is a larger library using significantly more language features. For that
part of the result, fewer than 1% of its C++ lines of code should be missing a
semantically meaningful port into Carbon code.

An important nuance of this goal is that it doesn't include building a complete
Carbon standard library beyond the most basic necessary types. The intent is to
exercise and show the interoperability layers of Carbon by re-using the C++
standard library in many cases and exporting a compatible C++ API to both woff2
and RE2's current API.

While this key result isn't directly tied to the main objective, we believe it
represents a critical milestone for being able to achieve this objective. It
both measures our progress solidifying Carbon's design and demonstrating the
value proposition of Carbon.

Note that both woff2 and RE2 libraries are chosen somewhat arbitrarily and could
easily be replaced with a different, more effective libraries to achieve the
fundamental result of demonstrating a compelling body of cohesive design and the
overarching value proposition.

#### Language design covers the syntax and semantics of the example port code.

We should have a clear understanding of the syntax and semantics used by these
example ports. While this should include accepted proposals, it doesn't
necessarily require either formal specification or implementation.

### Demo implementation of core features with working examples

A core set of Carbon features should be implemented sufficiently to build
working examples of those features and run them successfully. These features
could include:

-   User-defined types, functions, namespaces, packages, and importing.
-   Basic generic functions and types using interfaces.
-   Initial/simple implementation of safety checking including at least bounds
    checking, simple lifetime checking, and simple initialization checking.
-   Sum types sufficient for optional-types to model nullable pointers.
-   Pattern matching sufficient for basic function overloading on types and
    arity, as well as unwrapping of optional types for guard statements.

Stretch goals if we can hit the above:

-   Instantiating a basic C++ template through interop layer for use within
    Carbon.

The demo implementation should also provide demos outside of specific language
features including:

-   Basic benchmarking of the different phases of compilation (lexing, parsing,
    etc).
-   A basic REPL command line.

Stretch goals if we can hit the above:

-   Automatic code formatter on top of the implementation infrastructure.
-   A [compiler explorer](https://compiler-explorer.com/) fork with REPL
    integrated.

Benchmarking at this stage isn't expected to include extensive optimization.
Instead, it should focus on letting us track large/high-level impact on
different phases as they are developed or features are added. They may also help
illustrate initial high-level performance characteristics of the implementation,
but the long term focus should be on end-to-end user metrics.

Automatic code formatting could be achieved many ways, but it seems useful to
ensure the language and implementation both support use cases like formatting.

### Executable semantic specification for core features with test cases

This should include both a human readable rendering of the formal semantics as
well as an execution environment to run test cases through those semantics. The
core features which should be covered by these semantics are:

-   User-defined types, functions, namespaces, packages, and importing.
-   Basic generic functions and types using interfaces.
-   Sum types sufficient for optional-types to model nullable pointers.

This is intentionally a subset of the features covered by the demo
implementation. The intent is to reflect that _completing_ coverage of the
features in the specification is a slightly lower priority, and instead we
should rapidly spike out as complete of a demo as possible and come back to the
semantics if possible.

## Beyond 2021

Longer term goals are hard to pin down and always subject to change, but we want
to give an idea of what kinds of things are expected at a high level further out
in order to illustrate how the goals and priorities we have in 2021 feed into
subsequent years.

### Potential 2022 goals: finish 0.1 language, make it public

We expect that at some point in 2022 we will need to shift the experiment to be
public. This will allow us to significantly expand both those directly involved
and contributing to Carbon but also those able to evaluate and give us feedback.

We don't expect Carbon to shift away from an experiment until after it becomes
public and after we have been able to collect and incorporate a reasonable
amount of feedback from the broader industry and community.

We'll also need to start broadening our scope:

-   Expand the standard library to at least cover everything needed for self
    hosting.
-   Develop initial C++ to Carbon migration tooling.

### Potential 2023 goals: finish 0.2 language, stop experimenting

Once Carbon is moving quickly and getting public feedback, we should be able to
conclude the experiment. We should know if this is the right direction for
moving C++ forward for a large enough portion of the industry and community, and
whether the value proposition of this direction outweighs the cost.

However, there will still be a _lot_ of work to make Carbon into a production
quality language, even if the experiment concludes successfully.

Some concrete goals that might show up in this time frame:

-   Self-hosting toolchain, including sufficient Carbon standard library
    support.
-   Expand design of standard library to include, at least directionally,
    critical and complex areas. For example: concurrency/parallelism and
    networking/IO.
-   Migration tooling sufficient to use with real-world libraries and systems.
    This might be used to help with self-hosting Carbon, as well as by initial
    early adopters evaluating Carbon.

### Potential 2024-2025 goals: _ship_ 1.0 language & organization

A major milestone will be the first version of a production language. We should
also have finished transferring all governance of Carbon to an independent open
source organization at that point. However, we won't know what a more realistic
or clear schedule for these milestones will be until we get closer.

Another important aspect of our goals in this time frame is expanding them to
encompass the broader ecosystem of the language:

-   End-to-end developer tooling and experience.
-   Teaching and training material.
-   Package management.
-   Etc.

## Rationale

By its nature, we're not sure a planning document like this can directly advance
Carbon's goals, but we think this roadmap does a good job of keeping us focused
on the work that will help us generate concrete evidence as to whether Carbon is
likely to successfully achieve those goals (and help us figure out how to
course-correct if it's not). Increasing the representation of non-Googlers on
the core team is an important indicator (as well as enabler) of building an
"open and inclusive community", not to mention of having a broad enough user
base to succeed, and the example ports, demo implementation, and executable
semantics will help us concretely evaluate how well Carbon is meeting all of its
language goals.

In addition, as the proposal argues, concrete evidence that Carbon can succeed
will indirectly help Carbon make faster progress, by motivating further
investment in the project. Some aspects of the roadmap will also help accelerate
Carbon's development in more direct ways. In particular, the executable
semantics implementation should enable Carbon contributors to rapidly prototype
potential new features, which will help us identify and solve more problems at
an earlier stage, and have higher confidence in the proposals we adopt.

While rapid progress is not an explicit goal of the Carbon project, Carbon can't
meet any of its other goals until it exists in a usable form, and the longer it
takes to reach that point, the less likely it is to reach it at all.
