# Create a toolchain team.

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/179)

<!-- toc -->

## Table of contents

-   [Problem](#problem)
-   [Background](#background)
-   [Proposal](#proposal)
    -   [Scope](#scope)
-   [Rationale](#rationale)
    -   [Open questions](#open-questions)
        -   [Should the name of the team be "toolchain team" or "implementation team"?](#should-the-name-of-the-team-be-toolchain-team-or-implementation-team)

<!-- tocstop -->

## Problem

The development of a toolchain for Carbon needs a team of people to oversee it.
This will primarily involve code reviews and ensuring the quality of the end
toolchain, and includes significant work around compile time efficiency as well
as developing a cohesive set of libraries for use in developer tools and other
contexts.

## Background

This is largely a technical team that can fluidly evolve over time as people
have time and energy to commit to developing the toolchain's codebase itself.

## Proposal

Create a team from initial volunteers and evolve it over time based on who ends
up contributing. Notably, contributions can be to the design, documentation, and
code _review_ in addition to code or patches themselves.

### Scope

Beyond the traditional components of a language toolchain, this team should also
cover any needed code review and oversight for other implementation efforts
within the Carbon project, such as supporting tools and test suites related to
the language itself.

There may be some overlap between this _language_ infrastructure and the
_project_ infrastructure covered by the
[admins](/docs/project/groups.md#admins). This proposal doesn't suggest a hard
delineation between these, and if in doubt or there is disagreement, it should
be escalated to the [core team](/docs/project/groups.md) rather than spending
too much time defining precisely disjoint scopes.

## Rationale

Carbon's goals include providing a reference implementation and tooling.
Delivering this complex software requires a dedicated team, vision, leadership,
and a degree of autonomy.

### Open questions

#### Should the name of the team be "toolchain team" or "implementation team"?

Some core team members expressed a preference for "implementation team", none
expressed a preference for "toolchain team", all were fine either way. As
gribozavr noted, and everyone at the review meeting agreed, the team should be
free to choose its own name.
