# Change documentation style guide

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/149)

<!-- toc -->

## Table of contents

-   [Problem](#problem)
-   [Background](#background)
    -   [Common deviations](#common-deviations)
-   [Proposal](#proposal)
-   [Details](#details)
    -   [Google developer documentation style guide](#google-developer-documentation-style-guide)
    -   [Microsoft writing style guide](#microsoft-writing-style-guide)
    -   [Word lists](#word-lists)
-   [Alternatives considered](#alternatives-considered)
-   [Rationale](#rationale)
    -   [Painter rationale](#painter-rationale)
    -   [Open questions](#open-questions)
        -   [Which style guide?](#which-style-guide)

<!-- tocstop -->

## Problem

There's disagreement with the current Google developer documentation style
guide. We should make sure the core team has a consensus on the style guide
chosen.

## Background

The status quo is that we use the Google style guide, per
[CONTRIBUTING.md](/CONTRIBUTING.md#style). There's basic support for a style
guide in order to avoid protracted debate about formatting and to maintain basic
consistency.

Key desires for a style guide are:

-   Actively maintained.
-   Freely available for contributors.

### Common deviations

CONTRIBUTING.md notes a couple deviations from the Google style guide. These may
be assumed to apply regardless of the style guide, as the relevant styles are
common to Microsoft's style guide.

## Proposal

A style guide should be chosen. The only candidates found are:

-   Google developer documentation style guide
-   Microsoft writing style guide

This may be done with or without additional modifications, such as the em-dash
exception in CONTRIBUTING.md.

**Open question**: Which style guide?

**Decision**: Google style guide

## Details

A few key items are highlighted from both style guides for comparison.

### Google developer documentation style guide

https://developers.google.com/style

-   **Dates and times**:
    [January 19, 2017 or 2017-04-15 3:45 PM](https://developers.google.com/style/dates-times).
-   **Lists**:
    [nuanced guidance for punctuation](https://developers.google.com/style/lists).
-   **Non-English words**: mostly covered through the word list and
    [abbreviations](https://developers.google.com/style/abbreviations).
-   **Punctuation**:
    -   Commas: [Oxford](https://developers.google.com/style/commas).
    -   Parentheses:
        [use judiciously](https://developers.google.com/style/parentheses).
    -   Semicolons:
        [use judiciously](https://developers.google.com/style/semicolons).
-   **Word list**:
    -   Letter links, such as
        [i](https://developers.google.com/style/word-list#letter-i).
    -   Easy to skim comments on words.

### Microsoft writing style guide

https://docs.microsoft.com/en-us/style-guide/welcome/

-   **Dates and times**:
    [February 16, 2016, 3:45 PM](https://docs.microsoft.com/en-us/style-guide/global-communications/time-place#dates).
    [Only use digits for dates in locale-customized UIs](https://docs.microsoft.com/en-us/style-guide/a-z-word-list-term-collections/term-collections/date-time-terms).
-   **Lists**:
    [use a period if any item is a complete sentence](https://docs.microsoft.com/en-us/style-guide/scannable-content/lists).
-   **Non-English words**:
    [avoid](https://docs.microsoft.com/en-us/style-guide/word-choice/use-us-spelling-avoid-non-english-words).
-   **Punctuation**:
    -   Commas:
        [Oxford](https://docs.microsoft.com/en-us/style-guide/punctuation/commas).
    -   Parentheses:
        [no guidance, sentence-length parenthetical examples](https://docs.microsoft.com/en-us/style-guide/punctuation/formatting-punctuation).
    -   Semicolons:
        [avoid](https://docs.microsoft.com/en-us/style-guide/punctuation/semicolons).
-   **Word list**:
    -   Letter links and individual word links, such as
        [illegal](https://docs.microsoft.com/en-us/style-guide/a-z-word-list-term-collections/i/illegal).
    -   No way to skim comments on words; each needs to be read individually.

### Word lists

> NOTE: Due to the noted lack of support for skimming Microsoft's word list, it
> may be that Microsoft has other noteworthy guidance for terms that Google
> doesn't.

<!-- google-doc-style-ignore -->

above

: Google: Use preceding.

: Microsoft: "Use previous, preceding, or earlier."

and so on

: Google: See etc.

: Microsoft: "Use such as or like."

below

: Google: Use following.

: Microsoft: "Use a link, or use later or the following."

blacklist

: Google: Use blocklist.

: Microsoft: "Use block list instead. Note that block list is two words."

cons

: Google: Use disadvantages.

: Microsoft: No guidance.

CLI

: Google: Use command-line tool.

: Microsoft: No guidance.

client

: Google: Short for "client app", say "library" for "client library".

: Microsoft: Use customer to refer to people.

e.g.

: Google: Use for example or such as. Too many people mix up e.g. and i.e.

: Microsoft: "Use for example, such as, or like, as appropriate."

etc.

: Google: Avoid if possible, but use instead of and so on.

: Microsoft: "Use such as or like followed by an example or two."

filename, file name

: Google: one word.

: Microsoft: two words.

file name extension, extension

: Google: No guidance, but "filename extension" is used in the guide.

: Microsoft: Use instead of file extension.

flag

: Google: Use option.

: Microsoft: No guidance.

for instance

: Google: Use for example or such as.

: Microsoft: No guidance.

i.e.

: Google: Use that is.

: Microsoft: Use that is.

illegal

: Google: No guidance.

: Microsoft: "Don't use to mean invalid or not valid."

just

: Google: Don't use.

: Microsoft: No guidance.

master/slave

: Google: Use master with caution. Don't use slave. Multiple alternatives given.

: Microsoft: Don't use master/slave. Multiple alternatives given.

native

: Google: Avoid and use more precise terms when possible, such as "built-in".

: Microsoft: Only guidance is for native language. "Don't use to refer to a
computer system's machine language. Use machine language or host language
instead."

pros

: Google: Use advantages.

: Microsoft: No guidance.

quick

: Google: Avoid.

: Microsoft: No guidance.

regex

: Google: Use regular expression.

: Microsoft: No guidance.

repo

: Google: Use repository.

: Microsoft: No guidance.

should

: Google: Avoid because it's ambiguous.

: Microsoft: "Before using should or must, consider other ways to discuss
recommendations or requirements."

simple, simply

: Google: Avoid; "what might be simple for you might not be simple for others."

: Microsoft: Only guidance is for simply; nothing for simple. "Don't use to mean
that something is easy to do."

tl;dr

: Google: Use to summarize.

: Microsoft: No guidance.

traditional

: Google: Avoid.

: Microsoft: No guidance.

via

: Google: Don't use.

: Microsoft: No explicit guidance, but might be considered to fall under
non-English words.

vice versa

: Google: Use other way around or conversely.

: Microsoft: No explicit guidance, but might be considered to fall under
non-English words.

vs.

: Google: Use versus.

: Microsoft: Use versus.

<!-- google-doc-style-resume -->

## Alternatives considered

Various offline resources like the Chicago Manual of Style may be helpful to
some, but require a subscription or physical copy, and so are less useful as
canonical resources for contributors.

## Rationale

The core team reached consensus that there should be a style guide, but did not
have a strong preference between the Google style guide and the Microsoft style
guide. One advantage of the Microsoft style guide is that it is less
Google-centric, which could contribute somewhat to our community goal. Given the
level of experience of the core team members with these style guides, it is not
clear that a well-informed decision could be made. As such, the core team
decided to leave the decision of the specific style guide up to the Painter.

### Painter rationale

Given the lack of a high level reason to pick one over the other, the painter
looked at the available tooling for linting against the two options and spoke
with people who have written substantial developer documentation against both
style guides. There was no persuasive reason to change from the Google
documentation style guide at this time. Specific ambiguities or problems with
that style guide should instead be addressed, if necessary at all, with
Carbon-specific local rule.

### Open questions

#### Which style guide?

The core team decided to let the Painter choose the style guide to be used. The
painter selected to continue using the Google documentation markdown style
guide.
