# Goals

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/51)

<!-- toc -->

## Table of contents

-   [Problem](#problem)
-   [Background](#background)
-   [Proposal](#proposal)
    -   [Including success criteria](#including-success-criteria)
-   [Alternatives](#alternatives)
    -   [Change priority of interoperability and migration](#change-priority-of-interoperability-and-migration)
    -   [Address project goals differently](#address-project-goals-differently)
        -   [Status quo](#status-quo)
        -   [Completely remove the community priority from this document](#completely-remove-the-community-priority-from-this-document)
        -   [Add project goals to the priority list](#add-project-goals-to-the-priority-list)
        -   [Merge project goals and language goals](#merge-project-goals-and-language-goals)
-   [Rationale](#rationale)
    -   [Open questions](#open-questions)

<!-- tocstop -->

## Problem

We want to have clear goals for the Carbon project, to both establish and
document where we expect Carbon to be headed. These are aspirational goals, and
we will try our best to achieve all of them. The documented goals should make it
easier for potential users to determine whether Carbon is an appropriate fit for
them.

## Background

Carbon's goals are heavily based on
["Goals and priorities for C++"](https://docs.google.com/document/d/1jrpGk6Sa0bt1u1tSuZtPnVI3inr7A4c0iJC9V2I6zUA/edit).
Many thanks to the authors and contributors for helping us formulate our goals
and priorities.

This proposal was drafted in
[Docs](https://docs.google.com/document/d/1MJvVIDXQrhIj6hZ7NwMDbDch9XLO2VaYrGq29E57meU/edit).

## Proposal

The proposed goals are encapsulated in
[the goals changes](/docs/project/goals.md).

### Including success criteria

The goals are currently a series of rough goals, with no specific metrics to
measure them by. We've discussed adding metrics, and decided not to include them
in the goals; the expectation is that they'll be added separately as a
principle.

This proposal includes
[success criteria](/docs/project/principles/success_criteria.md) covering:

-   Platforms
-   Migration tooling

It should be expected that more will be added in the future.

## Alternatives

### Change priority of interoperability and migration

Right now, interoperability/migration is priority #7, indicating that when
trade-offs are necessary, interoperability is likely to suffer. At least some
parties believe it should be somewhere in the top 3 priorities, perhaps #1.
Overall, we believe a consensus can be formed around keeping
interoperability/migration as #7, so long as there are clear minimum
expectations for interoperability.

Part of the priority conflict may be an interpretation that there will only
rarely be compromises between goals, irrespective of the priority of
interoperability. For example, considering the readability of C++
interoperability syntax, it could be viewed in two ways:

1. An edge-case syntax that can be avoided in most code, thus not significantly
   affecting the readability goal.
2. A readability issue that risks making _all_ code less readable, representing
   the interoperability goal as subverting the readability goal, in which case
   either interoperability must be higher priority than readability, or we must
   have no interoperability.

While the proposers prefer the first interpretation, the second all-or-nothing
interpretation may be what's leading to the desire of treating interoperability
as a higher priority.

Overall, we would present the advantages and disadvantages as:

Advantages:

-   There is a consensus that interoperability is critical. Making it the top
    goal emphasizes that.

Disadvantages:

-   While interoperability is critical, the same is true of other goals; this
    isn't enough to determine priority.
-   There are trade-offs between goals where there is already a consensus that
    interoperability will be diminished in favor of other goals, and there
    aren't as many clear cases in the other direction.
    -   Taken to extremes, making interoperability and migration a higher
        priority than evolution would suggest that Carbon should start with C++
        and incrementally evolve from that base. We have observed areas where
        C++ has had trouble evolving, and Carbon would risk getting stuck on
        similar local maxima in order to avoid breaking existing code.

For example of where trade-offs may be seen right now:

-   Carbon's set of primitive types won't match C++'s list; we currently expect
    multiple C++ types to map to single Carbon types. This could be considered a
    conflict with multiple priorities:
    -   #2: Carbon's leaning for fewer types should make evolution of the
        language easier.
    -   #3: Carbon code will be easier to read and understand with fewer types.
-   When considering `Int` vs `int`, Carbon's plans do not mirror C++. This
    could be considered a conflict with multiple priorities:
    -   #1: Carbon's primary types, such as `Int`, should be allowed to replace
        C++-specified overflow behaviors with alternatives that are higher
        performance.
    -   #3: Avoiding platform-specific types should make it easier to understand
        how could will function on various platforms.
    -   #4: Carbon's plan for `Int` trapping where C++ would overflow should
        make code safety easier.
-   We expect platform support priorities to differ between C/C++ and Carbon.
    This is a conflict with Carbon's #6 priority, which focuses support on
    modern over legacy platforms.
-   C++'s preprocessor macros will be replaced by metaprogramming in Carbon.
    It's not clear what migration of code using macros will look like, but some
    will likely be expanded by automation. This could be considered a conflict
    with multiple priorities:
    -   #2: Structured metaprogramming should make it easier to evolve software.
    -   #3: Metaprogramming should be easier to read than preprocessor macros.
-   Templates have been argued as only being added for
    interoperability/migration, and that we could only have generics without
    that goal. This is not considered a conflict between goal priorities.
    -   This could be considered a conflict with priority #3, because templates
        are hard to read and understand. However, templates don't constrain
        other parts of the language. While they may have readability or other
        problems, they aren't core or required in the way that other elements
        are, including primitive types.

### Address project goals differently

A concern was raised that, while the "Governance and evolution" doc calls for
all decisions to be justified by goals, there was no clear goal to justify the
existence of things like a code of conduct. Similarly, if performance is the
highest priority, then one might decide that retaining a performance expert may
take priority over addressing their bad behavior.

To address this issue, project goals were added. They are not explicitly part of
the numeric priority list. However, while we expect a ranking of language goals
in order to weigh tradeoffs in the language design, we see project goals as
orthogonal to language design.

#### Status quo

The project goals could be addressed as-is in the proposal.

#### Completely remove the community priority from this document

We could completely remove the project goals from this document.

Advantages:

-   Allows this to be the "language goals" document.

Disadvantages:

-   Creates additional documents that need to be understood to parse language
    goals.
-   Makes for less clear prioritization of community, increasing ambiguity on
    how community vs language design conflicts can be resolved.

#### Add project goals to the priority list

We could make the project goals part of the priority list.

Advantages:

-   Makes the ordering unambiguous.

Disadvantages:

-   Makes what's currently a numerated list of language design goals less
    design-focused.
-   Prevents saying trivial things like "performance is our top priority".
    -   Unless community isn't the top priority, re-creating the conflict risk
        that led to the creating of these project goals.

#### Merge project goals and language goals

Originally, we only had one goals and priorities section. We could re-merge
project goals and language goals.

Advantages:

-   Makes the document shorter and more concise.
-   Tooling can already be considered a priority under "Code that is easy to
    read, understand, and write", and is explicitly mentioned as part of that
    goal.

Disadvantages:

-   Previous setup raised objections over why the community goal wasn't part of
    the priority list.

## Rationale

A concrete set of goals is essential to ensure that contributors to the Carbon
project are working in the same direction, and as a guide for what constitutes
progress in every aspect of the project. It is important to have a coherent,
agreed-upon vision and direction for a programming language, as a social
contract between people who work on it and people who use it. The goals listed
have been iterated on for many months by many parties.

These goals reflect not only the kind of community and language that the core
team would like to build, but also the kind of community and language that a
large population of C++ users have been asking for from C++ itself. As a
consequence, this particular set of goals seems like an important direction in
which to experiment with a candidate future for C++ itself. By doing so, it will
address a specific group of C++ users.

While there may be some uncertainty about resolving conflicts between goals,
particularly migratability and C++ interoperability, the core team feels that
they are generally in alignment in this regard. The priority among goals can be
revised as needed based on the experience of using it in practice.

### Open questions

There were no open questions. GitHub issue
[106](https://github.com/carbon-language/carbon-lang/issues/106) contains points
to be considered and, if necessary, resolved in a subsequent proposal.
