# Proposal tracking

<!--
Part of the Carbon Language project, under the Apache License v2.0 with LLVM
Exceptions. See /LICENSE for license information.
SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
-->

[Pull request](https://github.com/carbon-language/carbon-lang/pull/44)

<!-- toc -->

## Table of contents

-   [Problem](#problem)
-   [Background](#background)
-   [Proposal](#proposal)
    -   [Overview](#overview)
    -   [Open question: Do we use a Google Docs-centric or GitHub Markdown-centric flow?](#open-question-do-we-use-a-google-docs-centric-or-github-markdown-centric-flow)
        -   [Option: Google Docs-centric flow](#option-google-docs-centric-flow)
            -   [Overview](#overview-1)
            -   [Flow summary](#flow-summary)
            -   [Advantages/Disadvantages](#advantagesdisadvantages)
        -   [Option: GitHub Markdown-centric flow](#option-github-markdown-centric-flow)
            -   [Overview](#overview-2)
            -   [Flow summary](#flow-summary-1)
            -   [Advantages/Disadvantages](#advantagesdisadvantages-1)
-   [Details](#details)
    -   [Carbon language shared drive](#carbon-language-shared-drive)
        -   [Main shared drive](#main-shared-drive)
        -   [Proposals (shared folder)](#proposals-shared-folder)
        -   [Proposal Archive (folder in shared drive)](#proposal-archive-folder-in-shared-drive)
    -   [Google Docs proposal ACLs](#google-docs-proposal-acls)
-   [Markdown-specific questions](#markdown-specific-questions)
    -   [Open question: Where should proposals be stored in GitHub?](#open-question-where-should-proposals-be-stored-in-github)
        -   [Option: Proposal archive GitHub repository (carbon-proposals)](#option-proposal-archive-github-repository-carbon-proposals)
        -   [Option: Store proposals in the repository they affect](#option-store-proposals-in-the-repository-they-affect)
    -   [Open question: Should we push comments to focus on GitHub?](#open-question-should-we-push-comments-to-focus-on-github)
        -   [Common principles](#common-principles)
        -   [Option: Push high-level comments to Discourse Forums](#option-push-high-level-comments-to-discourse-forums)
        -   [Option: Push high-level comments to GitHub](#option-push-high-level-comments-to-github)
        -   [Option: Give no guidance, see what happens](#option-give-no-guidance-see-what-happens)
    -   [Open question: Should there be a tracking issue?](#open-question-should-there-be-a-tracking-issue)
        -   [Common principles](#common-principles-1)
        -   [Option: Tracking issue for all proposals](#option-tracking-issue-for-all-proposals)
        -   [Option: Don't require tracking issues](#option-dont-require-tracking-issues)
    -   [Open question: Should declined/deferred proposals be committed?](#open-question-should-declineddeferred-proposals-be-committed)
        -   [Common principles](#common-principles-2)
        -   [Option: Do not commit declined/deferred proposals](#option-do-not-commit-declineddeferred-proposals)
        -   [Option: Commit declined/deferred proposals](#option-commit-declineddeferred-proposals)
-   [Alternatives considered](#alternatives-considered)
    -   [Use a shared drive for everything](#use-a-shared-drive-for-everything)
-   [Appendix](#appendix)
    -   [General concern about multiple Markdown flavors](#general-concern-about-multiple-markdown-flavors)
    -   [Google Docs vs GitHub comment flow comparison](#google-docs-vs-github-comment-flow-comparison)
        -   [Comment clustering](#comment-clustering)
        -   [Basic comments](#basic-comments)
        -   [Suggesting edits](#suggesting-edits)
    -   [Google Docs add-ons](#google-docs-add-ons)
        -   [Docs to Markdown](#docs-to-markdown)
        -   [Code blocks](#code-blocks)
        -   [Advanced Find & Replace](#advanced-find--replace)
    -   [Markdown editing](#markdown-editing)
        -   [StackEdit](#stackedit)
    -   [GitHub Markdown syntax highlighting](#github-markdown-syntax-highlighting)
-   [Rationale](#rationale)
    -   [Rationale for using a GitHub markdown-centric flow](#rationale-for-using-a-github-markdown-centric-flow)
    -   [Rationale for not requiring tracking issues](#rationale-for-not-requiring-tracking-issues)
    -   [Rationale for not committing proposals that are declined or deferred](#rationale-for-not-committing-proposals-that-are-declined-or-deferred)
    -   [Rationale for committing a proposal to the repository it affects](#rationale-for-committing-a-proposal-to-the-repository-it-affects)
    -   [Rationale for pushing high-level comments to GitHub](#rationale-for-pushing-high-level-comments-to-github)
    -   [Open questions](#open-questions)
        -   [Do we use a Google Docs-centric or GitHub Markdown-centric flow?](#do-we-use-a-google-docs-centric-or-github-markdown-centric-flow)
        -   [Where should proposals be stored in GitHub?](#where-should-proposals-be-stored-in-github)
        -   [Should we push comments to focus on GitHub?](#should-we-push-comments-to-focus-on-github)
        -   [Should there be a tracking issue?](#should-there-be-a-tracking-issue)
        -   [Should declined/deferred proposals be committed?](#should-declineddeferred-proposals-be-committed)

<!-- tocstop -->

## Problem

How should we:

-   Draft proposals?
-   Store under review proposals?
-   Archive proposals?

Each of these is a distinct, important step. We may be able to use the same
storage for multiple steps.

## Background

One thing that is _not_ under question is that we will have accepted proposals
in Markdown. This is critical, as we are essentially only delaying when a
proposal goes to Markdown.

The evolution process expects that community contributors will author proposals
for review by the core team. Things to consider are:

-   How easy is it for an author to write a proposal?
    -   What if there are multiple contributors to a proposal?
-   How easy is it to comment on a proposal?
    -   What about small typo fixes?
-   How do we prevent unwanted edits during the comment process?
-   How much work does it take to convert a proposal into a final doc edit?
-   How do we prevent edits after a decision is complete?

In any situation, it's necessary that proposals be clearly contributed to Carbon
(even if in a draft phase, even if never accepted), and have an appropriate
license attached.

Although the evolution document currently makes statements about how to manage
proposals, changes in approval from this doc may affect the evolution process.
Explicit wording changes aren't outlined here because they are assumed to be
part of executing this proposal rather than the substance of this proposal.

For reference, a version of this proposal is also available in GitHub (broken
link:
`https://github.com/carbon-language/carbon-proposals/blob/d1946fab824742b4857fa74ffc1b9fe9af37375d/proposals/p0001.md`).

## Proposal

### Overview

This proposal presents two possible flows: one Google Docs-centric, one
Markdown-centric. This is an open question.

In either case, it's assumed that we will want a Carbon language shared drive
for any Google Docs we may create, and a Proposal archive GitHub repository.

### Open question: Do we use a Google Docs-centric or GitHub Markdown-centric flow?

**Decision:** GitHub Markdown-centric flow

All documents will end up in Markdown. Some members of the core team have a
stated preference for reviewing proposals in Google Docs, and some have a
preference for Markdown. No other clear options exist. This would yield two
possible flows:

#### Option: Google Docs-centric flow

##### Overview

-   Draft proposals: Google Docs
-   Under review proposals: Google Docs
-   Archive proposals: Google Docs + PDF
-   Final format: Markdown

##### Flow summary

For reviewing a proposal:

-   Authors create a Google Doc in the Proposals shared folder.
    -   Authors may want to trim down edit access, leaving only comment access.
-   When ready for review, the authors share the Google Doc on Discourse Forums.
    -   Community comments on the Google Doc.
-   To move for a decision, ownership is transferred to a review manager.
    -   The review manager trims down all access to comment access.
-   When a decision is reached, the review manager updates the doc and moves it
    to the Proposal Archive folder in the Carbon language shared drive.
-   A PDF is saved to the carbon-proposals GitHub repository.
-   The author converts any long-term documentation portions of the doc to
    Markdown.

If the proposal needs to be checked later to figure out why a decision was made:

-   Pragmatically, the PDF should have the same viewable content as the Google
    Doc, and so can be used.
-   The Google Doc's comments will be a mess to read, and so should likely be
    treated as inaccessible later.
-   The edit history of a Google Doc is only visible to users with edit access.
    Since most people will have comment-only or view-only access to reviewed
    docs, we should treat edit history as not accessible.

##### Advantages/Disadvantages

Advantages:

-   Supports collaborative editing.
-   Commenting in Docs is a slightly better UI, even though the commenting
    workflows are equivalent.
-   Images can easily be embedded in the Google Doc, without needing separate
    files.

Neutral:

-   Has an easier [suggested edit workflow](#suggesting-edits) than GitHub.
    -   For commenters, this may be a pro because they can see their suggested
        edit as they make it.
    -   For the author, this is a mixed bag:
        -   When a suggestion is for multiple, fragmented edits, it's harder to
            read.
            -   for example, "foo ~~bar ~~baaz bang~~wiz ~~bing" -> "foo baaz
                bangbing"
        -   It's easier to accept changes.
        -   It's harder to comment on changes, as the change is still visible
            and hiding the original state of the doc.
            -   This is especially true when trying to respond to comments by
                others on a suggested edit, as you can't _both_ have a
                discussion _and_ apply/reject the edit.
        -   It's harder to make alternative edits and/or reject changes, as it
            effectively resolves the comment thread and hinders further
            discussion.
    -   For other readers, this is likely a con: it's harder to read the
        original state of the doc that's been suggested on, and it's not clear
        how the author will respond.

Disadvantages:

-   Documents will go through at least three different file formats (Docs, PDF,
    Markdown).
    -   Docs->Markdown conversion has limited tooling support.
    -   Comment history will be lost on conversions.
    -   Using different formats for proposals and documentation/specification
        creates additional work when pulling text into a proposal to suggest
        modifications, and when applying those modifications.
    -   Any differences between the text in different formats will be difficult
        to notice, particularly if the author makes a change when converting
        long-term documentation from Docs to Markdown.
-   Difficult to manage access control on files.
    -   Docs does not provide access to version history (desirable) without
        granting full edit access (undesirable).
    -   Shared drives combine permissions for adding files to a folder and
        editing files. Permissions can also only be _added_, not _removed_, from
        individual docs. As a result, contributors who can create new proposals
        will also receive the ability to edit all proposals.
    -   Docs will not automatically mirror permissions if we use two different
        sharing systems (shared drive and shared folder).
-   Difficult to archive documents as read-only.
    -   If we set archived documents to be view-only, users won't be able to
        read comments. At that point, the PDF version that we plan to commit to
        the Proposal archive GitHub repository is sufficient, and we could
        delete the proposal.
    -   If we set archived documents to allow commenting, then users can comment
        on and add suggested edits to archived documents. Only review managers
        could close suggested edits. This could confuse the history of the doc,
        and stop archives from looking read-only.
    -   In any case, archived documents would not be editable, and so revision
        history could not be seen.
-   Managing comments over time is infeasible.
    -   It's infeasible to point people to old comment threads, to suggest they
        read and engage if they disagree with the original request.
    -   Even identifying _whether_ a comment led to a particular change is
        infeasible.
    -   Comments vanish if the text they're on is removed.
    -   There is no way to quickly check for unresponded comments: instead,
        authors will need to repeatedly crawl the doc. This is exacerbated by
        process advice that the commenter be left to decide whether to resolve
        comments, or slow-to-respond commenters.
-   No support for seeing deltas.
    -   Only editors can see the delta. However, it should be expected that only
        the author is an editor.
    -   Even if deltas were accessible, Docs delta support requires extra work
        on the part of a doc editor to set up markers in the version history.
-   Restricted support for extensibility.
    -   Proposals frequently have duplicated/boilerplate text that the authors
        may need to rewrite in bulk, for example when renaming something. Google
        Docs has built-in regex search. However, regex replace with capture
        groups isn't directly supported, so users would need to learn and use
        Google Apps Script to do the replacement.
    -   When URLs need to be replaced, Google Docs has _no_ support. Authors
        must audit every URL.
-   No low-friction support for formatted code blocks and inline code snippets.
    -   [Extensions exist](#google-docs-add-ons); we'll probably want to
        recommend a specific extension to the community.
-   Intra-document links break frequently, just from moving headers.
    -   It's also difficult to determine when an intra-document link is broken.
        There doesn't seem to be support (built-in or add-on) for identifying
        issues.
    -   It's also not supported to search through links, so even if the author
        knows what they're breaking, they won't be able to find it.
-   Google Docs comment syntax is essentially text-only.
    -   Syntax can interfere with "\*" insertion in code snippets due to bolding
        confusion.
-   May enhance Google-centric views of Carbon.
    -   Swift and Rust use Markdown-centric flows.
-   Some companies may block Google Docs, because it's a file transfer service.
    -   It's unclear how prevalent this would be. GitHub may also be blocked
        under similar security rules, but it's a requirement for participation
        whereas Google Docs is avoidable.
    -   Ref:
        [[1]](https://community.cisco.com/t5/web-security/blocking-google-docs/td-p/3376518),
        [[2]](https://www.reddit.com/r/sysadmin/comments/2kwyhk/block_google_docs/),
        [[3]](https://mybroadband.co.za/forum/threads/google-drive-blocked-at-work-work-around.809132/)
-   Some individuals may refuse to use Google Docs over privacy (or other)
    concerns.
    -   We've considered creating a GSuite domain for Carbon contributor
        accounts to help address this. However, it may not address everyone's
        concerns.

#### Option: GitHub Markdown-centric flow

##### Overview

-   Draft proposals: Markdown, possibly in Google Docs (but not required)
-   Under review proposals: Markdown with review comments by way of GitHub
-   Archive proposals: Markdown
-   Final format: Markdown

##### Flow summary

For reviewing a proposal:

-   Authors prepare a markdown doc using their favored tooling.
    -   This could be [a WYSIWYG markdown editor](#markdown-editing), or Google
        docs for collaboration.
-   Authors create a pull request with the markdown doc, to the carbon-proposals
    GitHub repository.
    -   Community comments on the pull request.
-   To move for a decision, no special action is taken.
-   When a decision is reached, the review manager ensures the markdown doc is
    updated appropriately and approves the pull request.

If the proposal needs to be checked later to figure out why a decision was made:

-   The committed markdown represents the final state of the proposal.
-   The pull request may be viewed to read through comments, even after it is
    merged.
-   The pull request will have edit history publicly visible.
    -   GitHub has a nice renderer for markdown diffs.

##### Advantages/Disadvantages

Advantages:

-   No need to convert file formats.
    -   Markdown reviews can be committed directly, putting all history in one
        place.
    -   When dealing with a proposal that results in separate long-term
        documentation, any differences between proposal text and long-term text
        will be relatively easy to see in a diff.
-   Access control is straightforward, determined by location.
-   Referring to older comments is feasible.
    -   There may be some cases where comments disappear in certain situations,
        but these problems should be avoidable.
-   The archival copy of a document will include an easy link to comment
    history.
-   Easy to see Markdown-formatted deltas in GitHub.
-   The style of all documents can be updated centrally by changing a style
    sheet.
-   Multiple comments may be sent together in a review.
    -   Comments may also be sent individually as in Docs.
-   GitHub comment syntax supports Markdown, allowing code in comments.
-   Multi-author editing is possible by using a shared GitHub branch as a
    source.
    -   This may still be less convenient than Google Docs flows, but
        multi-author proposals could still use Google Docs to collaborate on the
        Markdown.

Neutral:

-   Has a more difficult [suggested edit workflow](#suggesting-edits) than
    Google Docs.
    -   For commenters, this may be a con, as it takes a little more work to add
        a suggested edit. This may still lead to fewer suggested edits.
    -   For the author, this is a mixed bag:
        -   Whereas Google Docs may often see multiple, fragmented edits for the
            same sentence, commenters would be more likely to suggest them
            together (a pro).
        -   It's seamless to comment on changes, as it follows the normal
            comment flow.
        -   It's seamless to make alternative edits and/or reject changes.
        -   The author may need to do extra reformatting/word wrapping after
            accepting a Markdown change, which Docs would handle internally.
    -   For other readers, this is likely a pro: the current state of the doc
        remains visible.

Disadvantages:

-   GitHub comments on pull requests can be difficult to find in certain
    situations.
    -   Comments can disappear when a pull request is rebased and force-pushed.
    -   Comments generally don't get tracked across revisions to a pull request.
    -   If we disallow force-pushes on pull requests, they are probably okay
        most of the time.
-   Can't comment on the rendered Markdown, only the raw Markdown.
-   Images need to be stored separately from the main Markdown file.
    -   Final documentation may or may not need the images; they may only be
        added to explain the proposal. that is, this may be extra work without
        later benefit.

## Details

### Carbon language shared drive

#### Main shared drive

A shared drive will be used as a nexus for any Google Docs materials. This
mainly offers a central point for contributors to locate materials, as most will
not be able to modify contents.

A shared drive should be assumed to be present, regardless of whether we choose
a Google Docs-centric flow: if we allow/encourage the use of Google Docs for
collaborative editing in a Markdown-centric flow, we should still provide
storage.

Access controls:

-   Managers: a minimal set (chandlerc + review managers?) to prevent accidental
    edits.
    -   _Not_ the entire core team, in order to discourage the core team from
        using privileges not accessible to the rest of the community (including
        sub-teams).
-   Content managers: the review manager group, so that they can archive
    proposals.
-   Contributors: none - does not provide sufficiently distinct access from
    content managers.
-   Commenters: full community
-   Viewers: none

#### Proposals (shared folder)

Community members need to be able to add proposals to the shared folder. This
will be available as a shortcut from the main shared drive.

In shared folders, edit access to the folder allows adding/moving/removing
files, but doesn't grant control over the actual _file_, which is still owned by
the individual creator. Unlike shared drives, proposal authors can remove edit
access from individual files.

Access controls:

-   Owner: chandlerc
-   Editors: full community
-   Commenters/viewers: none (non-public)

#### Proposal Archive (folder in shared drive)

The archive will be used to store reviewed proposals. This will mainly make
comments on proposals available for future reference.

To allow viewing comments, comment access _must_ be granted: Google Docs
comments are not visible to users with view-only access. At the same time, this
means contributors will still be able to comment on archived docs: this should
be discouraged.

Access controls:

-   Inherited from Carbon language shared drive.

### Google Docs proposal ACLs

In this setup, pending proposals go into the Proposals shared folder, where
they'll still have their own ACLs.

Note that, in the Markdown-centric flow, this is generally not relevant: using
Google Docs is optional and may often be skipped.

Access controls:

-   Owner: proposal author (transferred to review manager, for proposals going
    to decision)
-   Editors: any collaborators
-   Commenters: community
-   Viewers: none

## Markdown-specific questions

### Open question: Where should proposals be stored in GitHub?

**Decision**: Store proposals in the repository they affect

#### Option: Proposal archive GitHub repository (carbon-proposals)

In this approach, the review managers are presumed to be responsible for commits
to the proposal archive.

Access controls:

-   Commit privileges: review managers

Advantages:

-   Easy to find pending proposals; just look at the carbon-proposals issue
    tracker.
-   All proposals will be uniquely numbered.
-   No need for a proposal label: everything's a proposal.

Disadvantages:

-   Proposals affect other repositories; may miss opportunities to combine
    changes.
-   Harder to filter for proposals that are relevant to a specific repository.

#### Option: Store proposals in the repository they affect

In this approach, we would store proposals in the same repository as they
affect. for example, a proposal about the spec would be stored in carbon-lang,
while a proposal specific to the compiler would be in carbon-toolchains. If a
proposal affected multiple repositories, we'd probably choose a single primary
repository for the proposal.

Specific to a GitHub Markdown-centric flow, we could additionally allow the
proposal's pull request to include the specific proposed changes to
documentation where appropriate, allowing for the author to avoid duplicating
text in the proposal itself.

We would likely still want a proposal document with a summary at a minimum, even
for small proposals. The summary can link to the pull request for details,
creating additional breadcrumbs for reading the full (with additional document
edits) proposal.

Rejected proposals should commit _only_ the proposal document. A link to the
pull request in the proposal document should make it easier to research
rejections. Alternatively, rejected proposals could have their pull request
abandoned, but that would leave only the tracking issue as a breadcrumb for
history.

Access controls:

-   Commit privileges: normal repository access, possibly with review managers
    getting broad access in order to finalize proposals.

Advantages:

-   Makes it easier to demonstrate the actual changes a proposal suggests
    making.
-   Reduces possible redundant work by the author of making changes in two
    places (the proposal, and affected documents).
-   Keeps discussion about the _proposal_ and discussion about the _proposed
    changes_ on a single review thread, for most cases.
-   Makes it easy to find most/all proposals relevant to a given repository.

Disadvantages:

-   Proposals would need to be tracked separately per-repository.
    -   This could also end up being a pro if we get a bunch of different
        repositories, as it may become easier to find relevant proposals for a
        given repository. It's only really a con for as long as we have few
        repositories (which may last long-term, as having many repositories may
        lead to other scaling problems).
-   Access controls are part of the parent repository, and so will be less
    restricted than if we had a separate proposals repository.
-   Proposals won't be uniquely numbered.
    -   We'll need to refer to proposals with the repository, for example,
        `carbon-lang/456`.
-   Need to make sure we have a proposal label, to separate from non-proposal
    traffic.

### Open question: Should we push comments to focus on GitHub?

**Decision**: Push high-level comments to GitHub

#### Common principles

-   Proposals will be declared on Discourse Forums at important stages; for
    example, asking for input on ideas, RFC, decisions, etc.
-   Some discussion is expected to occur on the GitHub PR.

#### Option: Push high-level comments to Discourse Forums

We could push for high-level comments to be added on the same thread as the
Discourse Forums RFC.

Advantages:

-   Discourse Forums offer better interfaces for pure, non-code-comment
    discussion.
-   Email notifications are easier to parse with less threading, more use of
    quotes, and "In Reply To" automation.
-   More familiar for people familiar with mixed Discourse/GitHub workflows.
    -   Both Rust and Swift use Discourse, and are closer to this option.
    -   May also be better for people used to using email lists to discuss
        proposed changes.

Disadvantages:

-   Leads contributors to two different places for comments - some high-level
    discussion will inevitably be in GitHub.
-   Contributors must read both Discourse Forums and GitHub to get context.

#### Option: Push high-level comments to GitHub

We could push for high-level comments to be added to the proposal PR, with other
discussion.

Advantages:

-   The GitHub PR becomes a single hub for conversation.
-   More familiar for people familiar with GitHub-only workflows.

Disadvantages:

-   Discourse Forum topics cannot have "create" without "reply" permissions, so
    some high-level discussion will inevitably be in Discourse Forums.
    -   We could address this by only allowing moderators to post RFCs, but that
        may be overly exclusive.
-   Email notifications include only the lines of code affected, not what is
    being replied to. This will generally make it infeasible to get context from
    emails.
-   Comment threads sometimes make it unclear what's being replied to. for
    example, (broken link:
    `https://github.com/carbon-language/carbon-proposals/pull/5#discussion_r423401993`)
    and (broken link:
    `https://github.com/carbon-language/carbon-proposals/pull/5/files/a51ff951561accfb4aee403d7add6e8e69009ce1#r423401993`)
    are equivalent, but the replied-to-comment is only visible in the file view.
    -   This may be particularly visible as an issue if high-level discussions
        are often not line-specific.
-   Not clear what to do about resolving high-level discussion comment threads.
    -   If comment threads are resolved, it's harder to read them, discouraging
        third-party comment.
    -   If comment threads are not resolved, they may create a bunch of noise.
        As noted above, GitHub manages the file view better than the discussion
        view.
    -   Mixed solutions will leave it to the author to choose the balance of
        issues.

#### Option: Give no guidance, see what happens

Rather than trying to guide high-level discussion to a particular medium, we
could offer no guidance.

Advantages:

-   Less policies, more freedom.
    -   Discover what happens, switch back and forth over time based on
        individual contributor preferences.

Disadvantages:

-   Advantages of a primary hub are discarded. Disadvantages of multiple hubs
    should be assumed to remain.

### Open question: Should there be a tracking issue?

**Decision**: Don't require tracking issues

#### Common principles

-   Discourse Forum topics are minimally used to announce when a decision is
    going to RFC, going to decision, and the decision once made.
-   The proposal's PR may be used for discussion of the proposal.

#### Option: Tracking issue for all proposals

In a workflow where there's always a tracking issue:

1.  Create the tracking issue, for example #123.
2.  Create the PR, for example #456, naming the proposal p0123.md after the
    tracking issue.
    1. Use GitHub features to link #123 and #456.
3.  Update the status in p0123.md and labels of #123 when progressing a
    proposal.
4.  When a decision is made, create a new PR, for example #789, containing the
    decision p0123-decision.md.
    1. This does not replace the Discourse Forum topic announcing a decision.
    2. Use GitHub features to link #123 and #789.
    3. Comments on the decision may go on the decision PR, similar to the
       proposal PR discussion.
5.  Declined/deferred proposals may be committed or not; it doesn't matter.

Advantages:

-   Easy to find the full decision in p0123-decision.md.
-   The PR to create the decision is clearly visible in the associated tracking
    issue.

Disadvantages:

-   The tracking issue separates more state.

#### Option: Don't require tracking issues

In a workflow where there's no need for a tracking issue (although contributors
may create them for bucketing work, they are non-essential):

1.  Create the PR, for example #456, naming the proposal p0456.md.
2.  Update the labels of #456 when progressing a proposal.
    1. Don't bother putting the status in p0456.md: people should rely on the PR
       labels since it's in the same place.
3.  When a decision is made, add it as a comment to #456.
    1. This does not replace the Discourse Forum topic announcing a decision.
    2. Comments on the decision should go in Discourse Forums.
    3. The author is asked to link to the decision in p0456.md before the commit
       is approved.
4.  If declined/deferred proposals are committed, it would be best to add a
    status in p0456.md before committing.

Advantages:

-   Lighter weight process: no tracking issue, and no need to update status in
    p0456.md.

Disadvantages:

-   Harder to store the decision in a way that clearly links it to the original
    proposal.
    -   In particular, finding discussion about the decision is hard to resolve.
        Neither below ideas clearly improve on this, so preference to keep
        everything in Discourse Forum topic.
    -   Could in theory have the full decision in p0456.md. Pro is it's easy to
        find, con is it makes it look more like the author's writing the
        decision.
    -   Could keep storing p0456-decision.md. Pro is it's easy to find, con is
        the lack of association with #456 and extra file+PR. Not clear that
        storage offers enough independent value to justify.
-   Restricts where discussion about a decision should occur.

### Open question: Should declined/deferred proposals be committed?

**Decision**: Do not commit declined/deferred proposals

#### Common principles

-   Accepted proposals are always committed.
-   We may (or may not) commit decisions for any committed proposal (accepted or
    otherwise).
    -   See notes in the above open question.

#### Option: Do not commit declined/deferred proposals

Under this approach, declined/deferred proposals are never committed. Instead,
the PR is abandoned and we at most save a link to it.

Note that GitHub does (at least to some extent) retain closed PRs, even those
coming from a fork.

Advantages:

-   The proposals directory remains a list of only accepted proposals.
-   No need to spend effort saving declined/deferred proposals.

\
Disadvantages:

-   Lose an easy way to check declined/deferred proposals for history.
    -   More reliance on searching forums for history.

#### Option: Commit declined/deferred proposals

Under this approach, declined/deferred proposals are committed.

Advantages:

-   Easy to skim through declined/deferred proposals.

Disadvantages:

-   Finding accepted proposals may become more difficult.
    -   Could put declined/deferred proposals in a different directory.
-   Requires a little more effort in order to save declined/deferred proposals.

## Alternatives considered

### Use a shared drive for everything

Instead of adding a shared folder for proposals, we could instead use a shared
drive for everything. However, this puts us in a bad situation for taking in new
proposals. We would need to choose between:

-   Allowing **all** community member edit access to **all** proposals.
-   Requiring authors ask a review manager to create a blank proposal for them
    to edit.

Neither of these feel like great situations - they are either overly-broad or
overly-restrictive sharing, neither approximating what we actually would want,
which is for anybody in the community to easily create proposals.

## Appendix

### General concern about multiple Markdown flavors

Different markdown implementations have subtly different rendering rules for the
same input. for example, per
[CommonMark Spec](https://spec.commonmark.org/0.29/#), table syntax is not
specified, although
[GitHub uses a table extension](https://guides.github.com/features/mastering-markdown/).
However, we do plan on using GitHub consistently; this only stands to confuse
users of other Markdown systems.

Choosing the Google Docs-centric flow does not eliminate this issue, since
proposals will be archived in Markdown either way.

### Google Docs vs GitHub comment flow comparison

#### Comment clustering

Google Docs only allows sending comments individually.

GitHub supports either sending comments individually or clustering multiple
comments together, as in a review.

#### Basic comments

[Google Docs](https://support.google.com/docs/answer/65129?co=GENIE.Platform%3DDesktop&hl=en):

1. Follow the link to the doc
2. Select text to comment on
3. Click on "+" to add a comment (or use keyboard shortcut)
4. Enter text
5. Click "Comment"

[GitHub](https://help.github.com/en/enterprise/2.14/user/articles/commenting-on-a-pull-request):

1. Follow the link to a pull request
2. Click on "+" next to line to comment on
3. Enter text
4. Click "Add single comment"

#### Suggesting edits

[Google Docs](https://support.google.com/docs/answer/6033474?co=GENIE.Platform%3DDesktop&hl=en):

1. Follow the link to the doc
2. Select text to suggest edit on
3. Type suggested edit

[GitHub](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request):

1. Follow the link to a pull request
2. Click on "+" next to line to comment on
3. Optionally select multiple lines
4. Click on the left-most button
5. Edit quoted text
6. Click "Add single comment"

### Google Docs add-ons

#### Docs to Markdown

https://gsuite.google.com/marketplace/app/docs_to_markdown/700168918607

This plugin actually looks pretty good, and may actually work better than
Google's internal-only equivalent. I'm not seeing obvious downsides.

Advantages:

-   Provides easy conversion of Google Docs to Markdown.

Disadvantages:

-   ?

#### Code blocks

https://gsuite.google.com/marketplace/app/code_blocks/100740430168

This is another code formatting tool, but doesn't seem to work as well as
Google's internal-only equivalent. Google's internal-only equivalent happens to
do some syntax highlighting, whereas Code blocks does none.

Advantages:

-   Public code formatting.
-   Works with "Docs to Markdown" plugin to get ```-block escaping.

Disadvantages:

-   Mediocre syntax highlighting for Carbon.
-   No inline `foo` highlighting, unlike Google's internal-only equivalent.
-   Different highlighting from that in the eventual Markdown document.

#### Advanced Find & Replace

https://gsuite.google.com/marketplace/app/advanced_find_replace/11210842879

Advanced Find & Replace offers more advanced functionality than the built-in
features, particularly around URL and regexp support.

Advantages:

-   Offers improved functionality around key Google Docs friction problems.

Disadvantages:

-   2 of 5 stars: we should not expect quality.
-   \$6 purchase price may turn off contributors.
-   Requires permissions that are banned by Google internally.

### Markdown editing

There are multiple markdown editing tools.

#### StackEdit

https://stackedit.io/

StackEdit may look good on the surface, but we may effectively be restricted to
using it as a WYSIWYG markdown editor, not for collaboration. For that, it's
simply one option amongst many, and not necessarily the best.

Advantages:

-   Provides preview when editing Markdown files.
-   Provides application-specific comment support.

Disadvantages:

-   Cannot use shared Google workspaces with Google corp accounts, due to
    security restrictions. Will likely cause issues for others, too.
-   Google Docs only works as passive storage.
    -   StackEdit docs aren't Google Docs, comments aren't Google Docs comments.

### GitHub Markdown syntax highlighting

GitHub's syntax highlighter
[allows adding third-party extensions](https://github.com/github/linguist/blob/master/CONTRIBUTING.md#adding-an-extension-to-a-language),
but requires them to have significant use.

Note we can't take advantage of this until Carbon is public. We may be able to
find a language with sufficiently similar syntax to
[override the language](https://github.com/github/linguist/#overrides) and get
reasonable highlighting.

## Rationale

During the decision process, several of the individual rationales were
influenced by the idea that one could view the proposal process in one of two
ways:

1.  A PR-centric model. The review team is trying to achieve consensus around a
    PR as a whole. The PR may (and often will) implement the proposed changes.
    The proposal as essentially a description of the changes.

2.  A proposal-centric model. The review team is trying to achieve consensus
    around a proposal. The PR may show a preview of the implementation, but it
    is purely informative.

If one favors a PR-centric model, this steers one away from committing proposals
that are not accepted, towards committing proposals to the affected repository,
etc. In general, the PR-centric model was favored.

### Rationale for using a GitHub markdown-centric flow

-   The GitHub markdown-centric flow makes the on-ramp as smooth as possible for
    external contributors.
    -   This positions the project to maximize the ease of engaging with and
        gaining contributions from the wider industry.
-   The final documents must be in markdown form, so it is best if contributors
    have the option to stay in markdown for the whole process. This is
    significantly less complex than something that converts between formats:

    -   Less to learn
    -   Fewer steps in the process
    -   No outdated versions in the old format left behind

-   The technical flow seems on balance better than the Google Docs-based
    workflow. The proposal does a really good job explaining advantages and
    disadvantages. In summary, the Google Docs-centric workflow has a lot of
    disadvantages that make it difficult to work with proposals over the long
    term.

### Rationale for not requiring tracking issues

There were several members who had no strong preference on this issue. The
consensus was that until there is a compelling reason to require tracking
issues, the process is more light-weight without them.

### Rationale for not committing proposals that are declined or deferred

-   This approach seems simpler.
-   When a proposal PR includes the changes put forth in the proposal
    (PR-centric model), the declined PR might need to be considerably
    changed--and might lose context--in order to be committed.
-   The community will put a lot of work into developing, discussing, and making
    a decision on a proposal. There may be valuable insight in rejected
    proposals, so it makes sense to archive them. However, as noted, committing
    the PR will not always be possible with reasonable effort if not working in
    a proposal-centric model, as the proposal text may not stand on its own.
-   While we may discover issues with this approach, it is better to try this
    way, see if any issues can be rectified, and propose changes as necessary.

### Rationale for committing a proposal to the repository it affects

-   This keeps the proposal close to the repository, and therefore, the
    community, that it affects.
-   It facilitates autonomy of (future) review teams responsible for a
    particular aspect of Carbon. For example, a reference implementation team
    responsible for the carbon-toolchain repository.
-   It simplifies the common case and makes it easier to find how each
    repository evolves over time.

### Rationale for pushing high-level comments to GitHub

While opinions were not as strong, reasons given for preferring comments in
GitHub:

-   This flow will maximize the alignment with “normal” GitHub development flow.
    -   This both improves pulling external/new people into the flow, and will
        reduce the number of flows they need to learn/remember/tool for.
-   We will get ecosystem benefits as this flow continues to be optimized by
    GitHub and those using it.

### Open questions

#### Do we use a Google Docs-centric or GitHub Markdown-centric flow?

**Decision:** Use GitHub Markdown-centric flow.

#### Where should proposals be stored in GitHub?

**Decision:** Store proposals in the repository they affect.

#### Should we push comments to focus on GitHub?

**Decision:** Push high-level comments to GitHub, rather than focusing these
discussions in Discourse.

#### Should there be a tracking issue?

**Decision:** Don't require tracking issues.

#### Should declined/deferred proposals be committed?

**Decision:** Do not commit declined/deferred proposals.
